/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.result.AbstractResult;
import org.primeframework.mvc.action.result.annotation.Binary;
import org.primeframework.mvc.content.binary.BinaryActionConfiguration;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

public class BinaryResult
extends AbstractResult<Binary> {
    private final ActionInvocationStore actionInvocationStore;
    private final HTTPResponse response;

    @Inject
    public BinaryResult(ExpressionEvaluator expressionEvaluator, ActionInvocationStore actionInvocationStore, HTTPResponse response) {
        super(expressionEvaluator);
        this.actionInvocationStore = actionInvocationStore;
        this.response = response;
    }

    @Override
    public boolean execute(Binary binary) throws IOException {
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        Object action = actionInvocation.action;
        if (action == null) {
            throw new PrimeException("There is no action class and somehow we got into the BinaryResult code. No es muy bueno.");
        }
        ActionConfiguration configuration = actionInvocation.configuration;
        if (configuration == null) {
            throw new PrimeException("The action [" + String.valueOf(action.getClass()) + "] has no configuration. This should be impossible!");
        }
        BinaryActionConfiguration binaryFileActionConfiguration = (BinaryActionConfiguration)configuration.additionalConfiguration.get(BinaryActionConfiguration.class);
        if (binaryFileActionConfiguration == null || binaryFileActionConfiguration.responseMember == null) {
            throw new PrimeException("The action [" + String.valueOf(action.getClass()) + "] is missing a field annotated with @BinaryResponse. This is used to figure out what to send back in the response.");
        }
        Path file = (Path)this.expressionEvaluator.getValue(binaryFileActionConfiguration.responseMember, action);
        if (file == null) {
            throw new PrimeException("The @BinaryResponse field [" + binaryFileActionConfiguration.responseMember + "] in the action [" + String.valueOf(action.getClass()) + "] is null. It cannot be null!");
        }
        this.response.setStatus(binary.status());
        this.response.setContentType(binary.contentType());
        this.addCacheControlHeader(binary, this.response);
        if (this.isHeadRequest(actionInvocation)) {
            return true;
        }
        OutputStream outputStream = this.response.getOutputStream();
        Files.copy(file, outputStream);
        if (binaryFileActionConfiguration.deleteResponseMemberUponCompletion) {
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected String getCacheControl(Binary result) {
        return result.cacheControl();
    }

    @Override
    protected boolean getDisableCacheControl(Binary result) {
        return result.disableCacheControl();
    }
}

