/*
 * Copyright (c) 2001-2007, Inversoft Inc., All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 *
 */
package org.primeframework.mvc.freemarker;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

/**
 * Encapsulates a URL to a FreeMaker template and also maintains access to the URLConnection and also the InputStream.
 *
 * @author Brian Pontarelli
 */
public class URLTemplateSource {
  private final URL url;

  private URLConnection conn;

  private InputStream inputStream;

  URLTemplateSource(URL url) throws IOException {
    this.url = url;
    this.conn = url.openConnection();
  }

  public void close() throws IOException {
    try {
      if (inputStream != null) {
        inputStream.close();
      }
    } finally {
      inputStream = null;
      conn = null;
    }
  }

  public boolean equals(Object o) {
    return (o instanceof URLTemplateSource) && url.equals(((URLTemplateSource) o).url);
  }

  public InputStream getInputStream() throws IOException {
    inputStream = conn.getInputStream();
    return inputStream;
  }

  public int hashCode() {
    return url.hashCode();
  }

  public long lastModified() {
    return conn.getLastModified();
  }

  public String toString() {
    return url.toString();
  }
}