/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Set;
import java.util.UUID;
import org.primeframework.mvc.security.BaseUserIdCookieSecurityContext;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.MockUser;
import org.primeframework.mvc.security.MockUserIdSessionContext;
import org.primeframework.mvc.security.UserIdSessionContext;

public class MockBaseUserIdCookieSecurityContext
extends BaseUserIdCookieSecurityContext<UUID> {
    public MockBaseUserIdCookieSecurityContext(HTTPRequest hTTPRequest, HTTPResponse hTTPResponse, Encryptor encryptor, ObjectMapper objectMapper, Clock clock, Duration duration, Duration duration2) {
        super(hTTPRequest, hTTPResponse, encryptor, objectMapper, clock, duration, duration2);
    }

    @Inject
    protected MockBaseUserIdCookieSecurityContext(HTTPRequest hTTPRequest, HTTPResponse hTTPResponse, Encryptor encryptor, ObjectMapper objectMapper, Clock clock) {
        super(hTTPRequest, hTTPResponse, encryptor, objectMapper, clock, Duration.ofMinutes(5L), Duration.ofMinutes(30L));
    }

    public Set<String> getCurrentUsersRoles() {
        return Set.of();
    }

    protected UserIdSessionContext<UUID> createUserIdSessionContext(UUID uUID, ZonedDateTime zonedDateTime) {
        return new MockUserIdSessionContext(uUID, zonedDateTime);
    }

    protected UUID getIdFromUser(Object object) {
        if (!(object instanceof MockUser)) {
            throw new RuntimeException("Expected MockUser and got " + String.valueOf(object.getClass()));
        }
        MockUser mockUser = (MockUser)object;
        return mockUser.id;
    }

    protected Class<? extends UserIdSessionContext<UUID>> getUserIdSessionContextClass() {
        return MockUserIdSessionContext.class;
    }

    protected MockUser retrieveUserById(UUID uUID) {
        return new MockUser("bob");
    }
}

