/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.primeframework.mvc.http.FormBodyPublisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FormBodyPublisherTest {
    @Test
    public void post_formData_string() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("test1", Collections.singletonList("value1"));
        linkedHashMap.put("test2", Collections.singletonList("value2"));
        linkedHashMap.put("test3", new ArrayList<String>(Arrays.asList("value3", null)));
        linkedHashMap.put("test4", null);
        FormBodyPublisher formBodyPublisher = new FormBodyPublisher(linkedHashMap);
        String string = new String(formBodyPublisher.getBody());
        Assert.assertEquals((String)string, (String)"test1=value1&test2=value2&test3=value3&test3=&test4=");
    }

    @Test
    public void post_formData_string_excludeNullValues() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("test1", Collections.singletonList("value1"));
        linkedHashMap.put("test2", Collections.singletonList("value2"));
        linkedHashMap.put("test3", new ArrayList<String>(Arrays.asList("value3", null)));
        linkedHashMap.put("test4", null);
        FormBodyPublisher formBodyPublisher = new FormBodyPublisher(linkedHashMap, true);
        String string = new String(formBodyPublisher.getBody());
        Assert.assertEquals((String)string, (String)"test1=value1&test2=value2&test3=value3");
    }
}

