/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import org.primeframework.mvc.PrimeBaseTest;
import org.testng.annotations.Test;

public class AcceptanceTest
extends PrimeBaseTest {
    @Test
    public void get_absoluteForward() {
        simulator.test("/absolute-forward-result").get().assertStatusCode(200).assertBody("Absolute Forward");
    }

    @Test
    public void get_action_noTemplate() {
        simulator.test("/no-template").get().assertStatusCode(500).assertBodyIsEmpty();
    }

    @Test
    public void get_action_withTemplate() {
        simulator.test("/action-template").get().assertStatusCode(200).assertBodyContains("Action and Template").assertBodyContainsMessagesFromKeys("message-key");
    }

    @Test
    public void get_defaultForward() {
        simulator.test("/default-forward-result").get().assertStatusCode(200).assertBody("Default Forward");
    }

    @Test
    public void get_noAction_noTemplate() {
        simulator.test("/no-action-no-template").get().assertStatusCode(404).assertBody("The page is missing!");
    }

    @Test
    public void get_noAction_withTemplate() {
        simulator.test("/actionless").get().assertStatusCode(200).assertBody("Hello Actionless World");
    }

    @Test
    public void get_nonPrimeResourceEndingWithSlash() {
        simulator.test("/potato/").get().assertStatusCode(404).assertBody("The page is missing!");
    }

    @Test
    public void get_redirectToIndex() {
        simulator.test("/redirect").get().assertStatusCode(301).assertRedirect("/redirect/");
    }

    @Test
    public void get_redirectToIndexWithTrailingSlash() {
        simulator.test("/redirect/").get().assertStatusCode(200).assertBody("Redirected");
    }

    @Test
    public void get_relativeForward() {
        simulator.test("/relative-forward-result").get().assertStatusCode(200).assertBody("Relative Forward");
    }
}

