/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.http;

import io.fusionauth.http.server.HTTPRequest;
import java.net.URI;
import org.primeframework.mvc.http.HTTPTools;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HTTPToolsTest {
    @Test
    public void buildBaseURI() {
        HTTPRequest hTTPRequest2 = (HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setHost("www.example.com"))).with(hTTPRequest -> hTTPRequest.setPath("/foo/bar"))).with(hTTPRequest -> hTTPRequest.setPort(9011))).with(hTTPRequest -> hTTPRequest.setScheme("http"));
        URI uRI = URI.create(hTTPRequest2.getBaseURL());
        Assert.assertEquals((String)uRI.toString(), (String)"http://www.example.com:9011");
        hTTPRequest2 = (HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setHost("www.example.com"))).with(hTTPRequest -> hTTPRequest.setPath("/foo/bar"))).with(hTTPRequest -> hTTPRequest.setPort(80))).with(hTTPRequest -> hTTPRequest.setScheme("http"));
        uRI = URI.create(hTTPRequest2.getBaseURL());
        Assert.assertEquals((String)uRI.toString(), (String)"http://www.example.com");
        hTTPRequest2 = (HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.addHeader("X-Forwarded-Proto", "https"))).with(hTTPRequest -> hTTPRequest.setHost("www.example.com"))).with(hTTPRequest -> hTTPRequest.setPath("/foo/bar"))).with(hTTPRequest -> hTTPRequest.setPort(443))).with(hTTPRequest -> hTTPRequest.setScheme("http"));
        uRI = URI.create(hTTPRequest2.getBaseURL());
        Assert.assertEquals((String)uRI.toString(), (String)"https://www.example.com");
        hTTPRequest2 = (HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.addHeader("X-Forwarded-Proto", "http"))).with(hTTPRequest -> hTTPRequest.setHost("www.example.com"))).with(hTTPRequest -> hTTPRequest.setPath("/foo/bar"))).with(hTTPRequest -> hTTPRequest.setPort(443))).with(hTTPRequest -> hTTPRequest.setScheme("https"));
        uRI = URI.create(hTTPRequest2.getBaseURL());
        Assert.assertEquals((String)uRI.toString(), (String)"http://www.example.com:443");
        hTTPRequest2 = (HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.addHeader("X-Forwarded-Proto", "https"))).with(hTTPRequest -> hTTPRequest.setHost("www.example.com"))).with(hTTPRequest -> hTTPRequest.setPath("/foo/bar"))).with(hTTPRequest -> hTTPRequest.setPort(443))).with(hTTPRequest -> hTTPRequest.setScheme("https"));
        uRI = URI.create(hTTPRequest2.getBaseURL());
        Assert.assertEquals((String)uRI.toString(), (String)"https://www.example.com");
        hTTPRequest2 = (HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setHost("www.example.com"))).with(hTTPRequest -> hTTPRequest.setPath("/foo/bar"))).with(hTTPRequest -> hTTPRequest.setPort(80))).with(hTTPRequest -> hTTPRequest.setScheme("https"));
        uRI = URI.create(hTTPRequest2.getBaseURL());
        Assert.assertEquals((String)uRI.toString(), (String)"https://www.example.com:80");
        hTTPRequest2 = (HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setHost("www.example.com"))).with(hTTPRequest -> hTTPRequest.setPath("/foo/bar"))).with(hTTPRequest -> hTTPRequest.setPort(443))).with(hTTPRequest -> hTTPRequest.setScheme("https"));
        uRI = URI.create(hTTPRequest2.getBaseURL());
        Assert.assertEquals((String)uRI.toString(), (String)"https://www.example.com");
        hTTPRequest2 = (HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.addHeader("X-Forwarded-Host", "foobar.com"))).with(hTTPRequest -> hTTPRequest.setHost("www.example.com"))).with(hTTPRequest -> hTTPRequest.setPath("/foo/bar"))).with(hTTPRequest -> hTTPRequest.setPort(443))).with(hTTPRequest -> hTTPRequest.setScheme("https"));
        uRI = URI.create(hTTPRequest2.getBaseURL());
        Assert.assertEquals((String)uRI.toString(), (String)"https://foobar.com");
        hTTPRequest2 = (HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.addHeader("X-Forwarded-Host", "foobar.com"))).with(hTTPRequest -> hTTPRequest.addHeader("X-Forwarded-Proto", "http"))).with(hTTPRequest -> hTTPRequest.setHost("www.example.com"))).with(hTTPRequest -> hTTPRequest.setPath("/foo/bar"))).with(hTTPRequest -> hTTPRequest.setPort(443))).with(hTTPRequest -> hTTPRequest.setScheme("https"));
        uRI = URI.create(hTTPRequest2.getBaseURL());
        Assert.assertEquals((String)uRI.toString(), (String)"http://foobar.com:443");
        hTTPRequest2 = (HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.addHeader("X-Forwarded-Host", "foobar.com"))).with(hTTPRequest -> hTTPRequest.addHeader("X-Forwarded-Proto", "http"))).with(hTTPRequest -> hTTPRequest.addHeader("X-Forwarded-port", "80"))).with(hTTPRequest -> hTTPRequest.setHost("www.example.com"))).with(hTTPRequest -> hTTPRequest.setPath("/foo/bar"))).with(hTTPRequest -> hTTPRequest.setPort(443))).with(hTTPRequest -> hTTPRequest.setScheme("https"));
        uRI = URI.create(hTTPRequest2.getBaseURL());
        Assert.assertEquals((String)uRI.toString(), (String)"http://foobar.com");
    }

    @Test
    public void getRequestURI() {
        this.assertBadRequestURI("/foo/../foo.png", "/foo.png");
        this.assertBadRequestURI("/./foo/../foo.png", "/foo.png");
        this.assertBadRequestURI("/././foo.png", "/foo.png");
        this.assertBadRequestURI("/foo/bar/../../foo.png", "/foo.png");
        this.assertBadRequestURI("/foo/bar/../.././foo.png", "/foo.png");
        this.assertBadRequestURI("/foo/bar/././foo.png", "/foo/bar/foo.png");
        this.assertBadRequestURI("/foo/%2E%2E/foo%2Epng", "/foo.png");
        this.assertBadRequestURI("/%2E/foo/%2E%2E/foo%2Epng", "/foo.png");
        this.assertEscapedURI("/../foo.png");
        this.assertEscapedURI("../../../foo.png");
        this.assertEscapedURI("/../../../foo.png");
        this.assertEscapedURI("/css/../../../foo.png");
        this.assertEscapedURI("../css/../../../foo.png");
        this.assertEscapedURI("/../css/../../../foo.png");
        this.assertBadRequestURI("/a/./.../....//b/foo.png", "/a/.../..../b/foo.png");
        this.assertBadRequestURI(".../....///.../....///.../....///.../....///.../....///.../....//foo.png", ".../..../.../..../.../..../.../..../.../..../.../..../foo.png");
        this.assertBadRequestURI("...foo.png", "...foo.png");
        this.assertOkRequestURI("..../foo.png");
        this.assertOkRequestURI("/....foo.png");
        this.assertOkRequestURI("/..../foo.png");
        this.assertOkRequestURI("/..../foo.png..");
        this.assertOkRequestURI("/..../foo.png...");
        this.assertOkRequestURI("/.well-known/openid-configuration");
        this.assertOkRequestURI("/foo/.well-known/openid-configuration");
        this.assertOkRequestURI("/foo/.well-known/.openid-configuration");
        this.assertOkRequestURI("/foo/version/1.0/foo.png");
        this.assertOkRequestURI("/foo/version/1.0.x/foo.png");
        this.assertOkRequestURI("/foo/version/1.2/foo.png");
        this.assertOkRequestURI("/foo/version/1.2.0/foo.png");
        this.assertOkRequestURI("/foo/version/1.2.0.x/foo.png");
        this.assertOkRequestURI("/foo/version/1.2.0.1.9.2.22.1.x/foo.png");
        this.assertOkRequestURI("/foo/version/1.2.0.1.9.2.22.1.x./foo.png");
        this.assertOkRequestURI("/foo/version/1.2.0.1.9.2.22.1.x./foo..png");
        this.assertOkRequestURI("/foo/version/1.2.0.1.9.2.22.1.x./foo....png");
        this.assertOkRequestURI("/foo/version/1.2.0.1.9.2.22.1.x./foo.......png");
        this.assertOkRequestURI("/f.o.o/b.a.r/1.2.0.1.9.2.22.1.x./f.o.o.png");
    }

    private void assertBadRequestURI(String string, String string2) {
        Assert.assertEquals((String)HTTPTools.sanitizeURI((String)HTTPTools.getRequestURI((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setPath(string))))), (String)string2);
    }

    private void assertBadURI(String string) {
        Assert.assertNull((Object)HTTPTools.sanitizeURI((String)HTTPTools.getRequestURI((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setPath(string))))));
    }

    private void assertEscapedURI(String string) {
        Assert.assertNull((Object)HTTPTools.sanitizeURI((String)HTTPTools.getRequestURI((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setPath(string))))));
    }

    private void assertOkRequestURI(String string) {
        Assert.assertEquals((String)HTTPTools.sanitizeURI((String)HTTPTools.getRequestURI((HTTPRequest)((HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setPath(string))))), (String)string);
    }
}

