/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import org.easymock.EasyMock;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.result.XMLStreamResult;
import org.primeframework.mvc.action.result.annotation.XMLStream;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class XMLStreamResultTest
extends PrimeBaseTest {
    @Test(dataProvider="httpMethod")
    public void explicit(HTTPMethod hTTPMethod) throws IOException {
        String string = "xml";
        String string2 = "<xml/>";
        byte[] byArray = string2.getBytes();
        long l = byArray.length;
        String string3 = "application/xhtml+xml; charset=UTF-8";
        Object object = new Object();
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.expect((Object)expressionEvaluator.getValue(string, object)).andReturn((Object)string2);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HTTPResponse hTTPResponse = new HTTPResponse(this){

            public OutputStream getOutputStream() {
                return byteArrayOutputStream;
            }
        };
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(object, new ExecuteMethodConfiguration(hTTPMethod, null, null), "/foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        XMLStreamImpl xMLStreamImpl = new XMLStreamImpl("success", "xml", 200);
        XMLStreamResult xMLStreamResult = new XMLStreamResult(expressionEvaluator, hTTPResponse, actionInvocationStore);
        xMLStreamResult.execute((XMLStream)xMLStreamImpl);
        Assert.assertEquals((String)byteArrayOutputStream.toString(), (String)(hTTPMethod == HTTPMethod.GET ? "<xml/>" : ""));
        EasyMock.verify((Object[])new Object[]{expressionEvaluator});
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)200);
        Assert.assertEquals((String)hTTPResponse.getContentType(), (String)string3);
        Assert.assertEquals((long)hTTPResponse.getContentLength(), (long)l);
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }

    @DataProvider(name="httpMethod")
    public Object[][] httpMethod() {
        return new Object[][]{{HTTPMethod.GET}, {HTTPMethod.HEAD}};
    }

    public static class XMLStreamImpl
    implements XMLStream {
        private final String cacheControl;
        private final String code;
        private final boolean disableCacheControl;
        private final String property;
        private final int status;

        public XMLStreamImpl(String string, String string2, int n) {
            this.cacheControl = "no-cache";
            this.code = string;
            this.disableCacheControl = false;
            this.property = string2;
            this.status = n;
        }

        public Class<? extends Annotation> annotationType() {
            return XMLStream.class;
        }

        public String cacheControl() {
            return this.cacheControl;
        }

        public String code() {
            return this.code;
        }

        public boolean disableCacheControl() {
            return this.disableCacheControl;
        }

        public String property() {
            return this.property;
        }

        public int status() {
            return this.status;
        }
    }
}

