/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ConstraintOverrideMethodConfiguration;
import org.primeframework.mvc.action.annotation.Action;
import org.primeframework.mvc.security.SecurityScheme;
import org.primeframework.mvc.security.SecurityWorkflow;
import org.primeframework.mvc.security.UnauthenticatedException;
import org.primeframework.mvc.security.annotation.AnonymousAccess;
import org.primeframework.mvc.security.annotation.ConstraintOverride;
import org.primeframework.mvc.security.guice.SecuritySchemeFactory;
import org.primeframework.mvc.util.ReflectionUtils;
import org.primeframework.mvc.workflow.WorkflowChain;

public class DefaultSecurityWorkflow
implements SecurityWorkflow {
    private final ActionInvocationStore actionInvocationStore;
    private final SecuritySchemeFactory factory;

    @Inject
    public DefaultSecurityWorkflow(ActionInvocationStore actionInvocationStore, SecuritySchemeFactory factory) {
        this.actionInvocationStore = actionInvocationStore;
        this.factory = factory;
    }

    @Override
    public void perform(WorkflowChain workflowChain) throws IOException {
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        if (actionInvocation == null || actionInvocation.configuration == null) {
            workflowChain.continueWorkflow();
            return;
        }
        Action actionAnnotation = actionInvocation.configuration.annotation;
        if (!actionAnnotation.requiresAuthentication()) {
            workflowChain.continueWorkflow();
            return;
        }
        if (actionInvocation.method.annotations.containsKey(AnonymousAccess.class)) {
            workflowChain.continueWorkflow();
            return;
        }
        String[] constraints = this.getConstraints(actionInvocation);
        for (String scheme : actionInvocation.configuration.securitySchemes) {
            SecurityScheme securityScheme = this.factory.build(scheme);
            if (securityScheme == null) {
                throw new PrimeException("You have specified an invalid security scheme named [" + scheme + "]");
            }
            try {
                securityScheme.handle(constraints);
                workflowChain.continueWorkflow();
                return;
            }
            catch (UnauthenticatedException unauthenticatedException) {
            }
        }
        throw new UnauthenticatedException();
    }

    protected String[] getConstraints(ActionInvocation actionInvocation) {
        ConstraintOverride constraint = (ConstraintOverride)actionInvocation.method.annotations.get(ConstraintOverride.class);
        if (constraint != null) {
            return constraint.value();
        }
        ConstraintOverrideMethodConfiguration configuration = actionInvocation.configuration.constraintValidationMethods.get(actionInvocation.method.httpMethod);
        if (configuration != null) {
            Object constraints = ReflectionUtils.invoke(configuration.method, actionInvocation.action, new Object[0]);
            return constraints != null ? (String[])((Collection)constraints).stream().map(Object::toString).toList().toArray(String[]::new) : new String[]{};
        }
        return actionInvocation.configuration.annotation.constraints();
    }
}

