/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.scope;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.List;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.scope.BaseBrowserSessionScope;
import org.primeframework.mvc.scope.annotation.BrowserActionSession;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.util.CookieTools;
import org.primeframework.mvc.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserActionSessionScope
extends BaseBrowserSessionScope<BrowserActionSession> {
    private static final Logger logger = LoggerFactory.getLogger(BrowserActionSessionScope.class);
    private final ActionInvocationStore actionInvocationStore;

    @Inject
    public BrowserActionSessionScope(HTTPRequest request, HTTPResponse response, ActionInvocationStore actionInvocationStore, Encryptor encryptor, ObjectMapper objectMapper) {
        super(request, response, encryptor, objectMapper);
        this.actionInvocationStore = actionInvocationStore;
    }

    public static <T> T get(Injector injector, HTTPRequest request, String fieldName, Class<T> type, Class<?> action) {
        List<Field> fields = ReflectionUtils.findAllFieldsWithAnnotation(action, BrowserActionSession.class);
        AccessibleObject actual = null;
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            actual = field;
        }
        if (actual == null) {
            return null;
        }
        BrowserActionSession scope = actual.getDeclaredAnnotation(BrowserActionSession.class);
        boolean encrypted = scope.encrypt();
        String cookieName = action.getName() + "$" + fieldName;
        Cookie cookie = request.getCookie(cookieName);
        if (cookie == null) {
            return null;
        }
        String value = cookie.value;
        try {
            Encryptor encryptor = (Encryptor)injector.getInstance(Encryptor.class);
            ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
            return CookieTools.fromJSONCookie(value, type, encrypted, encrypted, encryptor, objectMapper);
        }
        catch (Exception e) {
            String message = e.getClass().getCanonicalName() + " " + e.getMessage();
            if (scope.encrypt()) {
                logger.debug("Failed to decrypt cookie. This may be expected if the cookie was encrypted using a different key.\n\tCause: {}", (Object)message);
            } else {
                logger.debug("Failed to decode cookie. This is not expected.\n\tCause: {}", (Object)message);
            }
            return null;
        }
    }

    @Override
    protected boolean compress(BrowserActionSession scope) {
        return scope.compress();
    }

    @Override
    protected boolean encrypt(BrowserActionSession scope) {
        return scope.encrypt();
    }

    @Override
    protected String getCookieName(String fieldName, BrowserActionSession scope) {
        String className;
        if (scope.action() != BrowserActionSession.class) {
            className = scope.action().getName();
        } else {
            ActionInvocation ai = this.actionInvocationStore.getCurrent();
            if (ai.action == null) {
                throw new PrimeException("Attempting to store a value in the action session but the current request URL isn't associated with an action class");
            }
            className = ai.action.getClass().getName();
        }
        return className + "$" + ("##field-name##".equals(scope.name()) ? fieldName : scope.name());
    }

    @Override
    protected void setCookieValues(Cookie cookie, BrowserActionSession scope) {
        cookie.sameSite = scope.sameSite();
    }
}

