/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import com.google.inject.Inject;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.AbstractGlobalConverter;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.MultipleParametersUnsupportedException;
import org.primeframework.mvc.parameter.convert.annotation.GlobalConverter;

@GlobalConverter
public class EnumConverter
extends AbstractGlobalConverter {
    private final boolean emptyIsNull;

    @Inject
    public EnumConverter(MVCConfiguration configuration) {
        this.emptyIsNull = configuration.emptyParametersAreNull();
    }

    @Override
    protected String objectToString(Object value, Type convertFrom, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        return value.toString();
    }

    @Override
    protected Object stringToObject(String value, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        if (this.emptyIsNull && StringUtils.isBlank(value)) {
            return null;
        }
        try {
            return Enum.valueOf((Class)convertTo, value);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException(e);
        }
    }

    @Override
    protected Object stringsToObject(String[] values, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        throw new MultipleParametersUnsupportedException("You are attempting to map a form field that contains multiple parameters to a property on the action class that is of type Enum. This isn't allowed.");
    }
}

