/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter;

import com.google.inject.Inject;
import io.fusionauth.http.FileInfo;
import io.fusionauth.http.server.HTTPRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.ParameterParser;
import org.primeframework.mvc.security.csrf.CSRFProvider;

public class DefaultParameterParser
implements ParameterParser {
    public static final String CHECKBOX_PREFIX = "__cb_";
    public static final String RADIOBUTTON_PREFIX = "__rb_";
    private final ActionInvocationStore actionInvocationStore;
    private final MVCConfiguration configuration;
    private final CSRFProvider csrfProvider;
    private final HTTPRequest request;

    @Inject
    public DefaultParameterParser(MVCConfiguration configuration, ActionInvocationStore actionInvocationStore, CSRFProvider csrfProvider, HTTPRequest request) {
        this.configuration = configuration;
        this.actionInvocationStore = actionInvocationStore;
        this.csrfProvider = csrfProvider;
        this.request = request;
    }

    @Override
    public ParameterParser.Parameters parse() {
        Map parameters = this.request.getParameters();
        ParameterParser.Parameters result = new ParameterParser.Parameters();
        this.addFiles(result);
        if (!parameters.isEmpty()) {
            HashMap<String, List<String>> checkBoxes = new HashMap<String, List<String>>();
            HashMap<String, List<String>> radioButtons = new HashMap<String, List<String>>();
            HashSet<String> actions = new HashSet<String>();
            this.separateParameters(parameters, result, checkBoxes, radioButtons, actions);
            this.preParameters(result);
            checkBoxes.keySet().removeAll(result.optional.keySet());
            checkBoxes.keySet().removeAll(result.required.keySet());
            radioButtons.keySet().removeAll(result.optional.keySet());
            radioButtons.keySet().removeAll(result.required.keySet());
            this.addUncheckedValues(checkBoxes, result);
            this.addUncheckedValues(radioButtons, result);
            result.optional.keySet().removeAll(actions);
            result.required.keySet().removeAll(actions);
        }
        return result;
    }

    protected void addFiles(ParameterParser.Parameters result) {
        List files = this.request.getFiles();
        for (FileInfo file : files) {
            result.files.computeIfAbsent(file.name, key -> new ArrayList()).add(file);
        }
    }

    protected void addUncheckedValues(Map<String, List<String>> map, ParameterParser.Parameters parameters) {
        for (String key : map.keySet()) {
            List<String> values = map.get(key);
            if (values != null && values.size() == 1 && values.get(0).equals("") || this.empty(values)) {
                parameters.required.put(key, new ParameterParser.Parameters.Struct());
                continue;
            }
            parameters.required.put(key, new ParameterParser.Parameters.Struct(values));
        }
    }

    protected boolean empty(List<String> values) {
        if (values != null && values.size() > 0) {
            return values.stream().allMatch(value -> value.equals(""));
        }
        return true;
    }

    private void preParameters(ParameterParser.Parameters result) {
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        for (String name : actionInvocation.configuration.preParameterMembers.keySet()) {
            ParameterParser.Parameters.Struct struct = result.optional.remove(name);
            if (struct == null) {
                struct = result.required.remove(name);
            }
            if (struct == null) continue;
            result.pre.put(name, struct);
        }
    }

    private void separateParameters(Map<String, List<String>> parameters, ParameterParser.Parameters result, Map<String, List<String>> checkBoxes, Map<String, List<String>> radioButtons, Set<String> actions) {
        for (String key : parameters.keySet()) {
            boolean optional;
            boolean bl = optional = key.endsWith(".x") || key.endsWith(".y") || key.equals(this.csrfProvider.getParameterName());
            if (key.startsWith(CHECKBOX_PREFIX)) {
                checkBoxes.put(key.substring(CHECKBOX_PREFIX.length()), parameters.get(key));
                continue;
            }
            if (key.startsWith(RADIOBUTTON_PREFIX)) {
                radioButtons.put(key.substring(RADIOBUTTON_PREFIX.length()), parameters.get(key));
                continue;
            }
            int index = key.indexOf(64);
            String parameter = index > 0 ? key.substring(0, index) : key;
            ParameterParser.Parameters.Struct s = optional ? result.optional.get(parameter) : result.required.get(parameter);
            if (s == null) {
                s = new ParameterParser.Parameters.Struct();
                if (optional) {
                    result.optional.put(parameter, s);
                } else {
                    result.required.put(parameter, s);
                }
            }
            if (index > 0) {
                s.attributes.put(key.substring(index + 1), parameters.get(key).get(0));
                continue;
            }
            List<String> values = parameters.get(parameter);
            if (this.configuration.ignoreEmptyParameters() && this.empty(values)) continue;
            s.values = values;
        }
    }
}

