/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.message.l10n;

import com.google.inject.Inject;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Queue;
import java.util.ResourceBundle;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.locale.LocaleProvider;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.message.l10n.MissingMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleMessageProvider
implements MessageProvider {
    private static final Logger logger = LoggerFactory.getLogger(ResourceBundleMessageProvider.class);
    private final ResourceBundle.Control control;
    private final ActionInvocationStore invocationStore;
    private final LocaleProvider localeProvider;

    @Inject
    public ResourceBundleMessageProvider(LocaleProvider localeProvider, ResourceBundle.Control control, ActionInvocationStore invocationStore) {
        this.localeProvider = localeProvider;
        this.control = control;
        this.invocationStore = invocationStore;
    }

    @Override
    public String getMessage(String key, Object ... values) throws MissingMessageException {
        String message = this.getOptionalMessage(key, values);
        if (message == null) {
            ActionInvocation actionInvocation = this.invocationStore.getCurrent();
            String uri = actionInvocation != null ? actionInvocation.actionURI : null;
            throw new MissingMessageException("Message could not be found for the URI [" + uri + "] and key [" + key + "]");
        }
        return message;
    }

    @Override
    public String getOptionalMessage(String key, Object ... values) {
        ActionInvocation actionInvocation = this.invocationStore.getCurrent();
        String template = this.findMessage(actionInvocation, key);
        if (template == null) {
            template = this.findDefaultMessage(actionInvocation, key);
        }
        if (template == null) {
            if (!"[ValidationException]".equals(key)) {
                String uri = actionInvocation != null ? actionInvocation.actionURI : null;
                logger.debug("Message could not be found for the URI [{}] and key [{}]", (Object)uri, (Object)key);
            }
            return null;
        }
        Formatter f = new Formatter();
        f.format((Locale)this.localeProvider.get(), template, values);
        return f.out().toString();
    }

    protected Queue<String> determineBundles(String bundle) {
        LinkedList<String> names = new LinkedList<String>();
        names.offer(bundle);
        int index = bundle.lastIndexOf(47);
        while (index != -1) {
            bundle = bundle.substring(0, index);
            names.offer(bundle + "/package");
            index = bundle.lastIndexOf(47);
        }
        return names;
    }

    protected String findMessage(ActionInvocation actionInvocation, String key) {
        ActionConfiguration config;
        String actionURI = actionInvocation != null ? actionInvocation.actionURI : "/";
        String message = this.findMessage(actionURI, key);
        if (message != null) {
            return message;
        }
        ActionConfiguration actionConfiguration = config = actionInvocation != null ? actionInvocation.configuration : null;
        if (config == null) {
            return null;
        }
        return config.alternateMessageURIs.stream().map(uri -> this.findMessage((String)uri, key)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private String findDefaultMessage(ActionInvocation actionInvocation, String key) {
        int index;
        if (key.indexOf(91) == 0 && (index = key.indexOf(93, 1)) != -1) {
            return this.findMessage(actionInvocation, key.substring(0, index + 1));
        }
        return null;
    }

    private String findMessage(String uri, String key) {
        Queue<String> names = this.determineBundles(uri);
        for (String name : names) {
            try {
                ResourceBundle rb = ResourceBundle.getBundle(name, (Locale)this.localeProvider.get(), this.control);
                return rb.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return null;
    }
}

