/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.http;

import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import org.primeframework.mvc.PrimeException;

public final class HTTPObjectsHolder {
    private static final ThreadLocal<HTTPRequest> Requests = new ThreadLocal();
    private static final ThreadLocal<HTTPResponse> Responses = new ThreadLocal();

    private HTTPObjectsHolder() {
    }

    public static void clearRequest() {
        Requests.remove();
    }

    public static void clearResponse() {
        Responses.remove();
    }

    public static HTTPRequest getRequest() {
        return Requests.get();
    }

    public static void setRequest(HTTPRequest request) {
        if (Requests.get() != null) {
            throw new PrimeException("Request is already set into the HTTPObjectsHolder");
        }
        Requests.set(request);
    }

    public static HTTPResponse getResponse() {
        return Responses.get();
    }

    public static void setResponse(HTTPResponse response) {
        if (Responses.get() != null) {
            throw new PrimeException("Response is already set into the HTTPObjectsHolder");
        }
        Responses.set(response);
    }
}

