/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.AbstractRedirectResult;
import org.primeframework.mvc.action.result.SavedRequestTools;
import org.primeframework.mvc.action.result.annotation.ReexecuteSavedRequest;
import org.primeframework.mvc.action.result.annotation.SaveRequest;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.http.HTTPTools;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.saved.SavedHttpRequest;

public class SaveRequestResult
extends AbstractRedirectResult<SaveRequest> {
    private final MVCConfiguration configuration;
    private final Encryptor encryptor;
    private final ObjectMapper objectMapper;

    @Inject
    public SaveRequestResult(MessageStore messageStore, ExpressionEvaluator expressionEvaluator, HTTPResponse response, HTTPRequest request, ActionInvocationStore actionInvocationStore, MVCConfiguration configuration, Encryptor encryptor, ObjectMapper objectMapper) {
        super(expressionEvaluator, actionInvocationStore, messageStore, request, response);
        this.configuration = configuration;
        this.encryptor = encryptor;
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean execute(SaveRequest saveRequest) throws IOException {
        String source;
        this.moveMessagesToFlash();
        HTTPMethod method = this.request.getMethod();
        boolean saveRequestAllowed = HTTPMethod.GET.is(method);
        if (HTTPMethod.POST.is(method) && saveRequest.allowPost() && (source = HTTPTools.getOriginHeader(this.request)) != null) {
            URI uri = URI.create(this.request.getBaseURL());
            URI sourceURI = URI.create(source);
            if (uri.getPort() == sourceURI.getPort() && uri.getScheme().equalsIgnoreCase(sourceURI.getScheme()) && uri.getHost().equalsIgnoreCase(sourceURI.getHost())) {
                saveRequestAllowed = true;
            }
        }
        if (saveRequestAllowed) {
            Object redirectURI;
            Map requestParameters = null;
            if (HTTPMethod.GET.is(method)) {
                Map params = this.request.getParameters();
                redirectURI = this.request.getPath() + this.makeQueryString(params);
            } else {
                requestParameters = this.request.getParameters();
                redirectURI = this.request.getPath();
            }
            Cookie saveRequestCookie = SavedRequestTools.toCookie(new SavedHttpRequest(method, (String)redirectURI, requestParameters), this.configuration, this.encryptor, this.objectMapper);
            if (saveRequestCookie.value.getBytes(StandardCharsets.UTF_8).length <= this.configuration.savedRequestCookieMaximumSize()) {
                this.response.addCookie(saveRequestCookie);
            }
        }
        this.addCacheControlHeader(saveRequest, this.response);
        this.sendRedirect(null, saveRequest.uri(), saveRequest.encodeVariables(), saveRequest.perm());
        return true;
    }

    @Override
    protected String getCacheControl(SaveRequest result) {
        return result.cacheControl();
    }

    @Override
    protected boolean getDisableCacheControl(SaveRequest result) {
        return result.disableCacheControl();
    }

    private String makeQueryString(Map<String, List<String>> parameters) {
        if (parameters.size() == 0) {
            return "";
        }
        StringBuilder build = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            for (String value : entry.getValue()) {
                if (build.length() > 0) {
                    build.append("&");
                }
                build.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8));
            }
        }
        return "?" + String.valueOf(build);
    }

    public static class SaveRequestImpl
    implements SaveRequest {
        private final boolean allowPost;
        private final String cacheControl;
        private final String code;
        private final boolean disableCacheControl;
        private final boolean encode;
        private final boolean perm;
        private final String uri;

        public SaveRequestImpl(String uri, String code, boolean perm, boolean encode, boolean allowPost) {
            this.cacheControl = "no-cache";
            this.code = code;
            this.disableCacheControl = false;
            this.encode = encode;
            this.uri = uri;
            this.perm = perm;
            this.allowPost = allowPost;
        }

        @Override
        public boolean allowPost() {
            return this.allowPost;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return ReexecuteSavedRequest.class;
        }

        @Override
        public String cacheControl() {
            return this.cacheControl;
        }

        @Override
        public String code() {
            return this.code;
        }

        @Override
        public boolean disableCacheControl() {
            return this.disableCacheControl;
        }

        @Override
        public boolean encodeVariables() {
            return this.encode;
        }

        @Override
        public boolean perm() {
            return this.perm;
        }

        @Override
        public String uri() {
            return this.uri;
        }
    }
}

