/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.BaseTest;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.io.HTTPInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HTTPInputStreamTest
extends BaseTest {
    @Test(dataProvider="contentEncoding")
    public void read_chunked_withPushback(String string) throws Exception {
        String string2 = "These pretzels are making me thirsty. These pretzels are making me thirsty. These pretzels are making me thirsty.";
        byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
        int n = byArray.length;
        byArray = this.compressUsingContentEncoding(byArray, string);
        byArray = this.chunkEncode(byArray, 38, null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray);
        String string3 = "GET / HTTP/1.1\n\r";
        byte[] byArray2 = string3.getBytes(StandardCharsets.UTF_8);
        byteArrayOutputStream.write(byArray2);
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setHeader("Content-Encoding", string);
        hTTPRequest.setHeader("Transfer-Encoding", "chunked");
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        this.assertReadWithPushback(byArray3, string2, n, byArray2, hTTPRequest);
    }

    @Test(dataProvider="contentEncoding")
    public void read_fixedLength_withPushback(String string) throws Exception {
        String string2 = "These pretzels are making me thirsty. These pretzels are making me thirsty. These pretzels are making me thirsty.";
        byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
        int n = byArray.length;
        byArray = this.compressUsingContentEncoding(byArray, string);
        int n2 = byArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray);
        String string3 = "GET / HTTP/1.1\n\r";
        byte[] byArray2 = string3.getBytes(StandardCharsets.UTF_8);
        byteArrayOutputStream.write(byArray2);
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setHeader("Content-Encoding", string);
        hTTPRequest.setHeader("Content-Length", "" + n2);
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        this.assertReadWithPushback(byArray3, string2, n, byArray2, hTTPRequest);
    }

    private void assertReadWithPushback(byte[] byArray, String string, int n, byte[] byArray2, HTTPRequest hTTPRequest) throws Exception {
        int n2 = byArray.length;
        HTTPServerConfiguration hTTPServerConfiguration = new HTTPServerConfiguration().withRequestBufferSize(n2 + 100);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PushbackInputStream pushbackInputStream = new PushbackInputStream((InputStream)byteArrayInputStream, null);
        HTTPInputStream hTTPInputStream = new HTTPInputStream(hTTPServerConfiguration, hTTPRequest, pushbackInputStream, -1);
        byte[] byArray3 = new byte[hTTPServerConfiguration.getRequestBufferSize()];
        int n3 = hTTPInputStream.read(byArray3);
        Assert.assertEquals((int)n3, (int)n);
        Assert.assertEquals((String)new String(byArray3, 0, n3), (String)string);
        int n4 = hTTPInputStream.read(byArray3);
        Assert.assertEquals((int)n4, (int)-1);
        Assert.assertEquals((int)pushbackInputStream.getAvailableBufferedBytesRemaining(), (int)byArray2.length);
        byte[] byArray4 = new byte[100];
        int n5 = pushbackInputStream.read(byArray4);
        Assert.assertEquals((int)n5, (int)byArray2.length);
        Assert.assertEquals((String)new String(byArray4, 0, n5), (String)new String(byArray2));
    }
}

