/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.BaseTest;
import io.fusionauth.http.FileInfo;
import io.fusionauth.http.io.MultipartConfiguration;
import io.fusionauth.http.io.MultipartFileUploadPolicy;
import io.fusionauth.http.server.CountingInstrumenter;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPServer;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MultipartTest
extends BaseTest {
    public static final String Body = "------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"foo\"\r\n\r\nbar\r\n------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.jpg\"\r\nContent-Type: text/plain; charset=ISO-8859-1\r\n\r\nfilecontents\r\n------WebKitFormBoundaryTWfMVJErBoLURJIe--";
    public static final String ExpectedResponse = "{\"version\":\"42\"}";

    @Test(dataProvider="schemes")
    public void post(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertEquals((String)hTTPRequest.getContentType(), (String)"multipart/form-data");
            Map map = hTTPRequest.getFormData();
            Assert.assertEquals((Collection)((Collection)map.get("foo")), List.of("bar"));
            List list = hTTPRequest.getFiles();
            Assert.assertEquals((String)((FileInfo)list.getFirst()).getContentType(), (String)"text/plain");
            Assert.assertEquals((Object)((FileInfo)list.getFirst()).getEncoding(), (Object)StandardCharsets.ISO_8859_1);
            Assert.assertEquals((String)((FileInfo)list.getFirst()).getName(), (String)"file");
            Assert.assertEquals((String)Files.readString(((FileInfo)list.getFirst()).getFile()), (String)"filecontents");
            Files.delete(((FileInfo)list.getFirst()).getFile());
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setHeader("Content-Length", "16");
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(ExpectedResponse.getBytes());
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HTTPServer hTTPServer = ((HTTPServer)this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).withMultipartConfiguration(new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow))).start();
             HttpClient httpClient = this.makeClient(string, null);){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "multipart/form-data; boundary=----WebKitFormBoundaryTWfMVJErBoLURJIe").POST(HttpRequest.BodyPublishers.ofString(Body)).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
        }
    }

    @Test(dataProvider="schemes")
    public void post_server_configuration_fileTooBig(String string) throws Exception {
        this.withScheme(string).withFileSize(0xA00000).withConfiguration(hTTPServerConfiguration -> hTTPServerConfiguration.withMultipartConfiguration(new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow).withMaxFileSize(0x200000L).withMaxRequestSize(0xF00000L))).expectResponse("HTTP/1.1 413 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n").assertOptionalExceptionOnWrite(SocketException.class);
    }

    @Test(dataProvider="schemes")
    public void post_server_configuration_file_upload_allow(String string) throws Exception {
        this.withScheme(string).withFileCount(5).withConfiguration(hTTPServerConfiguration -> hTTPServerConfiguration.withMultipartConfiguration(new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow))).expectResponse("HTTP/1.1 200 \r\nconnection: keep-alive\r\ncontent-type: application/json\r\ncontent-length: 16\r\n\r\n{\"version\":\"42\"}").expectNoExceptionOnWrite();
    }

    @Test(dataProvider="schemes")
    public void post_server_configuration_file_upload_ignore(String string) throws Exception {
        this.withScheme(string).withFileCount(5).withConfiguration(hTTPServerConfiguration -> hTTPServerConfiguration.withMultipartConfiguration(new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Ignore))).expectedFileCount(0).expectResponse("HTTP/1.1 200 \r\nconnection: keep-alive\r\ncontent-type: application/json\r\ncontent-length: 16\r\n\r\n{\"version\":\"42\"}").expectNoExceptionOnWrite();
    }

    @Test(dataProvider="schemes")
    public void post_server_configuration_file_upload_reject(String string) throws Exception {
        this.withScheme(string).withConfiguration(hTTPServerConfiguration -> hTTPServerConfiguration.withMultipartConfiguration(new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Reject))).withFileCount(5).withFileSize(0x100000).expectResponse("HTTP/1.1 422 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n").assertOptionalExceptionOnWrite(SocketException.class);
    }

    @Test(dataProvider="schemes")
    public void post_server_configuration_requestTooBig(String string) throws Exception {
        this.withScheme(string).withFileSize(0x100000).withFileCount(15).withConfiguration(hTTPServerConfiguration -> hTTPServerConfiguration.withMultipartConfiguration(new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow).withMaxFileSize(0x200000L).withMaxRequestSize(0x300000L))).expectResponse("HTTP/1.1 413 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n").assertOptionalExceptionOnWrite(SocketException.class);
    }

    @Test(dataProvider="schemes")
    public void post_server_configuration_requestTooBig_maxBodySize(String string) throws Exception {
        this.withScheme(string).withFileSize(0x100000).withFileCount(15).withConfiguration(hTTPServerConfiguration -> hTTPServerConfiguration.withMultipartConfiguration(new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow).withMaxFileSize(0x80000000L).withMaxRequestSize(0x140000000L)).withMaxRequestBodySize(Map.of("*", 0x300000))).expectResponse("HTTP/1.1 413 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n").assertOptionalExceptionOnWrite(SocketException.class);
    }

    private Builder withConfiguration(Consumer<HTTPServerConfiguration> consumer) throws Exception {
        return new Builder("http").withConfiguration(consumer);
    }

    private Builder withScheme(String string) {
        return new Builder(string);
    }

    private class Builder {
        private Consumer<HTTPServerConfiguration> configuration;
        private int expectedFileCount = 1;
        private int fileCount = 1;
        private int fileSize = 42;
        private String scheme;
        private Exception thrownOnWrite;

        public Builder(String string) {
            this.scheme = string;
        }

        public Builder assertOptionalExceptionOnWrite(Class<? extends Exception> clazz) {
            if (this.thrownOnWrite != null) {
                Assert.assertEquals(this.thrownOnWrite.getClass(), clazz);
            }
            return this;
        }

        public Builder expectNoExceptionOnWrite() {
            Assert.assertNull((Object)this.thrownOnWrite);
            return this;
        }

        public Builder expectResponse(String string) throws Exception {
            HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
                Assert.assertEquals((String)hTTPRequest.getContentType(), (String)"multipart/form-data");
                Map map = hTTPRequest.getFormData();
                Assert.assertEquals((Collection)((Collection)map.get("foo")), List.of("bar"));
                List list = hTTPRequest.getFiles();
                Assert.assertEquals((int)list.size(), (int)this.expectedFileCount);
                for (FileInfo fileInfo : list) {
                    Assert.assertEquals((String)fileInfo.getContentType(), (String)"text/plain");
                    Assert.assertEquals((Object)fileInfo.getEncoding(), (Object)StandardCharsets.ISO_8859_1);
                    Assert.assertEquals((String)fileInfo.getName(), (String)"file");
                    Assert.assertEquals((String)Files.readString(fileInfo.getFile()), (String)"X".repeat(this.fileSize));
                    Files.delete(fileInfo.getFile());
                }
                hTTPResponse.setHeader("Content-Type", "application/json");
                hTTPResponse.setHeader("Content-Length", "16");
                hTTPResponse.setStatus(200);
                try {
                    OutputStream outputStream = hTTPResponse.getOutputStream();
                    outputStream.write(MultipartTest.ExpectedResponse.getBytes());
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            };
            HTTPServer hTTPServer = (HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)MultipartTest.this.makeServer(this.scheme, hTTPHandler, null).withInitialReadTimeout(Duration.ofSeconds(30L))).withKeepAliveTimeoutDuration(Duration.ofSeconds(30L))).withMinimumWriteThroughput(1024L)).withMinimumReadThroughput(1024L);
            if (this.configuration != null) {
                this.configuration.accept(hTTPServer.configuration());
            }
            try (HTTPServer hTTPServer2 = hTTPServer.start();
                 Socket socket = MultipartTest.this.makeClientSocket(this.scheme);){
                int n;
                socket.setSoTimeout((int)Duration.ofSeconds(30L).toMillis());
                String string2 = "-----WebKitFormBoundaryTWfMVJErBoLURJIe";
                String string3 = string2 + "\r\nContent-Disposition: form-data; name=\"foo\"\r\n\r\nbar\r\n";
                String string4 = "X".repeat(this.fileSize);
                for (n = 0; n < this.fileCount; ++n) {
                    string3 = string3 + string2;
                    string3 = string3 + "\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.jpg\"\r\nContent-Type: text/plain; charset=ISO-8859-1\r\n\r\n{file}\r\n".replace("{file}", string4);
                }
                string3 = string3 + string2 + "--";
                n = string3.getBytes(StandardCharsets.UTF_8).length;
                String string5 = "POST / HTTP/1.1\r\nHost: cyberdyne-systems.com\r\nContent-Length: {contentLength}\r\nContent-Type: multipart/form-data; boundary=---WebKitFormBoundaryTWfMVJErBoLURJIe\r\n\r\n{body}".replace("{body}", string3).replace("{contentLength}", "" + n);
                OutputStream outputStream = socket.getOutputStream();
                try {
                    outputStream.write(string5.getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception exception) {
                    this.thrownOnWrite = exception;
                }
                MultipartTest.this.assertHTTPResponseEquals(socket, string);
            }
            return this;
        }

        public Builder expectedFileCount(int n) {
            this.expectedFileCount = n;
            return this;
        }

        public Builder withConfiguration(Consumer<HTTPServerConfiguration> consumer) {
            this.configuration = consumer;
            return this;
        }

        public Builder withFileCount(int n) {
            this.fileCount = n;
            this.expectedFileCount = n;
            return this;
        }

        public Builder withFileSize(int n) {
            this.fileSize = n;
            return this;
        }

        public void withScheme(String string) {
            this.scheme = string;
        }
    }
}

