/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.BaseTest;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPServer;
import io.fusionauth.http.server.HTTPServerConfiguration;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FormDataTest
extends BaseTest {
    public static final String ExpectedResponse = "{\n  \"version\": \"42\"\n}\n".replaceAll("\\s", "");

    @Test(dataProvider="schemesAndChunked")
    public void post_server_configuration_max_form_data(String string, boolean bl) throws Exception {
        this.withScheme(string).withChunked(bl).withBodyParameterCount(4096).withBodyParameterSize(32).withConfiguration(hTTPServerConfiguration -> hTTPServerConfiguration.withMaxRequestBodySize(Map.of("application/x-www-form-urlencoded", 180223))).expectResponse("HTTP/1.1 200 \r\nconnection: keep-alive\r\ncontent-type: application/json\r\ncontent-length: 16\r\n\r\n{\"version\":\"42\"}").expectNoExceptionOnWrite();
        this.withScheme(string).withChunked(bl).withBodyParameterCount(43008).withBodyParameterSize(128).withConfiguration(hTTPServerConfiguration -> hTTPServerConfiguration.withMaxRequestBodySize(Map.of("application/x-www-form-urlencoded".toUpperCase(Locale.ROOT), 131072))).expectResponse("HTTP/1.1 413 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n").assertOptionalExceptionOnWrite(SocketException.class);
        this.withScheme(string).withChunked(bl).withBodyParameterCount(43008).withBodyParameterSize(128).withConfiguration(hTTPServerConfiguration -> hTTPServerConfiguration.withMaxRequestBodySize(Map.of("application/x-www-form-urlencoded", -1))).expectResponse("HTTP/1.1 200 \r\nconnection: keep-alive\r\ncontent-type: application/json\r\ncontent-length: 16\r\n\r\n{\"version\":\"42\"}").expectNoExceptionOnWrite();
        this.withScheme(string).withChunked(bl).withBodyParameterCount(43008).withBodyParameterSize(128).withConfiguration(hTTPServerConfiguration -> hTTPServerConfiguration.withMaxRequestBodySize(Map.of("*", 131072))).expectResponse("HTTP/1.1 413 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n").assertOptionalExceptionOnWrite(SocketException.class);
    }

    @Test(dataProvider="schemes")
    public void post_server_configuration_max_request_header_size(String string) throws Exception {
        this.withScheme(string).withHeaderCount(1655).withHeaderSize(64).expectResponse("HTTP/1.1 200 \r\nconnection: keep-alive\r\ncontent-type: application/json\r\ncontent-length: 16\r\n\r\n{\"version\":\"42\"}").expectNoExceptionOnWrite();
        this.withScheme(string).withHeaderCount(0x100000).withHeaderSize(128).expectResponse("HTTP/1.1 431 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n").assertOptionalExceptionOnWrite(SocketException.class);
        this.withScheme(string).withHeaderCount(0x100000).withHeaderSize(128).withConfiguration(hTTPServerConfiguration -> hTTPServerConfiguration.withMaxRequestHeaderSize(-1)).expectResponse("HTTP/1.1 200 \r\nconnection: keep-alive\r\ncontent-type: application/json\r\ncontent-length: 16\r\n\r\n{\"version\":\"42\"}").expectNoExceptionOnWrite();
    }

    private Builder withScheme(String string) {
        return new Builder(string);
    }

    private class Builder {
        private int bodyParameterCount = 1;
        private int bodyParameterSize = 42;
        private boolean chunked;
        private Consumer<HTTPServerConfiguration> configuration;
        private int headerCount;
        private int headerSize;
        private String scheme;
        private Exception thrownOnWrite;

        public Builder(String string) {
            this.scheme = string;
        }

        public Builder assertOptionalExceptionOnWrite(Class<? extends Exception> clazz) {
            if (this.thrownOnWrite != null) {
                Assert.assertEquals(this.thrownOnWrite.getClass(), clazz);
            }
            return this;
        }

        public Builder expectNoExceptionOnWrite() {
            Assert.assertNull((Object)this.thrownOnWrite);
            return this;
        }

        public Builder expectResponse(String string) throws Exception {
            HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
                Assert.assertEquals((String)hTTPRequest.getContentType(), (String)"application/x-www-form-urlencoded");
                Map map = hTTPRequest.getFormData();
                Assert.assertEquals((int)map.size(), (int)this.bodyParameterCount);
                String string = "X".repeat(this.bodyParameterSize);
                for (int i = 0; i < this.bodyParameterCount; ++i) {
                    Assert.assertEquals((Collection)((Collection)map.get("param" + String.format("%05d", i))), List.of(string));
                }
                hTTPResponse.setHeader("Content-Type", "application/json");
                hTTPResponse.setHeader("Content-Length", "16");
                hTTPResponse.setStatus(200);
                try {
                    OutputStream outputStream = hTTPResponse.getOutputStream();
                    outputStream.write(ExpectedResponse.getBytes());
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            };
            HTTPServer hTTPServer = (HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)FormDataTest.this.makeServer(this.scheme, hTTPHandler, null).withMinimumWriteThroughput(-1L)).withMinimumReadThroughput(-1L)).withReadThroughputCalculationDelayDuration(Duration.ofMinutes(2L))).withWriteThroughputCalculationDelayDuration(Duration.ofMinutes(2L))).withKeepAliveTimeoutDuration(Duration.ofSeconds(23L))).withInitialReadTimeout(Duration.ofSeconds(19L))).withProcessingTimeoutDuration(Duration.ofSeconds(27L));
            if (this.configuration != null) {
                this.configuration.accept(hTTPServer.configuration());
            }
            try (HTTPServer hTTPServer2 = hTTPServer.start();
                 Socket socket = FormDataTest.this.makeClientSocket(this.scheme);){
                int n;
                socket.setSoTimeout((int)Duration.ofSeconds(5L).toMillis());
                Object object = "GET / HTTP/1.1\r\nHost: cyberdyne-systems.com\r\nContent-Type: application/x-www-form-urlencoded\r\n";
                Object object2 = "";
                String string2 = "X".repeat(this.bodyParameterSize);
                ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                for (n = 0; n < this.bodyParameterCount; ++n) {
                    arrayList.add((CallSite)((Object)("param" + String.format("%05d", n) + "=" + string2)));
                }
                if (arrayList.size() > 0) {
                    object2 = (String)object2 + String.join((CharSequence)"&", arrayList);
                }
                if (this.chunked) {
                    object = (String)object + "Transfer-Encoding: chunked\r\n";
                    object2 = new String(FormDataTest.this.chunkEncode(((String)object2).getBytes(StandardCharsets.UTF_8), 100, null));
                } else {
                    n = ((String)object2).getBytes(StandardCharsets.UTF_8).length;
                    if (n > 0) {
                        object = (String)object + "Content-Length: {contentLength}\r\n".replace("{contentLength}", "" + n);
                    }
                }
                ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
                for (int i = 0; i < this.headerCount; ++i) {
                    arrayList2.add((CallSite)((Object)("header" + String.format("%05d", i) + ": " + "X".repeat(this.headerSize))));
                }
                if (arrayList2.size() > 0) {
                    object = (String)object + String.join((CharSequence)"\r\n", arrayList2) + "\r\n";
                }
                object = (String)object + "\r\n" + (String)object2;
                OutputStream outputStream = socket.getOutputStream();
                try {
                    outputStream.write(((String)object).getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception exception) {
                    this.thrownOnWrite = exception;
                }
                FormDataTest.this.assertHTTPResponseEquals(socket, string);
            }
            return this;
        }

        public Builder withBodyParameterCount(int n) {
            this.bodyParameterCount = n;
            return this;
        }

        public Builder withBodyParameterSize(int n) {
            this.bodyParameterSize = n;
            return this;
        }

        public Builder withChunked(boolean bl) {
            this.chunked = bl;
            return this;
        }

        public Builder withConfiguration(Consumer<HTTPServerConfiguration> consumer) {
            this.configuration = consumer;
            return this;
        }

        public Builder withHeaderCount(int n) {
            this.headerCount = n;
            return this;
        }

        public Builder withHeaderSize(int n) {
            this.headerSize = n;
            return this;
        }

        public void withScheme(String string) {
            this.scheme = string;
        }
    }
}

