/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import com.inversoft.net.ssl.SSLTools;
import com.inversoft.rest.ClientResponse;
import com.inversoft.rest.RESTClient;
import com.inversoft.rest.TextResponseHandler;
import io.fusionauth.http.BaseTest;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.log.AccumulatingLogger;
import io.fusionauth.http.log.AccumulatingLoggerFactory;
import io.fusionauth.http.log.Level;
import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.server.CountingInstrumenter;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPServer;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.net.URLDecoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLSession;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CoreTest
extends BaseTest {
    public static final String ExpectedResponse = "{\n  \"version\": \"42\"\n}\n".replaceAll("\\s", "");
    public static final String LongString = "1234567890".repeat(1664);
    public static final String RequestBody = "{\n  \"message\": \"Hello World\"\n}\n";

    @Test(dataProvider="schemes")
    public void badLanguage(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertTrue((boolean)hTTPRequest.getLocales().isEmpty());
            hTTPResponse.setStatus(200);
            hTTPResponse.getOutputStream().close();
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = this.makeURI(string, "");
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).header("Accept-Language", "en, fr_bad;q=0.7").GET().build();
            HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofInputStream());
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
        }
    }

    @Test
    public void badPreambleButReset() throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertNull((Object)hTTPRequest.getHeader("Bad-Header"));
            Assert.assertEquals((String)hTTPRequest.getHeader("Good-Header"), (String)"Good-Header");
            hTTPResponse.setStatus(200);
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = HttpClient.newHttpClient();
             HTTPServer hTTPServer = this.makeServer("http", hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            this.sendBadRequest("GET / HTTP/1.1\r\nX-Bad-Header: Bad-Header\r\r\n");
            URI uRI = this.makeURI("http", "");
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).header("Good-Header", "Good-Header").GET().build();
            HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
        }
        Assert.assertEquals((long)countingInstrumenter.getBadRequests(), (long)1L);
    }

    @Test(enabled=false)
    public void certificateChain() throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setStatus(200);
            hTTPResponse.getOutputStream().close();
        };
        try (HttpClient httpClient = this.makeClient("https", null);
             HTTPServer hTTPServer = this.makeServer("https", hTTPHandler).start();){
            URI uRI = this.makeURI("https", "");
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build();
            HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofInputStream());
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            SSLSession sSLSession = httpResponse.sslSession().get();
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            this.validateCertPath(rootCertificate, certificateArray);
        }
    }

    @Test(dataProvider="schemes")
    public void emptyContentType(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertNull((Object)hTTPRequest.getContentType());
            hTTPResponse.setStatus(200);
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "").POST(HttpRequest.BodyPublishers.noBody()).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
        }
    }

    @Test(dataProvider="schemes")
    public void emptyContentTypeWithEncoding(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertEquals((String)hTTPRequest.getContentType(), (String)"");
            Assert.assertEquals((Object)hTTPRequest.getCharacterEncoding(), (Object)StandardCharsets.UTF_16);
            hTTPResponse.setStatus(200);
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "; charset=UTF-16").POST(HttpRequest.BodyPublishers.noBody()).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
        }
    }

    @Test(dataProvider="schemes")
    public void handlerFailureGet(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            throw new IllegalStateException("Bad state");
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)500);
        }
    }

    @Test(dataProvider="schemes")
    public void handlerFailurePost(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            throw new IllegalStateException("Bad state");
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(RequestBody)).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)500);
        }
    }

    @Test(dataProvider="connections")
    public void handler_sets_connection_response_header(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setStatus(200);
            hTTPResponse.setHeader("Connection", string);
        };
        try (HttpClient httpClient = this.makeClient("http", null);
             HTTPServer hTTPServer = this.makeServer("http", hTTPHandler).start();){
            URI uRI = this.makeURI("http", "");
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build();
            HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)httpResponse.headers().firstValue("Connection").get(), (String)string);
        }
    }

    @Test(groups={"timeouts"})
    public void initialReadTimeout() {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            byte[] byArray = "Hey, looks like the timeout didn't work!".getBytes(StandardCharsets.UTF_8);
            hTTPResponse.setHeader("Content-Length", "" + byArray.length);
            hTTPResponse.setHeader("Content-Type", "text/plain");
            OutputStream outputStream = hTTPResponse.getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HTTPServer hTTPServer = ((HTTPServer)this.makeServer("http", hTTPHandler, (Instrumenter)countingInstrumenter).withInitialReadTimeout(Duration.ofMillis(250L))).start();
             Socket socket = new Socket("127.0.0.1", 4242);){
            this.sleep(1000L);
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write("GET / HTTP/1.1\r\nHost: localhost:42\r\nConnection: close\r\nContent-Length: 4\r\n\r\nbody\n".getBytes());
            outputStream.flush();
            byte[] byArray = socket.getInputStream().readAllBytes();
            Assert.assertEquals((int)byArray.length, (int)0, (String)new String(byArray, StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)countingInstrumenter.getAcceptedRequests(), (long)0L);
        Assert.assertEquals((long)countingInstrumenter.getClosedConnections(), (long)1L);
    }

    @Test(groups={"timeouts"})
    public void keepAliveTimeout() {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertNull((Object)hTTPRequest.getContentType());
            hTTPResponse.setStatus(200);
        };
        try (HTTPServer hTTPServer = ((HTTPServer)this.makeServer("http", hTTPHandler).withKeepAliveTimeoutDuration(Duration.ofSeconds(1L))).start();){
            URI uRI = this.makeURI("http", "");
            ClientResponse clientResponse = new RESTClient(Void.TYPE, Void.TYPE).url(uRI.toString()).connectTimeout(0).readTimeout(0).get().go();
            if (clientResponse.status != 200) {
                this.println(clientResponse.exception);
            }
            Assert.assertEquals((int)clientResponse.status, (int)200);
            this.sleep(2000L);
            clientResponse = new RESTClient(Void.TYPE, Void.TYPE).url(uRI.toString()).connectTimeout(0).readTimeout(0).get().go();
            if (clientResponse.status != 200) {
                this.println(clientResponse.exception);
            }
            Assert.assertEquals((int)clientResponse.status, (int)200);
        }
    }

    @Test
    public void keepAlive_maxRequests() throws Exception {
        int n = 10;
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> hTTPResponse.setStatus(200);
        try (HTTPServer hTTPServer = ((HTTPServer)((HTTPServer)this.makeServer("http", hTTPHandler).withMaxRequestsPerConnection(n)).withKeepAliveTimeoutDuration(Duration.ofSeconds(60L))).start();
             HttpClient httpClient = this.makeClient("http", null);){
            URI uRI = this.makeURI("http", "");
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build();
            for (int i = 1; i <= n; ++i) {
                HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
                Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
                Assert.assertEquals((String)httpResponse.headers().firstValue("Connection").get(), (String)(n == i ? "close" : "keep-alive"));
            }
        }
    }

    @Test(dataProvider="schemes")
    public void largeCSS(String string) throws Exception {
        String string2 = Files.readString(Paths.get("src/test/resources/fontawesome-6.0.0.min.css", new String[0]), StandardCharsets.UTF_8);
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(string2.getBytes(StandardCharsets.UTF_8));
                outputStream.close();
            }
            catch (Throwable throwable) {
                this.println(throwable);
            }
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = this.makeURI(string, "");
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build();
            HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)string2);
        }
    }

    @Test(dataProvider="schemes")
    public void large_body(String string) throws Exception {
        String string2 = "1234567890";
        int n = new HTTPServerConfiguration().getRequestBufferSize() / string2.length() + 42;
        String string3 = "foo=" + string2.repeat(n);
        byte[] byArray = string3.getBytes(StandardCharsets.UTF_8);
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setStatus(200);
            hTTPResponse.setContentType("application/x-www-form-urlencoded; charset=UTF-8");
            hTTPResponse.setContentLength((long)hTTPRequest.getBodyBytes().length);
            hTTPResponse.getOutputStream().write(hTTPRequest.getBodyBytes());
            hTTPResponse.getOutputStream().close();
            hTTPRequest.getFormData();
            Assert.assertEquals((byte[])hTTPRequest.getBodyBytes(), (byte[])hTTPRequest.getBodyBytes());
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();
             HttpClient httpClient = this.makeClient(string, null);){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).POST(HttpRequest.BodyPublishers.ofString(string3)).build(), responseInfo -> HttpResponse.BodySubscribers.ofByteArray());
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((byte[])((byte[])httpResponse.body()), (byte[])byArray);
            Assert.assertEquals((int)byArray.length, (int)16804);
            long l = countingInstrumenter.getBytesRead();
            Assert.assertTrue((l >= 16804L && l <= 17100L ? 1 : 0) != 0);
        }
    }

    @Test(dataProvider="schemes")
    public void large_headers(String string) throws Exception {
        int n = new HTTPServerConfiguration().getRequestBufferSize();
        int n2 = n / LongString.length() + 1;
        int n3 = new HTTPServerConfiguration().getResponseBufferSize();
        int n4 = n3 / LongString.length() + 1;
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                Assert.assertEquals((String)hTTPRequest.getHeader("X-Huge-Header-" + n3), (String)LongString);
            }
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setHeader("Content-Length", "" + ExpectedResponse.getBytes().length);
            for (n3 = 0; n3 < n4; ++n3) {
                hTTPResponse.setHeader("X-Huge-Header-" + n3, LongString);
            }
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(ExpectedResponse.getBytes());
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = this.makeURI(string, "");
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uRI);
            for (int i = 0; i < n2; ++i) {
                builder.setHeader("X-Huge-Header-" + i, LongString);
            }
            HttpResponse httpResponse = httpClient.send(builder.POST(HttpRequest.BodyPublishers.ofString(RequestBody)).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            for (int i = 0; i < n4; ++i) {
                Assert.assertEquals((String)httpResponse.headers().firstValue("X-Huge-Header-" + i).get(), (String)LongString);
            }
        }
    }

    @Test
    public void logger() {
        AccumulatingLogger accumulatingLogger = new AccumulatingLogger();
        accumulatingLogger.setLevel(Level.Debug);
        accumulatingLogger.info("Class name: [{}]", new Object[]{"io.fusionauth.http.Test$InnerClass"});
        String string = accumulatingLogger.toString();
        Assert.assertTrue((boolean)string.endsWith("Class name: [io.fusionauth.http.Test$InnerClass]"));
    }

    @Test(dataProvider="schemes")
    public void partialWriteThenException(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setStatus(200);
            hTTPResponse.getWriter().write("Here some body that should not be flushed");
            throw new RuntimeException("Failure");
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)500);
        }
    }

    @Test(dataProvider="schemes")
    public void partialWriteThenFlushThenException(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setStatus(200);
            Writer writer = hTTPResponse.getWriter();
            writer.write("Here some body that should not be flushed");
            writer.flush();
            throw new RuntimeException("Failure");
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)500);
        }
    }

    @Test(dataProvider="schemes", groups={"performance"})
    public void performance(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setHeader("Content-Length", "16");
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(ExpectedResponse.getBytes());
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        int n = 100000;
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            long l = System.currentTimeMillis();
            for (int i = 0; i < n; ++i) {
                HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
                Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
                Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
                if (i % 1000 != 0) continue;
                this.println(i);
            }
            long l2 = System.currentTimeMillis();
            double d = (double)(l2 - l) / (double)n;
            this.println("Average linear request time is [" + d + "]ms");
        }
        Assert.assertEquals((long)countingInstrumenter.getConnections(), (long)1L);
    }

    @Test(dataProvider="schemes", groups={"performance"})
    public void performanceNoKeepAlive(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setHeader("Content-Length", "16");
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(ExpectedResponse.getBytes());
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        int n = 5000;
        int n2 = -1;
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            try {
                URI uRI = this.makeURI(string, "");
                long l = System.currentTimeMillis();
                for (n2 = 0; n2 < n; ++n2) {
                    HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Connection", "close").POST(HttpRequest.BodyPublishers.noBody()).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
                    if (n2 % 1000 == 0) {
                        this.println(n2);
                    }
                    Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
                    Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
                }
                long l2 = System.currentTimeMillis();
                double d = (double)(l2 - l) / (double)n;
                this.println("Average linear request time without keep-alive is [" + d + "]ms");
            }
            catch (Exception exception) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                    stringBuilder.append(entry.getKey()).append(" ").append((Object)entry.getKey().getState()).append("\n");
                    for (StackTraceElement stackTraceElement : entry.getValue()) {
                        stringBuilder.append("\tat ").append(stackTraceElement).append("\n");
                    }
                    stringBuilder.append("\n");
                }
                this.println(stringBuilder);
                throw exception;
            }
        }
        catch (Exception exception) {
            this.println("Failed on iteration " + n2);
            throw exception;
        }
        Assert.assertEquals((long)countingInstrumenter.getConnections(), (long)n);
        Assert.assertEquals((long)countingInstrumenter.getClosedConnections(), (long)0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="schemes")
    public void serverClosesSockets(String string) {
        ClientResponse clientResponse;
        URI uRI;
        HTTPServer hTTPServer;
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setHeader("Content-Length", "16");
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(ExpectedResponse.getBytes());
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        try {
            hTTPServer = this.makeServer(string, hTTPHandler).start();
            try {
                SSLTools.disableSSLValidation();
                uRI = this.makeURI(string, "");
                clientResponse = new RESTClient(String.class, String.class).url(uRI.toString()).connectTimeout(600000).readTimeout(600000).get().successResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).errorResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).go();
                Assert.assertEquals((int)clientResponse.status, (int)200);
                Assert.assertEquals((String)((String)clientResponse.successResponse), (String)ExpectedResponse);
            }
            finally {
                if (hTTPServer != null) {
                    hTTPServer.close();
                }
            }
        }
        finally {
            SSLTools.enableSSLValidation();
        }
        try {
            hTTPServer = this.makeServer(string, hTTPHandler).start();
            try {
                SSLTools.disableSSLValidation();
                uRI = this.makeURI(string, "");
                clientResponse = new RESTClient(String.class, String.class).url(uRI.toString()).connectTimeout(600000).readTimeout(600000).get().successResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).errorResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).go();
                Assert.assertEquals((int)clientResponse.status, (int)200);
                Assert.assertEquals((String)((String)clientResponse.successResponse), (String)ExpectedResponse);
            }
            finally {
                if (hTTPServer != null) {
                    hTTPServer.close();
                }
            }
        }
        finally {
            SSLTools.enableSSLValidation();
        }
    }

    @Test(groups={"timeouts"})
    public void serverTimeout() throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            this.println("Handling ... (slowly)");
            this.sleep(3000L);
            hTTPResponse.setStatus(200);
            byte[] byArray = "I'm slow but I'm good.".getBytes(StandardCharsets.UTF_8);
            hTTPResponse.setContentLength((long)byArray.length);
            hTTPResponse.getOutputStream().write(byArray);
            hTTPResponse.getOutputStream().close();
            this.println("Closed");
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HTTPServer hTTPServer = ((HTTPServer)((HTTPServer)((HTTPServer)this.makeServer("http", hTTPHandler, (Instrumenter)countingInstrumenter).withProcessingTimeoutDuration(Duration.ofSeconds(1L))).withInitialReadTimeout(Duration.ofSeconds(30L))).withKeepAliveTimeoutDuration(Duration.ofSeconds(30L))).start();
             Socket socket = new Socket("127.0.0.1", 4242);){
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write("GET / HTTP/1.1\r\nHost: localhost:42\r\nConnection: close\r\nContent-Length: 4\r\n\r\nbody\n".getBytes());
            outputStream.flush();
            byte[] byArray = socket.getInputStream().readAllBytes();
            Assert.assertEquals((int)byArray.length, (int)0, (String)new String(byArray));
            Assert.assertEquals((long)countingInstrumenter.getClosedConnections(), (long)1L);
        }
    }

    @Test(dataProvider="schemesAndResponseBufferSizes")
    public void simpleGet(String string, int n) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertEquals((Collection)hTTPRequest.getAcceptEncodings(), List.of("deflate", "compress", "identity", "gzip", "br"));
            Assert.assertEquals((String)hTTPRequest.getBaseURL(), (String)(string.equals("http") ? "http://localhost:4242" : "https://local.fusionauth.io:4242"));
            Assert.assertEquals((String)hTTPRequest.getContentType(), (String)"text/plain");
            Assert.assertEquals((Object)hTTPRequest.getCharacterEncoding(), (Object)StandardCharsets.ISO_8859_1);
            Assert.assertEquals((String)hTTPRequest.getHeader("Origin"), (String)"https://example.com");
            Assert.assertEquals((String)hTTPRequest.getHeader("Referer"), (String)"foobar.com");
            Assert.assertEquals((String)hTTPRequest.getHeader("User-Agent"), (String)"java-http test");
            Assert.assertEquals((String)hTTPRequest.getHost(), (String)(string.equals("http") ? "localhost" : "local.fusionauth.io"));
            Assert.assertEquals((String)hTTPRequest.getIPAddress(), (String)"127.0.0.1");
            Assert.assertEquals((Collection)hTTPRequest.getLocales(), List.of(Locale.ENGLISH, Locale.GERMAN, Locale.FRENCH));
            Assert.assertEquals((Object)hTTPRequest.getMethod(), (Object)HTTPMethod.GET);
            Assert.assertEquals((String)hTTPRequest.getParameter("foo "), (String)"bar ");
            Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/api/system/version");
            Assert.assertEquals((int)hTTPRequest.getPort(), (int)4242);
            Assert.assertEquals((String)hTTPRequest.getProtocol(), (String)"HTTP/1.1");
            Assert.assertEquals((String)hTTPRequest.getQueryString(), (String)"foo%20=bar%20");
            Assert.assertEquals((String)hTTPRequest.getScheme(), (String)string);
            Assert.assertEquals((String)hTTPRequest.getURLParameter("foo "), (String)"bar ");
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(ExpectedResponse.getBytes());
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = ((HTTPServer)this.makeServer(string, hTTPHandler).withResponseBufferSize(n)).start();){
            URI uRI = this.makeURI(string, "?foo%20=bar%20");
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).header("Accept-Encoding", "deflate, compress, br;q=0.5, gzip;q=0.8, identity;q=1.0").header("Accept-Language", "en, fr;q=0.7, de;q=0.8").header("Content-Type", "text/plain; charset=ISO-8859-1").header("Origin", "https://example.com").header("Referer", "foobar.com").header("User-Agent", "java-http test").GET().build();
            HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofInputStream());
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)httpResponse.headers().firstValue("Content-Encoding").get(), (String)"deflate");
            Assert.assertEquals((String)httpResponse.headers().firstValue("Transfer-Encoding").get(), (String)"chunked");
            String string2 = new String(new InflaterInputStream((InputStream)httpResponse.body()).readAllBytes(), StandardCharsets.UTF_8);
            Assert.assertEquals((String)string2, (String)ExpectedResponse);
        }
    }

    @Test
    public void simpleGetMultiplePorts() throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setHeader("Content-Length", "16");
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(ExpectedResponse.getBytes());
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        Certificate[] certificateArray = new Certificate[]{certificate, intermediateCertificate};
        try (HttpClient httpClient = this.makeClient("https", null);
             HTTPServer hTTPServer = ((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)new HTTPServer().withHandler(hTTPHandler)).withListener(new HTTPListenerConfiguration(4242))).withListener(new HTTPListenerConfiguration(4243))).withListener(new HTTPListenerConfiguration(4244, certificateArray, keyPair.getPrivate()))).withLoggerFactory((LoggerFactory)AccumulatingLoggerFactory.FACTORY)).start();){
            URI uRI = URI.create("http://localhost:4242/api/system/version?foo=bar");
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build();
            HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
            uRI = URI.create("http://localhost:4243/api/system/version?foo=bar");
            httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build();
            httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
            uRI = URI.create("https://local.fusionauth.io:4244/api/system/version?foo=bar");
            httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build();
            httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
        }
    }

    @Test(dataProvider="schemesAndResponseBufferSizes")
    public void simplePost(String string, int n) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Object object;
            this.println("Handling");
            Assert.assertEquals((String)hTTPRequest.getHeader("Content-Type"), (String)"application/json");
            try {
                this.println("Reading");
                object = hTTPRequest.getInputStream().readAllBytes();
                Assert.assertEquals((String)new String((byte[])object), (String)RequestBody);
            }
            catch (IOException iOException) {
                Assert.fail((String)"Unable to parse body", (Throwable)iOException);
            }
            this.println("Done");
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setHeader("Content-Length", "16");
            hTTPResponse.setStatus(200);
            try {
                this.println("Writing");
                object = hTTPResponse.getOutputStream();
                ((OutputStream)object).write(ExpectedResponse.getBytes());
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        try (HTTPServer hTTPServer = ((HTTPServer)this.makeServer(string, hTTPHandler).withResponseBufferSize(n)).start();
             HttpClient httpClient = this.makeClient(string, null);){
            URI uRI = this.makeURI(string, "?foo=bar");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(RequestBody)).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
        }
    }

    @Test(dataProvider="schemes", groups={"timeouts"})
    public void slowClient(String string) throws Exception {
        byte[] byArray = new byte[0x800000];
        new SecureRandom().nextBytes(byArray);
        boolean bl = false;
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setContentType("application/octet-stream");
            hTTPResponse.setContentLength((long)byArray.length);
            hTTPResponse.setStatus(200);
            int n = 1;
            OutputStream outputStream = hTTPResponse.getOutputStream();
            for (int i = 0; i < byArray.length; i += 8192) {
                outputStream.write(byArray, i, 8192);
                if (!bl) continue;
                this.println("> Wrote    [8192] bytes. Total bytes written [" + n++ * 8 * 1024 + "].");
            }
            outputStream.close();
        };
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        AtomicInteger atomicInteger = new AtomicInteger();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = ((HTTPServer)((HTTPServer)this.makeServer(string, hTTPHandler).withWriteThroughputCalculationDelayDuration(Duration.ofMillis(1L))).withMinimumWriteThroughput(0x40000000L)).start();){
            URI uRI = this.makeURI(string, "");
            httpClient.send(HttpRequest.newBuilder().uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofByteArrayConsumer(optional -> {
                byte[] byArray = optional.orElse(null);
                if (byArray != null) {
                    if (!atomicBoolean.get()) {
                        int n = 5000;
                        if (bl) {
                            this.println("> Received [" + byArray.length + "] bytes. Total bytes received [" + atomicInteger.addAndGet(byArray.length) + "]. Sleep [" + n + "] ms.");
                        }
                        this.sleep(n);
                        atomicBoolean.set(true);
                    }
                } else {
                    this.println("no bytes");
                }
            }));
            Assert.fail((String)"Should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(groups={"timeouts"})
    public void slowHandler() {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertNull((Object)hTTPRequest.getContentType());
            hTTPResponse.setContentLength(2L);
            hTTPResponse.setStatus(200);
            OutputStream outputStream = hTTPResponse.getOutputStream();
            outputStream.write(52);
            hTTPResponse.flush();
            if (!atomicBoolean.getAndSet(true)) {
                this.println("Pausing for 4 seconds");
                this.sleep(4000L);
            }
            outputStream.write(50);
        };
        try (HTTPServer hTTPServer = ((HTTPServer)((HTTPServer)this.makeServer("http", hTTPHandler).withProcessingTimeoutDuration(Duration.ofSeconds(20L))).withWriteThroughputCalculationDelayDuration(Duration.ofSeconds(1L))).start();){
            URI uRI = this.makeURI("http", "");
            this.println("Sending first request");
            ClientResponse clientResponse = new RESTClient(String.class, String.class).url(uRI.toString()).connectTimeout(0).readTimeout(0).errorResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).successResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).get().go();
            this.println("Got first response");
            if (clientResponse.status != 200) {
                this.println(clientResponse.exception);
            }
            Assert.assertEquals((int)clientResponse.status, (int)200);
            Assert.assertEquals((String)((String)clientResponse.successResponse), (String)"4");
            this.println("Sending second request");
            clientResponse = new RESTClient(String.class, String.class).url(uRI.toString()).connectTimeout(0).readTimeout(0).errorResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).successResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).get().go();
            this.println("Got second response");
            if (clientResponse.status != 200) {
                this.println(clientResponse.exception);
            }
            Assert.assertEquals((int)clientResponse.status, (int)200);
            Assert.assertEquals((String)((String)clientResponse.successResponse), (String)"42");
        }
    }

    @Test(dataProvider="schemes")
    public void statusOnly(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {};
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(RequestBody)).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
        }
    }

    @Test
    public void tlsIssues() throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setStatus(200);
            hTTPResponse.getOutputStream().close();
        };
        try (HttpClient httpClient = this.makeClient("https", null);
             HTTPServer hTTPServer = this.makeServer("https", hTTPHandler).start();){
            URI uRI = this.makeURI("https", "");
            HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofByteArray("primeCSRFToken=QkJCAXsbQBgZhSVe1I4dv9B2ZXYDbUtCzAYUwfkvRjUJcUsBosHTeRbpvHgqXPN8TIK8DkSjG6HeaeJ-Yr4oCnXlUIW8T1r_9tVvuxxo38VKucd8gLnC2Mx7h_QuZu9dHEN79Q%3D%3D&tenantId=&tenant.name=Testing2&tenant.issuer=acme.com&tenant.themeId=75a068fd-e94b-451a-9aeb-3ddb9a3b5987&tenant.formConfiguration.adminUserFormId=ff153db4-d233-fcaa-76fd-98649866ff0b&__cb_tenant.usernameConfiguration.unique.enabled=false&tenant.usernameConfiguration.unique.strategy=OnCollision&tenant.usernameConfiguration.unique.numberOfDigits=5&tenant.usernameConfiguration.unique.separator=%23&tenant.connectorPolicies%5B0%5D.connectorId=e3306678-a53a-4964-9040-1c96f36dda72&connectorDomains%5B0%5D=*&tenant.connectorPolicies%5B0%5D.migrate=false&tenant.emailConfiguration.host=smtp.sendgrid.net&tenant.emailConfiguration.port=587&tenant.emailConfiguration.username=apikey&tenant.emailConfiguration.password=&tenant.emailConfiguration.security=TLS&tenant.emailConfiguration.defaultFromEmail=no-reply%40fusionauth.io&tenant.emailConfiguration.defaultFromName=FusionAuth&additionalEmailHeaders=&__cb_tenant.emailConfiguration.debug=false&__cb_tenant.emailConfiguration.verifyEmail=false&tenant.emailConfiguration.verifyEmail=true&__cb_tenant.emailConfiguration.implicitEmailVerificationAllowed=false&tenant.emailConfiguration.implicitEmailVerificationAllowed=true&__cb_tenant.emailConfiguration.verifyEmailWhenChanged=false&tenant.emailConfiguration.verificationEmailTemplateId=7fa81426-42a9-4eb2-ac09-73c044d410b1&tenant.emailConfiguration.emailVerifiedEmailTemplateId=&tenant.emailConfiguration.verificationStrategy=FormField&tenant.emailConfiguration.unverified.behavior=Gated&__cb_tenant.emailConfiguration.unverified.allowEmailChangeWhenGated=false&__cb_tenant.userDeletePolicy.unverified.enabled=false&tenant.userDeletePolicy.unverified.numberOfDaysToRetain=120&tenant.emailConfiguration.emailUpdateEmailTemplateId=&tenant.emailConfiguration.forgotPasswordEmailTemplateId=0502df1e-4010-4b43-b571-d423fce978b2&tenant.emailConfiguration.loginIdInUseOnCreateEmailTemplateId=&tenant.emailConfiguration.loginIdInUseOnUpdateEmailTemplateId=&tenant.emailConfiguration.loginNewDeviceEmailTemplateId=&tenant.emailConfiguration.loginSuspiciousEmailTemplateId=&tenant.emailConfiguration.passwordResetSuccessEmailTemplateId=&tenant.emailConfiguration.passwordUpdateEmailTemplateId=&tenant.emailConfiguration.passwordlessEmailTemplateId=fa6668cb-8569-44df-b0a2-8fcd996df915&tenant.emailConfiguration.setPasswordEmailTemplateId=e160cc59-a73e-4d95-8287-f82e5c541a5c&tenant.emailConfiguration.twoFactorMethodAddEmailTemplateId=&tenant.emailConfiguration.twoFactorMethodRemoveEmailTemplateId=&__cb_tenant.familyConfiguration.enabled=false&tenant.familyConfiguration.maximumChildAge=12&tenant.familyConfiguration.minimumOwnerAge=21&__cb_tenant.familyConfiguration.allowChildRegistrations=false&tenant.familyConfiguration.allowChildRegistrations=true&tenant.familyConfiguration.familyRequestEmailTemplateId=&tenant.familyConfiguration.confirmChildEmailTemplateId=&tenant.familyConfiguration.parentRegistrationEmailTemplateId=&__cb_tenant.familyConfiguration.parentEmailRequired=false&__cb_tenant.familyConfiguration.deleteOrphanedAccounts=false&tenant.familyConfiguration.deleteOrphanedAccountsDays=30&tenant.multiFactorConfiguration.loginPolicy=Enabled&__cb_tenant.multiFactorConfiguration.authenticator.enabled=false&tenant.multiFactorConfiguration.authenticator.enabled=true&__cb_tenant.multiFactorConfiguration.email.enabled=false&tenant.multiFactorConfiguration.email.templateId=61ee368e-018e-4c15-b7a7-47a696648dba&__cb_tenant.multiFactorConfiguration.sms.enabled=false&tenant.multiFactorConfiguration.sms.messengerId=&tenant.multiFactorConfiguration.sms.templateId=&__cb_tenant.webAuthnConfiguration.enabled=false&tenant.webAuthnConfiguration.enabled=true&tenant.webAuthnConfiguration.relyingPartyId=&tenant.webAuthnConfiguration.relyingPartyName=&__cb_tenant.webAuthnConfiguration.debug=false&__cb_tenant.webAuthnConfiguration.bootstrapWorkflow.enabled=false&tenant.webAuthnConfiguration.bootstrapWorkflow.authenticatorAttachmentPreference=any&tenant.webAuthnConfiguration.bootstrapWorkflow.userVerificationRequirement=required&__cb_tenant.webAuthnConfiguration.reauthenticationWorkflow.enabled=false&tenant.webAuthnConfiguration.reauthenticationWorkflow.enabled=true&tenant.webAuthnConfiguration.reauthenticationWorkflow.authenticatorAttachmentPreference=platform&tenant.webAuthnConfiguration.reauthenticationWorkflow.userVerificationRequirement=required&tenant.httpSessionMaxInactiveInterval=172800&tenant.logoutURL=&tenant.oauthConfiguration.clientCredentialsAccessTokenPopulateLambdaId=&tenant.jwtConfiguration.timeToLiveInSeconds=3600&tenant.jwtConfiguration.accessTokenKeyId=aea58f2a-4943-15ed-2190-0aa051200b64&tenant.jwtConfiguration.idTokenKeyId=092dbedc-30af-4149-9c61-b578f2c72f59&tenant.jwtConfiguration.refreshTokenExpirationPolicy=Fixed&tenant.jwtConfiguration.refreshTokenTimeToLiveInMinutes=43200&tenant.jwtConfiguration.refreshTokenSlidingWindowConfiguration.maximumTimeToLiveInMinutes=43200&tenant.jwtConfiguration.refreshTokenUsagePolicy=Reusable&__cb_tenant.jwtConfiguration.refreshTokenRevocationPolicy.onLoginPrevented=false&tenant.jwtConfiguration.refreshTokenRevocationPolicy.onLoginPrevented=true&__cb_tenant.jwtConfiguration.refreshTokenRevocationPolicy.onMultiFactorEnable=false&__cb_tenant.jwtConfiguration.refreshTokenRevocationPolicy.onPasswordChanged=false&tenant.jwtConfiguration.refreshTokenRevocationPolicy.onPasswordChanged=true&tenant.failedAuthenticationConfiguration.userActionId=&tenant.failedAuthenticationConfiguration.tooManyAttempts=5&tenant.failedAuthenticationConfiguration.resetCountInSeconds=60&tenant.failedAuthenticationConfiguration.actionDuration=3&tenant.failedAuthenticationConfiguration.actionDurationUnit=MINUTES&__cb_tenant.failedAuthenticationConfiguration.actionCancelPolicy.onPasswordReset=false&__cb_tenant.failedAuthenticationConfiguration.emailUser=false&__cb_tenant.passwordValidationRules.breachDetection.enabled=false&tenant.passwordValidationRules.breachDetection.matchMode=High&tenant.passwordValidationRules.breachDetection.onLogin=Off&tenant.passwordValidationRules.breachDetection.notifyUserEmailTemplateId=&tenant.passwordValidationRules.minLength=8&tenant.passwordValidationRules.maxLength=256&__cb_tenant.passwordValidationRules.requireMixedCase=false&__cb_tenant.passwordValidationRules.requireNonAlpha=false&__cb_tenant.passwordValidationRules.requireNumber=false&__cb_tenant.minimumPasswordAge.enabled=false&tenant.minimumPasswordAge.seconds=30&__cb_tenant.maximumPasswordAge.enabled=false&tenant.maximumPasswordAge.days=180&__cb_tenant.passwordValidationRules.rememberPreviousPasswords.enabled=false&tenant.passwordValidationRules.rememberPreviousPasswords.count=1&__cb_tenant.passwordValidationRules.validateOnLogin=false&tenant.passwordEncryptionConfiguration.encryptionScheme=salted-pbkdf2-hmac-sha256&tenant.passwordEncryptionConfiguration.encryptionSchemeFactor=24000&__cb_tenant.passwordEncryptionConfiguration.modifyEncryptionSchemeOnLogin=false&__cb_tenant.eventConfiguration.events%5B%27JWTPublicKeyUpdate%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27JWTPublicKeyUpdate%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27JWTRefreshTokenRevoke%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27JWTRefreshTokenRevoke%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27JWTRefresh%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27JWTRefresh%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27GroupCreate%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27GroupCreate%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27GroupCreateComplete%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27GroupDelete%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27GroupDelete%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27GroupDeleteComplete%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27GroupMemberAdd%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27GroupMemberAdd%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27GroupMemberAddComplete%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27GroupMemberRemove%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27GroupMemberRemove%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27GroupMemberRemoveComplete%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27GroupMemberUpdate%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27GroupMemberUpdate%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27GroupMemberUpdateComplete%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27GroupUpdate%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27GroupUpdate%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27GroupUpdateComplete%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserAction%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserBulkCreate%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserBulkCreate%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserCreate%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserCreate%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserCreateComplete%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserDeactivate%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserDeactivate%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserDelete%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserDelete%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserDeleteComplete%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserEmailUpdate%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserEmailVerified%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserEmailVerified%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserIdentityProviderLink%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserIdentityProviderUnlink%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserLoginIdDuplicateOnCreate%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserLoginIdDuplicateOnUpdate%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserLoginFailed%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserLoginFailed%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserLoginNewDevice%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserLoginNewDevice%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserLoginSuccess%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserLoginSuccess%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserLoginSuspicious%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserLoginSuspicious%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserPasswordBreach%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserPasswordBreach%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserPasswordResetSend%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserPasswordResetStart%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserPasswordResetSuccess%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserPasswordUpdate%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserReactivate%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserReactivate%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserRegistrationCreate%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserRegistrationCreate%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserRegistrationCreateComplete%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserRegistrationDelete%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserRegistrationDelete%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserRegistrationDeleteComplete%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserRegistrationUpdate%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserRegistrationUpdate%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserRegistrationUpdateComplete%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserRegistrationVerified%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserRegistrationVerified%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserTwoFactorMethodAdd%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserTwoFactorMethodRemove%27%5D.enabled=false&__cb_tenant.eventConfiguration.events%5B%27UserUpdate%27%5D.enabled=false&tenant.eventConfiguration.events%5B%27UserUpdate%27%5D.transactionType=None&__cb_tenant.eventConfiguration.events%5B%27UserUpdateComplete%27%5D.enabled=false&tenant.externalIdentifierConfiguration.authorizationGrantIdTimeToLiveInSeconds=30&tenant.externalIdentifierConfiguration.changePasswordIdTimeToLiveInSeconds=600&tenant.externalIdentifierConfiguration.deviceCodeTimeToLiveInSeconds=300&tenant.externalIdentifierConfiguration.emailVerificationIdTimeToLiveInSeconds=86400&tenant.externalIdentifierConfiguration.externalAuthenticationIdTimeToLiveInSeconds=300&tenant.externalIdentifierConfiguration.oneTimePasswordTimeToLiveInSeconds=60&tenant.externalIdentifierConfiguration.passwordlessLoginTimeToLiveInSeconds=180&tenant.externalIdentifierConfiguration.pendingAccountLinkTimeToLiveInSeconds=3600&tenant.externalIdentifierConfiguration.registrationVerificationIdTimeToLiveInSeconds=86400&tenant.externalIdentifierConfiguration.samlv2AuthNRequestIdTimeToLiveInSeconds=300&tenant.externalIdentifierConfiguration.setupPasswordIdTimeToLiveInSeconds=86400&tenant.externalIdentifierConfiguration.trustTokenTimeToLiveInSeconds=180&tenant.externalIdentifierConfiguration.twoFactorIdTimeToLiveInSeconds=300&tenant.externalIdentifierConfiguration.twoFactorOneTimeCodeIdTimeToLiveInSeconds=60&tenant.externalIdentifierConfiguration.twoFactorTrustIdTimeToLiveInSeconds=2592000&tenant.externalIdentifierConfiguration.webAuthnAuthenticationChallengeTimeToLiveInSeconds=180&tenant.externalIdentifierConfiguration.webAuthnRegistrationChallengeTimeToLiveInSeconds=180&tenant.externalIdentifierConfiguration.changePasswordIdGenerator.length=32&tenant.externalIdentifierConfiguration.changePasswordIdGenerator.type=randomBytes&tenant.externalIdentifierConfiguration.emailVerificationIdGenerator.length=32&tenant.externalIdentifierConfiguration.emailVerificationIdGenerator.type=randomBytes&tenant.externalIdentifierConfiguration.emailVerificationOneTimeCodeGenerator.length=6&tenant.externalIdentifierConfiguration.emailVerificationOneTimeCodeGenerator.type=randomAlphaNumeric&tenant.externalIdentifierConfiguration.passwordlessLoginGenerator.length=32&tenant.externalIdentifierConfiguration.passwordlessLoginGenerator.type=randomBytes&tenant.externalIdentifierConfiguration.registrationVerificationIdGenerator.length=32&tenant.externalIdentifierConfiguration.registrationVerificationIdGenerator.type=randomBytes&tenant.externalIdentifierConfiguration.registrationVerificationOneTimeCodeGenerator.length=6&tenant.externalIdentifierConfiguration.registrationVerificationOneTimeCodeGenerator.type=randomAlphaNumeric&tenant.externalIdentifierConfiguration.setupPasswordIdGenerator.length=32&tenant.externalIdentifierConfiguration.setupPasswordIdGenerator.type=randomBytes&tenant.externalIdentifierConfiguration.deviceUserCodeIdGenerator.length=6&tenant.externalIdentifierConfiguration.deviceUserCodeIdGenerator.type=randomAlphaNumeric&tenant.externalIdentifierConfiguration.twoFactorOneTimeCodeIdGenerator.length=6&tenant.externalIdentifierConfiguration.twoFactorOneTimeCodeIdGenerator.type=randomDigits&tenant.emailConfiguration.properties=&__cb_tenant.scimServerConfiguration.enabled=false&tenant.scimServerConfiguration.clientEntityTypeId=&tenant.scimServerConfiguration.serverEntityTypeId=&tenant.lambdaConfiguration.scimUserRequestConverterId=&tenant.lambdaConfiguration.scimUserResponseConverterId=&tenant.lambdaConfiguration.scimEnterpriseUserRequestConverterId=&tenant.lambdaConfiguration.scimEnterpriseUserResponseConverterId=&tenant.lambdaConfiguration.scimGroupRequestConverterId=&tenant.lambdaConfiguration.scimGroupResponseConverterId=&scimSchemas=&__cb_tenant.loginConfiguration.requireAuthentication=false&tenant.loginConfiguration.requireAuthentication=true&tenant.accessControlConfiguration.uiIPAccessControlListId=&__cb_tenant.captchaConfiguration.enabled=false&tenant.captchaConfiguration.enabled=true&tenant.captchaConfiguration.captchaMethod=GoogleRecaptchaV2&tenant.captchaConfiguration.siteKey=6LdGKU8kAAAAAJ75pcseAvWyo3cYnQyIU3eGqulg&tenant.captchaConfiguration.secretKey=6LdGKU8kAAAAALqeN2ECaeLOONJduofuRerZBlyI&tenant.captchaConfiguration.threshold=0.5&tenant.ssoConfiguration.deviceTrustTimeToLiveInSeconds=31536000&blockedDomains=&__cb_tenant.rateLimitConfiguration.failedLogin.enabled=false&tenant.rateLimitConfiguration.failedLogin.limit=5&tenant.rateLimitConfiguration.failedLogin.timePeriodInSeconds=60&__cb_tenant.rateLimitConfiguration.forgotPassword.enabled=false&tenant.rateLimitConfiguration.forgotPassword.limit=5&tenant.rateLimitConfiguration.forgotPassword.timePeriodInSeconds=60&__cb_tenant.rateLimitConfiguration.sendEmailVerification.enabled=false&tenant.rateLimitConfiguration.sendEmailVerification.limit=5&tenant.rateLimitConfiguration.sendEmailVerification.timePeriodInSeconds=60&__cb_tenant.rateLimitConfiguration.sendPasswordless.enabled=false&tenant.rateLimitConfiguration.sendPasswordless.limit=5&tenant.rateLimitConfiguration.sendPasswordless.timePeriodInSeconds=60&__cb_tenant.rateLimitConfiguration.sendRegistrationVerification.enabled=false&tenant.rateLimitConfiguration.sendRegistrationVerification.limit=5&tenant.rateLimitConfiguration.sendRegistrationVerification.timePeriodInSeconds=60&__cb_tenant.rateLimitConfiguration.sendTwoFactor.enabled=false&tenant.rateLimitConfiguration.sendTwoFactor.limit=5&tenant.rateLimitConfiguration.sendTwoFactor.timePeriodInSeconds=60".getBytes(StandardCharsets.UTF_8));
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).header("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8").header("Accept-Encoding", "gzip, deflate, br").header("Accept-Language", "en-US,en;q=0.5").header("Cache-Control", "max-age=0").header("Connection", "keep-alive").header("Content-Type", "application/x-www-form-urlencoded").header("Cookie", "_pk_id.1.8f36=19a58ac7d2eae34e.1703797254.; _pk_ses.1.8f36=1; fusionauth.locale=en; fusionauth.timezone=America/Denver; fusionauth.trusted-device.LJ9DfxybqbRJDIEar0MjOs1Dh9t4CUII7Ynx6BwZTbM=vAZ_0ETfK-utHZr6ErKdZm3s13LnYSmo8v417oiOB2wYmD09Nb_EYTcZ0RZFfkFf; fusionauth.known-device.LJ9DfxybqbRJDIEar0MjOs1Dh9t4CUII7Ynx6BwZTbM=oR3hEmqnAZQNtsYHG-3iSfkTVaohg0AQx_4WTfIS_213Lz6hxqPrBoj5LePRFqQd; federated.csrf=_I0Ug4kFjA7XhWva; fusionauth.sso=AoG7EJ2m0K5rARXr8LtYE_mjHpZSI2gMuHSzl-LD3e9SyBTTQszseRICR14rbUiqz7cwDfI3FgNcWbJBjvge506EHUfwBw-zGaM6pkDVoXfDIrOJdNUuCa8Ypzlt9lA6EqlTXZVWucErgXU1GxzikDA; fusionauth.remember-device=QkJCARHvawOLQQo6u55SnnjQnB9azwdr-fk7WmSc7NEEokml; fusionauth.rt=532xIZvgP15j7_s6XwKSh33Fj10waD8GeRqE7nEQe4D4CZl2VSitmQ; fusionauth.at=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCIsImd0eSI6WyJhdXRob3JpemF0aW9uX2NvZGUiXSwia2lkIjoiY2QwYWIwYmUzIn0.eyJhdWQiOiIzYzIxOWU1OC1lZDBlLTRiMTgtYWQ0OC1mNGY5Mjc5M2FlMzIiLCJleHAiOjE3MDU3MDI2NzksImlhdCI6MTcwNTcwMjYxOSwiaXNzIjoiYWNtZS5jb20iLCJzdWIiOiIwMDAwMDAwMC0wMDAwLTAwMDAtMDAwMC0wMDAwMDAwMDAwMDEiLCJqdGkiOiIwNzI5YjczMy03OGQ1LTQwNDAtOTY5Ni0zNWVjYWQ5YWYyZDgiLCJhdXRoZW50aWNhdGlvblR5cGUiOiJQSU5HIiwiZW1haWwiOiJhZG1pbkBmdXNpb25hdXRoLmlvIiwiZW1haWxfdmVyaWZpZWQiOnRydWUsImFwcGxpY2F0aW9uSWQiOiIzYzIxOWU1OC1lZDBlLTRiMTgtYWQ0OC1mNGY5Mjc5M2FlMzIiLCJzY29wZSI6Im9mZmxpbmVfYWNjZXNzIiwicm9sZXMiOlsiYWRtaW4iXSwic2lkIjoiODRhNGZmYzMtMWMzYy00OTA3LWIwZTgtZmY0NWNmNDFjMTkxIiwiYXV0aF90aW1lIjoxNzA1NzAyNjE5LCJ0aWQiOiIzMDY2MzEzMi02NDY0LTY2NjUtMzAzMi0zMjY0NjY2MTM5MzQifQ.twCgoWKPVLJuBaTCGTMdKWto8XICHpCk6zp2QkSIjNM; io.fusionauth.app.action.admin.tenant.IndexAction$s=QkJCA9x7yVuN7noZSN59WZMzJZGPcjSGAJjVr5ghJbPz3sOOcoCAS7PrcyMXBax0Cb6JdqCebWfX0tD4Y3lt5EK9KM8=").header("Origin", "https://local.fusionauth.io:9013").header("Referer", "https://local.fusionauth.io:9013/").header("Sec-Fetch-Dest", "document").header("Sec-Fetch-Mode", "navigate").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-User", "?1").header("Sec-GPC", "1").header("Upgrade-Insecure-Requests", "1").header("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36").header("sec-ch-ua", "\"Not_A Brand\";v=\"8\", \"Chromium\";v=\"120\", \"Brave\";v=\"120\"").header("sec-ch-ua-mobile", "?0").header("sec-ch-ua-platform", "\"macOS\"").POST(bodyPublisher).build();
            HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofInputStream());
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
        }
    }

    @Test(dataProvider="schemes")
    public void unicode(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertEquals((String)URLDecoder.decode(hTTPRequest.getPath(), StandardCharsets.UTF_8), (String)"/\uc704\ud0a4\ubc31\uacfc:\ub300\ubb38");
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            hTTPResponse.getOutputStream().close();
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = URI.create("http://localhost:4242/\uc704\ud0a4\ubc31\uacfc:\ub300\ubb38");
            if (string.equals("https")) {
                uRI = URI.create("https://local.fusionauth.io:4242/\uc704\ud0a4\ubc31\uacfc:\ub300\ubb38");
            }
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build();
            HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.discarding());
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
        }
    }

    @Test(dataProvider="schemes")
    public void utf8HeaderValues(String string) throws Exception {
        String string2 = "S\u00e3o Paulo";
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setHeader("Content-Length", "" + ExpectedResponse.getBytes().length);
            hTTPResponse.setHeader("X-Response-Header", string2);
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(ExpectedResponse.getBytes());
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        try (HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();
             Socket socket = this.makeClientSocket(string);){
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(String.format("GET /api/status HTTP/1.1\r\nHost: localhost:42\r\nX-Request-Header: %s\r\n\r\n", string2).getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            String string3 = String.format("HTTP/1.1 200 \r\nconnection: keep-alive\r\ncontent-type: text/plain\r\ncontent-length: 16\r\nx-response-header: %s\r\n\r\n{\"version\":\"42\"}", string2);
            this.assertHTTPResponseEquals(socket, string3);
        }
    }

    @Test(dataProvider="schemes")
    public void writer(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            try {
                hTTPRequest.getInputStream().readAllBytes();
                hTTPResponse.setHeader("Content-Type", "text/plain; charset=UTF-16");
                hTTPResponse.setHeader("Content-Length", String.valueOf(ExpectedResponse.getBytes(StandardCharsets.UTF_16).length));
                hTTPResponse.setStatus(200);
                Writer writer = hTTPResponse.getWriter();
                writer.write(ExpectedResponse);
                writer.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(RequestBody)).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_16));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
        }
    }
}

