/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.BaseTest;
import io.fusionauth.http.server.CountingInstrumenter;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPServer;
import io.fusionauth.http.server.Instrumenter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CompressionTest
extends BaseTest {
    private final Path file = Paths.get("src/test/java/io/fusionauth/http/ChunkedTest.java", new String[0]);

    @DataProvider(name="chunkedSchemes")
    public Object[][] chunkedSchemes() {
        return new Object[][]{{"http", true}, {"http", false}, {"https", true}, {"https", false}};
    }

    /*
     * WARNING - void declaration
     */
    @Test(dataProvider="compressedChunkedSchemes")
    public void compress(String string, String string2, String string3) throws Exception {
        Object object;
        Object object2;
        Object[] objectArray;
        byte[] byArray;
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            String string = new String(hTTPRequest.getInputStream().readAllBytes());
            Assert.assertEquals((String)string, (String)"Hello world!");
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            hTTPResponse.setContentLength(Files.size(this.file));
            try (InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        String string4 = "Hello world!";
        byte[] byArray2 = byArray = string4.getBytes(StandardCharsets.UTF_8);
        if (!string2.isEmpty()) {
            void var9_11;
            Object[] object3 = objectArray = (Object[])string2.toLowerCase().trim().split(",");
            int n = object3.length;
            for (int i = 0; i < n; ++i) {
                object2 = object3[i];
                object = object2.trim();
                if (((String)object).equals("deflate")) {
                    byArray2 = this.deflate(byArray2);
                    continue;
                }
                if (!((String)object).equals("gzip") && !((String)object).equals("x-gzip")) continue;
                byArray2 = this.gzip(byArray2);
            }
            byte[] byArray3 = byArray2;
            for (n = objectArray.length - 1; n >= 0; --n) {
                String string5 = objectArray[n].trim();
                if (string5.equals("deflate")) {
                    byte[] byArray4 = this.inflate((byte[])var9_11);
                    continue;
                }
                if (!string5.equals("gzip") && !string5.equals("x-gzip")) continue;
                byte[] byArray5 = this.ungzip((byte[])var9_11);
            }
            Assert.assertEquals((byte[])var9_11, (byte[])byArray);
            Assert.assertEquals((String)new String(byArray), (String)string4);
        }
        objectArray = byArray2;
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            object2 = this.makeURI(string, "");
            object = httpClient.send(HttpRequest.newBuilder().uri((URI)object2).header("Accept-Encoding", string3).header("Content-Encoding", string2).header("Content-Type", "text/plain").header("Transfer-Encoding", "chunked").POST(HttpRequest.BodyPublishers.ofInputStream(() -> CompressionTest.lambda$compress$1((byte[])objectArray))).build(), responseInfo -> HttpResponse.BodySubscribers.ofInputStream());
            Assert.assertEquals((int)object.statusCode(), (int)200);
            String string6 = null;
            Object object4 = string3.toLowerCase().trim().split(",");
            int n = ((String[])object4).length;
            int n2 = 0;
            if (n2 < n) {
                String string7 = object4[n2];
                string6 = string7.trim();
            }
            Assert.assertNotNull(string6);
            object4 = null;
            InputStream inputStream = (InputStream)object.body();
            if (string6.isEmpty()) {
                object4 = new String(inputStream.readAllBytes());
            } else {
                Assert.assertEquals((String)object.headers().firstValue("Content-Encoding").orElse(null), (String)string6);
                if (string6.equals("deflate")) {
                    object4 = new String(new InflaterInputStream(inputStream).readAllBytes());
                } else if (string6.equals("gzip") || string6.equals("x-gzip")) {
                    object4 = new String(new GZIPInputStream(inputStream).readAllBytes(), StandardCharsets.UTF_8);
                }
            }
            Assert.assertEquals((String)object4, (String)Files.readString(this.file));
        }
    }

    @Test
    public void compressBadContentLength() throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setCompress(true);
            hTTPResponse.setContentLength(1000000L);
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            try (InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        try (HttpClient httpClient = this.makeClient("http", null);
             HTTPServer hTTPServer = ((HTTPServer)this.makeServer("http", hTTPHandler).withCompressByDefault(false)).start();){
            URI uRI = this.makeURI("http", "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().header("Accept-Encoding", "gzip").uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofInputStream());
            Assert.assertEquals((String)httpResponse.headers().firstValue("Content-Encoding").orElse(null), (String)"gzip");
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)new String(new GZIPInputStream((InputStream)httpResponse.body()).readAllBytes(), StandardCharsets.UTF_8), (String)Files.readString(this.file));
        }
    }

    @Test(groups={"performance"})
    public void compressPerformance() throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            try (InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        for (boolean bl : List.of(Boolean.valueOf(true), Boolean.valueOf(false))) {
            CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
            HttpClient httpClient = this.makeClient("http", null);
            try {
                HTTPServer hTTPServer = ((HTTPServer)this.makeServer("http", hTTPHandler, (Instrumenter)countingInstrumenter).withCompressByDefault(bl)).start();
                try {
                    URI uRI = this.makeURI("http", "");
                    int n = 25000;
                    long l = System.currentTimeMillis();
                    for (int i = 0; i < n; ++i) {
                        HttpResponse httpResponse = bl ? httpClient.send(HttpRequest.newBuilder().header("Accept-Encoding", "gzip").uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofInputStream()) : httpClient.send(HttpRequest.newBuilder().header("Accept-Encoding", "gzip").uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
                        String string = bl ? new String(new GZIPInputStream((InputStream)httpResponse.body()).readAllBytes(), StandardCharsets.UTF_8) : httpResponse.body();
                        Assert.assertEquals((String)httpResponse.headers().firstValue("Content-Encoding").orElse(null), (String)(bl ? "gzip" : null));
                        Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
                        Assert.assertEquals((Object)string, (Object)Files.readString(this.file));
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    BigDecimal bigDecimal = new BigDecimal(l3).divide(new BigDecimal(n));
                    DecimalFormat decimalFormat = new DecimalFormat("#,###");
                    String string = bl ? bl + " " : "" + bl;
                    this.println("[compression: " + string + "][" + decimalFormat.format(n) + "] requests. Total time [" + decimalFormat.format(l3) + "] ms, Avg [" + String.valueOf(bigDecimal) + "] ms");
                }
                finally {
                    if (hTTPServer == null) continue;
                    hTTPServer.close();
                }
            }
            finally {
                if (httpClient == null) continue;
                httpClient.close();
            }
        }
    }

    @Test(dataProvider="schemes")
    public void compressWithContentLength(String string) throws Exception {
        String string2 = "Hello world!";
        byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = this.gzip(byArray);
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertEquals((boolean)hTTPRequest.isChunked(), (boolean)false);
            String string2 = hTTPRequest.getHeader("Content-Length");
            Assert.assertEquals((String)string2, (String)("" + byArray2.length));
            byte[] byArray2 = hTTPRequest.getInputStream().readAllBytes();
            Assert.assertNotEquals((Object)byArray2.length, (Object)string2);
            String string3 = new String(byArray2);
            Assert.assertEquals((String)string3, (String)string2);
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
        };
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(byArray2);
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, null).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Encoding", "gzip").header("Content-Type", "text/plain").POST(bodyPublisher).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)"");
        }
    }

    @DataProvider(name="compressedChunkedSchemes")
    public Object[][] compressedChunkedSchemes() {
        Object[][] objectArrayArray = new Object[][]{{"", ""}, {"deflate", ""}, {"gzip", ""}, {"", "deflate"}, {"", "gzip"}, {"deflate", "deflate"}, {"gzip", "gzip"}, {"Deflate", "Deflate"}, {"Gzip", "Gzip"}, {"deflate", "deflate, gzip"}, {"gzip", "gzip, deflate"}, {"deflate, gzip", "deflate, gzip"}, {"gzip, deflate", "gzip, deflate"}, {"x-gzip", "deflate, gzip"}, {"X-Gzip, deflate", "gzip, deflate"}, {"deflate, x-gzip", "gzip, deflate"}};
        Object[][] objectArray = this.schemes();
        Object[][] objectArray2 = new Object[objectArrayArray.length * 2][3];
        int n = 0;
        for (Object[] objectArray3 : objectArrayArray) {
            for (Object[] objectArray4 : objectArray) {
                objectArray2[n][0] = objectArray4[0];
                objectArray2[n][1] = objectArray3[0];
                objectArray2[n][2] = objectArray3[1];
                ++n;
            }
        }
        return objectArray2;
    }

    @Test(dataProvider="chunkedSchemes")
    public void requestedButNotAccepted(String string, boolean bl) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setCompress(true);
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            if (!bl) {
                hTTPResponse.setContentLength(Files.size(this.file));
            }
            try (InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertNull(httpResponse.headers().firstValue("Content-Encoding").orElse(null));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)Files.readString(this.file));
        }
    }

    @Test(dataProvider="chunkedSchemes")
    public void requestedButNotAccepted_unSupportedEncoding(String string, boolean bl) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setCompress(true);
            hTTPResponse.setCompress(true);
            hTTPResponse.setCompress(false);
            hTTPResponse.setCompress(true);
            hTTPResponse.setCompress(false);
            hTTPResponse.setCompress(true);
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            if (!bl) {
                hTTPResponse.setContentLength(Files.size(this.file));
            }
            try (InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                try {
                    hTTPResponse.setCompress(false);
                    AssertJUnit.fail((String)"Expected setCompress(false) to fail hard!");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().header("Accept-Encoding", "br").uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertNull(httpResponse.headers().firstValue("Content-Encoding").orElse(null));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)Files.readString(this.file));
        }
    }

    @Test(dataProvider="schemes")
    public void unsupportedContentType(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
        };
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> new ByteArrayInputStream("Hello World".getBytes(StandardCharsets.UTF_8)));
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, null).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Encoding", "br").header("Content-Type", "text/plain").POST(bodyPublisher).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)415);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)"");
        }
    }

    private static /* synthetic */ InputStream lambda$compress$1(byte[] byArray) {
        return new ByteArrayInputStream(byArray);
    }
}

