/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.io;

public class Throughput {
    private final long readThroughputDelay;
    private final long writeThroughputDelay;
    private long firstReadInstant;
    private long firstWroteInstant;
    private long lastReadInstant;
    private long lastWroteInstant;
    private long numberOfBytesRead;
    private long numberOfBytesWritten;

    public Throughput(long l, long l2) {
        this.readThroughputDelay = l;
        this.writeThroughputDelay = l2;
    }

    public synchronized long lastUsed() {
        if (this.lastReadInstant == 0L && this.lastWroteInstant == 0L) {
            return Long.MAX_VALUE;
        }
        return Math.max(this.lastReadInstant, this.lastWroteInstant);
    }

    public synchronized void read(long l) {
        long l2 = System.currentTimeMillis();
        if (this.firstReadInstant == 0L) {
            this.firstReadInstant = l2;
        }
        this.numberOfBytesRead += l;
        this.lastReadInstant = l2;
    }

    public synchronized long readThroughput(long l) {
        if (this.firstReadInstant == 0L || this.numberOfBytesRead == 0L || this.lastReadInstant == this.firstReadInstant) {
            return Long.MAX_VALUE;
        }
        if (this.numberOfBytesWritten == 0L) {
            long l2 = l - this.firstReadInstant;
            if (l2 < this.readThroughputDelay) {
                return Long.MAX_VALUE;
            }
            return this.numberOfBytesWritten;
        }
        double d = (double)this.numberOfBytesRead / (double)(this.lastReadInstant - this.firstReadInstant) * 1000.0;
        return Math.round(d);
    }

    public synchronized long writeThroughput(long l) {
        if (this.firstWroteInstant == 0L || this.numberOfBytesWritten == 0L) {
            return Long.MAX_VALUE;
        }
        long l2 = l - this.firstWroteInstant;
        if (l2 < this.writeThroughputDelay) {
            return Long.MAX_VALUE;
        }
        double d = (double)this.numberOfBytesWritten / (double)l2 * 1000.0;
        return Math.round(d);
    }

    public synchronized void wrote(long l) {
        long l2 = System.currentTimeMillis();
        if (this.firstWroteInstant == 0L) {
            this.firstWroteInstant = l2;
        }
        this.numberOfBytesWritten += l;
        this.lastWroteInstant = l2;
    }
}

