/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.FileInfo;
import io.fusionauth.http.io.DefaultMultipartFileManager;
import io.fusionauth.http.io.MultipartConfiguration;
import io.fusionauth.http.io.MultipartFileManager;
import io.fusionauth.http.io.MultipartStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MultipartStreamProcessor {
    private MultipartConfiguration multipartConfiguration;
    private MultipartFileManager multipartFileManager;

    public MultipartConfiguration getMultiPartConfiguration() {
        if (this.multipartConfiguration == null) {
            this.multipartConfiguration = new MultipartConfiguration();
        }
        return this.multipartConfiguration;
    }

    public MultipartFileManager getMultipartFileManager() {
        if (this.multipartFileManager == null) {
            this.getMultiPartConfiguration();
            this.multipartFileManager = new DefaultMultipartFileManager(Paths.get(this.multipartConfiguration.getTemporaryFileLocation(), new String[0]), this.multipartConfiguration.getTemporaryFilenamePrefix(), this.multipartConfiguration.getTemporaryFilenameSuffix());
        }
        return this.multipartFileManager;
    }

    public void process(InputStream inputStream, Map<String, List<String>> map, List<FileInfo> list, byte[] byArray) throws IOException {
        new MultipartStream(inputStream, byArray, this.getMultipartFileManager(), this.getMultiPartConfiguration()).process(map, list);
    }

    public void setMultipartConfiguration(MultipartConfiguration multipartConfiguration) {
        Objects.requireNonNull(multipartConfiguration);
        this.multipartConfiguration = multipartConfiguration;
    }
}

