/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.server.HTTPRequest;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HTTPRequestTest {
    @Test
    public void acceptEncoding() {
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.addHeader("Accept-Encoding", "foo, bar  , baz");
        Assert.assertEquals((Collection)hTTPRequest.getAcceptEncodings(), List.of("foo", "bar", "baz"));
    }

    @Test
    public void decodeHeaders() {
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setHeader("coNTent-LENGTH", "42");
        hTTPRequest.setHeader("coNTent-type", "multipart/form-data; boundary=--foobarbaz");
        Assert.assertTrue((boolean)hTTPRequest.isMultipart());
        Assert.assertEquals((String)hTTPRequest.getMultipartBoundary(), (String)"--foobarbaz");
        Assert.assertEquals((Long)hTTPRequest.getContentLength(), (Long)42L);
        Assert.assertNull((Object)hTTPRequest.getCharacterEncoding());
        hTTPRequest.setHeader("coNTent-type", "text/html; charset=UTF-8");
        Assert.assertEquals((Object)hTTPRequest.getCharacterEncoding(), (Object)StandardCharsets.UTF_8);
        hTTPRequest.setHeader("Content-Type", "text/html; charset=ISO-8859-1");
        Assert.assertEquals((Object)hTTPRequest.getCharacterEncoding(), (Object)StandardCharsets.ISO_8859_1);
        hTTPRequest.setHeader("content-type", "application/x-www-form-urlencoded");
        Assert.assertFalse((boolean)hTTPRequest.isMultipart());
        Assert.assertEquals((Long)hTTPRequest.getContentLength(), (Long)42L);
        Assert.assertNull((Object)hTTPRequest.getCharacterEncoding());
        hTTPRequest.setHeader("content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        Assert.assertFalse((boolean)hTTPRequest.isMultipart());
        Assert.assertEquals((Long)hTTPRequest.getContentLength(), (Long)42L);
        Assert.assertEquals((Object)hTTPRequest.getCharacterEncoding(), (Object)StandardCharsets.UTF_8);
        hTTPRequest.setHeader("content-type", "application/x-www-form-urlencoded; charset=ISO-8859-1");
        Assert.assertFalse((boolean)hTTPRequest.isMultipart());
        Assert.assertEquals((Long)hTTPRequest.getContentLength(), (Long)42L);
        Assert.assertEquals((Object)hTTPRequest.getCharacterEncoding(), (Object)StandardCharsets.ISO_8859_1);
    }

    @Test
    public void getBaseURL() {
        this.assertBaseURL("https://acme.com", "X-Forwarded-Host", "acme.com", "X-Forwarded-Proto", "https");
        this.assertBaseURL("https://acme.com:8192", "X-Forwarded-Host", "acme.com:8192", "X-Forwarded-Proto", "https");
        this.assertBaseURL("https://acme.com", "X-Forwarded-Host", "acme.com", "X-Forwarded-Port", "443", "X-Forwarded-Proto", "https");
        this.assertBaseURL("https://acme.com:8192", "X-Forwarded-Host", "acme.com", "X-Forwarded-Port", "8192", "X-Forwarded-Proto", "https");
        this.assertBaseURL("http://acme.com:8080", "X-Forwarded-Host", "acme.com");
        this.assertBaseURL("https://acme.com:8080", "X-Forwarded-Host", "acme.com:##", "X-Forwarded-Proto", "https");
        this.assertBaseURL("https://localhost:8080", "X-Forwarded-Proto", "https");
        this.assertBaseURL("https://localhost", (HTTPRequest hTTPRequest) -> hTTPRequest.setPort(80), "X-Forwarded-Proto", "https");
        this.assertBaseURL("http://localhost", (HTTPRequest hTTPRequest) -> {
            hTTPRequest.setPort(80);
            hTTPRequest.setScheme("https");
        }, "X-Forwarded-Proto", "http");
    }

    @Test
    public void getHost() {
        this.assertGetHost("acme.com", "acme.com");
        this.assertGetHost("acme.com:42", "acme.com");
        this.assertGetHost("acme.com, example.com", "acme.com");
        this.assertGetHost("acme.com ,  example.com ", "acme.com");
        this.assertGetHost("acme.com:41 ,  example.com:42 ", "acme.com");
    }

    @Test
    public void getIPAddress() {
        this.assertGetIPAddress("192.168.1.1", "192.168.1.1");
        this.assertGetIPAddress("192.168.1.1, 192.168.1.2", "192.168.1.1");
        this.assertGetIPAddress("192.168.1.1 ,  192.168.1.2 ", "192.168.1.1");
    }

    @Test
    public void hostHeaderPortHandling() {
        this.assertURLs("http", "myhost", "myhost", 80, "http://myhost");
        this.assertURLs("https", "myhost", "myhost", 443, "https://myhost");
        this.assertURLs("http", "myhost:80", "myhost", 80, "http://myhost");
        this.assertURLs("https", "myhost:80", "myhost", 80, "https://myhost:80");
        this.assertURLs("http", "myhost:443", "myhost", 443, "http://myhost:443");
        this.assertURLs("https", "myhost:443", "myhost", 443, "https://myhost");
        this.assertURLs("http", "myhost:9011", "myhost", 9011, "http://myhost:9011");
        this.assertURLs("https", "myhost:9011", "myhost", 9011, "https://myhost:9011");
        this.assertURLs("http", "myhost:abc", "myhost", -1, "http://myhost");
        this.assertURLs("https", "myhost:abc", "myhost", -1, "https://myhost");
        this.assertURLs("https", "otherhost:abc  ", "otherhost", -1, "https://otherhost");
    }

    @Test
    public void queryString() {
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setPath("/path?name=value");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of("name", List.of("value")));
        hTTPRequest.setPath("/path?name=value&name1=value1");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of("name", List.of("value"), "name1", List.of("value1")));
        hTTPRequest.setPath("/path?name+space=value+space&name1+space=value1+space");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of("name space", List.of("value space"), "name1 space", List.of("value1 space")));
        hTTPRequest.setPath("/path?name");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of());
        hTTPRequest.setPath("/path?name==");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of("name", List.of("=")));
        hTTPRequest.setPath("/path?==");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of());
        hTTPRequest.setPath("/path?==name=value");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of("name", List.of("value")));
        hTTPRequest.setPath("/path?name=a=b=c");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of("name", List.of("a=b=c")));
        hTTPRequest.setPath("/path?name&&");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of());
        hTTPRequest.setPath("/path?name=&");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of("name", List.of("")));
        hTTPRequest.setPath("/path?name=%26&");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of("name", List.of("&")));
        hTTPRequest.setPath("/path?name%3D=%26&");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of("name=", List.of("&")));
        hTTPRequest.setPath("/path?name=");
        Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/path");
        Assert.assertEquals((Map)hTTPRequest.getURLParameters(), Map.of("name", List.of("")));
    }

    private void assertBaseURL(String string, Consumer<HTTPRequest> consumer, String ... stringArray) {
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setScheme("http");
        hTTPRequest.setHost("localhost");
        hTTPRequest.setPort(8080);
        if (consumer != null) {
            consumer.accept(hTTPRequest);
        }
        if (stringArray.length % 2 != 0) {
            Assert.fail((String)"You need to provide pairs.");
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            hTTPRequest.setHeader(stringArray[i], stringArray[i + 1]);
        }
        Assert.assertEquals((String)hTTPRequest.getBaseURL(), (String)string);
    }

    private void assertBaseURL(String string, String ... stringArray) {
        this.assertBaseURL(string, (Consumer<HTTPRequest>)null, stringArray);
    }

    private void assertGetHost(String string, String string2) {
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setHeader("X-Forwarded-Host", string);
        Assert.assertEquals((String)hTTPRequest.getHost(), (String)string2);
    }

    private void assertGetIPAddress(String string, String string2) {
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setHeader("X-Forwarded-For", string);
        Assert.assertEquals((String)hTTPRequest.getIPAddress(), (String)string2);
    }

    private void assertURLs(String string, String string2, String string3, int n, String string4) {
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setScheme(string);
        hTTPRequest.addHeader("host", string2);
        Assert.assertEquals((String)hTTPRequest.getHost(), (String)string3);
        Assert.assertEquals((int)hTTPRequest.getPort(), (int)n);
        Assert.assertEquals((String)hTTPRequest.getBaseURL(), (String)string4);
    }
}

