/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.BaseSocketTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class HTTP11SocketTest
extends BaseSocketTest {
    @Test(invocationCount=100)
    public void bad_request() throws Exception {
        this.withRequest("cat /etc/password\r\n\r\n{body}").expectResponse("HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
    }

    @DataProvider(name="chunk-extensions")
    public Object[][] chunkExtensions() {
        return new Object[][]{{";foo=bar"}, {";foo"}, {";foo="}, {";foo=bar;bar=baz"}, {";foo=bar;bar="}, {";foo=bar;bar"}};
    }

    @Test(invocationCount=100)
    public void duplicate_host_header() throws Exception {
        this.withRequest("GET / HTTP/1.1\r\nHost: cyberdyne-systems.com\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
    }

    @Test(invocationCount=100)
    public void duplicate_host_header_withTransferEncoding() throws Exception {
        this.withRequest("GET / HTTP/1.1\r\nHost: cyberdyne-systems.com\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nTransfer-Encoding: chunked\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
    }

    @Test(invocationCount=100)
    public void host_header_required() throws Exception {
        this.withRequest("GET / HTTP/1.1\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
    }

    @Test(invocationCount=100)
    public void host_header_required_with_X_Forwarded_Host() throws Exception {
        this.withRequest("GET / HTTP/1.1\r\nX-Forwarded-Host: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
    }

    @Test(invocationCount=100)
    public void invalid_content_length() throws Exception {
        this.withRequest("GET / HTTP/1.1\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: 9223372036854775808\r\n\r\n{body}").expectResponse("HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
        this.withRequest("GET / HTTP/1.1\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: -1\r\n\r\n{body}").expectResponse("HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
        this.withRequest("GET / HTTP/1.1\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: -9223372036854775807\r\n\r\n{body}").expectResponse("HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
    }

    @Test(invocationCount=100)
    public void invalid_version() throws Exception {
        this.withRequest("GET / HTTP/1\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 505 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
        this.withRequest("GET / HTTP/1.\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 505 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
        this.withRequest("GET / HTTP/1.2\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 505 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
        this.withRequest("GET / HTTP/9.9\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 505 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
    }

    @Test(invocationCount=100)
    public void keepAlive_bodyNeverRead() throws Exception {
        this.withRequest("GET / HTTP/1.1\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 200 \r\nconnection: keep-alive\r\ncontent-length: 0\r\n\r\n");
    }

    @Test(invocationCount=100)
    public void mangled_version() throws Exception {
        this.withRequest("GET / PTTH/1.1\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
        this.withRequest("GET / HHHH/1.1\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
    }

    @Test(invocationCount=100)
    public void missing_protocol() throws Exception {
        this.withRequest("GET /\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\n\r\n{body}").expectResponse("HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
    }

    @Test(dataProvider="chunk-extensions", invocationCount=100)
    public void transfer_encoding_chunked_extensions(String string) throws Exception {
        this.withRequest("GET / HTTP/1.1\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nTransfer-Encoding: chunked\r\n\r\n{body}").withChunkedExtension(string).expectResponse("HTTP/1.1 200 \r\nconnection: keep-alive\r\ncontent-length: 0\r\n\r\n");
    }

    @Test(invocationCount=250)
    public void transfer_encoding_content_length() throws Exception {
        this.withRequest("GET / HTTP/1.1\r\nHost: cyberdyne-systems.com\r\nContent-Type: plain/text\r\nContent-Length: {contentLength}\r\nTransfer-Encoding: chunked\r\n\r\n{body}").expectResponse("HTTP/1.1 200 \r\nconnection: keep-alive\r\ncontent-length: 0\r\n\r\n");
    }
}

