/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import com.inversoft.net.ssl.SSLTools;
import com.inversoft.rest.ClientResponse;
import com.inversoft.rest.RESTClient;
import com.inversoft.rest.TextResponseHandler;
import io.fusionauth.http.BaseTest;
import io.fusionauth.http.server.CountingInstrumenter;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPServer;
import io.fusionauth.http.server.Instrumenter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ChunkedTest
extends BaseTest {
    public static final String ExpectedResponse = "{\"version\":\"42\"}";
    public static final String RequestBody = "{\"message\":\"Hello World\"}";

    @Test(dataProvider="schemes")
    public void chunkedRequest(String string) throws Exception {
        String string2 = "These pretzels are making me thirsty. ".repeat(16000);
        byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            byte[] byArray2;
            Assert.assertTrue((boolean)hTTPRequest.isChunked());
            try {
                byArray2 = hTTPRequest.getInputStream().readAllBytes();
                Assert.assertEquals((byte[])byArray2, (byte[])byArray);
            }
            catch (IOException iOException) {
                Assert.fail((String)"Unable to parse body", (Throwable)iOException);
            }
            byArray2 = ExpectedResponse.getBytes(StandardCharsets.UTF_8);
            hTTPResponse.setHeader("Content-Type", "application/json");
            hTTPResponse.setHeader("Content-Length", "" + byArray2.length);
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(byArray2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            for (int i = 0; i < 1000; ++i) {
                HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "text/plain").POST(HttpRequest.BodyPublishers.ofInputStream(() -> new ByteArrayInputStream(byArray))).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
                Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
                Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
                Assert.assertEquals((long)countingInstrumenter.getChunkedRequests(), (long)(i + 1));
            }
        }
    }

    @Test(dataProvider="schemes")
    public void chunkedRequest_doNotReadTheInputStream(String string) throws Exception {
        String string2 = "These pretzels are making me thirsty. ".repeat(16000);
        byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertTrue((boolean)hTTPRequest.isChunked());
            byte[] byArray = ExpectedResponse.getBytes(StandardCharsets.UTF_8);
            hTTPResponse.setHeader("Content-Type", "application/json");
            hTTPResponse.setHeader("Content-Length", "" + byArray.length);
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = ((HTTPServer)this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).withMaximumBytesToDrain(byArray.length * 2)).start();){
            URI uRI = this.makeURI(string, "");
            for (int i = 0; i < 10; ++i) {
                HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "text/plain").POST(HttpRequest.BodyPublishers.ofInputStream(() -> new ByteArrayInputStream(byArray))).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
                Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
                Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
                Assert.assertEquals((long)countingInstrumenter.getChunkedRequests(), (long)(i + 1));
            }
        }
    }

    @Test(dataProvider="schemes")
    public void chunkedResponse(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(ExpectedResponse.getBytes());
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "application/json").GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
            Assert.assertEquals((long)countingInstrumenter.getChunkedResponses(), (long)1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="schemes")
    public void chunkedResponseRestify(String string) {
        String string2 = "Success!\nparm=some values\ntheRest=some other values\n";
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/html; charset=UTF-8");
            hTTPResponse.setHeader("Cache-Control", "no-cache");
            hTTPResponse.setStatus(200);
            try {
                Writer writer = hTTPResponse.getWriter();
                writer.write(string2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            SSLTools.disableSSLValidation();
            URI uRI = this.makeURI(string, "");
            ClientResponse clientResponse = new RESTClient(String.class, String.class).url(uRI.toString()).get().successResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).errorResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).go();
            Assert.assertEquals((int)clientResponse.status, (int)200);
            Assert.assertEquals((String)((String)clientResponse.successResponse), (String)string2);
            Assert.assertEquals((long)countingInstrumenter.getChunkedResponses(), (long)1L);
        }
        finally {
            SSLTools.enableSSLValidation();
        }
    }

    @Test(dataProvider="schemes")
    public void chunkedResponseStreamingFile(String string) throws Exception {
        Path path = Paths.get("src/test/java/io/fusionauth/http/ChunkedTest.java", new String[0]);
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "application/json").GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)Files.readString(path));
            Assert.assertEquals((long)countingInstrumenter.getChunkedResponses(), (long)1L);
        }
    }

    @Test(dataProvider="schemes")
    public void chunkedResponseWriter(String string) throws Exception {
        String string2 = "Success!\nparm=some values\ntheRest=some other values\n";
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/html; charset=UTF-8");
            hTTPResponse.setHeader("Cache-Control", "no-cache");
            hTTPResponse.setStatus(200);
            try {
                Writer writer = hTTPResponse.getWriter();
                writer.write(string2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)string2);
            Assert.assertEquals((long)countingInstrumenter.getChunkedResponses(), (long)1L);
        }
    }

    @Test(dataProvider="schemes", groups={"performance"})
    public void performanceChunked(String string) throws Exception {
        this.verbose = true;
        String string2 = "These pretzels are making me thirsty. ".repeat(16000);
        byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(byArray);
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        int n = 15000;
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            long l;
            URI uRI = this.makeURI(string, "");
            long l2 = l = System.currentTimeMillis();
            for (int i = 0; i < n; ++i) {
                HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
                Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
                Assert.assertEquals((String)((String)httpResponse.body()), (String)string2);
                if (System.currentTimeMillis() - l2 <= 5000L) continue;
                long l3 = System.currentTimeMillis();
                double d = (double)(l3 - l) / (double)i;
                this.printf("Chunked Performance: Iterations [%,d] Response body [%,d] bytes. Running average is [%f] ms.\n", i, byArray.length, d);
                l2 = System.currentTimeMillis();
            }
            long l4 = System.currentTimeMillis();
            double d = (double)(l4 - l) / (double)n;
            this.printf("Chunked Performance: Iterations [%,d] Response body [%,d] bytes. Final average is [%f] ms.\n", n, byArray.length, d);
        }
        Assert.assertTrue((countingInstrumenter.getConnections() == 1L || countingInstrumenter.getConnections() == 2L ? 1 : 0) != 0);
        Assert.assertEquals((long)countingInstrumenter.getChunkedResponses(), (long)n);
        Assert.assertEquals((long)countingInstrumenter.getAcceptedRequests(), (long)n);
    }

    @Test(dataProvider="schemes")
    public void smallChunkedRequest(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            byte[] byArray;
            Assert.assertTrue((boolean)hTTPRequest.isChunked());
            try {
                byArray = hTTPRequest.getInputStream().readAllBytes();
                Assert.assertEquals((String)new String(byArray), (String)RequestBody);
            }
            catch (IOException iOException) {
                Assert.fail((String)"Unable to parse body", (Throwable)iOException);
            }
            byArray = ExpectedResponse.getBytes(StandardCharsets.UTF_8);
            hTTPResponse.setHeader("Content-Type", "application/json");
            hTTPResponse.setHeader("Content-Length", "" + byArray.length);
            hTTPResponse.setStatus(200);
            try {
                OutputStream outputStream = hTTPResponse.getOutputStream();
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofInputStream(() -> new ByteArrayInputStream(RequestBody.getBytes()))).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
            Assert.assertEquals((long)countingInstrumenter.getChunkedRequests(), (long)1L);
        }
    }
}

