/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;

public final class SecurityTools {
    public static final String CERT_END = "-----END CERTIFICATE";
    public static final String CERT_START = "BEGIN CERTIFICATE-----";
    public static final String P8_KEY_END = "-----END PRIVATE KEY";
    public static final String P8_KEY_START = "BEGIN PRIVATE KEY-----";

    private SecurityTools() {
    }

    public static SSLContext clientContext(Certificate certificate) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        keyStore.setCertificateEntry("cert-alias", certificate);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore);
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
        return sSLContext;
    }

    public static Certificate parseCertificate(String string) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return certificateFactory.generateCertificates(byteArrayInputStream).stream().findFirst().get();
    }

    public static Certificate[] parseCertificates(String string) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates(byteArrayInputStream);
        return SecurityTools.reorderCertificates(collection);
    }

    public static byte[] parseDERFromPEM(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0) {
            throw new IllegalArgumentException("Invalid PEM format");
        }
        int n2 = string.indexOf(string3);
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid PEM format");
        }
        String string4 = string.substring(n + string2.length(), n2).replaceAll("\\s", "");
        return Base64.getDecoder().decode(string4);
    }

    public static RSAPrivateKey parsePrivateKey(String string) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] byArray = SecurityTools.parseDERFromPEM(string, P8_KEY_START, P8_KEY_END);
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    public static SSLContext serverContext(Certificate certificate, PrivateKey privateKey) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        keyStore.setCertificateEntry("cert-alias", certificate);
        keyStore.setKeyEntry("key-alias", privateKey, "changeit".toCharArray(), new Certificate[]{certificate});
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, "changeit".toCharArray());
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
        return sSLContext;
    }

    public static SSLContext serverContext(Certificate[] certificateArray, PrivateKey privateKey) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        keyStore.setKeyEntry("key-alias", privateKey, "changeit".toCharArray(), certificateArray);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, "changeit".toCharArray());
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
        return sSLContext;
    }

    private static Certificate[] reorderCertificates(Collection<X509Certificate> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Empty certificate list");
        }
        Certificate[] certificateArray = new X509Certificate[collection.size()];
        if (collection.size() == 1) {
            certificateArray[0] = collection.stream().findFirst().get();
            return certificateArray;
        }
        HashMap<X500Principal, X509Certificate> hashMap = new HashMap<X500Principal, X509Certificate>(collection.size());
        HashMap<X500Principal, X509Certificate> hashMap2 = new HashMap<X500Principal, X509Certificate>(collection.size());
        for (X509Certificate x509Certificate : collection) {
            hashMap.put(x509Certificate.getIssuerX500Principal(), x509Certificate);
            hashMap2.put(x509Certificate.getSubjectX500Principal(), x509Certificate);
        }
        for (X509Certificate x509Certificate : collection) {
            if (hashMap.containsKey(x509Certificate.getSubjectX500Principal())) continue;
            certificateArray[0] = x509Certificate;
            break;
        }
        for (int i = 0; i < certificateArray.length - 1; ++i) {
            X509Certificate x509Certificate;
            x509Certificate = (X509Certificate)hashMap2.get(((X509Certificate)certificateArray[i]).getIssuerX500Principal());
            if (x509Certificate == null) {
                throw new IllegalArgumentException("Missing issuer cert for " + String.valueOf(((X509Certificate)certificateArray[i]).getIssuerX500Principal()));
            }
            certificateArray[i + 1] = x509Certificate;
        }
        return certificateArray;
    }
}

