/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.log;

import io.fusionauth.http.log.BaseLogger;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class FileLogger
extends BaseLogger {
    private final Writer writer;

    public FileLogger(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            this.writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    protected void handleMessage(String string) {
        try {
            this.writer.write(string + "\n");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

