/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.io.MultipartFileUploadPolicy;
import java.util.Objects;

public class MultipartConfiguration {
    private boolean deleteTemporaryFiles = true;
    private MultipartFileUploadPolicy fileUploadPolicy = MultipartFileUploadPolicy.Reject;
    private long maxFileSize = 0x100000L;
    private long maxRequestSize = 0xA00000L;
    private int multipartBufferSize = 8192;
    private String temporaryFileLocation = System.getProperty("java.io.tmpdir");
    private String temporaryFilenamePrefix = "java-http";
    private String temporaryFilenameSuffix = "file-upload";

    public MultipartConfiguration() {
    }

    public MultipartConfiguration(MultipartConfiguration multipartConfiguration) {
        this.deleteTemporaryFiles = multipartConfiguration.deleteTemporaryFiles;
        this.fileUploadPolicy = multipartConfiguration.fileUploadPolicy;
        this.maxFileSize = multipartConfiguration.maxFileSize;
        this.maxRequestSize = multipartConfiguration.maxRequestSize;
        this.multipartBufferSize = multipartConfiguration.multipartBufferSize;
        this.temporaryFileLocation = multipartConfiguration.temporaryFileLocation;
        this.temporaryFilenamePrefix = multipartConfiguration.temporaryFilenamePrefix;
        this.temporaryFilenameSuffix = multipartConfiguration.temporaryFilenameSuffix;
    }

    public boolean deleteTemporaryFiles() {
        return this.deleteTemporaryFiles;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MultipartConfiguration)) {
            return false;
        }
        MultipartConfiguration multipartConfiguration = (MultipartConfiguration)object;
        return this.deleteTemporaryFiles == multipartConfiguration.deleteTemporaryFiles && this.fileUploadPolicy == multipartConfiguration.fileUploadPolicy && this.maxFileSize == multipartConfiguration.maxFileSize && this.maxRequestSize == multipartConfiguration.maxRequestSize && this.multipartBufferSize == multipartConfiguration.multipartBufferSize && Objects.equals(this.temporaryFileLocation, multipartConfiguration.temporaryFileLocation) && Objects.equals(this.temporaryFilenamePrefix, multipartConfiguration.temporaryFilenamePrefix) && Objects.equals(this.temporaryFilenameSuffix, multipartConfiguration.temporaryFilenameSuffix);
    }

    public MultipartFileUploadPolicy getFileUploadPolicy() {
        return this.fileUploadPolicy;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public int getMultipartBufferSize() {
        return this.multipartBufferSize;
    }

    public String getTemporaryFileLocation() {
        return this.temporaryFileLocation;
    }

    public String getTemporaryFilenamePrefix() {
        return this.temporaryFilenamePrefix;
    }

    public String getTemporaryFilenameSuffix() {
        return this.temporaryFilenameSuffix;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deleteTemporaryFiles, this.fileUploadPolicy, this.maxFileSize, this.maxRequestSize, this.multipartBufferSize, this.temporaryFileLocation, this.temporaryFilenamePrefix, this.temporaryFilenameSuffix});
    }

    public boolean isDeleteTemporaryFiles() {
        return this.deleteTemporaryFiles;
    }

    public MultipartConfiguration withDeleteTemporaryFiles(boolean bl) {
        this.deleteTemporaryFiles = bl;
        return this;
    }

    public MultipartConfiguration withFileUploadPolicy(MultipartFileUploadPolicy multipartFileUploadPolicy) {
        Objects.requireNonNull(multipartFileUploadPolicy, "You cannot set the fileUploadPolicy to null");
        this.fileUploadPolicy = multipartFileUploadPolicy;
        return this;
    }

    public MultipartConfiguration withMaxFileSize(long l) {
        this.maxFileSize = l;
        return this;
    }

    public MultipartConfiguration withMaxRequestSize(long l) {
        if (l < this.maxFileSize) {
            throw new IllegalArgumentException("The maximum request size must be greater than the maxFileSize");
        }
        this.maxRequestSize = l;
        return this;
    }

    public MultipartConfiguration withMultipartBufferSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The multipart buffer size must be greater than 0");
        }
        this.multipartBufferSize = n;
        return this;
    }

    public MultipartConfiguration withTemporaryFileLocation(String string) {
        Objects.requireNonNull(string, "You cannot set the temporaryFileLocation to null");
        this.temporaryFileLocation = string;
        return this;
    }

    public MultipartConfiguration withTemporaryFilenamePrefix(String string) {
        this.temporaryFilenamePrefix = string;
        return this;
    }

    public MultipartConfiguration withTemporaryFilenameSuffix(String string) {
        this.temporaryFilenameSuffix = string;
        return this;
    }
}

