/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class FastByteArrayOutputStream
extends OutputStream {
    protected byte[] buffer;
    protected int count;
    protected int growthRate;

    public FastByteArrayOutputStream(int n, int n2) {
        this.buffer = new byte[n];
        this.growthRate = n2;
    }

    public byte[] bytes() {
        return this.buffer;
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    @Override
    public void write(int n) {
        if (this.count + 1 >= this.buffer.length) {
            this.resize(this.growthRate);
        }
        this.buffer[this.count] = (byte)n;
        ++this.count;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (this.count + n2 >= this.buffer.length) {
            this.resize(Math.max(this.growthRate, n2));
        }
        System.arraycopy(byArray, n, this.buffer, this.count, n2);
        this.count += n2;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    private void resize(int n) {
        this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + n);
    }
}

