/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.util;

import com.inversoft.json.ToString;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.internal.HTTPBuffers;
import io.fusionauth.http.server.io.HTTPInputStream;
import io.fusionauth.http.util.HTTPTools;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class HTTPToolsTest {
    @Test
    public void getMaxRequestBodySize() {
        Map<String, Integer> map = Map.of("*", 1, "application/*", 2, "application/json", 3, "application/x-www-form-urlencoded", 4, "multipart/form-data", 5, "text/*", 6, "text/html", 7);
        this.assertMaxConfiguredSize(null, 1, map);
        this.assertMaxConfiguredSize("application/json", 3, map);
        this.assertMaxConfiguredSize("application/json-patch+json", 2, map);
        this.assertMaxConfiguredSize("application/octet-stream", 2, map);
        this.assertMaxConfiguredSize("application/pdf", 2, map);
        this.assertMaxConfiguredSize("application/x-www-form-urlencoded", 4, map);
        this.assertMaxConfiguredSize("multipart/form-data", 5, map);
        this.assertMaxConfiguredSize("text/css", 6, map);
        this.assertMaxConfiguredSize("text/html", 7, map);
        this.assertMaxConfiguredSize("", 1, map);
        this.assertMaxConfiguredSize("null", 1, map);
        this.assertMaxConfiguredSize("application/json; foo=bar", 2, map);
        this.assertMaxConfiguredSize("multipart/form-data; boundary=------", 1, map);
        this.assertMaxConfiguredSize("text/css; charset=ISO-8859-1", 6, map);
        this.assertMaxConfiguredSize("text/unexpected", 6, map);
        this.assertMaxConfiguredSize("text/unexpected/value", 6, map);
    }

    @Test
    public void parseEncodedData() {
        this.assertEncodedData("bar", "bar", StandardCharsets.UTF_8);
        this.assertEncodedData("bar&%%%=baz", "bar", StandardCharsets.UTF_8);
        this.assertEncodedData("bar&bar=ba%\u00e5&=boom", "bar", StandardCharsets.UTF_8);
        this.assertEncodedData("bar&bar=% % %", "bar", StandardCharsets.UTF_8);
        this.assertEncodedData("\ud83d\ude0e", "\ud83d\ude0e", StandardCharsets.UTF_8);
        this.assertEncodedData("\u20ac", "\u20ac", StandardCharsets.UTF_8);
        this.assertEncodedData("\u00e9", "\u00e9", StandardCharsets.UTF_8);
        this.assertEncodedData("H\u00e9ll\u00f6", "H\u00e9ll\u00f6", StandardCharsets.UTF_8);
        this.assertHexValue("\ud83d\ude0e", "D83D DE0E");
        this.assertHexValue("\u20ac", "20AC");
        this.assertEncodedData("\ud83d\ude0e", "?", StandardCharsets.ISO_8859_1);
        this.assertEncodedData("\u20ac", "?", StandardCharsets.ISO_8859_1);
        this.assertHexValue("\u00e9", "E9");
        this.assertHexValue("H\u00e9ll\u00f6", "48 E9 6C 6C F6");
        this.assertEncodedData("\u00e9", "\u00e9", StandardCharsets.ISO_8859_1);
        this.assertEncodedData("H\u00e9ll\u00f6", "H\u00e9ll\u00f6", StandardCharsets.ISO_8859_1);
        this.assertEncodedData("H\u00e9ll\u00f6", "H\ufffdll\ufffd", StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8);
        this.assertEncodedData("Hello world", "Hello world", StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8);
        this.assertHexValue("H\u00e9ll\u00f6", "48    E9 6C 6C F6   ", StandardCharsets.ISO_8859_1);
        this.assertHexValue("H\u00e9ll\u00f6", "48 C3 A9 6C 6C C3 B6", StandardCharsets.UTF_8);
        this.assertEncodedData("H\u00e9ll\u00f6", "H\u00c3\u00a9ll\u00c3\u00b6", StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1);
        this.assertEncodedData("Hello world", "Hello world", StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1);
        this.assertHexValue("\u00e9", "C3 A9", StandardCharsets.UTF_8);
        this.assertHexValue("\u00c3\u00a9", "C3 A9", StandardCharsets.ISO_8859_1);
        this.assertHexValue("\u00f6", "C3 B6", StandardCharsets.UTF_8);
        this.assertHexValue("\u00c3\u00b6", "C3 B6", StandardCharsets.ISO_8859_1);
    }

    @Test
    public void parseHeaderValue() {
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"text/plain; charset=iso8859-1"), (Object)new HTTPTools.HeaderValue("text/plain", Map.of("charset", "iso8859-1")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"text/plain; charset=iso-8859-1"), (Object)new HTTPTools.HeaderValue("text/plain", Map.of("charset", "iso-8859-1")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"text/plain; charset=iso8859-1; boundary=FOOBAR"), (Object)new HTTPTools.HeaderValue("text/plain", Map.of("boundary", "FOOBAR", "charset", "iso8859-1")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"text/plain; charset=iso-8859-1; boundary=FOOBAR"), (Object)new HTTPTools.HeaderValue("text/plain", Map.of("boundary", "FOOBAR", "charset", "iso-8859-1")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"form-data; filename=foo.jpg"), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", "foo.jpg")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"form-data; filename=\"foo.jpg\""), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", "foo.jpg")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"form-data; filename*=UTF-8''foo.jpg"), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", "foo.jpg")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"form-data; filename=ignore.jpg; filename*=UTF-8''foo.jpg"), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", "foo.jpg")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"form-data; filename*=UTF-8'en'foo.jpg"), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", "foo.jpg")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"form-data; filename=ignore.jpg; filename*=UTF-8'en'foo.jpg"), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", "foo.jpg")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"form-data; filename*=ISO-8859-1''foo.jpg"), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", "foo.jpg")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"form-data; filename*=ISO-8859-1'en'foo.jpg"), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", "foo.jpg")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"form-data; filename=ignore.jpg; filename*=ISO-8859-1'en'foo.jpg"), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", "foo.jpg")));
        String string = "\u00e5pple";
        String string2 = "\ud83d\ude01";
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)("form-data; filename*=ISO8859-1'en'" + URLEncoder.encode(string, StandardCharsets.ISO_8859_1))), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", string)));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)("form-data; filename*=ISO-8859-1'en'" + URLEncoder.encode(string, StandardCharsets.ISO_8859_1))), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", string)));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)("form-data; filename*=UTF-8'en'" + URLEncoder.encode(string2, StandardCharsets.UTF_8))), (Object)new HTTPTools.HeaderValue("form-data", Map.of("filename", string2)));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value; list=a; b; another=param"), (Object)new HTTPTools.HeaderValue("value", Map.of("another", "param", "b", "", "list", "a")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value; list=a; b=; another=param"), (Object)new HTTPTools.HeaderValue("value", Map.of("another", "param", "b", "", "list", "a")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value; list=\"a;b\"; another=param"), (Object)new HTTPTools.HeaderValue("value", Map.of("another", "param", "list", "a;b")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value; list=\"a\";"), (Object)new HTTPTools.HeaderValue("value", Map.of("list", "a")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value; list*"), (Object)new HTTPTools.HeaderValue("value", Map.of("list", "")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value;"), (Object)new HTTPTools.HeaderValue("value", Map.of()));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value; "), (Object)new HTTPTools.HeaderValue("value", Map.of()));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value; f"), (Object)new HTTPTools.HeaderValue("value", Map.of("f", "")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value;  f"), (Object)new HTTPTools.HeaderValue("value", Map.of("f", "")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value; f="), (Object)new HTTPTools.HeaderValue("value", Map.of("f", "")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value;  f="), (Object)new HTTPTools.HeaderValue("value", Map.of("f", "")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value; f=f"), (Object)new HTTPTools.HeaderValue("value", Map.of("f", "f")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value; f =f"), (Object)new HTTPTools.HeaderValue("value", Map.of("f ", "f")));
        Assert.assertEquals((Object)HTTPTools.parseHeaderValue((String)"value; f= f"), (Object)new HTTPTools.HeaderValue("value", Map.of("f", " f")));
    }

    @Test
    public void parsePreamble() throws Exception {
        String string = "GET / HTTP/1.1\r\nHost: localhost:42\r\nConnection: close\r\nContent-Length: 113\r\nHeader1: Value1\r\nHeader2: Value2\r\nHeader3: Value3\r\nHeader4: Value4\r\nHeader5: Value5\r\nHeader6: Value6\r\nHeader7: Value7\r\nHeader8: Value8\r\nHeader9: Value9\r\nHeader10: Value10\r\n\r\nThese pretzels are making me thirsty. These pretzels are making me thirsty. These pretzels are making me thirsty.GET / HTTP/1.1\r\n";
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        int n = byArray.length;
        HTTPServerConfiguration hTTPServerConfiguration = new HTTPServerConfiguration().withRequestBufferSize(n + 100);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PushbackInputStream pushbackInputStream = new PushbackInputStream((InputStream)byteArrayInputStream, null);
        HTTPRequest hTTPRequest = new HTTPRequest();
        HTTPBuffers hTTPBuffers = new HTTPBuffers(hTTPServerConfiguration);
        byte[] byArray2 = hTTPBuffers.requestBuffer();
        HTTPTools.initialize((LoggerFactory)hTTPServerConfiguration.getLoggerFactory());
        HTTPTools.parseRequestPreamble((PushbackInputStream)pushbackInputStream, (int)131072, (HTTPRequest)hTTPRequest, (byte[])byArray2, () -> {});
        Assert.assertEquals((Object)hTTPRequest.getMethod(), (Object)HTTPMethod.GET);
        Assert.assertEquals((String)hTTPRequest.getHost(), (String)"localhost");
        Assert.assertEquals((int)hTTPRequest.getPort(), (int)42);
        Assert.assertEquals((Long)hTTPRequest.getContentLength(), (long)113L);
        Assert.assertEquals((int)hTTPRequest.getHeaders().size(), (int)13);
        Assert.assertEquals((String)hTTPRequest.getHeader("Content-Length"), (String)"113");
        Assert.assertEquals((String)hTTPRequest.getHeader("Connection"), (String)"close");
        Assert.assertEquals((String)hTTPRequest.getHeader("Host"), (String)"localhost:42");
        for (int i = 1; i <= 10; ++i) {
            Assert.assertEquals((String)hTTPRequest.getHeader("Header" + i), (String)("Value" + i));
        }
        Assert.assertEquals((int)pushbackInputStream.getAvailableBufferedBytesRemaining(), (int)129);
        HTTPInputStream hTTPInputStream = new HTTPInputStream(hTTPServerConfiguration, hTTPRequest, pushbackInputStream, -1);
        byte[] byArray3 = new byte[1024];
        int n2 = hTTPInputStream.read(byArray3);
        Assert.assertEquals((int)n2, (int)113);
        int n3 = hTTPInputStream.read(byArray3);
        Assert.assertEquals((int)n3, (int)-1);
        Assert.assertEquals((int)pushbackInputStream.getAvailableBufferedBytesRemaining(), (int)16);
        int n4 = pushbackInputStream.read(byArray3);
        Assert.assertEquals((int)n4, (int)16);
    }

    private void assertEncodedData(String string, String string2, Charset charset) {
        this.assertEncodedData(string, string2, charset, charset);
    }

    private void assertEncodedData(String string, String string2, Charset charset, Charset charset2) {
        HashMap hashMap = new HashMap(1);
        byte[] byArray = ("foo=" + string).getBytes(charset);
        HTTPTools.parseEncodedData((byte[])byArray, (int)0, (int)byArray.length, (Charset)charset2, hashMap);
        Assert.assertEquals(hashMap, Map.of("foo", List.of(string2)), (String)("Actual:\n" + ToString.toString(hashMap)));
    }

    private void assertHexValue(String string, String string2) {
        Assert.assertEquals((String)this.hex(string), (String)string2);
    }

    private void assertHexValue(String string, String string2, Charset charset) {
        String string3 = string2.trim();
        string3 = string3.replaceAll(" +", " ");
        Assert.assertEquals((String)this.hex(string.getBytes(charset)), (String)string3);
    }

    private void assertMaxConfiguredSize(String string, int n, Map<String, Integer> map) {
        Assert.assertEquals((int)HTTPTools.getMaxRequestBodySize((String)string, map), (int)n);
    }

    private String hex(byte[] byArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (byte by : byArray) {
            arrayList.add(Integer.toHexString(0xFF & by).toUpperCase());
        }
        return String.join((CharSequence)" ", arrayList);
    }

    private String hex(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (char c : string.toCharArray()) {
            arrayList.add(Integer.toHexString(c).toUpperCase());
        }
        return String.join((CharSequence)" ", arrayList);
    }
}

