/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.service;

import io.fusionauth.samlv2.domain.Algorithm;
import io.fusionauth.samlv2.domain.Assertion;
import io.fusionauth.samlv2.domain.AuthenticationRequest;
import io.fusionauth.samlv2.domain.AuthenticationResponse;
import io.fusionauth.samlv2.domain.Binding;
import io.fusionauth.samlv2.domain.DigestAlgorithm;
import io.fusionauth.samlv2.domain.EncryptionAlgorithm;
import io.fusionauth.samlv2.domain.KeyLocation;
import io.fusionauth.samlv2.domain.KeyTransportAlgorithm;
import io.fusionauth.samlv2.domain.LogoutRequest;
import io.fusionauth.samlv2.domain.LogoutResponse;
import io.fusionauth.samlv2.domain.MaskGenerationFunction;
import io.fusionauth.samlv2.domain.MetaData;
import io.fusionauth.samlv2.domain.NameID;
import io.fusionauth.samlv2.domain.NameIDFormat;
import io.fusionauth.samlv2.domain.ResponseStatus;
import io.fusionauth.samlv2.domain.SAMLException;
import io.fusionauth.samlv2.domain.SignatureLocation;
import io.fusionauth.samlv2.domain.SignatureNotFoundException;
import io.fusionauth.samlv2.domain.Status;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.AuthnRequestType;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.LogoutRequestType;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.StatusResponseType;
import io.fusionauth.samlv2.service.CertificateTools;
import io.fusionauth.samlv2.service.DefaultSAMLv2Service;
import io.fusionauth.samlv2.service.SAMLv2Service;
import io.fusionauth.samlv2.service.TestKeySelector;
import io.fusionauth.samlv2.service.TestPostBindingSignatureHelper;
import io.fusionauth.samlv2.service.TestRedirectBindingSignatureHelper;
import io.fusionauth.samlv2.util.SAMLTools;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.xml.crypto.KeySelector;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

@Test(groups={"unit"})
public class DefaultSAMLv2ServiceTest {
    private String assertionSigned;
    private String assertionUnsigned;
    private String baseXml;
    private String encryptedSigned;
    private String encryptedUnsigned;
    private KeyPair encryptionKeyPair;
    private KeyPair signingKeyPair;

    @DataProvider(name="BooleanTriState")
    public Object[][] BooleanTriState() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}, {null}};
    }

    @Test
    public void assertionDecryptionDefaults() throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(new RSAPrivateKeySpec(new BigInteger("21734648244307152755738902242704624429675455693104061482953980655823499524284217582577935962219675181839097134429878676848067944269649003417313253763145613039845156858929146350893510281417425701635390227843218753386852942958087790126591910892081707753005524949329857277363222746280909051526362184081185954039703446436022345307092346517413518280909483768946131477611274390374625720745000173012484689181319542884541163003470909355448313533318136237678943263133529991715284549440616270148923866161198748312992261382455526114770464413102345807150728423473869759031086596301998397561122681012070445972165920288084712186321"), new BigInteger("2627246950446332058699110175423135552922607992443510918533979809198372876869242896214083780043399404771798030104421912476774863886112568550161826087731198353627009668377202151330979270479101063648863411278727725778272563805391938498601722966981572071033305898173415465329072899217806147766785803779409419532480730005663347830294097525463269173509836986107754922630483079886942638729284878709865541937468056706189367357847138095922090696226255189351459450052835991176393120796259048519702721129794393046985282164398590601866202429118551867608688177161937729422431790107723304390299253182892873596285122556471119338537")));
        byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse-assertionDecryptionDefaults.txt", new String[0]));
        String string = new String(byArray, StandardCharsets.UTF_8);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string, false, null, true, privateKey);
        byArray = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String string2 = new String(byArray, StandardCharsets.UTF_8);
        AuthenticationResponse authenticationResponse2 = defaultSAMLv2Service.parseResponse(string2, false, null);
        ((Assertion)authenticationResponse.assertions.get((int)0)).id = ((Assertion)authenticationResponse2.assertions.get((int)0)).id;
        authenticationResponse.authnInstant = authenticationResponse2.authnInstant;
        Assert.assertEquals((Object)authenticationResponse, (Object)authenticationResponse2);
    }

    @DataProvider(name="assertionEncryption")
    public Object[][] assertionEncryption() {
        return new Object[][]{{EncryptionAlgorithm.AES128, KeyLocation.Child, KeyTransportAlgorithm.RSAv15, DigestAlgorithm.SHA256, null}, {EncryptionAlgorithm.AES128, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP_MGF1P, DigestAlgorithm.SHA256, null}, {EncryptionAlgorithm.AES128, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES128, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA512, MaskGenerationFunction.MGF1_SHA256}, {EncryptionAlgorithm.AES192, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES256, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES256, KeyLocation.Sibling, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES128GCM, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES192GCM, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES256GCM, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.TripleDES, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}};
    }

    @Test
    public void authnInstant() throws Exception {
        ZonedDateTime zonedDateTime;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String string = new String(byArray);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string, false, null);
        authenticationResponse.authnInstant = zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(1L);
        String string2 = defaultSAMLv2Service.buildAuthnResponse(authenticationResponse, true, keyPair.getPrivate(), CertificateTools.fromKeyPair(keyPair, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Response, true);
        AuthenticationResponse authenticationResponse2 = defaultSAMLv2Service.parseResponse(string2, true, (KeySelector)new TestKeySelector(keyPair.getPublic()));
        Assert.assertEquals((Object)authenticationResponse2.status.code, (Object)ResponseStatus.Success);
        Assert.assertEquals((Object)authenticationResponse2.authnInstant, (Object)SAMLTools.toZonedDateTime((XMLGregorianCalendar)SAMLTools.toXMLGregorianCalendar((ZonedDateTime)zonedDateTime)));
        Assert.assertTrue((boolean)authenticationResponse2.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        authenticationResponse.authnInstant = null;
        authenticationResponse.issueInstant = ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(2L);
        string2 = defaultSAMLv2Service.buildAuthnResponse(authenticationResponse, true, keyPair.getPrivate(), CertificateTools.fromKeyPair(keyPair, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Response, true);
        authenticationResponse2 = defaultSAMLv2Service.parseResponse(string2, true, (KeySelector)new TestKeySelector(keyPair.getPublic()));
        Assert.assertEquals((Object)authenticationResponse2.status.code, (Object)ResponseStatus.Success);
        Assert.assertEquals((Object)authenticationResponse2.authnInstant, (Object)authenticationResponse2.issueInstant);
        Assert.assertTrue((boolean)authenticationResponse2.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
    }

    @BeforeClass
    public void beforeClass() throws Exception {
        System.setProperty("com.sun.org.apache.xml.internal.security.ignoreLineBreaks", "true");
        this.loadKeys();
        this.loadAssertionTemplates();
    }

    @DataProvider(name="bindings")
    public Object[][] bindings() {
        return new Object[][]{{Binding.HTTP_Redirect}, {Binding.HTTP_POST}};
    }

    @Test
    public void buildIdPMetaData() throws Exception {
        MetaData metaData = new MetaData();
        metaData.id = UUID.randomUUID().toString();
        metaData.entityId = "https://fusionauth.io/samlv2/" + metaData.id;
        metaData.idp = new MetaData.IDPMetaData();
        metaData.idp.wantAuthnRequestsSigned = true;
        metaData.idp.postBindingSignInEndpoints.add("https://fusionauth.io/samlv2/login/POST");
        metaData.idp.redirectBindingSignInEndpoints.add("https://fusionauth.io/samlv2/login/REDIRECT");
        metaData.idp.postBindingLogoutEndpoints.add("https://fusionauth.io/samlv2/logout/POST");
        metaData.idp.redirectBindingLogoutEndpoints.add("https://fusionauth.io/samlv2/logout/REDIRECT");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509Certificate x509Certificate = CertificateTools.fromKeyPair(keyPair, Algorithm.RS256, "FusionAuth");
        metaData.idp.certificates.add(x509Certificate);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        String string = defaultSAMLv2Service.buildMetadataResponse(metaData);
        Assert.assertTrue((boolean)string.contains("_" + metaData.id));
        Assert.assertTrue((boolean)string.contains(metaData.entityId));
        Assert.assertTrue((boolean)string.contains((CharSequence)metaData.idp.postBindingSignInEndpoints.get(0)));
        Assert.assertTrue((boolean)string.contains((CharSequence)metaData.idp.postBindingLogoutEndpoints.get(0)));
        Assert.assertTrue((boolean)string.contains((CharSequence)metaData.idp.redirectBindingLogoutEndpoints.get(0)));
        Assert.assertTrue((boolean)string.contains((CharSequence)metaData.idp.redirectBindingLogoutEndpoints.get(0)));
        Assert.assertTrue((boolean)string.contains("<ns2:IDPSSODescriptor WantAuthnRequestsSigned=\"true\" protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">"));
        MetaData metaData2 = defaultSAMLv2Service.parseMetaData(string);
        Assert.assertEquals((String)metaData2.id, (String)("_" + metaData.id));
        Assert.assertEquals((String)metaData2.entityId, (String)metaData.entityId);
        Assert.assertEquals((Collection)metaData2.idp.postBindingSignInEndpoints, (Collection)metaData.idp.postBindingSignInEndpoints);
        Assert.assertEquals((Collection)metaData2.idp.redirectBindingSignInEndpoints, (Collection)metaData.idp.redirectBindingSignInEndpoints);
        Assert.assertEquals((Collection)metaData2.idp.postBindingLogoutEndpoints, (Collection)metaData.idp.postBindingLogoutEndpoints);
        Assert.assertEquals((Collection)metaData2.idp.redirectBindingLogoutEndpoints, (Collection)metaData.idp.redirectBindingLogoutEndpoints);
        Assert.assertEquals((Collection)metaData2.idp.certificates, (Collection)metaData.idp.certificates);
    }

    @Test(dataProvider="bindings")
    public void buildLogoutRequest(Binding binding) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        X509Certificate x509Certificate = this.generateX509Certificate(keyPair, "SHA256withRSA");
        LogoutRequest logoutRequest = new LogoutRequest();
        logoutRequest.id = "_1245";
        logoutRequest.issuer = "https://acme.corp/saml";
        logoutRequest.sessionIndex = "42";
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        String string = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.buildRedirectLogoutRequest(logoutRequest, "Relay-State-String", true, privateKey, Algorithm.RS256) : defaultSAMLv2Service.buildPostLogoutRequest(logoutRequest, true, privateKey, x509Certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)string);
        String string2 = string;
        if (binding == Binding.HTTP_Redirect) {
            int n = string2.indexOf(61);
            int n2 = string2.indexOf(38);
            string2 = string2.substring(n + 1, n2);
            string2 = URLDecoder.decode(string2, StandardCharsets.UTF_8);
        }
        byte[] byArray = binding == Binding.HTTP_Redirect ? SAMLTools.decodeAndInflate((String)string2) : SAMLTools.decode((String)string2);
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{AuthnRequestType.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(byArray));
        Assert.assertEquals((String)((LogoutRequestType)jAXBElement.getValue()).getID(), (String)"_1245");
        Assert.assertEquals((String)((LogoutRequestType)jAXBElement.getValue()).getIssuer().getValue(), (String)"https://acme.corp/saml");
        Assert.assertEquals((int)((LogoutRequestType)jAXBElement.getValue()).getSessionIndex().size(), (int)1);
        Assert.assertEquals((String)((String)((LogoutRequestType)jAXBElement.getValue()).getSessionIndex().get(0)), (String)"42");
        Assert.assertEquals((String)((LogoutRequestType)jAXBElement.getValue()).getVersion(), (String)"2.0");
        if (binding == Binding.HTTP_Redirect) {
            int n = string.indexOf("RelayState=");
            int n3 = string.indexOf(38, n);
            String string3 = URLDecoder.decode(string.substring(n + "RelayState=".length(), n3), StandardCharsets.UTF_8);
            Assert.assertEquals((String)string3, (String)"Relay-State-String");
            n = string.indexOf("SigAlg=");
            n3 = string.indexOf(38, n);
            String string4 = URLDecoder.decode(string.substring(n + "SigAlg=".length(), n3), StandardCharsets.UTF_8);
            Assert.assertEquals((String)string4, (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        }
    }

    @Test(dataProvider="bindings")
    public void buildLogoutResponse(Binding binding) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        X509Certificate x509Certificate = this.generateX509Certificate(keyPair, "SHA256withRSA");
        LogoutResponse logoutResponse = new LogoutResponse();
        logoutResponse.id = "_1245";
        logoutResponse.issuer = "https://acme.corp/saml";
        logoutResponse.sessionIndex = "42";
        logoutResponse.status = new Status();
        logoutResponse.status.code = ResponseStatus.Success;
        logoutResponse.status.message = "Ok";
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        String string = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.buildRedirectLogoutResponse(logoutResponse, "Relay-State-String", true, privateKey, Algorithm.RS256) : defaultSAMLv2Service.buildPostLogoutResponse(logoutResponse, true, privateKey, x509Certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)string);
        String string2 = string;
        if (binding == Binding.HTTP_Redirect) {
            int n = string2.indexOf(61);
            int n2 = string2.indexOf(38);
            string2 = string2.substring(n + 1, n2);
            string2 = URLDecoder.decode(string2, StandardCharsets.UTF_8);
        }
        byte[] byArray = binding == Binding.HTTP_Redirect ? SAMLTools.decodeAndInflate((String)string2) : SAMLTools.decode((String)string2);
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{AuthnRequestType.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(byArray));
        Assert.assertEquals((String)((StatusResponseType)jAXBElement.getValue()).getID(), (String)"_1245");
        Assert.assertEquals((String)((StatusResponseType)jAXBElement.getValue()).getIssuer().getValue(), (String)"https://acme.corp/saml");
        Assert.assertEquals((String)((StatusResponseType)jAXBElement.getValue()).getVersion(), (String)"2.0");
        if (binding == Binding.HTTP_Redirect) {
            int n = string.indexOf("RelayState=");
            int n3 = string.indexOf(38, n);
            String string3 = URLDecoder.decode(string.substring(n + "RelayState=".length(), n3), StandardCharsets.UTF_8);
            Assert.assertEquals((String)string3, (String)"Relay-State-String");
            n = string.indexOf("SigAlg=");
            n3 = string.indexOf(38, n);
            String string4 = URLDecoder.decode(string.substring(n + "SigAlg=".length(), n3), StandardCharsets.UTF_8);
            Assert.assertEquals((String)string4, (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        }
    }

    @Test
    public void buildLogoutResponse_signatureFollowsIssuer() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        X509Certificate x509Certificate = this.generateX509Certificate(keyPair, "SHA256withRSA");
        LogoutResponse logoutResponse = new LogoutResponse();
        logoutResponse.id = "_1245";
        logoutResponse.issuer = "https://acme.corp/saml";
        logoutResponse.sessionIndex = "42";
        logoutResponse.status = new Status();
        logoutResponse.status.code = ResponseStatus.Success;
        logoutResponse.status.message = "Ok";
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        String string = defaultSAMLv2Service.buildPostLogoutResponse(logoutResponse, true, privateKey, x509Certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)string);
        byte[] byArray = SAMLTools.decode((String)string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        Element element = (Element)document.getElementsByTagName("Issuer").item(0);
        Element element2 = (Element)element.getNextSibling();
        Assert.assertEquals((String)element2.getTagName(), (String)"Signature");
    }

    @Test(dataProvider="BooleanTriState")
    public void buildPostAuthnRequest_forceAuthn(Boolean bl) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        X509Certificate x509Certificate = this.generateX509Certificate(keyPair, "SHA256withRSA");
        AuthenticationRequest authenticationRequest2 = new AuthenticationRequest();
        authenticationRequest2.id = "foobarbaz";
        authenticationRequest2.issuer = "https://local.fusionauth.io";
        authenticationRequest2.forceAuthn = bl;
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        String string = defaultSAMLv2Service.buildPostAuthnRequest(authenticationRequest2, true, privateKey, x509Certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)string);
        AuthenticationRequest authenticationRequest3 = defaultSAMLv2Service.parseRequestPostBinding(string, authenticationRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(x509Certificate.getPublicKey()), true));
        Assert.assertEquals((Boolean)authenticationRequest3.forceAuthn, (Boolean)bl);
        String string2 = defaultSAMLv2Service.buildRedirectAuthnRequest(authenticationRequest2, "Relay-State", true, privateKey, Algorithm.RS256);
        Assert.assertNotNull((Object)string2);
        AuthenticationRequest authenticationRequest4 = defaultSAMLv2Service.parseRequestRedirectBinding(string2, authenticationRequest -> new TestRedirectBindingSignatureHelper(x509Certificate.getPublicKey(), true));
        Assert.assertEquals((Boolean)authenticationRequest4.forceAuthn, (Boolean)bl);
    }

    @Test
    public void buildPostAuthnRequest_signatureFollowsIssuer() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        X509Certificate x509Certificate = this.generateX509Certificate(keyPair, "SHA256withRSA");
        AuthenticationRequest authenticationRequest = new AuthenticationRequest();
        authenticationRequest.id = "foobarbaz";
        authenticationRequest.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        String string = defaultSAMLv2Service.buildPostAuthnRequest(authenticationRequest, true, privateKey, x509Certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)string);
        byte[] byArray = SAMLTools.decode((String)string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        Element element = (Element)document.getElementsByTagName("Issuer").item(0);
        Element element2 = (Element)element.getNextSibling();
        Assert.assertEquals((String)element2.getTagName(), (String)"Signature");
    }

    @Test
    public void buildPostLogoutRequest_signatureFollowsIssuer() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        X509Certificate x509Certificate = this.generateX509Certificate(keyPair, "SHA256withRSA");
        LogoutRequest logoutRequest = new LogoutRequest();
        logoutRequest.id = "foobarbaz";
        logoutRequest.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        String string = defaultSAMLv2Service.buildPostLogoutRequest(logoutRequest, true, privateKey, x509Certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)string);
        byte[] byArray = SAMLTools.decode((String)string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        Element element = (Element)document.getElementsByTagName("Issuer").item(0);
        Element element2 = (Element)element.getNextSibling();
        Assert.assertEquals((String)element2.getTagName(), (String)"Signature");
    }

    @Test(dataProvider="bindings")
    public void buildRedirectAuthnRequest(Binding binding) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        X509Certificate x509Certificate = this.generateX509Certificate(keyPair, "SHA256withRSA");
        AuthenticationRequest authenticationRequest = new AuthenticationRequest();
        authenticationRequest.id = "foobarbaz";
        authenticationRequest.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        String string = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.buildRedirectAuthnRequest(authenticationRequest, "Relay-State-String", true, privateKey, Algorithm.RS256) : defaultSAMLv2Service.buildPostAuthnRequest(authenticationRequest, true, privateKey, x509Certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)string);
        String string2 = string;
        if (binding == Binding.HTTP_Redirect) {
            int n = string2.indexOf(61);
            int n2 = string2.indexOf(38);
            string2 = string2.substring(n + 1, n2);
            string2 = URLDecoder.decode(string2, StandardCharsets.UTF_8);
        }
        byte[] byArray = binding == Binding.HTTP_Redirect ? SAMLTools.decodeAndInflate((String)string2) : SAMLTools.decode((String)string2);
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{AuthnRequestType.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(byArray));
        Assert.assertEquals((String)((AuthnRequestType)jAXBElement.getValue()).getID(), (String)"foobarbaz");
        Assert.assertEquals((String)((AuthnRequestType)jAXBElement.getValue()).getIssuer().getValue(), (String)"https://local.fusionauth.io");
        Assert.assertEquals((String)((AuthnRequestType)jAXBElement.getValue()).getVersion(), (String)"2.0");
        Assert.assertFalse((boolean)((AuthnRequestType)jAXBElement.getValue()).getNameIDPolicy().isAllowCreate());
        if (binding == Binding.HTTP_Redirect) {
            int n = string.indexOf("RelayState=");
            int n3 = string.indexOf(38, n);
            String string3 = URLDecoder.decode(string.substring(n + "RelayState=".length(), n3), StandardCharsets.UTF_8);
            Assert.assertEquals((String)string3, (String)"Relay-State-String");
            n = string.indexOf("SigAlg=");
            n3 = string.indexOf(38, n);
            String string4 = URLDecoder.decode(string.substring(n + "SigAlg=".length(), n3), StandardCharsets.UTF_8);
            Assert.assertEquals((String)string4, (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        }
    }

    @Test
    public void buildSPMetaData() throws Exception {
        MetaData metaData = new MetaData();
        metaData.id = UUID.randomUUID().toString();
        metaData.entityId = "https://fusionauth.io/samlv2/sp/" + metaData.id;
        metaData.sp = new MetaData.SPMetaData();
        metaData.sp.acsEndpoint = "https://fusionauth.io/oauth2/callback";
        metaData.sp.nameIDFormat = NameIDFormat.EmailAddress.toSAMLFormat();
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        String string = defaultSAMLv2Service.buildMetadataResponse(metaData);
        Assert.assertTrue((boolean)string.contains("_" + metaData.id));
        Assert.assertTrue((boolean)string.contains(metaData.entityId));
        Assert.assertTrue((boolean)string.contains(metaData.sp.acsEndpoint));
        Assert.assertTrue((boolean)string.contains(metaData.sp.nameIDFormat));
        Assert.assertTrue((boolean)string.contains("<ns2:SPSSODescriptor AuthnRequestsSigned=\"false\" WantAssertionsSigned=\"false\" protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">"));
        MetaData metaData2 = defaultSAMLv2Service.parseMetaData(string);
        Assert.assertEquals((String)metaData2.id, (String)("_" + metaData.id));
        Assert.assertEquals((String)metaData2.entityId, (String)metaData.entityId);
        Assert.assertEquals((String)metaData2.sp.acsEndpoint, (String)metaData.sp.acsEndpoint);
        Assert.assertEquals((String)metaData2.sp.nameIDFormat, (String)metaData.sp.nameIDFormat);
    }

    @Test(dataProvider="bindings")
    public void hacking_CVE_2022_21449(Binding binding) throws Exception {
        String string;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        keyPairGenerator.initialize(256);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        AuthenticationRequest authenticationRequest2 = new AuthenticationRequest();
        authenticationRequest2.id = "foobarbaz";
        authenticationRequest2.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        if (binding == Binding.HTTP_Redirect) {
            string = defaultSAMLv2Service.buildRedirectAuthnRequest(authenticationRequest2, "Relay-State-String", true, keyPair.getPrivate(), Algorithm.ES256);
        } else {
            X509Certificate x509Certificate = this.generateX509Certificate(keyPair, "SHA256withECDSA");
            string = defaultSAMLv2Service.buildPostAuthnRequest(authenticationRequest2, true, keyPair.getPrivate(), x509Certificate, Algorithm.ES256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        }
        int n = string.indexOf("Signature=");
        int n2 = string.indexOf("&", n);
        byte[] byArray = new byte[]{48, 6, 2, 1, 0, 2, 1, 0};
        String string2 = Base64.getUrlEncoder().encodeToString(byArray);
        if (binding == Binding.HTTP_Redirect) {
            String string3 = string.substring(0, n) + "Signature=" + string2;
            if (n2 != -1) {
                string3 = string3 + string.substring(n2);
            }
            try {
                defaultSAMLv2Service.parseRequestRedirectBinding(string3, authenticationRequest -> new TestRedirectBindingSignatureHelper(keyPair.getPublic(), true));
                Assert.fail((String)"This should have exploded.");
            }
            catch (SAMLException sAMLException) {}
        } else {
            Document document = this.parseDocument(string);
            Node node = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Node node2 = node.getFirstChild().getNextSibling();
            node2.setTextContent(string2);
            String string4 = SAMLTools.marshallToString((Document)document);
            String string5 = new String(Base64.getEncoder().encode(string4.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            try {
                defaultSAMLv2Service.parseRequestPostBinding(string5, authenticationRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(keyPair.getPublic()), true));
                Assert.fail((String)"This should have exploded.");
            }
            catch (SAMLException sAMLException) {
                // empty catch block
            }
        }
    }

    @DataProvider(name="maxLineLength")
    public Object[][] maxLineLength() {
        return new Object[][]{{42}, {64}, {76}, {96}, {128}};
    }

    @Test(dataProvider="bindings")
    public void parseLogout_Request_raw(Binding binding) throws Exception {
        X509Certificate x509Certificate;
        Object object;
        byte[] byArray = binding == Binding.HTTP_Redirect ? Files.readAllBytes(Paths.get("src/test/xml/encoded/logout-request.txt", new String[0])) : Files.readAllBytes(Paths.get("src/test/xml/encoded/logout-request-embedded-signature.txt", new String[0]));
        String string = new String(byArray, StandardCharsets.UTF_8);
        String string2 = Files.readString(Paths.get("src/test/xml/signature/logout-request.txt", new String[0]));
        String string3 = "MIICajCCAdOgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBSMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lbG9naW4gSW5jMRcwFQYDVQQDDA5zcC5leGFtcGxlLmNvbTAeFw0xNDA3MTcxNDEyNTZaFw0xNTA3MTcxNDEyNTZaMFIxCzAJBgNVBAYTAnVzMRMwEQYDVQQIDApDYWxpZm9ybmlhMRUwEwYDVQQKDAxPbmVsb2dpbiBJbmMxFzAVBgNVBAMMDnNwLmV4YW1wbGUuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDZx+ON4IUoIWxgukTb1tOiX3bMYzYQiwWPUNMp+Fq82xoNogso2bykZG0yiJm5o8zv/sd6pGouayMgkx/2FSOdc36T0jGbCHuRSbtia0PEzNIRtmViMrt3AeoWBidRXmZsxCNLwgIV6dn2WpuE5Az0bHgpZnQxTKFek0BMKU/d8wIDAQABo1AwTjAdBgNVHQ4EFgQUGHxYqZYyX7cTxKVODVgZwSTdCnwwHwYDVR0jBBgwFoAUGHxYqZYyX7cTxKVODVgZwSTdCnwwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQ0FAAOBgQByFOl+hMFICbd3DJfnp2Rgd/dqttsZG/tyhILWvErbio/DEe98mXpowhTkC04ENprOyXi7ZbUqiicF89uAGyt1oqgTUCD1VsLahqIcmrzgumNyTwLGWo17WDAa1/usDhetWAMhgzF/Cnf5ek0nK00m0YZGyc4LzgD0CROMASTWNg==";
        try (Object object2 = new ByteArrayInputStream(Base64.getMimeDecoder().decode(string3));){
            object = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)((CertificateFactory)object).generateCertificate((InputStream)object2);
        }
        Assert.assertNotNull((Object)x509Certificate);
        object2 = x509Certificate.getPublicKey();
        object = "SAMLRequest=" + URLEncoder.encode(string, StandardCharsets.UTF_8) + "&RelayState=" + URLEncoder.encode("http://sp.example.com/relaystate", StandardCharsets.UTF_8) + "&SigAlg=" + URLEncoder.encode(Algorithm.RS1.uri, StandardCharsets.UTF_8) + "&Signature=" + URLEncoder.encode(string2, StandardCharsets.UTF_8);
        boolean bl = false;
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        LogoutRequest logoutRequest = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.parseLogoutRequestRedirectBinding((String)object, arg_0 -> DefaultSAMLv2ServiceTest.lambda$parseLogout_Request_raw$4((PublicKey)object2, bl, arg_0)) : defaultSAMLv2Service.parseLogoutRequestPostBinding(string, arg_0 -> DefaultSAMLv2ServiceTest.lambda$parseLogout_Request_raw$5((PublicKey)object2, bl, arg_0));
        Assert.assertEquals((String)logoutRequest.id, (String)(binding == Binding.HTTP_Redirect ? "ONELOGIN_21df91a89767879fc0f7df6a1490c6000c81644d" : "pfxd4d369e8-9ea1-780c-aff8-a1d11a9862a1"));
        Assert.assertEquals((String)logoutRequest.issuer, (String)"http://sp.example.com/demo1/metadata.php");
        Assert.assertEquals((String)logoutRequest.nameIdFormat, (String)NameIDFormat.Transient.toSAMLFormat());
        Assert.assertEquals((String)logoutRequest.version, (String)"2.0");
        String string4 = binding == Binding.HTTP_Redirect ? new String(Files.readAllBytes(Paths.get("src/test/xml/logout-request.xml", new String[0]))) : new String(Files.readAllBytes(Paths.get("src/test/xml/logout-request-embedded-signature.xml", new String[0])));
        Assert.assertEquals((String)logoutRequest.xml.replace("\r\n", "\n"), (String)string4.replace("\r\n", "\n"));
    }

    @Test
    public void parseMetaData() throws Exception {
        byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/metadata.xml", new String[0]));
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        MetaData metaData = defaultSAMLv2Service.parseMetaData(new String(byArray, StandardCharsets.UTF_8));
        Assert.assertEquals((int)metaData.idp.certificates.size(), (int)3);
        byArray = Files.readAllBytes(Paths.get("src/test/xml/metadata-2.xml", new String[0]));
        metaData = defaultSAMLv2Service.parseMetaData(new String(byArray, StandardCharsets.UTF_8));
        Assert.assertEquals((int)metaData.idp.certificates.size(), (int)1);
    }

    @Test(enabled=false)
    public void parseRequest_compassSecurity() throws Exception {
        String string = "PHNhbWxwOkF1dGhuUmVxdWVzdCB4bWxuczpzYW1scD0idXJuOm9hc2lzOm5hbWVzOnRjOlNBTUw6Mi4wOnByb3RvY29sIg0KICAgICAgICAgICAgICAgICAgICB4bWxuczpzYW1sPSJ1cm46b2FzaXM6bmFtZXM6dGM6U0FNTDoyLjA6YXNzZXJ0aW9uIiBJRD0iXzdmZTUxMGNjOGU1MWFhNDE1NThhIg0KICAgICAgICAgICAgICAgICAgICBJc3N1ZUluc3RhbnQ9IjIwMjEtMDEtMjFUMTY6NDY6MDVaIiBQcm92aWRlck5hbWU9IlNpbXBsZSBTQU1MIFNlcnZpY2UgUHJvdmlkZXIiDQogICAgICAgICAgICAgICAgICAgIEFzc2VydGlvbkNvbnN1bWVyU2VydmljZVVSTD0iaHR0cDovL2xvY2FsaG9zdDo3MDcwL3NhbWwvc3NvIg0KICAgICAgICAgICAgICAgICAgICBEZXN0aW5hdGlvbj0iaHR0cDovL2xvY2FsaG9zdDo5MDExL3NhbWx2Mi9sb2dpbi81YjJlNDgzZi03NTcyLTQ4NzktODE3ZS0xYTkwYWM0NGU3NTciDQogICAgICAgICAgICAgICAgICAgIFByb3RvY29sQmluZGluZz0idXJuOm9hc2lzOm5hbWVzOnRjOlNBTUw6Mi4wOmJpbmRpbmdzOkhUVFAtUE9TVCIgVmVyc2lvbj0iMi4wIj4NCiAgPHNhbWw6SXNzdWVyPnVybjpleGFtcGxlOnNwPC9zYW1sOklzc3Vlcj4NCiAgPFNpZ25hdHVyZSB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC8wOS94bWxkc2lnIyI+DQogICAgPFNpZ25lZEluZm8+DQogICAgICA8Q2Fub25pY2FsaXphdGlvbk1ldGhvZCBBbGdvcml0aG09Imh0dHA6Ly93d3cudzMub3JnLzIwMDEvMTAveG1sLWV4Yy1jMTRuIyIvPg0KICAgICAgPFNpZ25hdHVyZU1ldGhvZCBBbGdvcml0aG09Imh0dHA6Ly93d3cudzMub3JnLzIwMDEvMDQveG1sZHNpZy1tb3JlI3JzYS1zaGEyNTYiLz4NCiAgICAgIDxSZWZlcmVuY2UgVVJJPSIjXzdmZTUxMGNjOGU1MWFhNDE1NThhIj4NCiAgICAgICAgPFRyYW5zZm9ybXM+DQogICAgICAgICAgPFRyYW5zZm9ybSBBbGdvcml0aG09Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvMDkveG1sZHNpZyNlbnZlbG9wZWQtc2lnbmF0dXJlIi8+DQogICAgICAgICAgPFRyYW5zZm9ybSBBbGdvcml0aG09Imh0dHA6Ly93d3cudzMub3JnLzIwMDEvMTAveG1sLWV4Yy1jMTRuIyIvPg0KICAgICAgICA8L1RyYW5zZm9ybXM+DQogICAgICAgIDxEaWdlc3RNZXRob2QgQWxnb3JpdGhtPSJodHRwOi8vd3d3LnczLm9yZy8yMDAxLzA0L3htbGVuYyNzaGEyNTYiLz4NCiAgICAgICAgPERpZ2VzdFZhbHVlPjV4V2cvaWRqOGpNV2Z3ZWRmaksyQkVZa2QveUxXY2pNa2ZKK1ZmOHQrRkE9PC9EaWdlc3RWYWx1ZT4NCiAgICAgIDwvUmVmZXJlbmNlPg0KICAgIDwvU2lnbmVkSW5mbz4NCiAgICA8U2lnbmF0dXJlVmFsdWU+DQogICAgICBsZ05CSEZ4UHFueHVKRmVRa0cwN3dNY0JwZll3TkVBc2pMeWpQTTBsQit5Nm8rNEtDSzN0U2padXVSUVlNWTRJb3J6Uk95b3piZGtsRitCT2UxL0tKNFhxRGhFaXFlbUEyTGszcEliakJQbit6NDdGcER0NWdsQUVxY3NmMlI2RDhKTndkNWJxSmgxYnVITXNUQ3dIOFhPVHZpdHlxQXZrZmp4WVhNU290SDFWSWxrRWxjZFF6aXA5ZlhsZW1ZdExCdXoybG5sTHYyS01DSkRpYTlQTzZrSHQySTRBL2s0WXBNRmx2NlF0aGlPcjdlVjROOWIxVk43VUxYRHJlUS9OUDhtZWdtWGVBcWxaMC81VnlXdGRYQ1E0QUlSUVlUeW5mTlZ3TDA1VG5JOXNYZDl5WTdPbXk5WVJwdEYzaHZBWVFqd0t1ak90bjNGUnJNSldKMzRha3c9PQ0KICAgIDwvU2lnbmF0dXJlVmFsdWU+DQogICAgPEtleUluZm8+DQogICAgICA8WDUwOURhdGE+DQogICAgICAgIDxYNTA5Q2VydGlmaWNhdGU+DQogICAgICAgICAgTUlJRFV6Q0NBanVnQXdJQkFnSUpBUEowbUE2V3pPcHZNQTBHQ1NxR1NJYjNEUUVCQ3dVQU1HQXhDekFKQmdOVkJBWVRBbFZUTVJNd0VRWURWUVFJRXdwRFlXeHBabTl5Ym1saE1SWXdGQVlEVlFRSEV3MVRZVzRnUm5KaGJtTnBjMk52TVJBd0RnWURWUVFLRXdkS1lXNXJlVU52TVJJd0VBWURWUVFERXdsc2IyTmhiR2h2YzNRd0hoY05NVFF3TXpFeU1UazBOak16V2hjTk1qY3hNVEU1TVRrME5qTXpXakJnTVFzd0NRWURWUVFHRXdKVlV6RVRNQkVHQTFVRUNCTUtRMkZzYVdadmNtNXBZVEVXTUJRR0ExVUVCeE1OVTJGdUlFWnlZVzVqYVhOamJ6RVFNQTRHQTFVRUNoTUhTbUZ1YTNsRGJ6RVNNQkFHQTFVRUF4TUpiRzlqWVd4b2IzTjBNSUlCSWpBTkJna3Foa2lHOXcwQkFRRUZBQU9DQVE4QU1JSUJDZ0tDQVFFQXRsTkR5NERSMnRoWjJERGNpSVRvZlVwd1laY25Yay85cHFEdDhWMTZqQkQwMnVPZC9UZHlzZ2lLTGpyWlpiQy9YME9YMUVGZTVkTjY1VXJMT0RRQkJ6WjMvOFBZejY4MTlNS2M5aXJWOCs3MzJINWRHd3pnbVlCWUQrcXFmNEJjUjM2TDdUam1Pd2prZSsxY01jR2crV1hWU1hRTS9kalN4aFFIaldOamtSdDFUL21MZmxxTXFwb3B6Y21BUFFETEVIRXJ0dWFtOVh0dWRqaUZNOHI1anp2bXUvVXBJUGliYndBWThxM3NUUHBFN0pCTHI2SXk0cEJBY2lMbFhhNE5yRFE4YUw4akZwaWhqdm0rdUhWTUhNR215bkdpY0dRTGdyRktPV3M2NTVtVlZXWGZET2U2SjVwaUJYcjFteW5uQnN0ZGRTYWxaNWFMQVdGOGc2c3pmUUlEQVFBQm94QXdEakFNQmdOVkhSTUJBZjhFQWpBQU1BMEdDU3FHU0liM0RRRUJDd1VBQTRJQkFRQ2xaeStnTVlrTmZvK2RRakV1dmJ2eDYyTU1SM1dka3BmZXk0M1pnUHF4MTh2cEcwUDdhSXFUeWJreFRraGkvQXc4cExEY0l2QVBaSHFsTWZMQ05Cci80K3NucXJMbzNPaUdaSTFobDlRT0czaFFta3JqVDEwaGx5WFJTM29UbmpENWJoRGoraW5iRzFpOVFSSzdQTzBQUXFXaElLZ3J0THlZcDNXdlM2WjljWVh3UXQ1RmNZYmhLcCtDK2t2Q3pxK1RmYlFhbWx2ZWhXakJVTlIyN0NFMTFNLy9XVEYwbmZiT0Z1MzJFQzZrQjBFR2Q2UFRJd2h0eTJ6SHhnKyt1WU1qQVVMK1pOdU5pYU1jMzU1b1h2THRoMXE1cmszR2EzdW5wQmptUTdvYlUyLzQvV2RKblBmdmxEMmt0QVYvUzVkVlNLU0RObWthZzhJWDBuSGIvMUZODQogICAgICAgIDwvWDUwOUNlcnRpZmljYXRlPg0KICAgICAgPC9YNTA5RGF0YT4NCiAgICA8L0tleUluZm8+DQogIDwvU2lnbmF0dXJlPg0KICA8c2FtbHA6TmFtZUlEUG9saWN5IEZvcm1hdD0idXJuOm9hc2lzOm5hbWVzOnRjOlNBTUw6MS4xOm5hbWVpZC1mb3JtYXQ6ZW1haWxBZGRyZXNzIiBBbGxvd0NyZWF0ZT0idHJ1ZSIvPg0KICA8c2FtbHA6UmVxdWVzdGVkQXV0aG5Db250ZXh0IENvbXBhcmlzb249ImV4YWN0Ij4NCiAgICA8c2FtbDpBdXRobkNvbnRleHRDbGFzc1JlZj51cm46b2FzaXM6bmFtZXM6dGM6U0FNTDoyLjA6YWM6Y2xhc3NlczpQYXNzd29yZFByb3RlY3RlZFRyYW5zcG9ydA0KICAgIDwvc2FtbDpBdXRobkNvbnRleHRDbGFzc1JlZj4NCiAgPC9zYW1scDpSZXF1ZXN0ZWRBdXRobkNvbnRleHQ+DQo8L3NhbWxwOkF1dGhuUmVxdWVzdD4=";
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(new BigInteger("23016430918823899869174537266594866915196701755262955756947374683306171050449785978041642070945082562110926617344211216571596575890159654912559343561454566120924390651417182396241104494630512996615232908509829811443784313485862019497373006302688901954848508137355590138442254765794572625586049567608157223736747587462558785268970406066201827350377828581492579969240135441642716939367190425379788145244337250560138881783025442595121210838086638484878363941229167629103738547784336822433469701246494321129732432091196962736034404069520496182669787723781485938596516343326251546340541402004104537790138422441873446220669"), new BigInteger("65537")));
        TestPostBindingSignatureHelper testPostBindingSignatureHelper = new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), true);
        AuthenticationRequest authenticationRequest2 = defaultSAMLv2Service.parseRequestPostBinding(string, authenticationRequest -> testPostBindingSignatureHelper);
        Assert.assertEquals((String)authenticationRequest2.id, (String)"_7fe510cc8e51aa41558a");
        Assert.assertEquals((String)authenticationRequest2.issuer, (String)"urn:example:sp");
        Assert.assertEquals((String)authenticationRequest2.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)authenticationRequest2.version, (String)"2.0");
    }

    @Test
    public void parseRequest_expandedEntity() throws Exception {
        try {
            DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
            byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/authn-request-expanded-entity.xml", new String[0]));
            String string = SAMLTools.deflateAndEncode((byte[])byArray);
            String string2 = "SAMLRequest=" + URLEncoder.encode(string, StandardCharsets.UTF_8);
            AuthenticationRequest authenticationRequest2 = defaultSAMLv2Service.parseRequestRedirectBinding(string2, authenticationRequest -> new TestRedirectBindingSignatureHelper());
            Assert.fail((String)("Expected an exception because we are declaring a DOCTYPE and expanding an entity. The issuer is now set to [" + authenticationRequest2.issuer + "] which is not good."));
        }
        catch (SAMLException sAMLException) {
            Assert.assertEquals((String)sAMLException.getMessage(), (String)"Unable to parse SAML v2.0 document.");
            Assert.assertEquals((String)sAMLException.getCause().getClass().getCanonicalName(), (String)"org.xml.sax.SAXParseException");
            Assert.assertEquals((String)sAMLException.getCause().getMessage(), (String)"DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void parseRequest_externalDTD() throws Exception {
        Path path = null;
        try {
            path = Files.createTempFile("readThisFile", ".tmp", new FileAttribute[0]);
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(path.toFile()));){
                bufferedWriter.write("You've been pwned.");
            }
            bufferedWriter = new DefaultSAMLv2Service();
            byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/authn-request-external-dtd.xml", new String[0]));
            String string = new String(byArray);
            string = string.replace("{{tempFile}}", path.toFile().getAbsolutePath());
            byArray = string.getBytes(StandardCharsets.UTF_8);
            String string2 = SAMLTools.deflateAndEncode((byte[])byArray);
            String string3 = "SAMLRequest=" + URLEncoder.encode(string2, StandardCharsets.UTF_8);
            AuthenticationRequest authenticationRequest2 = bufferedWriter.parseRequestRedirectBinding(string3, authenticationRequest -> new TestRedirectBindingSignatureHelper());
            Assert.fail((String)("Expected an exception because we are declaring a DOCTYPE. The issuer is now set to [" + authenticationRequest2.issuer + "] which is not good."));
        }
        catch (SAMLException sAMLException) {
            Assert.assertEquals((String)sAMLException.getMessage(), (String)"Unable to parse SAML v2.0 document.");
            Assert.assertEquals((String)sAMLException.getCause().getClass().getCanonicalName(), (String)"org.xml.sax.SAXParseException");
            Assert.assertEquals((String)sAMLException.getCause().getMessage(), (String)"DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true.");
        }
        finally {
            if (path != null) {
                Files.deleteIfExists(path);
            }
        }
    }

    @Test(dataProvider="bindings")
    public void parseRequest_forceAuthn(Binding binding) throws Exception {
        byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/authn-request-forceAuthn.xml", new String[0]));
        String string = binding == Binding.HTTP_Redirect ? SAMLTools.deflateAndEncode((byte[])byArray) : SAMLTools.encode((byte[])byArray);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationRequest authenticationRequest2 = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.parseRequestRedirectBinding("SAMLRequest=" + URLEncoder.encode(string, StandardCharsets.UTF_8), authenticationRequest -> new TestRedirectBindingSignatureHelper()) : defaultSAMLv2Service.parseRequestPostBinding(string, authenticationRequest -> new TestPostBindingSignatureHelper());
        Assert.assertEquals((String)authenticationRequest2.id, (String)"_809707f0030a5d00620c9d9df97f627afe9dcc24");
        Assert.assertEquals((String)authenticationRequest2.issuer, (String)"http://sp.example.com/demo1/metadata.php");
        Assert.assertEquals((String)authenticationRequest2.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)authenticationRequest2.version, (String)"2.0");
        Assert.assertEquals((Boolean)authenticationRequest2.forceAuthn, (Boolean)Boolean.TRUE);
    }

    @Test
    public void parseRequest_hasDocType() throws Exception {
        try {
            DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
            byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/authn-request-has-doctype.xml", new String[0]));
            String string = SAMLTools.deflateAndEncode((byte[])byArray);
            String string2 = "SAMLRequest=" + URLEncoder.encode(string, StandardCharsets.UTF_8);
            defaultSAMLv2Service.parseRequestRedirectBinding(string2, authenticationRequest -> new TestRedirectBindingSignatureHelper());
            Assert.fail((String)"expected an exception because we are declaring a DOCTYPE");
        }
        catch (SAMLException sAMLException) {
            Assert.assertEquals((String)sAMLException.getMessage(), (String)"Unable to parse SAML v2.0 document.");
            Assert.assertEquals((String)sAMLException.getCause().getClass().getCanonicalName(), (String)"org.xml.sax.SAXParseException");
            Assert.assertEquals((String)sAMLException.getCause().getMessage(), (String)"DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true.");
        }
    }

    @Test(dataProvider="maxLineLength")
    public void parseRequest_includeLineReturns(int n) throws Exception {
        String string = new String(Files.readAllBytes(Paths.get("src/test/xml/authn-request-control.xml", new String[0])));
        String string2 = new String(Files.readAllBytes(Paths.get("src/test/xml/deflated/authn-request-control.txt", new String[0])));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string2.length(); i += n) {
            arrayList.add(string2.substring(i, Math.min(i + n, string2.length())));
        }
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        String string3 = String.join((CharSequence)"\n", arrayList);
        String string4 = "SAMLRequest=" + URLEncoder.encode(string3, StandardCharsets.UTF_8);
        AuthenticationRequest authenticationRequest2 = defaultSAMLv2Service.parseRequestRedirectBinding(string4, authenticationRequest -> new TestRedirectBindingSignatureHelper());
        Assert.assertEquals((String)authenticationRequest2.id, (String)"_809707f0030a5d00620c9d9df97f627afe9dcc24");
        Assert.assertEquals((String)authenticationRequest2.issuer, (String)"http://sp.example.com/demo1/metadata.php");
        Assert.assertEquals((String)authenticationRequest2.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)authenticationRequest2.version, (String)"2.0");
        Assert.assertEquals((String)authenticationRequest2.xml.replace("\r\n", "\n"), (String)string.replace("\r\n", "\n"));
    }

    @Test(dataProvider="bindings")
    public void parseRequest_noNameIdPolicy(Binding binding) throws Exception {
        String string = new String(Files.readAllBytes(Paths.get("src/test/xml/authn-request-noNameIdPolicy.xml", new String[0])));
        String string2 = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/deflated/authn-request-noNameIdPolicy.txt", new String[0]) : Paths.get("src/test/xml/encoded/authn-request-noNameIdPolicy.txt", new String[0])));
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationRequest authenticationRequest2 = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.parseRequestRedirectBinding("SAMLRequest=" + URLEncoder.encode(string2, StandardCharsets.UTF_8), authenticationRequest -> new TestRedirectBindingSignatureHelper()) : defaultSAMLv2Service.parseRequestPostBinding(string2, authenticationRequest -> new TestPostBindingSignatureHelper());
        Assert.assertEquals((String)authenticationRequest2.id, (String)"id_4c6e5aa3");
        Assert.assertEquals((String)authenticationRequest2.issuer, (String)"https://medallia.com/sso/mlg");
        Assert.assertEquals((String)authenticationRequest2.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)authenticationRequest2.version, (String)"2.0");
        Assert.assertEquals((String)authenticationRequest2.xml.replace("\r\n", "\n"), (String)string.replace("\r\n", "\n"));
    }

    @Test(dataProvider="bindings")
    public void parseRequest_verifySignature(Binding binding) throws Exception {
        String string = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/authn-request-redirect-signed.xml", new String[0]) : Paths.get("src/test/xml/authn-request-post-signed.xml", new String[0])));
        String string2 = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/relay-state/authn-request-redirect.txt", new String[0]) : Paths.get("src/test/xml/relay-state/authn-request-post.txt", new String[0])));
        String string3 = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/deflated/authn-request-signed.txt", new String[0]) : Paths.get("src/test/xml/encoded/authn-request-signed.txt", new String[0])));
        String string4 = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/signature/authn-request-redirect.txt", new String[0]) : Paths.get("src/test/xml/signature/authn-request-post.txt", new String[0])));
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.getMimeDecoder().decode(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/public-key/authn-request-redirect.txt", new String[0]) : Paths.get("src/test/xml/public-key/authn-request-post.txt", new String[0])))));
        String string5 = "SAMLRequest=" + URLEncoder.encode(string3, StandardCharsets.UTF_8) + "&RelayState=" + URLEncoder.encode(string2, StandardCharsets.UTF_8) + "&SigAlg=" + URLEncoder.encode(Algorithm.RS256.uri, StandardCharsets.UTF_8) + "&Signature=" + URLEncoder.encode(string4, StandardCharsets.UTF_8);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationRequest authenticationRequest2 = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.parseRequestRedirectBinding(string5, authenticationRequest -> new TestRedirectBindingSignatureHelper(publicKey, true)) : defaultSAMLv2Service.parseRequestPostBinding(string3, authenticationRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), true));
        Assert.assertEquals((String)authenticationRequest2.id, (String)(binding == Binding.HTTP_Redirect ? "ID_025417c8-50c8-4916-bfe0-e05694f8cea7" : "ID_26d69170-fc73-4b62-8bb6-c72769216134"));
        Assert.assertEquals((String)authenticationRequest2.issuer, (String)"http://localhost:8080/auth/realms/master");
        Assert.assertEquals((String)authenticationRequest2.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)authenticationRequest2.version, (String)"2.0");
        Assert.assertEquals((String)authenticationRequest2.xml.replace("\r\n", "\n"), (String)string.replace("\r\n", "\n"));
    }

    @Test(dataProvider="bindings")
    public void parseRequest_verifySignature_badSignature(Binding binding) throws Exception {
        String string = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/relay-state/authn-request-redirect.txt", new String[0]) : Paths.get("src/test/xml/relay-state/authn-request-post.txt", new String[0])));
        String string2 = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/deflated/authn-request-signed.txt", new String[0]) : Paths.get("src/test/xml/encoded/authn-request-signed-badSignature.txt", new String[0])));
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.getMimeDecoder().decode(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/public-key/authn-request-redirect.txt", new String[0]) : Paths.get("src/test/xml/public-key/authn-request-post.txt", new String[0])))));
        try {
            DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
            if (binding == Binding.HTTP_Redirect) {
                String string3 = new String(Files.readAllBytes(Paths.get("src/test/xml/signature/authn-request-redirect-bad.txt", new String[0])));
                String string4 = "SAMLRequest=" + URLEncoder.encode(string2, StandardCharsets.UTF_8) + "&RelayState=" + URLEncoder.encode(string, StandardCharsets.UTF_8) + "&SigAlg=" + URLEncoder.encode("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", StandardCharsets.UTF_8) + "&Signature=" + URLEncoder.encode(string3, StandardCharsets.UTF_8);
                defaultSAMLv2Service.parseRequestRedirectBinding(string4, authenticationRequest -> new TestRedirectBindingSignatureHelper(publicKey, true));
            } else {
                defaultSAMLv2Service.parseRequestPostBinding(string2, authenticationRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), true));
            }
            Assert.fail((String)"Should have failed signature validation");
        }
        catch (SAMLException sAMLException) {
            Assert.assertEquals((String)sAMLException.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is invalid.");
        }
    }

    @Test(dataProvider="bindings")
    public void parseRequest_withNameIdPolicy(Binding binding) throws Exception {
        String string = new String(Files.readAllBytes(Paths.get("src/test/xml/authn-request-control.xml", new String[0])));
        String string2 = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/deflated/authn-request-control.txt", new String[0]) : Paths.get("src/test/xml/encoded/authn-request-control.txt", new String[0])));
        String string3 = "SAMLRequest=" + URLEncoder.encode(string2, StandardCharsets.UTF_8);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationRequest authenticationRequest2 = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.parseRequestRedirectBinding(string3, authenticationRequest -> new TestRedirectBindingSignatureHelper()) : defaultSAMLv2Service.parseRequestPostBinding(string2, authenticationRequest -> new TestPostBindingSignatureHelper());
        Assert.assertEquals((String)authenticationRequest2.acsURL, (String)"http://sp.example.com/demo1/index.php?acs");
        Assert.assertEquals((String)authenticationRequest2.id, (String)"_809707f0030a5d00620c9d9df97f627afe9dcc24");
        Assert.assertEquals((String)authenticationRequest2.issuer, (String)"http://sp.example.com/demo1/metadata.php");
        Assert.assertEquals((String)authenticationRequest2.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)authenticationRequest2.version, (String)"2.0");
        Assert.assertEquals((String)authenticationRequest2.xml.replace("\r\n", "\n"), (String)string.replace("\r\n", "\n"));
    }

    @Test
    public void parseResponse() throws Exception {
        PublicKey publicKey;
        Object object;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try (Object object2 = Files.newInputStream(Paths.get("src/test/certificates/certificate.cer", new String[0]), new OpenOption[0]);){
            object = certificateFactory.generateCertificate((InputStream)object2);
            publicKey = ((Certificate)object).getPublicKey();
        }
        object2 = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        object = new String((byte[])object2);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse((String)object, true, KeySelector.singletonKeySelector(publicKey));
        Assert.assertEquals((String)authenticationResponse.destination, (String)"https://local.fusionauth.io/oauth2/callback");
        Assert.assertTrue((boolean)authenticationResponse.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((String)authenticationResponse.issuer, (String)"https://sts.windows.net/c2150111-3c44-4508-9f08-790cb4032a23/");
        Assert.assertEquals((Object)authenticationResponse.status.code, (Object)ResponseStatus.Success);
        Assertion assertion = (Assertion)authenticationResponse.assertions.get(0);
        Assert.assertTrue((boolean)assertion.conditions.notBefore.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertTrue((boolean)ZonedDateTime.now(ZoneOffset.UTC).isAfter(assertion.conditions.notOnOrAfter));
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.microsoft.com/identity/claims/displayname")).get(0)), (String)"Brian Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname")).get(0)), (String)"Brian");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname")).get(0)), (String)"Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress")).get(0)), (String)"brian@inversoft.com");
        Assert.assertNotNull((Object)assertion.subject.nameIDs);
        Assert.assertEquals((int)assertion.subject.nameIDs.size(), (int)1);
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)0)).format, (String)NameIDFormat.EmailAddress.toSAMLFormat());
    }

    @Test
    public void parseResponse_detachedSignature() throws Exception {
        byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse-detachedSignature.txt", new String[0]));
        String string = new String(byArray, StandardCharsets.UTF_8);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string, true, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()));
        Assert.assertEquals((String)authenticationResponse.destination, (String)"https://local.fusionauth.io/samlv2/acs");
        Assert.assertTrue((boolean)authenticationResponse.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((String)authenticationResponse.issuer, (String)"https://example.com/saml");
        Assert.assertEquals((Object)authenticationResponse.status.code, (Object)ResponseStatus.Success);
        Assertion assertion = (Assertion)authenticationResponse.assertions.get(0);
        Assert.assertTrue((boolean)assertion.conditions.notBefore.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertTrue((boolean)ZonedDateTime.now(ZoneOffset.UTC).isAfter(assertion.conditions.notOnOrAfter));
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("sub")).get(0)), (String)"41");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("email")).get(0)), (String)"test@example.com");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("username")).get(0)), (String)"guitarchargejobs");
        Assert.assertNotNull((Object)assertion.subject.nameIDs);
        Assert.assertEquals((int)assertion.subject.nameIDs.size(), (int)2);
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)0)).format, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)1)).format, (String)NameIDFormat.Persistent.toSAMLFormat());
    }

    @Test
    public void parseResponse_duplicateIds() throws Exception {
        String string = this.baseXml.replace("${assertions}", String.join((CharSequence)"", List.of(this.assertionUnsigned, this.assertionUnsigned)));
        String string2 = Base64.getMimeEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        try {
            defaultSAMLv2Service.parseResponse(string2, false, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()), false, this.encryptionKeyPair.getPrivate());
            Assert.fail((String)"Expected SAMLException");
        }
        catch (SAMLException sAMLException) {
            Assert.assertEquals((String)sAMLException.getMessage(), (String)"Unable to parse SAML v2.0 XML. The document contains duplicate element IDs.");
        }
        string = this.baseXml.replace("${assertions}", String.join((CharSequence)"", List.of(this.encryptedUnsigned, this.encryptedUnsigned)));
        string2 = Base64.getMimeEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
        try {
            defaultSAMLv2Service.parseResponse(string2, false, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()), false, this.encryptionKeyPair.getPrivate());
            Assert.fail((String)"Expected SAMLException");
        }
        catch (SAMLException sAMLException) {
            Assert.assertEquals((String)sAMLException.getMessage(), (String)"Unable to parse SAML v2.0 XML. The document contains duplicate element IDs.");
        }
    }

    @Test
    public void parseResponse_handleNilAttribute_UnsupportedType_NoValue() throws Exception {
        byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/deflated/example-response.txt", new String[0]));
        String string = new String(byArray);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string, false, null);
        Assert.assertEquals((String)authenticationResponse.destination, (String)"http://sp.example.com/demo1/index.php?acs");
        Assert.assertEquals((String)authenticationResponse.issuer, (String)"http://idp.example.com/metadata.php");
        Assert.assertEquals((Object)authenticationResponse.status.code, (Object)ResponseStatus.Success);
        Assertion assertion = (Assertion)authenticationResponse.assertions.get(0);
        Assert.assertTrue((boolean)assertion.conditions.notBefore.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((int)((List)assertion.attributes.get("uid")).size(), (int)1);
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("uid")).get(0)), (String)"test");
        Assert.assertEquals((int)((List)assertion.attributes.get("mail")).size(), (int)1);
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("mail")).get(0)), (String)"test@example.com");
        Assert.assertEquals((int)((List)assertion.attributes.get("eduPersonAffiliation")).size(), (int)2);
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("eduPersonAffiliation")).get(0)), (String)"users");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("eduPersonAffiliation")).get(1)), (String)"examplerole1");
        Assert.assertEquals((int)((List)assertion.attributes.get("memberOf")).size(), (int)1);
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("memberOf")).get(0)), (String)"");
        Assert.assertEquals((int)((List)assertion.attributes.get("PersonImmutableID")).size(), (int)1);
        Assert.assertNull(((List)assertion.attributes.get("PersonImmutableID")).get(0));
        Assert.assertEquals((int)((List)assertion.attributes.get("isAdmin")).size(), (int)1);
        Assert.assertNull(((List)assertion.attributes.get("isAdmin")).get(0));
        Assert.assertEquals((int)((List)assertion.attributes.get("noValue")).size(), (int)0);
        Assert.assertNotNull((Object)assertion.subject.nameIDs);
        Assert.assertEquals((int)assertion.subject.nameIDs.size(), (int)1);
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)0)).format, (String)NameIDFormat.Transient.toSAMLFormat());
        Assertion assertion2 = new Assertion(assertion);
        Assert.assertEquals((Object)assertion2, (Object)assertion);
    }

    @Test(dataProvider="maxLineLength")
    public void parseResponse_includeLineReturns(int n) throws Exception {
        PublicKey publicKey;
        Object object;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try (Object object2 = Files.newInputStream(Paths.get("src/test/certificates/certificate.cer", new String[0]), new OpenOption[0]);){
            object = certificateFactory.generateCertificate((InputStream)object2);
            publicKey = ((Certificate)object).getPublicKey();
        }
        object2 = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        object = new String((byte[])object2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < ((String)object).length(); i += n) {
            arrayList.add(((String)object).substring(i, Math.min(i + n, ((String)object).length())));
        }
        String string = String.join((CharSequence)"\n", arrayList);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string, true, KeySelector.singletonKeySelector(publicKey));
        Assert.assertEquals((String)authenticationResponse.destination, (String)"https://local.fusionauth.io/oauth2/callback");
        Assert.assertTrue((boolean)authenticationResponse.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((String)authenticationResponse.issuer, (String)"https://sts.windows.net/c2150111-3c44-4508-9f08-790cb4032a23/");
        Assert.assertEquals((Object)authenticationResponse.status.code, (Object)ResponseStatus.Success);
        Assertion assertion = (Assertion)authenticationResponse.assertions.get(0);
        Assert.assertTrue((boolean)assertion.conditions.notBefore.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertTrue((boolean)ZonedDateTime.now(ZoneOffset.UTC).isAfter(assertion.conditions.notOnOrAfter));
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.microsoft.com/identity/claims/displayname")).get(0)), (String)"Brian Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname")).get(0)), (String)"Brian");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname")).get(0)), (String)"Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress")).get(0)), (String)"brian@inversoft.com");
        Assert.assertNotNull((Object)assertion.subject.nameIDs);
        Assert.assertEquals((int)assertion.subject.nameIDs.size(), (int)1);
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)0)).format, (String)NameIDFormat.EmailAddress.toSAMLFormat());
    }

    @Test
    public void parseResponse_multipleAssertions_ignoreSignature() throws Exception {
        String string = this.baseXml.replace("${assertions}", String.join((CharSequence)"", List.of(this.assertionSigned, this.assertionUnsigned, this.encryptedSigned, this.encryptedUnsigned)));
        String string2 = Base64.getMimeEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string2, false, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()), false, this.encryptionKeyPair.getPrivate());
        Assert.assertEquals((int)authenticationResponse.assertions.size(), (int)4);
    }

    @Test
    public void parseResponse_multipleAssertions_verifySignature() throws Exception {
        String string = this.baseXml.replace("${assertions}", String.join((CharSequence)"", List.of(this.assertionSigned, this.assertionUnsigned, this.encryptedSigned, this.encryptedUnsigned)));
        String string2 = Base64.getMimeEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string2, true, KeySelector.singletonKeySelector(this.signingKeyPair.getPublic()), false, this.encryptionKeyPair.getPrivate());
        Assert.assertEquals((int)authenticationResponse.assertions.size(), (int)2);
        Assert.assertEquals((String)((Assertion)authenticationResponse.assertions.get((int)0)).id, (String)"_b839e63e-4673-43a8-b226-ef73676a70b1");
        Assert.assertEquals((String)((Assertion)authenticationResponse.assertions.get((int)1)).id, (String)"_604b9303-a5b0-411f-9b3a-5f525fe6887b");
        authenticationResponse = defaultSAMLv2Service.parseResponse(string2, true, KeySelector.singletonKeySelector(this.signingKeyPair.getPublic()), true, this.encryptionKeyPair.getPrivate());
        Assert.assertEquals((int)authenticationResponse.assertions.size(), (int)1);
        Assert.assertEquals((String)((Assertion)authenticationResponse.assertions.get((int)0)).id, (String)"_604b9303-a5b0-411f-9b3a-5f525fe6887b");
        string = this.baseXml.replace("${assertions}", String.join((CharSequence)"", List.of(this.assertionUnsigned, this.encryptedUnsigned)));
        string2 = Base64.getMimeEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
        try {
            defaultSAMLv2Service.parseResponse(string2, true, KeySelector.singletonKeySelector(this.signingKeyPair.getPublic()), false, this.encryptionKeyPair.getPrivate());
            Assert.fail((String)"Expected SignatureNotFoundException");
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            Assert.assertEquals((String)signatureNotFoundException.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is missing from the XML but is required.");
        }
    }

    @Test
    public void parseResponse_requireEncryptedAssertion_unencrypted() throws Exception {
        byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String string = new String(byArray, StandardCharsets.UTF_8);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string, false, null, true, null);
        Assert.assertTrue((boolean)authenticationResponse.assertions.isEmpty());
    }

    @Test
    public void parseResponse_signatureCheck_badSignature() throws Exception {
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        String string = this.baseXml.replace("${assertions}", this.assertionSigned);
        String string2 = Base64.getMimeEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
        try {
            defaultSAMLv2Service.parseResponse(string2, true, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()));
            Assert.fail((String)"Expected SAMLException");
        }
        catch (SAMLException sAMLException) {
            Assert.assertEquals((String)sAMLException.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is invalid.");
        }
        string = this.baseXml.replace("${assertions}", this.encryptedSigned);
        string2 = Base64.getMimeEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
        try {
            defaultSAMLv2Service.parseResponse(string2, true, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()), true, this.encryptionKeyPair.getPrivate());
            Assert.fail((String)"Expected SAMLException");
        }
        catch (SAMLException sAMLException) {
            Assert.assertEquals((String)sAMLException.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is invalid.");
        }
        string = this.baseXml.replace("${assertions}", this.assertionUnsigned);
        string2 = Base64.getMimeEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string2, false, null);
        string2 = defaultSAMLv2Service.buildAuthnResponse(authenticationResponse, true, this.signingKeyPair.getPrivate(), CertificateTools.fromKeyPair(this.signingKeyPair, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Response, false);
        try {
            defaultSAMLv2Service.parseResponse(string2, true, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()));
            Assert.fail((String)"Expected SAMLException");
        }
        catch (SAMLException sAMLException) {
            Assert.assertEquals((String)sAMLException.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is invalid.");
        }
    }

    @Test
    public void parseResponse_signatureCheck_missing() throws Exception {
        PublicKey publicKey;
        Object object;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try (Object object2 = Files.newInputStream(Paths.get("src/test/certificates/certificate.cer", new String[0]), new OpenOption[0]);){
            object = certificateFactory.generateCertificate((InputStream)object2);
            publicKey = ((Certificate)object).getPublicKey();
        }
        object2 = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse-signatureRemoved.txt", new String[0]));
        object = new String((byte[])object2);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        try {
            defaultSAMLv2Service.parseResponse((String)object, true, KeySelector.singletonKeySelector(publicKey));
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (SAMLException sAMLException) {
            Assert.assertEquals((String)sAMLException.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is missing from the XML but is required.");
        }
    }

    @Test
    public void parseResponse_signatureCheck_missingEncrypted() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String string = new String(byArray, StandardCharsets.UTF_8);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string, false, null);
        String string2 = defaultSAMLv2Service.buildAuthnResponse(authenticationResponse, false, null, null, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Response, false, true, EncryptionAlgorithm.AES128GCM, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, CertificateTools.fromKeyPair(keyPair, Algorithm.RS256, "FooBar"), DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1);
        try {
            defaultSAMLv2Service.parseResponse(string2, true, null, true, keyPair.getPrivate());
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (SAMLException sAMLException) {
            Assert.assertEquals((String)sAMLException.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is missing from the XML but is required.");
        }
    }

    @Test(dataProvider="bindings")
    public void parse_LogoutRequest(Binding binding) throws Exception {
        X509Certificate x509Certificate;
        Object object;
        byte[] byArray = binding == Binding.HTTP_Redirect ? Files.readAllBytes(Paths.get("src/test/xml/logout-request.xml", new String[0])) : Files.readAllBytes(Paths.get("src/test/xml/logout-request-embedded-signature.xml", new String[0]));
        String string = binding == Binding.HTTP_Redirect ? SAMLTools.deflateAndEncode((byte[])byArray) : SAMLTools.encode((byte[])byArray);
        String string2 = Files.readString(Paths.get("src/test/xml/signature/logout-request.txt", new String[0]));
        String string3 = "MIICajCCAdOgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBSMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lbG9naW4gSW5jMRcwFQYDVQQDDA5zcC5leGFtcGxlLmNvbTAeFw0xNDA3MTcxNDEyNTZaFw0xNTA3MTcxNDEyNTZaMFIxCzAJBgNVBAYTAnVzMRMwEQYDVQQIDApDYWxpZm9ybmlhMRUwEwYDVQQKDAxPbmVsb2dpbiBJbmMxFzAVBgNVBAMMDnNwLmV4YW1wbGUuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDZx+ON4IUoIWxgukTb1tOiX3bMYzYQiwWPUNMp+Fq82xoNogso2bykZG0yiJm5o8zv/sd6pGouayMgkx/2FSOdc36T0jGbCHuRSbtia0PEzNIRtmViMrt3AeoWBidRXmZsxCNLwgIV6dn2WpuE5Az0bHgpZnQxTKFek0BMKU/d8wIDAQABo1AwTjAdBgNVHQ4EFgQUGHxYqZYyX7cTxKVODVgZwSTdCnwwHwYDVR0jBBgwFoAUGHxYqZYyX7cTxKVODVgZwSTdCnwwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQ0FAAOBgQByFOl+hMFICbd3DJfnp2Rgd/dqttsZG/tyhILWvErbio/DEe98mXpowhTkC04ENprOyXi7ZbUqiicF89uAGyt1oqgTUCD1VsLahqIcmrzgumNyTwLGWo17WDAa1/usDhetWAMhgzF/Cnf5ek0nK00m0YZGyc4LzgD0CROMASTWNg==";
        try (Object object2 = new ByteArrayInputStream(Base64.getMimeDecoder().decode(string3));){
            object = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)((CertificateFactory)object).generateCertificate((InputStream)object2);
        }
        Assert.assertNotNull((Object)x509Certificate);
        object2 = x509Certificate.getPublicKey();
        object = "SAMLRequest=" + URLEncoder.encode(string, StandardCharsets.UTF_8) + "&RelayState=" + URLEncoder.encode("http://sp.example.com/relaystate", StandardCharsets.UTF_8) + "&SigAlg=" + URLEncoder.encode(Algorithm.RS1.uri, StandardCharsets.UTF_8) + "&Signature=" + URLEncoder.encode(string2, StandardCharsets.UTF_8);
        boolean bl = false;
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        LogoutRequest logoutRequest = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.parseLogoutRequestRedirectBinding((String)object, arg_0 -> DefaultSAMLv2ServiceTest.lambda$parse_LogoutRequest$21((PublicKey)object2, bl, arg_0)) : defaultSAMLv2Service.parseLogoutRequestPostBinding(string, arg_0 -> DefaultSAMLv2ServiceTest.lambda$parse_LogoutRequest$22((PublicKey)object2, bl, arg_0));
        Assert.assertEquals((String)logoutRequest.id, (String)(binding == Binding.HTTP_Redirect ? "ONELOGIN_21df91a89767879fc0f7df6a1490c6000c81644d" : "pfxd4d369e8-9ea1-780c-aff8-a1d11a9862a1"));
        Assert.assertEquals((String)logoutRequest.issuer, (String)"http://sp.example.com/demo1/metadata.php");
        Assert.assertEquals((String)logoutRequest.nameIdFormat, (String)NameIDFormat.Transient.toSAMLFormat());
        Assert.assertEquals((String)logoutRequest.version, (String)"2.0");
        String string4 = new String(byArray, StandardCharsets.UTF_8);
        Assert.assertEquals((String)logoutRequest.xml.replace("\r\n", "\n"), (String)string4.replace("\r\n", "\n"));
    }

    @Test(dataProvider="bindings")
    public void parse_LogoutResponse(Binding binding) throws Exception {
        X509Certificate x509Certificate;
        Object object;
        byte[] byArray = binding == Binding.HTTP_Redirect ? Files.readAllBytes(Paths.get("src/test/xml/logout-response.xml", new String[0])) : Files.readAllBytes(Paths.get("src/test/xml/logout-response-embedded-signature.xml", new String[0]));
        String string = binding == Binding.HTTP_Redirect ? SAMLTools.deflateAndEncode((byte[])byArray) : SAMLTools.encode((byte[])byArray);
        String string2 = Files.readString(Paths.get("src/test/xml/signature/logout-response.txt", new String[0]));
        String string3 = "MIICajCCAdOgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBSMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lbG9naW4gSW5jMRcwFQYDVQQDDA5zcC5leGFtcGxlLmNvbTAeFw0xNDA3MTcxNDEyNTZaFw0xNTA3MTcxNDEyNTZaMFIxCzAJBgNVBAYTAnVzMRMwEQYDVQQIDApDYWxpZm9ybmlhMRUwEwYDVQQKDAxPbmVsb2dpbiBJbmMxFzAVBgNVBAMMDnNwLmV4YW1wbGUuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDZx+ON4IUoIWxgukTb1tOiX3bMYzYQiwWPUNMp+Fq82xoNogso2bykZG0yiJm5o8zv/sd6pGouayMgkx/2FSOdc36T0jGbCHuRSbtia0PEzNIRtmViMrt3AeoWBidRXmZsxCNLwgIV6dn2WpuE5Az0bHgpZnQxTKFek0BMKU/d8wIDAQABo1AwTjAdBgNVHQ4EFgQUGHxYqZYyX7cTxKVODVgZwSTdCnwwHwYDVR0jBBgwFoAUGHxYqZYyX7cTxKVODVgZwSTdCnwwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQ0FAAOBgQByFOl+hMFICbd3DJfnp2Rgd/dqttsZG/tyhILWvErbio/DEe98mXpowhTkC04ENprOyXi7ZbUqiicF89uAGyt1oqgTUCD1VsLahqIcmrzgumNyTwLGWo17WDAa1/usDhetWAMhgzF/Cnf5ek0nK00m0YZGyc4LzgD0CROMASTWNg==";
        try (Object object2 = new ByteArrayInputStream(Base64.getMimeDecoder().decode(string3));){
            object = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)((CertificateFactory)object).generateCertificate((InputStream)object2);
        }
        Assert.assertNotNull((Object)x509Certificate);
        object2 = x509Certificate.getPublicKey();
        object = "SAMLRequest=" + URLEncoder.encode(string, StandardCharsets.UTF_8) + "&RelayState=" + URLEncoder.encode("http://sp.example.com/relaystate", StandardCharsets.UTF_8) + "&SigAlg=" + URLEncoder.encode(Algorithm.RS1.uri, StandardCharsets.UTF_8) + "&Signature=" + URLEncoder.encode(string2, StandardCharsets.UTF_8);
        boolean bl = false;
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        LogoutResponse logoutResponse = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.parseLogoutResponseRedirectBinding((String)object, arg_0 -> DefaultSAMLv2ServiceTest.lambda$parse_LogoutResponse$23((PublicKey)object2, bl, arg_0)) : defaultSAMLv2Service.parseLogoutResponsePostBinding(string, arg_0 -> DefaultSAMLv2ServiceTest.lambda$parse_LogoutResponse$24((PublicKey)object2, bl, arg_0));
        Assert.assertEquals((String)logoutResponse.id, (String)(binding == Binding.HTTP_Redirect ? "_6c3737282f007720e736f0f4028feed8cb9b40291c" : "pfxe335499f-e73b-80bd-60c4-1628984aed4f"));
        Assert.assertEquals((String)logoutResponse.issuer, (String)"http://idp.example.com/metadata.php");
        Assert.assertEquals((String)logoutResponse.version, (String)"2.0");
        Assert.assertNull((Object)logoutResponse.inResponseTo);
        Assert.assertNull((Object)logoutResponse.sessionIndex);
        String string4 = new String(byArray, StandardCharsets.UTF_8);
        Assert.assertEquals((String)logoutResponse.xml.replace("\r\n", "\n"), (String)string4.replace("\r\n", "\n"));
    }

    @Test(dataProvider="bindings")
    public void roundTripAuthnRequest(Binding binding) throws Exception {
        String string;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        AuthenticationRequest authenticationRequest2 = new AuthenticationRequest();
        authenticationRequest2.id = "foobarbaz";
        authenticationRequest2.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        if (binding == Binding.HTTP_Redirect) {
            string = defaultSAMLv2Service.buildRedirectAuthnRequest(authenticationRequest2, "Relay-State-String", true, keyPair.getPrivate(), Algorithm.RS256);
        } else {
            X509Certificate x509Certificate = this.generateX509Certificate(keyPair, "SHA256withRSA");
            string = defaultSAMLv2Service.buildPostAuthnRequest(authenticationRequest2, true, keyPair.getPrivate(), x509Certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        }
        authenticationRequest2 = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.parseRequestRedirectBinding(string, authenticationRequest -> new TestRedirectBindingSignatureHelper(keyPair.getPublic(), true)) : defaultSAMLv2Service.parseRequestPostBinding(string, authenticationRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(keyPair.getPublic()), true));
        Assert.assertEquals((String)authenticationRequest2.id, (String)"foobarbaz");
        Assert.assertEquals((String)authenticationRequest2.issuer, (String)"https://local.fusionauth.io");
        Assert.assertEquals((String)authenticationRequest2.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)authenticationRequest2.version, (String)"2.0");
    }

    @Test(dataProvider="bindings")
    public void roundTripAuthnRequest_ECDSA(Binding binding) throws Exception {
        String string;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        keyPairGenerator.initialize(256);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        AuthenticationRequest authenticationRequest2 = new AuthenticationRequest();
        authenticationRequest2.id = "foobarbaz";
        authenticationRequest2.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        if (binding == Binding.HTTP_Redirect) {
            string = defaultSAMLv2Service.buildRedirectAuthnRequest(authenticationRequest2, "Relay-State-String", true, keyPair.getPrivate(), Algorithm.ES256);
        } else {
            X509Certificate x509Certificate = this.generateX509Certificate(keyPair, "SHA256withECDSA");
            string = defaultSAMLv2Service.buildPostAuthnRequest(authenticationRequest2, true, keyPair.getPrivate(), x509Certificate, Algorithm.ES256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        }
        authenticationRequest2 = binding == Binding.HTTP_Redirect ? defaultSAMLv2Service.parseRequestRedirectBinding(string, authenticationRequest -> new TestRedirectBindingSignatureHelper(keyPair.getPublic(), true)) : defaultSAMLv2Service.parseRequestPostBinding(string, authenticationRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(keyPair.getPublic()), true));
        Assert.assertEquals((String)authenticationRequest2.id, (String)"foobarbaz");
        Assert.assertEquals((String)authenticationRequest2.issuer, (String)"https://local.fusionauth.io");
        Assert.assertEquals((String)authenticationRequest2.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)authenticationRequest2.version, (String)"2.0");
    }

    @Test(dataProvider="assertionEncryption")
    public void roundTripResponseEncryptedAssertion(EncryptionAlgorithm encryptionAlgorithm, KeyLocation keyLocation, KeyTransportAlgorithm keyTransportAlgorithm, DigestAlgorithm digestAlgorithm, MaskGenerationFunction maskGenerationFunction) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
        byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String string = new String(byArray, StandardCharsets.UTF_8);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string, false, null);
        String string2 = defaultSAMLv2Service.buildAuthnResponse(authenticationResponse, true, keyPair.getPrivate(), CertificateTools.fromKeyPair(keyPair, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Response, true, true, encryptionAlgorithm, keyLocation, keyTransportAlgorithm, CertificateTools.fromKeyPair(keyPair2, Algorithm.RS256, "FooBar"), digestAlgorithm, maskGenerationFunction);
        AuthenticationResponse authenticationResponse2 = defaultSAMLv2Service.parseResponse(string2, true, KeySelector.singletonKeySelector(keyPair.getPublic()), true, keyPair2.getPrivate());
        Assert.assertEquals((Object)authenticationResponse2, (Object)authenticationResponse);
        string2 = defaultSAMLv2Service.buildAuthnResponse(authenticationResponse, true, keyPair.getPrivate(), CertificateTools.fromKeyPair(keyPair, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Assertion, true, true, encryptionAlgorithm, keyLocation, keyTransportAlgorithm, CertificateTools.fromKeyPair(keyPair2, Algorithm.RS256, "FooBar"), digestAlgorithm, maskGenerationFunction);
        authenticationResponse2 = defaultSAMLv2Service.parseResponse(string2, true, KeySelector.singletonKeySelector(keyPair.getPublic()), true, keyPair2.getPrivate());
        Assert.assertEquals((Object)authenticationResponse2, (Object)authenticationResponse);
    }

    @Test(dataProvider="signatureLocation")
    public void roundTripResponseFailedRequestSignedAssertion(SignatureLocation signatureLocation, boolean bl) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse-authnFailed.txt", new String[0]));
        String string = new String(byArray);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string, false, null);
        String string2 = defaultSAMLv2Service.buildAuthnResponse(authenticationResponse, true, keyPair.getPrivate(), CertificateTools.fromKeyPair(keyPair, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", signatureLocation, bl);
        authenticationResponse = defaultSAMLv2Service.parseResponse(string2, true, (KeySelector)new TestKeySelector(keyPair.getPublic()));
        Document document = this.parseDocument(string2);
        Node node = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        Assert.assertEquals((String)node.getPreviousSibling().getLocalName(), (String)"Issuer");
        Assert.assertEquals((String)node.getNextSibling().getLocalName(), (String)"Status");
        Assert.assertEquals((String)node.getParentNode().getLocalName(), (String)"Response");
        Assert.assertEquals((String)authenticationResponse.destination, (String)"https://local.fusionauth.io/samlv2/acs");
        Assert.assertTrue((boolean)authenticationResponse.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((String)authenticationResponse.issuer, (String)"https://acme.com/saml/idp");
        Assert.assertEquals((Object)authenticationResponse.status.code, (Object)ResponseStatus.AuthenticationFailed);
    }

    @Test(dataProvider="signatureLocation")
    public void roundTripResponseSignedAssertion(SignatureLocation signatureLocation, boolean bl) throws Exception {
        ZonedDateTime zonedDateTime;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        byte[] byArray = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String string = new String(byArray);
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        AuthenticationResponse authenticationResponse = defaultSAMLv2Service.parseResponse(string, false, null);
        authenticationResponse.authnInstant = zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(1L);
        String string2 = defaultSAMLv2Service.buildAuthnResponse(authenticationResponse, true, keyPair.getPrivate(), CertificateTools.fromKeyPair(keyPair, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", signatureLocation, bl);
        authenticationResponse = defaultSAMLv2Service.parseResponse(string2, true, (KeySelector)new TestKeySelector(keyPair.getPublic()));
        Document document = this.parseDocument(string2);
        Node node = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        if (signatureLocation == SignatureLocation.Assertion) {
            Assert.assertEquals((String)node.getPreviousSibling().getLocalName(), (String)"Issuer");
            Assert.assertEquals((String)node.getNextSibling().getLocalName(), (String)"Subject");
            Assert.assertEquals((String)node.getParentNode().getLocalName(), (String)"Assertion");
        } else {
            Assert.assertEquals((String)node.getParentNode().getLocalName(), (String)"Response");
            Assert.assertEquals((String)node.getPreviousSibling().getLocalName(), (String)"Issuer");
        }
        Assert.assertEquals((Object)authenticationResponse.authnInstant, (Object)SAMLTools.toZonedDateTime((XMLGregorianCalendar)SAMLTools.toXMLGregorianCalendar((ZonedDateTime)zonedDateTime)));
        Assert.assertEquals((String)authenticationResponse.destination, (String)"https://local.fusionauth.io/oauth2/callback");
        Assert.assertTrue((boolean)authenticationResponse.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((String)authenticationResponse.issuer, (String)"https://sts.windows.net/c2150111-3c44-4508-9f08-790cb4032a23/");
        Assert.assertEquals((Object)authenticationResponse.status.code, (Object)ResponseStatus.Success);
        Assertion assertion = (Assertion)authenticationResponse.assertions.get(0);
        Assert.assertTrue((boolean)assertion.conditions.notBefore.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertTrue((boolean)ZonedDateTime.now(ZoneOffset.UTC).isAfter(assertion.conditions.notOnOrAfter));
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.microsoft.com/identity/claims/displayname")).get(0)), (String)"Brian Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname")).get(0)), (String)"Brian");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname")).get(0)), (String)"Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress")).get(0)), (String)"brian@inversoft.com");
        Assert.assertNotNull((Object)assertion.subject.nameIDs);
        Assert.assertEquals((int)assertion.subject.nameIDs.size(), (int)1);
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)0)).format, (String)NameIDFormat.EmailAddress.toSAMLFormat());
    }

    @DataProvider(name="signatureLocation")
    public Object[][] signatureLocation() {
        return new Object[][]{{SignatureLocation.Assertion, true}, {SignatureLocation.Assertion, false}, {SignatureLocation.Response, true}, {SignatureLocation.Response, false}};
    }

    @Test
    public void unmarshalPerformance() throws Exception {
        String string = SAMLTools.encode((byte[])Files.readAllBytes(Paths.get("src/test/xml/authn-request-control.xml", new String[0])));
        DefaultSAMLv2Service defaultSAMLv2Service = new DefaultSAMLv2Service();
        long l = 5000L;
        long l2 = System.currentTimeMillis();
        int n = 0;
        while ((long)n < l) {
            defaultSAMLv2Service.parseRequestPostBinding(string, authenticationRequest -> new TestPostBindingSignatureHelper());
            ++n;
        }
        long l3 = System.currentTimeMillis() - l2;
        double d = l3 / l;
        Assert.assertTrue((d < 1.0 ? 1 : 0) != 0, (String)("Not fast enough!\nIterations: " + l + ", total time: " + l3 + " ms, avg: " + d + " ms\n"));
    }

    @Test
    public void variousURLEncoding_SignatureVerification() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        AuthenticationRequest authenticationRequest2 = new AuthenticationRequest();
        authenticationRequest2.id = "foobarbaz";
        authenticationRequest2.issuer = "https://local.fusionauth.io";
        MockDefaultSAMLv2Service mockDefaultSAMLv2Service = new MockDefaultSAMLv2Service();
        String string = mockDefaultSAMLv2Service.buildRedirectAuthnRequest(authenticationRequest2, "Relay-State-String", true, keyPair.getPrivate(), Algorithm.RS256);
        authenticationRequest2 = mockDefaultSAMLv2Service.parseRequestRedirectBinding(string, authenticationRequest -> new TestRedirectBindingSignatureHelper(keyPair.getPublic(), true));
        Assert.assertEquals((String)authenticationRequest2.id, (String)"foobarbaz");
        Assert.assertEquals((String)authenticationRequest2.issuer, (String)"https://local.fusionauth.io");
        Assert.assertEquals((String)authenticationRequest2.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)authenticationRequest2.version, (String)"2.0");
        mockDefaultSAMLv2Service.lowerCaseURLEncoding = true;
        string = mockDefaultSAMLv2Service.buildRedirectAuthnRequest(authenticationRequest2, "Relay-State-String", true, keyPair.getPrivate(), Algorithm.RS256);
        authenticationRequest2 = mockDefaultSAMLv2Service.parseRequestRedirectBinding(string, authenticationRequest -> new TestRedirectBindingSignatureHelper(keyPair.getPublic(), true));
        Assert.assertEquals((String)authenticationRequest2.id, (String)"foobarbaz");
        Assert.assertEquals((String)authenticationRequest2.issuer, (String)"https://local.fusionauth.io");
        Assert.assertEquals((String)authenticationRequest2.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)authenticationRequest2.version, (String)"2.0");
    }

    private X509Certificate generateX509Certificate(KeyPair keyPair, String string) throws IllegalArgumentException {
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC);
            X509CertInfo x509CertInfo = new X509CertInfo();
            CertificateX509Key certificateX509Key = new CertificateX509Key(keyPair.getPublic());
            x509CertInfo.set("key", certificateX509Key);
            x509CertInfo.set("version", new CertificateVersion(1));
            x509CertInfo.set("algorithmID", new CertificateAlgorithmId(new AlgorithmId(ObjectIdentifier.of(KnownOIDs.SHA256withRSA))));
            x509CertInfo.set("issuer", new X500Name("CN=FusionAuth"));
            x509CertInfo.set("subject", new X500Name("CN=FusionAuth"));
            x509CertInfo.set("validity", new CertificateValidity(Date.from(zonedDateTime.toInstant()), Date.from(zonedDateTime.plusYears(10L).toInstant())));
            x509CertInfo.set("serialNumber", new CertificateSerialNumber(new BigInteger(UUID.randomUUID().toString().replace("-", ""), 16)));
            X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
            x509CertImpl.sign(keyPair.getPrivate(), string);
            return x509CertImpl;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    private void loadAssertionTemplates() throws IOException {
        this.baseXml = Files.readString(Paths.get("src/test/xml/assertion/response-template.xml.txt", new String[0]));
        this.assertionSigned = Files.readString(Paths.get("src/test/xml/assertion/assertion-signed.xml.txt", new String[0]));
        this.assertionUnsigned = Files.readString(Paths.get("src/test/xml/assertion/assertion-unsigned.xml.txt", new String[0]));
        this.encryptedSigned = Files.readString(Paths.get("src/test/xml/assertion/encrypted-signed.xml.txt", new String[0]));
        this.encryptedUnsigned = Files.readString(Paths.get("src/test/xml/assertion/encrypted-unsigned.xml.txt", new String[0]));
    }

    private void loadKeys() throws Exception {
        try (InputStream inputStream = Files.newInputStream(Paths.get("src/test/certificates/signature-certificate.pem", new String[0]), new OpenOption[0]);
             InputStream inputStream2 = Files.newInputStream(Paths.get("src/test/certificates/signature-private-pkcs8.der", new String[0]), new OpenOption[0]);
             InputStream inputStream3 = Files.newInputStream(Paths.get("src/test/certificates/encryption-certificate.pem", new String[0]), new OpenOption[0]);
             InputStream inputStream4 = Files.newInputStream(Paths.get("src/test/certificates/encryption-private-pkcs8.der", new String[0]), new OpenOption[0]);){
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(inputStream2.readAllBytes());
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(inputStream);
            this.signingKeyPair = new KeyPair(certificate.getPublicKey(), privateKey);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec2 = new PKCS8EncodedKeySpec(inputStream4.readAllBytes());
            PrivateKey privateKey2 = keyFactory.generatePrivate(pKCS8EncodedKeySpec2);
            certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate2 = certificateFactory.generateCertificate(inputStream3);
            this.encryptionKeyPair = new KeyPair(certificate2.getPublicKey(), privateKey2);
        }
    }

    private Document parseDocument(String string) throws ParserConfigurationException {
        byte[] byArray = Base64.getMimeDecoder().decode(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(new ByteArrayInputStream(byArray));
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static /* synthetic */ SAMLv2Service.PostBindingSignatureHelper lambda$parse_LogoutResponse$24(PublicKey publicKey, boolean bl, LogoutResponse logoutResponse) {
        return new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), bl);
    }

    private static /* synthetic */ SAMLv2Service.RedirectBindingSignatureHelper lambda$parse_LogoutResponse$23(PublicKey publicKey, boolean bl, LogoutResponse logoutResponse) {
        return new TestRedirectBindingSignatureHelper(publicKey, bl);
    }

    private static /* synthetic */ SAMLv2Service.PostBindingSignatureHelper lambda$parse_LogoutRequest$22(PublicKey publicKey, boolean bl, LogoutRequest logoutRequest) {
        return new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), bl);
    }

    private static /* synthetic */ SAMLv2Service.RedirectBindingSignatureHelper lambda$parse_LogoutRequest$21(PublicKey publicKey, boolean bl, LogoutRequest logoutRequest) {
        return new TestRedirectBindingSignatureHelper(publicKey, bl);
    }

    private static /* synthetic */ SAMLv2Service.PostBindingSignatureHelper lambda$parseLogout_Request_raw$5(PublicKey publicKey, boolean bl, LogoutRequest logoutRequest) {
        return new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), bl);
    }

    private static /* synthetic */ SAMLv2Service.RedirectBindingSignatureHelper lambda$parseLogout_Request_raw$4(PublicKey publicKey, boolean bl, LogoutRequest logoutRequest) {
        return new TestRedirectBindingSignatureHelper(publicKey, bl);
    }

    private static class MockDefaultSAMLv2Service
    extends DefaultSAMLv2Service {
        public boolean lowerCaseURLEncoding = false;

        private MockDefaultSAMLv2Service() {
        }

        protected String urlEncode(String string) {
            if (this.lowerCaseURLEncoding) {
                return URLEncoder.encode(string, StandardCharsets.UTF_8).replace("%2B", "%2b").replace("%2F", "%2f").replace("%3A", "%3a").replace("%3D", "%3d");
            }
            return super.urlEncode(string);
        }
    }
}

