/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.util;

import io.fusionauth.samlv2.domain.NameID;
import io.fusionauth.samlv2.domain.SAMLException;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.NameIDType;
import io.fusionauth.samlv2.domain.jaxb.oasis.metadata.KeyDescriptorType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmldsig.X509DataType;
import io.fusionauth.samlv2.util.SAMLRequestParameters;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class SAMLTools {
    private static final Map<String, Boolean> FactoryFeatures = new HashMap<String, Boolean>();
    private static final Map<Class<?>, Unmarshaller> UnmarshallerCache = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(SAMLTools.class);

    public static String attributeToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Element) {
            return ((Element)object).getTextContent();
        }
        logger.warn("This library currently doesn't handle attributes of type [" + object.getClass() + "]");
        return null;
    }

    public static ZonedDateTime convertToZonedDateTime(XMLGregorianCalendar xMLGregorianCalendar) {
        return xMLGregorianCalendar != null ? xMLGregorianCalendar.toGregorianCalendar().toZonedDateTime() : null;
    }

    public static byte[] decode(String string) {
        return Base64.getMimeDecoder().decode(string);
    }

    public static byte[] decodeAndInflate(String string) throws SAMLException {
        byte[] byArray = Base64.getMimeDecoder().decode(string);
        Inflater inflater = new Inflater(true);
        inflater.setInput(byArray);
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while (inflater.getRemaining() > 0 && (n = inflater.inflate(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (DataFormatException dataFormatException) {
            throw new SAMLException("Invalid AuthnRequest. Inflating the bytes failed.", dataFormatException);
        }
    }

    public static String decodeToString(String string) {
        return new String(Base64.getMimeDecoder().decode(string), StandardCharsets.UTF_8);
    }

    public static String deflateAndEncode(byte[] byArray) {
        Deflater deflater = new Deflater(8, true);
        deflater.setInput(byArray);
        deflater.finish();
        byte[] byArray2 = new byte[byArray.length];
        int n = deflater.deflate(byArray2);
        deflater.end();
        byte[] byArray3 = Arrays.copyOf(byArray2, n);
        return new String(Base64.getEncoder().encode(byArray3), StandardCharsets.UTF_8);
    }

    public static String encode(byte[] byArray) {
        return new String(Base64.getEncoder().encode(byArray), StandardCharsets.UTF_8);
    }

    public static <T> byte[] marshallToBytes(JAXBElement<T> jAXBElement, Class<T> clazz) throws SAMLException {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller marshaller = jAXBContext.createMarshaller();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            marshaller.marshal(jAXBElement, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (JAXBException jAXBException) {
            throw new SAMLException("Unable to marshallRequest JAXB SAML object to bytes.", jAXBException);
        }
    }

    public static <T> Document marshallToDocument(JAXBElement<T> jAXBElement, Class<T> clazz) throws SAMLException {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller marshaller = jAXBContext.createMarshaller();
            Document document = SAMLTools.newDocumentBuilder().newDocument();
            marshaller.marshal(jAXBElement, (Node)document);
            return document;
        }
        catch (SAMLException | JAXBException throwable) {
            throw new SAMLException("Unable to marshallRequest JAXB SAML object to DOM.", throwable);
        }
    }

    public static String marshallToString(Document document) throws TransformerException {
        return SAMLTools.marshallNodeToString(document, false);
    }

    public static String marshallToString(Element element) throws TransformerException {
        return SAMLTools.marshallNodeToString(element, true);
    }

    public static DocumentBuilder newDocumentBuilder() throws SAMLException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            for (String string : FactoryFeatures.keySet()) {
                try {
                    documentBuilderFactory.setFeature(string, FactoryFeatures.get(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.debug("Failed to set feature [" + string + "=" + FactoryFeatures.get(string) + "]. This may be expected if the parser does not recognize this feature.", (Throwable)illegalArgumentException);
                }
            }
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAMLException("Unable to configure the DocumentBuilderFactory with feature [http://javax.xml.XMLConstants/feature/secure-processing].", parserConfigurationException);
        }
    }

    public static Document newDocumentFromBytes(byte[] byArray) throws SAMLException {
        try {
            return SAMLTools.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (IOException | SAXException exception) {
            throw new SAMLException("Unable to parse SAML v2.0 document.", exception);
        }
    }

    public static NameID parseNameId(NameIDType nameIDType) {
        NameID nameID = new NameID();
        nameID.format = nameIDType.getFormat();
        nameID.id = nameIDType.getValue();
        return nameID;
    }

    public static SAMLRequestParameters parseQueryString(String string) {
        String[] stringArray;
        SAMLRequestParameters sAMLRequestParameters = new SAMLRequestParameters();
        if (string == null) {
            return sAMLRequestParameters;
        }
        block12: for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length != 2) continue;
            switch (stringArray2[0]) {
                case "RelayState": {
                    sAMLRequestParameters.RelayState = stringArray2[1];
                    continue block12;
                }
                case "SAMLRequest": {
                    sAMLRequestParameters.SAMLRequest = stringArray2[1];
                    continue block12;
                }
                case "SigAlg": {
                    sAMLRequestParameters.SigAlg = stringArray2[1];
                    continue block12;
                }
                case "Signature": {
                    sAMLRequestParameters.Signature = stringArray2[1];
                }
            }
        }
        return sAMLRequestParameters;
    }

    public static Certificate toCertificate(KeyDescriptorType keyDescriptorType) {
        try {
            List<Object> list = keyDescriptorType.getKeyInfo().getContent();
            for (Object object : list) {
                JAXBElement jAXBElement;
                if (!(object instanceof JAXBElement) || (jAXBElement = (JAXBElement)object).getDeclaredType() != X509DataType.class) continue;
                X509DataType x509DataType = (X509DataType)jAXBElement.getValue();
                List<Object> list2 = x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName();
                for (Object object2 : list2) {
                    jAXBElement = (JAXBElement)object2;
                    if (!jAXBElement.getName().getLocalPart().equals("X509Certificate")) continue;
                    byte[] byArray = (byte[])jAXBElement.getValue();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    return certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                }
            }
            return null;
        }
        catch (CertificateException certificateException) {
            throw new IllegalArgumentException(certificateException);
        }
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(ZonedDateTime zonedDateTime) throws SAMLException {
        if (zonedDateTime == null) {
            return null;
        }
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(GregorianCalendar.from(zonedDateTime));
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new SAMLException("Unable to initiate DataTypeFactor.", datatypeConfigurationException);
        }
    }

    public static ZonedDateTime toZonedDateTime(XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar == null) {
            return null;
        }
        return xMLGregorianCalendar.toGregorianCalendar().toZonedDateTime();
    }

    public static <T> T unmarshallFromDocument(Document document, Class<T> clazz) throws SAMLException {
        try {
            Unmarshaller unmarshaller = SAMLTools.getUnmarshaller(clazz);
            JAXBElement jAXBElement = unmarshaller.unmarshal((Node)document, clazz);
            return (T)jAXBElement.getValue();
        }
        catch (JAXBException jAXBException) {
            throw new SAMLException("Unable to unmarshall SAML response", jAXBException);
        }
    }

    public static boolean validate(Document document, URL uRL, SchemaValidationErrors schemaValidationErrors) throws SAMLException {
        Schema schema;
        Object object;
        try {
            object = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ((SchemaFactory)object).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            schema = ((SchemaFactory)object).newSchema(uRL);
        }
        catch (SAXException sAXException) {
            throw new SAMLException("An invalid schema was requested. Schema [" + uRL + "].", sAXException);
        }
        object = schema.newValidator();
        ((Validator)object).setErrorHandler(schemaValidationErrors);
        try {
            ((Validator)object).setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        try {
            ((Validator)object).setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        DOMSource dOMSource = new DOMSource(document);
        try {
            ((Validator)object).validate(dOMSource);
        }
        catch (IOException | SAXException exception) {
            throw new SAMLException("Failed to validate the document source.", exception);
        }
        return schemaValidationErrors.error.isEmpty() && schemaValidationErrors.fatal.isEmpty() && schemaValidationErrors.warning.isEmpty();
    }

    private static <T> Unmarshaller getUnmarshaller(Class<T> clazz) throws SAMLException {
        Unmarshaller unmarshaller = UnmarshallerCache.get(clazz);
        if (unmarshaller == null) {
            try {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                unmarshaller = jAXBContext.createUnmarshaller();
            }
            catch (Exception exception) {
                throw new SAMLException(exception.getCause());
            }
            UnmarshallerCache.put(clazz, unmarshaller);
        }
        return unmarshaller;
    }

    private static String marshallNodeToString(Node node, boolean bl) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", bl ? "yes" : "no");
        transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    static {
        FactoryFeatures.put("http://apache.org/xml/features/disallow-doctype-decl", true);
        FactoryFeatures.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        FactoryFeatures.put("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        FactoryFeatures.put("http://xml.org/sax/features/external-general-entities", false);
        FactoryFeatures.put("http://xml.org/sax/features/external-parameter-entities", false);
    }

    public static class SchemaValidationErrors
    implements ErrorHandler {
        public final List<SAXParseException> error = new ArrayList<SAXParseException>();
        public final List<SAXParseException> fatal = new ArrayList<SAXParseException>();
        public final List<SAXParseException> warning = new ArrayList<SAXParseException>();

        @Override
        public void error(SAXParseException sAXParseException) {
            this.error.add(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            this.fatal.add(sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            this.warning.add(sAXParseException);
        }
    }
}

