/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.domain;

public enum ConfirmationMethod {
    Bearer("urn:oasis:names:tc:SAML:2.0:cm:bearer"),
    HolderOfKey("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key"),
    SenderVouches("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");

    private final String samlFormat;

    private ConfirmationMethod(String string2) {
        this.samlFormat = string2;
    }

    public static ConfirmationMethod fromSAMLFormat(String string) {
        if (string == null) {
            return null;
        }
        for (ConfirmationMethod confirmationMethod : ConfirmationMethod.values()) {
            if (!confirmationMethod.toSAMLFormat().equals(string)) continue;
            return confirmationMethod;
        }
        throw new IllegalArgumentException("Invalid SAML v2.0 confirmation method [" + string + "]");
    }

    public String toSAMLFormat() {
        return this.samlFormat;
    }
}

