/*
 * Copyright (c) 2019-2025, Inversoft Inc., All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package io.fusionauth.samlv2.domain;

import java.util.Objects;

public class NameID {
  public String format;

  public String id;

  public NameID() {

  }

  public NameID(NameID other) {
    this.format = other.format;
    this.id = other.id;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NameID nameID = (NameID) o;
    return Objects.equals(format, nameID.format) &&
        Objects.equals(id, nameID.id);
  }

  @Override
  public int hashCode() {
    return Objects.hash(format, id);
  }
}
