/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.service;

import io.fusionauth.samlv2.domain.Algorithm;
import io.fusionauth.samlv2.domain.Assertion;
import io.fusionauth.samlv2.domain.AuthenticationRequest;
import io.fusionauth.samlv2.domain.AuthenticationResponse;
import io.fusionauth.samlv2.domain.Binding;
import io.fusionauth.samlv2.domain.DigestAlgorithm;
import io.fusionauth.samlv2.domain.EncryptionAlgorithm;
import io.fusionauth.samlv2.domain.KeyLocation;
import io.fusionauth.samlv2.domain.KeyTransportAlgorithm;
import io.fusionauth.samlv2.domain.LogoutRequest;
import io.fusionauth.samlv2.domain.LogoutResponse;
import io.fusionauth.samlv2.domain.MaskGenerationFunction;
import io.fusionauth.samlv2.domain.MetaData;
import io.fusionauth.samlv2.domain.NameID;
import io.fusionauth.samlv2.domain.NameIDFormat;
import io.fusionauth.samlv2.domain.ResponseStatus;
import io.fusionauth.samlv2.domain.SAMLException;
import io.fusionauth.samlv2.domain.SignatureLocation;
import io.fusionauth.samlv2.domain.SignatureNotFoundException;
import io.fusionauth.samlv2.domain.Status;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.AuthnRequestType;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.LogoutRequestType;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.StatusResponseType;
import io.fusionauth.samlv2.service.CertificateTools;
import io.fusionauth.samlv2.service.DefaultSAMLv2Service;
import io.fusionauth.samlv2.service.TestKeySelector;
import io.fusionauth.samlv2.service.TestPostBindingSignatureHelper;
import io.fusionauth.samlv2.service.TestRedirectBindingSignatureHelper;
import io.fusionauth.samlv2.util.SAMLTools;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.xml.crypto.KeySelector;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

@Test(groups={"unit"})
public class DefaultSAMLv2ServiceTest {
    private String assertionSigned;
    private String assertionUnsigned;
    private String baseXml;
    private String encryptedSigned;
    private String encryptedUnsigned;
    private KeyPair encryptionKeyPair;
    private KeyPair signingKeyPair;

    @DataProvider(name="BooleanTriState")
    public Object[][] BooleanTriState() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}, {null}};
    }

    @Test
    public void assertionDecryptionDefaults() throws Exception {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = factory.generatePrivate(new RSAPrivateKeySpec(new BigInteger("21734648244307152755738902242704624429675455693104061482953980655823499524284217582577935962219675181839097134429878676848067944269649003417313253763145613039845156858929146350893510281417425701635390227843218753386852942958087790126591910892081707753005524949329857277363222746280909051526362184081185954039703446436022345307092346517413518280909483768946131477611274390374625720745000173012484689181319542884541163003470909355448313533318136237678943263133529991715284549440616270148923866161198748312992261382455526114770464413102345807150728423473869759031086596301998397561122681012070445972165920288084712186321"), new BigInteger("2627246950446332058699110175423135552922607992443510918533979809198372876869242896214083780043399404771798030104421912476774863886112568550161826087731198353627009668377202151330979270479101063648863411278727725778272563805391938498601722966981572071033305898173415465329072899217806147766785803779409419532480730005663347830294097525463269173509836986107754922630483079886942638729284878709865541937468056706189367357847138095922090696226255189351459450052835991176393120796259048519702721129794393046985282164398590601866202429118551867608688177161937729422431790107723304390299253182892873596285122556471119338537")));
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse-assertionDecryptionDefaults.txt", new String[0]));
        String encodedXML = new String(ba, StandardCharsets.UTF_8);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse parsedResponse = service.parseResponse(encodedXML, false, null, true, privateKey);
        ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String encodedResponse = new String(ba, StandardCharsets.UTF_8);
        AuthenticationResponse response = service.parseResponse(encodedResponse, false, null);
        ((Assertion)parsedResponse.assertions.get((int)0)).id = ((Assertion)response.assertions.get((int)0)).id;
        parsedResponse.authnInstant = response.authnInstant;
        Assert.assertEquals((Object)parsedResponse, (Object)response);
    }

    @DataProvider(name="assertionEncryption")
    public Object[][] assertionEncryption() {
        return new Object[][]{{EncryptionAlgorithm.AES128, KeyLocation.Child, KeyTransportAlgorithm.RSAv15, DigestAlgorithm.SHA256, null}, {EncryptionAlgorithm.AES128, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP_MGF1P, DigestAlgorithm.SHA256, null}, {EncryptionAlgorithm.AES128, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES128, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA512, MaskGenerationFunction.MGF1_SHA256}, {EncryptionAlgorithm.AES192, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES256, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES256, KeyLocation.Sibling, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES128GCM, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES192GCM, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.AES256GCM, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}, {EncryptionAlgorithm.TripleDES, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1}};
    }

    @Test
    public void authnInstant() throws Exception {
        ZonedDateTime expectedAuthnInstant;
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String encodedResponse = new String(ba);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(encodedResponse, false, null);
        response.authnInstant = expectedAuthnInstant = ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(1L);
        String encodedXML = service.buildAuthnResponse(response, true, kp.getPrivate(), CertificateTools.fromKeyPair(kp, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Response, true);
        AuthenticationResponse builtResponse = service.parseResponse(encodedXML, true, (KeySelector)new TestKeySelector(kp.getPublic()));
        Assert.assertEquals((Object)builtResponse.status.code, (Object)ResponseStatus.Success);
        Assert.assertEquals((Object)builtResponse.authnInstant, (Object)SAMLTools.toZonedDateTime((XMLGregorianCalendar)SAMLTools.toXMLGregorianCalendar((ZonedDateTime)expectedAuthnInstant)));
        Assert.assertTrue((boolean)builtResponse.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        response.authnInstant = null;
        response.issueInstant = ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(2L);
        encodedXML = service.buildAuthnResponse(response, true, kp.getPrivate(), CertificateTools.fromKeyPair(kp, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Response, true);
        builtResponse = service.parseResponse(encodedXML, true, (KeySelector)new TestKeySelector(kp.getPublic()));
        Assert.assertEquals((Object)builtResponse.status.code, (Object)ResponseStatus.Success);
        Assert.assertEquals((Object)builtResponse.authnInstant, (Object)builtResponse.issueInstant);
        Assert.assertTrue((boolean)builtResponse.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
    }

    @BeforeClass
    public void beforeClass() throws Exception {
        System.setProperty("com.sun.org.apache.xml.internal.security.ignoreLineBreaks", "true");
        this.loadKeys();
        this.loadAssertionTemplates();
    }

    @DataProvider(name="bindings")
    public Object[][] bindings() {
        return new Object[][]{{Binding.HTTP_Redirect}, {Binding.HTTP_POST}};
    }

    @Test
    public void buildIdPMetaData() throws Exception {
        MetaData metaData = new MetaData();
        metaData.id = UUID.randomUUID().toString();
        metaData.entityId = "https://fusionauth.io/samlv2/" + metaData.id;
        metaData.idp = new MetaData.IDPMetaData();
        metaData.idp.wantAuthnRequestsSigned = true;
        metaData.idp.postBindingSignInEndpoints.add("https://fusionauth.io/samlv2/login/POST");
        metaData.idp.redirectBindingSignInEndpoints.add("https://fusionauth.io/samlv2/login/REDIRECT");
        metaData.idp.postBindingLogoutEndpoints.add("https://fusionauth.io/samlv2/logout/POST");
        metaData.idp.redirectBindingLogoutEndpoints.add("https://fusionauth.io/samlv2/logout/REDIRECT");
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        X509Certificate cert = CertificateTools.fromKeyPair(kp, Algorithm.RS256, "FusionAuth");
        metaData.idp.certificates.add(cert);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        String xml = service.buildMetadataResponse(metaData);
        Assert.assertTrue((boolean)xml.contains("_" + metaData.id));
        Assert.assertTrue((boolean)xml.contains(metaData.entityId));
        Assert.assertTrue((boolean)xml.contains((CharSequence)metaData.idp.postBindingSignInEndpoints.get(0)));
        Assert.assertTrue((boolean)xml.contains((CharSequence)metaData.idp.postBindingLogoutEndpoints.get(0)));
        Assert.assertTrue((boolean)xml.contains((CharSequence)metaData.idp.redirectBindingLogoutEndpoints.get(0)));
        Assert.assertTrue((boolean)xml.contains((CharSequence)metaData.idp.redirectBindingLogoutEndpoints.get(0)));
        Assert.assertTrue((boolean)xml.contains("<ns2:IDPSSODescriptor WantAuthnRequestsSigned=\"true\" protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">"));
        MetaData parsed = service.parseMetaData(xml);
        Assert.assertEquals((String)parsed.id, (String)("_" + metaData.id));
        Assert.assertEquals((String)parsed.entityId, (String)metaData.entityId);
        Assert.assertEquals((Collection)parsed.idp.postBindingSignInEndpoints, (Collection)metaData.idp.postBindingSignInEndpoints);
        Assert.assertEquals((Collection)parsed.idp.redirectBindingSignInEndpoints, (Collection)metaData.idp.redirectBindingSignInEndpoints);
        Assert.assertEquals((Collection)parsed.idp.postBindingLogoutEndpoints, (Collection)metaData.idp.postBindingLogoutEndpoints);
        Assert.assertEquals((Collection)parsed.idp.redirectBindingLogoutEndpoints, (Collection)metaData.idp.redirectBindingLogoutEndpoints);
        Assert.assertEquals((Collection)parsed.idp.certificates, (Collection)metaData.idp.certificates);
    }

    @Test(dataProvider="bindings")
    public void buildLogoutRequest(Binding binding) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        PrivateKey privateKey = kp.getPrivate();
        X509Certificate certificate = this.generateX509Certificate(kp, "SHA256withRSA");
        LogoutRequest logoutRequest = new LogoutRequest();
        logoutRequest.id = "_1245";
        logoutRequest.issuer = "https://acme.corp/saml";
        logoutRequest.sessionIndex = "42";
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        String rawRequest = binding == Binding.HTTP_Redirect ? service.buildRedirectLogoutRequest(logoutRequest, "Relay-State-String", true, privateKey, Algorithm.RS256) : service.buildPostLogoutRequest(logoutRequest, true, privateKey, certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)rawRequest);
        String samlRequest = rawRequest;
        if (binding == Binding.HTTP_Redirect) {
            int start = samlRequest.indexOf(61);
            int end = samlRequest.indexOf(38);
            samlRequest = samlRequest.substring(start + 1, end);
            samlRequest = URLDecoder.decode(samlRequest, StandardCharsets.UTF_8);
        }
        byte[] bytes = binding == Binding.HTTP_Redirect ? SAMLTools.decodeAndInflate((String)samlRequest) : SAMLTools.decode((String)samlRequest);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AuthnRequestType.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        JAXBElement element = (JAXBElement)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(bytes));
        Assert.assertEquals((String)((LogoutRequestType)element.getValue()).getID(), (String)"_1245");
        Assert.assertEquals((String)((LogoutRequestType)element.getValue()).getIssuer().getValue(), (String)"https://acme.corp/saml");
        Assert.assertEquals((int)((LogoutRequestType)element.getValue()).getSessionIndex().size(), (int)1);
        Assert.assertEquals((String)((String)((LogoutRequestType)element.getValue()).getSessionIndex().get(0)), (String)"42");
        Assert.assertEquals((String)((LogoutRequestType)element.getValue()).getVersion(), (String)"2.0");
        if (binding == Binding.HTTP_Redirect) {
            int start = rawRequest.indexOf("RelayState=");
            int end = rawRequest.indexOf(38, start);
            String relayState = URLDecoder.decode(rawRequest.substring(start + "RelayState=".length(), end), StandardCharsets.UTF_8);
            Assert.assertEquals((String)relayState, (String)"Relay-State-String");
            start = rawRequest.indexOf("SigAlg=");
            end = rawRequest.indexOf(38, start);
            String sigAlg = URLDecoder.decode(rawRequest.substring(start + "SigAlg=".length(), end), StandardCharsets.UTF_8);
            Assert.assertEquals((String)sigAlg, (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        }
    }

    @Test(dataProvider="bindings")
    public void buildLogoutResponse(Binding binding) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        PrivateKey privateKey = kp.getPrivate();
        X509Certificate certificate = this.generateX509Certificate(kp, "SHA256withRSA");
        LogoutResponse logoutResponse = new LogoutResponse();
        logoutResponse.id = "_1245";
        logoutResponse.issuer = "https://acme.corp/saml";
        logoutResponse.sessionIndex = "42";
        logoutResponse.status = new Status();
        logoutResponse.status.code = ResponseStatus.Success;
        logoutResponse.status.message = "Ok";
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        String rawResponse = binding == Binding.HTTP_Redirect ? service.buildRedirectLogoutResponse(logoutResponse, "Relay-State-String", true, privateKey, Algorithm.RS256) : service.buildPostLogoutResponse(logoutResponse, true, privateKey, certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)rawResponse);
        String samlResponse = rawResponse;
        if (binding == Binding.HTTP_Redirect) {
            int start = samlResponse.indexOf(61);
            int end = samlResponse.indexOf(38);
            samlResponse = samlResponse.substring(start + 1, end);
            samlResponse = URLDecoder.decode(samlResponse, StandardCharsets.UTF_8);
        }
        byte[] bytes = binding == Binding.HTTP_Redirect ? SAMLTools.decodeAndInflate((String)samlResponse) : SAMLTools.decode((String)samlResponse);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AuthnRequestType.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        JAXBElement element = (JAXBElement)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(bytes));
        Assert.assertEquals((String)((StatusResponseType)element.getValue()).getID(), (String)"_1245");
        Assert.assertEquals((String)((StatusResponseType)element.getValue()).getIssuer().getValue(), (String)"https://acme.corp/saml");
        Assert.assertEquals((String)((StatusResponseType)element.getValue()).getVersion(), (String)"2.0");
        if (binding == Binding.HTTP_Redirect) {
            int start = rawResponse.indexOf("RelayState=");
            int end = rawResponse.indexOf(38, start);
            String relayState = URLDecoder.decode(rawResponse.substring(start + "RelayState=".length(), end), StandardCharsets.UTF_8);
            Assert.assertEquals((String)relayState, (String)"Relay-State-String");
            start = rawResponse.indexOf("SigAlg=");
            end = rawResponse.indexOf(38, start);
            String sigAlg = URLDecoder.decode(rawResponse.substring(start + "SigAlg=".length(), end), StandardCharsets.UTF_8);
            Assert.assertEquals((String)sigAlg, (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        }
    }

    @Test
    public void buildLogoutResponse_signatureFollowsIssuer() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        PrivateKey privateKey = kp.getPrivate();
        X509Certificate certificate = this.generateX509Certificate(kp, "SHA256withRSA");
        LogoutResponse logoutResponse = new LogoutResponse();
        logoutResponse.id = "_1245";
        logoutResponse.issuer = "https://acme.corp/saml";
        logoutResponse.sessionIndex = "42";
        logoutResponse.status = new Status();
        logoutResponse.status.code = ResponseStatus.Success;
        logoutResponse.status.message = "Ok";
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        String samlRequest = service.buildPostLogoutResponse(logoutResponse, true, privateKey, certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)samlRequest);
        byte[] bytes = SAMLTools.decode((String)samlRequest);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(bytes));
        Element issuer = (Element)doc.getElementsByTagName("Issuer").item(0);
        Element signature = (Element)issuer.getNextSibling();
        Assert.assertEquals((String)signature.getTagName(), (String)"Signature");
    }

    @Test(dataProvider="BooleanTriState")
    public void buildPostAuthnRequest_forceAuthn(Boolean forceAuthN) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        PrivateKey privateKey = kp.getPrivate();
        X509Certificate certificate = this.generateX509Certificate(kp, "SHA256withRSA");
        AuthenticationRequest request = new AuthenticationRequest();
        request.id = "foobarbaz";
        request.issuer = "https://local.fusionauth.io";
        request.forceAuthn = forceAuthN;
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        String postRequest = service.buildPostAuthnRequest(request, true, privateKey, certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)postRequest);
        AuthenticationRequest actualPostRequest = service.parseRequestPostBinding(postRequest, authRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(certificate.getPublicKey()), true));
        Assert.assertEquals((Boolean)actualPostRequest.forceAuthn, (Boolean)forceAuthN);
        String redirectRequest = service.buildRedirectAuthnRequest(request, "Relay-State", true, privateKey, Algorithm.RS256);
        Assert.assertNotNull((Object)redirectRequest);
        AuthenticationRequest actualRedirectRequest = service.parseRequestRedirectBinding(redirectRequest, authRequest -> new TestRedirectBindingSignatureHelper(certificate.getPublicKey(), true));
        Assert.assertEquals((Boolean)actualRedirectRequest.forceAuthn, (Boolean)forceAuthN);
    }

    @Test
    public void buildPostAuthnRequest_signatureFollowsIssuer() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        PrivateKey privateKey = kp.getPrivate();
        X509Certificate certificate = this.generateX509Certificate(kp, "SHA256withRSA");
        AuthenticationRequest request = new AuthenticationRequest();
        request.id = "foobarbaz";
        request.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        String samlRequest = service.buildPostAuthnRequest(request, true, privateKey, certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)samlRequest);
        byte[] bytes = SAMLTools.decode((String)samlRequest);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(bytes));
        Element issuer = (Element)doc.getElementsByTagName("Issuer").item(0);
        Element signature = (Element)issuer.getNextSibling();
        Assert.assertEquals((String)signature.getTagName(), (String)"Signature");
    }

    @Test
    public void buildPostLogoutRequest_signatureFollowsIssuer() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        PrivateKey privateKey = kp.getPrivate();
        X509Certificate certificate = this.generateX509Certificate(kp, "SHA256withRSA");
        LogoutRequest request = new LogoutRequest();
        request.id = "foobarbaz";
        request.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        String samlRequest = service.buildPostLogoutRequest(request, true, privateKey, certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)samlRequest);
        byte[] bytes = SAMLTools.decode((String)samlRequest);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(bytes));
        Element issuer = (Element)doc.getElementsByTagName("Issuer").item(0);
        Element signature = (Element)issuer.getNextSibling();
        Assert.assertEquals((String)signature.getTagName(), (String)"Signature");
    }

    @Test(dataProvider="bindings")
    public void buildRedirectAuthnRequest(Binding binding) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        PrivateKey privateKey = kp.getPrivate();
        X509Certificate certificate = this.generateX509Certificate(kp, "SHA256withRSA");
        AuthenticationRequest request = new AuthenticationRequest();
        request.id = "foobarbaz";
        request.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        String rawRequest = binding == Binding.HTTP_Redirect ? service.buildRedirectAuthnRequest(request, "Relay-State-String", true, privateKey, Algorithm.RS256) : service.buildPostAuthnRequest(request, true, privateKey, certificate, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Assert.assertNotNull((Object)rawRequest);
        String samlRequest = rawRequest;
        if (binding == Binding.HTTP_Redirect) {
            int start = samlRequest.indexOf(61);
            int end = samlRequest.indexOf(38);
            samlRequest = samlRequest.substring(start + 1, end);
            samlRequest = URLDecoder.decode(samlRequest, StandardCharsets.UTF_8);
        }
        byte[] bytes = binding == Binding.HTTP_Redirect ? SAMLTools.decodeAndInflate((String)samlRequest) : SAMLTools.decode((String)samlRequest);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AuthnRequestType.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        JAXBElement fromEncoded = (JAXBElement)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(bytes));
        Assert.assertEquals((String)((AuthnRequestType)fromEncoded.getValue()).getID(), (String)"foobarbaz");
        Assert.assertEquals((String)((AuthnRequestType)fromEncoded.getValue()).getIssuer().getValue(), (String)"https://local.fusionauth.io");
        Assert.assertEquals((String)((AuthnRequestType)fromEncoded.getValue()).getVersion(), (String)"2.0");
        Assert.assertFalse((boolean)((AuthnRequestType)fromEncoded.getValue()).getNameIDPolicy().isAllowCreate());
        if (binding == Binding.HTTP_Redirect) {
            int start = rawRequest.indexOf("RelayState=");
            int end = rawRequest.indexOf(38, start);
            String relayState = URLDecoder.decode(rawRequest.substring(start + "RelayState=".length(), end), StandardCharsets.UTF_8);
            Assert.assertEquals((String)relayState, (String)"Relay-State-String");
            start = rawRequest.indexOf("SigAlg=");
            end = rawRequest.indexOf(38, start);
            String sigAlg = URLDecoder.decode(rawRequest.substring(start + "SigAlg=".length(), end), StandardCharsets.UTF_8);
            Assert.assertEquals((String)sigAlg, (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        }
    }

    @Test
    public void buildSPMetaData() throws Exception {
        MetaData metaData = new MetaData();
        metaData.id = UUID.randomUUID().toString();
        metaData.entityId = "https://fusionauth.io/samlv2/sp/" + metaData.id;
        metaData.sp = new MetaData.SPMetaData();
        metaData.sp.acsEndpoint = "https://fusionauth.io/oauth2/callback";
        metaData.sp.nameIDFormat = NameIDFormat.EmailAddress;
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        String xml = service.buildMetadataResponse(metaData);
        Assert.assertTrue((boolean)xml.contains("_" + metaData.id));
        Assert.assertTrue((boolean)xml.contains(metaData.entityId));
        Assert.assertTrue((boolean)xml.contains(metaData.sp.acsEndpoint));
        Assert.assertTrue((boolean)xml.contains(metaData.sp.nameIDFormat.toSAMLFormat()));
        Assert.assertTrue((boolean)xml.contains("<ns2:SPSSODescriptor AuthnRequestsSigned=\"false\" WantAssertionsSigned=\"false\" protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">"));
        MetaData parsed = service.parseMetaData(xml);
        Assert.assertEquals((String)parsed.id, (String)("_" + metaData.id));
        Assert.assertEquals((String)parsed.entityId, (String)metaData.entityId);
        Assert.assertEquals((String)parsed.sp.acsEndpoint, (String)metaData.sp.acsEndpoint);
        Assert.assertEquals((Object)parsed.sp.nameIDFormat, (Object)metaData.sp.nameIDFormat);
    }

    @Test(dataProvider="bindings")
    public void hacking_CVE_2022_21449(Binding binding) throws Exception {
        String queryString;
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        kpg.initialize(256);
        KeyPair kp = kpg.generateKeyPair();
        AuthenticationRequest request = new AuthenticationRequest();
        request.id = "foobarbaz";
        request.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        if (binding == Binding.HTTP_Redirect) {
            queryString = service.buildRedirectAuthnRequest(request, "Relay-State-String", true, kp.getPrivate(), Algorithm.ES256);
        } else {
            X509Certificate cert = this.generateX509Certificate(kp, "SHA256withECDSA");
            queryString = service.buildPostAuthnRequest(request, true, kp.getPrivate(), cert, Algorithm.ES256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        }
        int start = queryString.indexOf("Signature=");
        int end = queryString.indexOf("&", start);
        byte[] hackedBytes = new byte[]{48, 6, 2, 1, 0, 2, 1, 0};
        String hackedSig = Base64.getUrlEncoder().encodeToString(hackedBytes);
        if (binding == Binding.HTTP_Redirect) {
            String hacked = queryString.substring(0, start) + "Signature=" + hackedSig;
            if (end != -1) {
                hacked = hacked + queryString.substring(end);
            }
            try {
                service.parseRequestRedirectBinding(hacked, authRequest -> new TestRedirectBindingSignatureHelper(kp.getPublic(), true));
                Assert.fail((String)"This should have exploded.");
            }
            catch (SAMLException sAMLException) {}
        } else {
            Document document = this.parseDocument(queryString);
            Node signature = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Node signatureValue = signature.getFirstChild().getNextSibling();
            signatureValue.setTextContent(hackedSig);
            String hackedDocument = SAMLTools.marshallToString((Document)document);
            String hackedDocumentEncoded = new String(Base64.getEncoder().encode(hackedDocument.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            try {
                service.parseRequestPostBinding(hackedDocumentEncoded, authRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(kp.getPublic()), true));
                Assert.fail((String)"This should have exploded.");
            }
            catch (SAMLException sAMLException) {
                // empty catch block
            }
        }
    }

    @DataProvider(name="maxLineLength")
    public Object[][] maxLineLength() {
        return new Object[][]{{42}, {64}, {76}, {96}, {128}};
    }

    @Test(dataProvider="bindings")
    public void parseLogout_Request_raw(Binding binding) throws Exception {
        X509Certificate certificate;
        byte[] bytes = binding == Binding.HTTP_Redirect ? Files.readAllBytes(Paths.get("src/test/xml/encoded/logout-request.txt", new String[0])) : Files.readAllBytes(Paths.get("src/test/xml/encoded/logout-request-embedded-signature.txt", new String[0]));
        String encodedXML = new String(bytes, StandardCharsets.UTF_8);
        String redirectSignature = Files.readString(Paths.get("src/test/xml/signature/logout-request.txt", new String[0]));
        String x509encoded = "MIICajCCAdOgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBSMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lbG9naW4gSW5jMRcwFQYDVQQDDA5zcC5leGFtcGxlLmNvbTAeFw0xNDA3MTcxNDEyNTZaFw0xNTA3MTcxNDEyNTZaMFIxCzAJBgNVBAYTAnVzMRMwEQYDVQQIDApDYWxpZm9ybmlhMRUwEwYDVQQKDAxPbmVsb2dpbiBJbmMxFzAVBgNVBAMMDnNwLmV4YW1wbGUuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDZx+ON4IUoIWxgukTb1tOiX3bMYzYQiwWPUNMp+Fq82xoNogso2bykZG0yiJm5o8zv/sd6pGouayMgkx/2FSOdc36T0jGbCHuRSbtia0PEzNIRtmViMrt3AeoWBidRXmZsxCNLwgIV6dn2WpuE5Az0bHgpZnQxTKFek0BMKU/d8wIDAQABo1AwTjAdBgNVHQ4EFgQUGHxYqZYyX7cTxKVODVgZwSTdCnwwHwYDVR0jBBgwFoAUGHxYqZYyX7cTxKVODVgZwSTdCnwwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQ0FAAOBgQByFOl+hMFICbd3DJfnp2Rgd/dqttsZG/tyhILWvErbio/DEe98mXpowhTkC04ENprOyXi7ZbUqiicF89uAGyt1oqgTUCD1VsLahqIcmrzgumNyTwLGWo17WDAa1/usDhetWAMhgzF/Cnf5ek0nK00m0YZGyc4LzgD0CROMASTWNg==";
        try (ByteArrayInputStream is = new ByteArrayInputStream(Base64.getMimeDecoder().decode(x509encoded));){
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            certificate = (X509Certificate)factory.generateCertificate(is);
        }
        Assert.assertNotNull((Object)certificate);
        PublicKey publicKey = certificate.getPublicKey();
        String queryString = "SAMLRequest=" + URLEncoder.encode(encodedXML, StandardCharsets.UTF_8) + "&RelayState=" + URLEncoder.encode("http://sp.example.com/relaystate", StandardCharsets.UTF_8) + "&SigAlg=" + URLEncoder.encode(Algorithm.RS1.uri, StandardCharsets.UTF_8) + "&Signature=" + URLEncoder.encode(redirectSignature, StandardCharsets.UTF_8);
        boolean verifySignature = false;
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        LogoutRequest request = binding == Binding.HTTP_Redirect ? service.parseLogoutRequestRedirectBinding(queryString, logoutRequest -> new TestRedirectBindingSignatureHelper(publicKey, verifySignature)) : service.parseLogoutRequestPostBinding(encodedXML, logoutRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), verifySignature));
        Assert.assertEquals((String)request.id, (String)(binding == Binding.HTTP_Redirect ? "ONELOGIN_21df91a89767879fc0f7df6a1490c6000c81644d" : "pfxd4d369e8-9ea1-780c-aff8-a1d11a9862a1"));
        Assert.assertEquals((String)request.issuer, (String)"http://sp.example.com/demo1/metadata.php");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.Transient.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
        String expectedXML = binding == Binding.HTTP_Redirect ? new String(Files.readAllBytes(Paths.get("src/test/xml/logout-request.xml", new String[0]))) : new String(Files.readAllBytes(Paths.get("src/test/xml/logout-request-embedded-signature.xml", new String[0])));
        Assert.assertEquals((String)request.xml.replace("\r\n", "\n"), (String)expectedXML.replace("\r\n", "\n"));
    }

    @Test
    public void parseMetaData() throws Exception {
        byte[] buf = Files.readAllBytes(Paths.get("src/test/xml/metadata.xml", new String[0]));
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        MetaData metaData = service.parseMetaData(new String(buf, StandardCharsets.UTF_8));
        Assert.assertEquals((int)metaData.idp.certificates.size(), (int)3);
        buf = Files.readAllBytes(Paths.get("src/test/xml/metadata-2.xml", new String[0]));
        metaData = service.parseMetaData(new String(buf, StandardCharsets.UTF_8));
        Assert.assertEquals((int)metaData.idp.certificates.size(), (int)1);
    }

    @Test(enabled=false)
    public void parseRequest_compassSecurity() throws Exception {
        String encodedXML = "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";
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(new BigInteger("23016430918823899869174537266594866915196701755262955756947374683306171050449785978041642070945082562110926617344211216571596575890159654912559343561454566120924390651417182396241104494630512996615232908509829811443784313485862019497373006302688901954848508137355590138442254765794572625586049567608157223736747587462558785268970406066201827350377828581492579969240135441642716939367190425379788145244337250560138881783025442595121210838086638484878363941229167629103738547784336822433469701246494321129732432091196962736034404069520496182669787723781485938596516343326251546340541402004104537790138422441873446220669"), new BigInteger("65537")));
        TestPostBindingSignatureHelper signatureHelper = new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), true);
        AuthenticationRequest request = service.parseRequestPostBinding(encodedXML, authRequest -> signatureHelper);
        Assert.assertEquals((String)request.id, (String)"_7fe510cc8e51aa41558a");
        Assert.assertEquals((String)request.issuer, (String)"urn:example:sp");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
    }

    @Test
    public void parseRequest_expandedEntity() throws Exception {
        try {
            DefaultSAMLv2Service service = new DefaultSAMLv2Service();
            byte[] xml = Files.readAllBytes(Paths.get("src/test/xml/authn-request-expanded-entity.xml", new String[0]));
            String deflated = SAMLTools.deflateAndEncode((byte[])xml);
            String queryString = "SAMLRequest=" + URLEncoder.encode(deflated, StandardCharsets.UTF_8);
            AuthenticationRequest request = service.parseRequestRedirectBinding(queryString, authRequest -> new TestRedirectBindingSignatureHelper());
            Assert.fail((String)("Expected an exception because we are declaring a DOCTYPE and expanding an entity. The issuer is now set to [" + request.issuer + "] which is not good."));
        }
        catch (SAMLException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Unable to parse SAML v2.0 document.");
            Assert.assertEquals((String)e.getCause().getClass().getCanonicalName(), (String)"org.xml.sax.SAXParseException");
            Assert.assertEquals((String)e.getCause().getMessage(), (String)"DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void parseRequest_externalDTD() throws Exception {
        Path tempFile = null;
        try {
            tempFile = Files.createTempFile("readThisFile", ".tmp", new FileAttribute[0]);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile.toFile()));){
                writer.write("You've been pwned.");
            }
            DefaultSAMLv2Service service = new DefaultSAMLv2Service();
            byte[] xml = Files.readAllBytes(Paths.get("src/test/xml/authn-request-external-dtd.xml", new String[0]));
            String xmlString = new String(xml);
            xmlString = xmlString.replace("{{tempFile}}", tempFile.toFile().getAbsolutePath());
            xml = xmlString.getBytes(StandardCharsets.UTF_8);
            String deflated = SAMLTools.deflateAndEncode((byte[])xml);
            String queryString = "SAMLRequest=" + URLEncoder.encode(deflated, StandardCharsets.UTF_8);
            AuthenticationRequest request = service.parseRequestRedirectBinding(queryString, authRequest -> new TestRedirectBindingSignatureHelper());
            Assert.fail((String)("Expected an exception because we are declaring a DOCTYPE. The issuer is now set to [" + request.issuer + "] which is not good."));
        }
        catch (SAMLException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Unable to parse SAML v2.0 document.");
            Assert.assertEquals((String)e.getCause().getClass().getCanonicalName(), (String)"org.xml.sax.SAXParseException");
            Assert.assertEquals((String)e.getCause().getMessage(), (String)"DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true.");
        }
        finally {
            if (tempFile != null) {
                Files.deleteIfExists(tempFile);
            }
        }
    }

    @Test(dataProvider="bindings")
    public void parseRequest_forceAuthn(Binding binding) throws Exception {
        byte[] bytes = Files.readAllBytes(Paths.get("src/test/xml/authn-request-forceAuthn.xml", new String[0]));
        String encodedXML = binding == Binding.HTTP_Redirect ? SAMLTools.deflateAndEncode((byte[])bytes) : SAMLTools.encode((byte[])bytes);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationRequest request = binding == Binding.HTTP_Redirect ? service.parseRequestRedirectBinding("SAMLRequest=" + URLEncoder.encode(encodedXML, StandardCharsets.UTF_8), authRequest -> new TestRedirectBindingSignatureHelper()) : service.parseRequestPostBinding(encodedXML, authRequest -> new TestPostBindingSignatureHelper());
        Assert.assertEquals((String)request.id, (String)"_809707f0030a5d00620c9d9df97f627afe9dcc24");
        Assert.assertEquals((String)request.issuer, (String)"http://sp.example.com/demo1/metadata.php");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
        Assert.assertEquals((Boolean)request.forceAuthn, (Boolean)Boolean.TRUE);
    }

    @Test
    public void parseRequest_hasDocType() throws Exception {
        try {
            DefaultSAMLv2Service service = new DefaultSAMLv2Service();
            byte[] xml = Files.readAllBytes(Paths.get("src/test/xml/authn-request-has-doctype.xml", new String[0]));
            String deflated = SAMLTools.deflateAndEncode((byte[])xml);
            String queryString = "SAMLRequest=" + URLEncoder.encode(deflated, StandardCharsets.UTF_8);
            service.parseRequestRedirectBinding(queryString, authRequest -> new TestRedirectBindingSignatureHelper());
            Assert.fail((String)"expected an exception because we are declaring a DOCTYPE");
        }
        catch (SAMLException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Unable to parse SAML v2.0 document.");
            Assert.assertEquals((String)e.getCause().getClass().getCanonicalName(), (String)"org.xml.sax.SAXParseException");
            Assert.assertEquals((String)e.getCause().getMessage(), (String)"DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true.");
        }
    }

    @Test(dataProvider="maxLineLength")
    public void parseRequest_includeLineReturns(int maxLineLength) throws Exception {
        String xml = new String(Files.readAllBytes(Paths.get("src/test/xml/authn-request-control.xml", new String[0])));
        String encodedXML = new String(Files.readAllBytes(Paths.get("src/test/xml/deflated/authn-request-control.txt", new String[0])));
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < encodedXML.length(); i += maxLineLength) {
            lines.add(encodedXML.substring(i, Math.min(i + maxLineLength, encodedXML.length())));
        }
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        String withLineReturns = String.join((CharSequence)"\n", lines);
        String queryString = "SAMLRequest=" + URLEncoder.encode(withLineReturns, StandardCharsets.UTF_8);
        AuthenticationRequest request = service.parseRequestRedirectBinding(queryString, authRequest -> new TestRedirectBindingSignatureHelper());
        Assert.assertEquals((String)request.id, (String)"_809707f0030a5d00620c9d9df97f627afe9dcc24");
        Assert.assertEquals((String)request.issuer, (String)"http://sp.example.com/demo1/metadata.php");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
        Assert.assertEquals((String)request.xml.replace("\r\n", "\n"), (String)xml.replace("\r\n", "\n"));
    }

    @Test(dataProvider="bindings")
    public void parseRequest_noNameIdPolicy(Binding binding) throws Exception {
        String xml = new String(Files.readAllBytes(Paths.get("src/test/xml/authn-request-noNameIdPolicy.xml", new String[0])));
        String encodedXML = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/deflated/authn-request-noNameIdPolicy.txt", new String[0]) : Paths.get("src/test/xml/encoded/authn-request-noNameIdPolicy.txt", new String[0])));
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationRequest request = binding == Binding.HTTP_Redirect ? service.parseRequestRedirectBinding("SAMLRequest=" + URLEncoder.encode(encodedXML, StandardCharsets.UTF_8), authRequest -> new TestRedirectBindingSignatureHelper()) : service.parseRequestPostBinding(encodedXML, authRequest -> new TestPostBindingSignatureHelper());
        Assert.assertEquals((String)request.id, (String)"id_4c6e5aa3");
        Assert.assertEquals((String)request.issuer, (String)"https://medallia.com/sso/mlg");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
        Assert.assertEquals((String)request.xml.replace("\r\n", "\n"), (String)xml.replace("\r\n", "\n"));
    }

    @Test(dataProvider="bindings")
    public void parseRequest_verifySignature(Binding binding) throws Exception {
        String xml = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/authn-request-redirect-signed.xml", new String[0]) : Paths.get("src/test/xml/authn-request-post-signed.xml", new String[0])));
        String relayState = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/relay-state/authn-request-redirect.txt", new String[0]) : Paths.get("src/test/xml/relay-state/authn-request-post.txt", new String[0])));
        String encodedXML = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/deflated/authn-request-signed.txt", new String[0]) : Paths.get("src/test/xml/encoded/authn-request-signed.txt", new String[0])));
        String signature = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/signature/authn-request-redirect.txt", new String[0]) : Paths.get("src/test/xml/signature/authn-request-post.txt", new String[0])));
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.getMimeDecoder().decode(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/public-key/authn-request-redirect.txt", new String[0]) : Paths.get("src/test/xml/public-key/authn-request-post.txt", new String[0])))));
        String queryString = "SAMLRequest=" + URLEncoder.encode(encodedXML, StandardCharsets.UTF_8) + "&RelayState=" + URLEncoder.encode(relayState, StandardCharsets.UTF_8) + "&SigAlg=" + URLEncoder.encode(Algorithm.RS256.uri, StandardCharsets.UTF_8) + "&Signature=" + URLEncoder.encode(signature, StandardCharsets.UTF_8);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationRequest request = binding == Binding.HTTP_Redirect ? service.parseRequestRedirectBinding(queryString, authRequest -> new TestRedirectBindingSignatureHelper(publicKey, true)) : service.parseRequestPostBinding(encodedXML, authRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), true));
        Assert.assertEquals((String)request.id, (String)(binding == Binding.HTTP_Redirect ? "ID_025417c8-50c8-4916-bfe0-e05694f8cea7" : "ID_26d69170-fc73-4b62-8bb6-c72769216134"));
        Assert.assertEquals((String)request.issuer, (String)"http://localhost:8080/auth/realms/master");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
        Assert.assertEquals((String)request.xml.replace("\r\n", "\n"), (String)xml.replace("\r\n", "\n"));
    }

    @Test(dataProvider="bindings")
    public void parseRequest_verifySignature_badSignature(Binding binding) throws Exception {
        String relayState = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/relay-state/authn-request-redirect.txt", new String[0]) : Paths.get("src/test/xml/relay-state/authn-request-post.txt", new String[0])));
        String encodedXML = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/deflated/authn-request-signed.txt", new String[0]) : Paths.get("src/test/xml/encoded/authn-request-signed-badSignature.txt", new String[0])));
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.getMimeDecoder().decode(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/public-key/authn-request-redirect.txt", new String[0]) : Paths.get("src/test/xml/public-key/authn-request-post.txt", new String[0])))));
        try {
            DefaultSAMLv2Service service = new DefaultSAMLv2Service();
            if (binding == Binding.HTTP_Redirect) {
                String signature = new String(Files.readAllBytes(Paths.get("src/test/xml/signature/authn-request-redirect-bad.txt", new String[0])));
                String queryString = "SAMLRequest=" + URLEncoder.encode(encodedXML, StandardCharsets.UTF_8) + "&RelayState=" + URLEncoder.encode(relayState, StandardCharsets.UTF_8) + "&SigAlg=" + URLEncoder.encode("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", StandardCharsets.UTF_8) + "&Signature=" + URLEncoder.encode(signature, StandardCharsets.UTF_8);
                service.parseRequestRedirectBinding(queryString, request -> new TestRedirectBindingSignatureHelper(publicKey, true));
            } else {
                service.parseRequestPostBinding(encodedXML, authRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), true));
            }
            Assert.fail((String)"Should have failed signature validation");
        }
        catch (SAMLException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is invalid.");
        }
    }

    @Test(dataProvider="bindings")
    public void parseRequest_withNameIdPolicy(Binding binding) throws Exception {
        String xml = new String(Files.readAllBytes(Paths.get("src/test/xml/authn-request-control.xml", new String[0])));
        String encodedXML = new String(Files.readAllBytes(binding == Binding.HTTP_Redirect ? Paths.get("src/test/xml/deflated/authn-request-control.txt", new String[0]) : Paths.get("src/test/xml/encoded/authn-request-control.txt", new String[0])));
        String queryString = "SAMLRequest=" + URLEncoder.encode(encodedXML, StandardCharsets.UTF_8);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationRequest request = binding == Binding.HTTP_Redirect ? service.parseRequestRedirectBinding(queryString, authRequest -> new TestRedirectBindingSignatureHelper()) : service.parseRequestPostBinding(encodedXML, authRequest -> new TestPostBindingSignatureHelper());
        Assert.assertEquals((String)request.acsURL, (String)"http://sp.example.com/demo1/index.php?acs");
        Assert.assertEquals((String)request.id, (String)"_809707f0030a5d00620c9d9df97f627afe9dcc24");
        Assert.assertEquals((String)request.issuer, (String)"http://sp.example.com/demo1/metadata.php");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
        Assert.assertEquals((String)request.xml.replace("\r\n", "\n"), (String)xml.replace("\r\n", "\n"));
    }

    @Test
    public void parseResponse() throws Exception {
        PublicKey key;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (InputStream is = Files.newInputStream(Paths.get("src/test/certificates/certificate.cer", new String[0]), new OpenOption[0]);){
            Certificate cert = cf.generateCertificate(is);
            key = cert.getPublicKey();
        }
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String encodedResponse = new String(ba);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(encodedResponse, true, KeySelector.singletonKeySelector(key));
        Assert.assertEquals((String)response.destination, (String)"https://local.fusionauth.io/oauth2/callback");
        Assert.assertTrue((boolean)response.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((String)response.issuer, (String)"https://sts.windows.net/c2150111-3c44-4508-9f08-790cb4032a23/");
        Assert.assertEquals((Object)response.status.code, (Object)ResponseStatus.Success);
        Assertion assertion = (Assertion)response.assertions.get(0);
        Assert.assertTrue((boolean)assertion.conditions.notBefore.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertTrue((boolean)ZonedDateTime.now(ZoneOffset.UTC).isAfter(assertion.conditions.notOnOrAfter));
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.microsoft.com/identity/claims/displayname")).get(0)), (String)"Brian Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname")).get(0)), (String)"Brian");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname")).get(0)), (String)"Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress")).get(0)), (String)"brian@inversoft.com");
        Assert.assertNotNull((Object)assertion.subject.nameIDs);
        Assert.assertEquals((int)assertion.subject.nameIDs.size(), (int)1);
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)0)).format, (String)NameIDFormat.EmailAddress.toSAMLFormat());
    }

    @Test
    public void parseResponse_detachedSignature() throws Exception {
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse-detachedSignature.txt", new String[0]));
        String encodedResponse = new String(ba, StandardCharsets.UTF_8);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(encodedResponse, true, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()));
        Assert.assertEquals((String)response.destination, (String)"https://local.fusionauth.io/samlv2/acs");
        Assert.assertTrue((boolean)response.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((String)response.issuer, (String)"https://example.com/saml");
        Assert.assertEquals((Object)response.status.code, (Object)ResponseStatus.Success);
        Assertion assertion = (Assertion)response.assertions.get(0);
        Assert.assertTrue((boolean)assertion.conditions.notBefore.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertTrue((boolean)ZonedDateTime.now(ZoneOffset.UTC).isAfter(assertion.conditions.notOnOrAfter));
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("sub")).get(0)), (String)"41");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("email")).get(0)), (String)"test@example.com");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("username")).get(0)), (String)"guitarchargejobs");
        Assert.assertNotNull((Object)assertion.subject.nameIDs);
        Assert.assertEquals((int)assertion.subject.nameIDs.size(), (int)2);
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)0)).format, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)1)).format, (String)NameIDFormat.Persistent.toSAMLFormat());
    }

    @Test
    public void parseResponse_duplicateIds() throws Exception {
        String responseXml = this.baseXml.replace("${assertions}", String.join((CharSequence)"", List.of(this.assertionUnsigned, this.assertionUnsigned)));
        String encodedResponse = Base64.getMimeEncoder().encodeToString(responseXml.getBytes(StandardCharsets.UTF_8));
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        try {
            service.parseResponse(encodedResponse, false, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()), false, this.encryptionKeyPair.getPrivate());
            Assert.fail((String)"Expected SAMLException");
        }
        catch (SAMLException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Unable to parse SAML v2.0 XML. The document contains duplicate element IDs.");
        }
        responseXml = this.baseXml.replace("${assertions}", String.join((CharSequence)"", List.of(this.encryptedUnsigned, this.encryptedUnsigned)));
        encodedResponse = Base64.getMimeEncoder().encodeToString(responseXml.getBytes(StandardCharsets.UTF_8));
        try {
            service.parseResponse(encodedResponse, false, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()), false, this.encryptionKeyPair.getPrivate());
            Assert.fail((String)"Expected SAMLException");
        }
        catch (SAMLException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Unable to parse SAML v2.0 XML. The document contains duplicate element IDs.");
        }
    }

    @Test
    public void parseResponse_handleNilAttribute_UnsupportedType_NoValue() throws Exception {
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/deflated/example-response.txt", new String[0]));
        String encodedResponse = new String(ba);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(encodedResponse, false, null);
        Assert.assertEquals((String)response.destination, (String)"http://sp.example.com/demo1/index.php?acs");
        Assert.assertEquals((String)response.issuer, (String)"http://idp.example.com/metadata.php");
        Assert.assertEquals((Object)response.status.code, (Object)ResponseStatus.Success);
        Assertion assertion = (Assertion)response.assertions.get(0);
        Assert.assertTrue((boolean)assertion.conditions.notBefore.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((int)((List)assertion.attributes.get("uid")).size(), (int)1);
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("uid")).get(0)), (String)"test");
        Assert.assertEquals((int)((List)assertion.attributes.get("mail")).size(), (int)1);
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("mail")).get(0)), (String)"test@example.com");
        Assert.assertEquals((int)((List)assertion.attributes.get("eduPersonAffiliation")).size(), (int)2);
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("eduPersonAffiliation")).get(0)), (String)"users");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("eduPersonAffiliation")).get(1)), (String)"examplerole1");
        Assert.assertEquals((int)((List)assertion.attributes.get("memberOf")).size(), (int)1);
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("memberOf")).get(0)), (String)"");
        Assert.assertEquals((int)((List)assertion.attributes.get("PersonImmutableID")).size(), (int)1);
        Assert.assertNull(((List)assertion.attributes.get("PersonImmutableID")).get(0));
        Assert.assertEquals((int)((List)assertion.attributes.get("isAdmin")).size(), (int)1);
        Assert.assertNull(((List)assertion.attributes.get("isAdmin")).get(0));
        Assert.assertEquals((int)((List)assertion.attributes.get("noValue")).size(), (int)0);
        Assert.assertNotNull((Object)assertion.subject.nameIDs);
        Assert.assertEquals((int)assertion.subject.nameIDs.size(), (int)1);
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)0)).format, (String)NameIDFormat.Transient.toSAMLFormat());
        Assertion copy = new Assertion(assertion);
        Assert.assertEquals((Object)copy, (Object)assertion);
    }

    @Test(dataProvider="maxLineLength")
    public void parseResponse_includeLineReturns(int maxLineLength) throws Exception {
        PublicKey key;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (InputStream is = Files.newInputStream(Paths.get("src/test/certificates/certificate.cer", new String[0]), new OpenOption[0]);){
            Certificate cert = cf.generateCertificate(is);
            key = cert.getPublicKey();
        }
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String encodedResponse = new String(ba);
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < encodedResponse.length(); i += maxLineLength) {
            lines.add(encodedResponse.substring(i, Math.min(i + maxLineLength, encodedResponse.length())));
        }
        String withLineReturns = String.join((CharSequence)"\n", lines);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(withLineReturns, true, KeySelector.singletonKeySelector(key));
        Assert.assertEquals((String)response.destination, (String)"https://local.fusionauth.io/oauth2/callback");
        Assert.assertTrue((boolean)response.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((String)response.issuer, (String)"https://sts.windows.net/c2150111-3c44-4508-9f08-790cb4032a23/");
        Assert.assertEquals((Object)response.status.code, (Object)ResponseStatus.Success);
        Assertion assertion = (Assertion)response.assertions.get(0);
        Assert.assertTrue((boolean)assertion.conditions.notBefore.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertTrue((boolean)ZonedDateTime.now(ZoneOffset.UTC).isAfter(assertion.conditions.notOnOrAfter));
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.microsoft.com/identity/claims/displayname")).get(0)), (String)"Brian Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname")).get(0)), (String)"Brian");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname")).get(0)), (String)"Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress")).get(0)), (String)"brian@inversoft.com");
        Assert.assertNotNull((Object)assertion.subject.nameIDs);
        Assert.assertEquals((int)assertion.subject.nameIDs.size(), (int)1);
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)0)).format, (String)NameIDFormat.EmailAddress.toSAMLFormat());
    }

    @Test
    public void parseResponse_multipleAssertions_ignoreSignature() throws Exception {
        String responseXml = this.baseXml.replace("${assertions}", String.join((CharSequence)"", List.of(this.assertionSigned, this.assertionUnsigned, this.encryptedSigned, this.encryptedUnsigned)));
        String encodedResponse = Base64.getMimeEncoder().encodeToString(responseXml.getBytes(StandardCharsets.UTF_8));
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(encodedResponse, false, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()), false, this.encryptionKeyPair.getPrivate());
        Assert.assertEquals((int)response.assertions.size(), (int)4);
    }

    @Test
    public void parseResponse_multipleAssertions_verifySignature() throws Exception {
        String responseXml = this.baseXml.replace("${assertions}", String.join((CharSequence)"", List.of(this.assertionSigned, this.assertionUnsigned, this.encryptedSigned, this.encryptedUnsigned)));
        String encodedResponse = Base64.getMimeEncoder().encodeToString(responseXml.getBytes(StandardCharsets.UTF_8));
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(encodedResponse, true, KeySelector.singletonKeySelector(this.signingKeyPair.getPublic()), false, this.encryptionKeyPair.getPrivate());
        Assert.assertEquals((int)response.assertions.size(), (int)2);
        Assert.assertEquals((String)((Assertion)response.assertions.get((int)0)).id, (String)"_b839e63e-4673-43a8-b226-ef73676a70b1");
        Assert.assertEquals((String)((Assertion)response.assertions.get((int)1)).id, (String)"_604b9303-a5b0-411f-9b3a-5f525fe6887b");
        response = service.parseResponse(encodedResponse, true, KeySelector.singletonKeySelector(this.signingKeyPair.getPublic()), true, this.encryptionKeyPair.getPrivate());
        Assert.assertEquals((int)response.assertions.size(), (int)1);
        Assert.assertEquals((String)((Assertion)response.assertions.get((int)0)).id, (String)"_604b9303-a5b0-411f-9b3a-5f525fe6887b");
        responseXml = this.baseXml.replace("${assertions}", String.join((CharSequence)"", List.of(this.assertionUnsigned, this.encryptedUnsigned)));
        encodedResponse = Base64.getMimeEncoder().encodeToString(responseXml.getBytes(StandardCharsets.UTF_8));
        try {
            service.parseResponse(encodedResponse, true, KeySelector.singletonKeySelector(this.signingKeyPair.getPublic()), false, this.encryptionKeyPair.getPrivate());
            Assert.fail((String)"Expected SignatureNotFoundException");
        }
        catch (SignatureNotFoundException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is missing from the XML but is required.");
        }
    }

    @Test
    public void parseResponse_requireEncryptedAssertion_unencrypted() throws Exception {
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String encodedResponse = new String(ba, StandardCharsets.UTF_8);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(encodedResponse, false, null, true, null);
        Assert.assertTrue((boolean)response.assertions.isEmpty());
    }

    @Test
    public void parseResponse_signatureCheck_badSignature() throws Exception {
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        String responseXml = this.baseXml.replace("${assertions}", this.assertionSigned);
        String encodedResponse = Base64.getMimeEncoder().encodeToString(responseXml.getBytes(StandardCharsets.UTF_8));
        try {
            service.parseResponse(encodedResponse, true, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()));
            Assert.fail((String)"Expected SAMLException");
        }
        catch (SAMLException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is invalid.");
        }
        responseXml = this.baseXml.replace("${assertions}", this.encryptedSigned);
        encodedResponse = Base64.getMimeEncoder().encodeToString(responseXml.getBytes(StandardCharsets.UTF_8));
        try {
            service.parseResponse(encodedResponse, true, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()), true, this.encryptionKeyPair.getPrivate());
            Assert.fail((String)"Expected SAMLException");
        }
        catch (SAMLException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is invalid.");
        }
        responseXml = this.baseXml.replace("${assertions}", this.assertionUnsigned);
        encodedResponse = Base64.getMimeEncoder().encodeToString(responseXml.getBytes(StandardCharsets.UTF_8));
        AuthenticationResponse response = service.parseResponse(encodedResponse, false, null);
        encodedResponse = service.buildAuthnResponse(response, true, this.signingKeyPair.getPrivate(), CertificateTools.fromKeyPair(this.signingKeyPair, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Response, false);
        try {
            service.parseResponse(encodedResponse, true, KeySelector.singletonKeySelector(this.encryptionKeyPair.getPublic()));
            Assert.fail((String)"Expected SAMLException");
        }
        catch (SAMLException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is invalid.");
        }
    }

    @Test
    public void parseResponse_signatureCheck_missing() throws Exception {
        PublicKey key;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (InputStream is = Files.newInputStream(Paths.get("src/test/certificates/certificate.cer", new String[0]), new OpenOption[0]);){
            Certificate cert = cf.generateCertificate(is);
            key = cert.getPublicKey();
        }
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse-signatureRemoved.txt", new String[0]));
        String encodedResponse = new String(ba);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        try {
            service.parseResponse(encodedResponse, true, KeySelector.singletonKeySelector(key));
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (SAMLException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is missing from the XML but is required.");
        }
    }

    @Test
    public void parseResponse_signatureCheck_missingEncrypted() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair encryptionKeyPair = kpg.generateKeyPair();
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String encodedResponse = new String(ba, StandardCharsets.UTF_8);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(encodedResponse, false, null);
        String encodedXML = service.buildAuthnResponse(response, false, null, null, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Response, false, true, EncryptionAlgorithm.AES128GCM, KeyLocation.Child, KeyTransportAlgorithm.RSA_OAEP, CertificateTools.fromKeyPair(encryptionKeyPair, Algorithm.RS256, "FooBar"), DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1_SHA1);
        try {
            service.parseResponse(encodedXML, true, null, true, encryptionKeyPair.getPrivate());
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (SAMLException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid SAML v2.0 operation. The signature is missing from the XML but is required.");
        }
    }

    @Test(dataProvider="bindings")
    public void parse_LogoutRequest(Binding binding) throws Exception {
        X509Certificate certificate;
        byte[] bytes = binding == Binding.HTTP_Redirect ? Files.readAllBytes(Paths.get("src/test/xml/logout-request.xml", new String[0])) : Files.readAllBytes(Paths.get("src/test/xml/logout-request-embedded-signature.xml", new String[0]));
        String encodedXML = binding == Binding.HTTP_Redirect ? SAMLTools.deflateAndEncode((byte[])bytes) : SAMLTools.encode((byte[])bytes);
        String redirectSignature = Files.readString(Paths.get("src/test/xml/signature/logout-request.txt", new String[0]));
        String x509encoded = "MIICajCCAdOgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBSMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lbG9naW4gSW5jMRcwFQYDVQQDDA5zcC5leGFtcGxlLmNvbTAeFw0xNDA3MTcxNDEyNTZaFw0xNTA3MTcxNDEyNTZaMFIxCzAJBgNVBAYTAnVzMRMwEQYDVQQIDApDYWxpZm9ybmlhMRUwEwYDVQQKDAxPbmVsb2dpbiBJbmMxFzAVBgNVBAMMDnNwLmV4YW1wbGUuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDZx+ON4IUoIWxgukTb1tOiX3bMYzYQiwWPUNMp+Fq82xoNogso2bykZG0yiJm5o8zv/sd6pGouayMgkx/2FSOdc36T0jGbCHuRSbtia0PEzNIRtmViMrt3AeoWBidRXmZsxCNLwgIV6dn2WpuE5Az0bHgpZnQxTKFek0BMKU/d8wIDAQABo1AwTjAdBgNVHQ4EFgQUGHxYqZYyX7cTxKVODVgZwSTdCnwwHwYDVR0jBBgwFoAUGHxYqZYyX7cTxKVODVgZwSTdCnwwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQ0FAAOBgQByFOl+hMFICbd3DJfnp2Rgd/dqttsZG/tyhILWvErbio/DEe98mXpowhTkC04ENprOyXi7ZbUqiicF89uAGyt1oqgTUCD1VsLahqIcmrzgumNyTwLGWo17WDAa1/usDhetWAMhgzF/Cnf5ek0nK00m0YZGyc4LzgD0CROMASTWNg==";
        try (ByteArrayInputStream is = new ByteArrayInputStream(Base64.getMimeDecoder().decode(x509encoded));){
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            certificate = (X509Certificate)factory.generateCertificate(is);
        }
        Assert.assertNotNull((Object)certificate);
        PublicKey publicKey = certificate.getPublicKey();
        String queryString = "SAMLRequest=" + URLEncoder.encode(encodedXML, StandardCharsets.UTF_8) + "&RelayState=" + URLEncoder.encode("http://sp.example.com/relaystate", StandardCharsets.UTF_8) + "&SigAlg=" + URLEncoder.encode(Algorithm.RS1.uri, StandardCharsets.UTF_8) + "&Signature=" + URLEncoder.encode(redirectSignature, StandardCharsets.UTF_8);
        boolean verifySignature = false;
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        LogoutRequest request = binding == Binding.HTTP_Redirect ? service.parseLogoutRequestRedirectBinding(queryString, logoutRequest -> new TestRedirectBindingSignatureHelper(publicKey, verifySignature)) : service.parseLogoutRequestPostBinding(encodedXML, logoutRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), verifySignature));
        Assert.assertEquals((String)request.id, (String)(binding == Binding.HTTP_Redirect ? "ONELOGIN_21df91a89767879fc0f7df6a1490c6000c81644d" : "pfxd4d369e8-9ea1-780c-aff8-a1d11a9862a1"));
        Assert.assertEquals((String)request.issuer, (String)"http://sp.example.com/demo1/metadata.php");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.Transient.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
        String expectedXML = new String(bytes, StandardCharsets.UTF_8);
        Assert.assertEquals((String)request.xml.replace("\r\n", "\n"), (String)expectedXML.replace("\r\n", "\n"));
    }

    @Test(dataProvider="bindings")
    public void parse_LogoutResponse(Binding binding) throws Exception {
        X509Certificate certificate;
        byte[] bytes = binding == Binding.HTTP_Redirect ? Files.readAllBytes(Paths.get("src/test/xml/logout-response.xml", new String[0])) : Files.readAllBytes(Paths.get("src/test/xml/logout-response-embedded-signature.xml", new String[0]));
        String encodedXML = binding == Binding.HTTP_Redirect ? SAMLTools.deflateAndEncode((byte[])bytes) : SAMLTools.encode((byte[])bytes);
        String redirectSignature = Files.readString(Paths.get("src/test/xml/signature/logout-response.txt", new String[0]));
        String x509encoded = "MIICajCCAdOgAwIBAgIBADANBgkqhkiG9w0BAQ0FADBSMQswCQYDVQQGEwJ1czETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMT25lbG9naW4gSW5jMRcwFQYDVQQDDA5zcC5leGFtcGxlLmNvbTAeFw0xNDA3MTcxNDEyNTZaFw0xNTA3MTcxNDEyNTZaMFIxCzAJBgNVBAYTAnVzMRMwEQYDVQQIDApDYWxpZm9ybmlhMRUwEwYDVQQKDAxPbmVsb2dpbiBJbmMxFzAVBgNVBAMMDnNwLmV4YW1wbGUuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDZx+ON4IUoIWxgukTb1tOiX3bMYzYQiwWPUNMp+Fq82xoNogso2bykZG0yiJm5o8zv/sd6pGouayMgkx/2FSOdc36T0jGbCHuRSbtia0PEzNIRtmViMrt3AeoWBidRXmZsxCNLwgIV6dn2WpuE5Az0bHgpZnQxTKFek0BMKU/d8wIDAQABo1AwTjAdBgNVHQ4EFgQUGHxYqZYyX7cTxKVODVgZwSTdCnwwHwYDVR0jBBgwFoAUGHxYqZYyX7cTxKVODVgZwSTdCnwwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQ0FAAOBgQByFOl+hMFICbd3DJfnp2Rgd/dqttsZG/tyhILWvErbio/DEe98mXpowhTkC04ENprOyXi7ZbUqiicF89uAGyt1oqgTUCD1VsLahqIcmrzgumNyTwLGWo17WDAa1/usDhetWAMhgzF/Cnf5ek0nK00m0YZGyc4LzgD0CROMASTWNg==";
        try (ByteArrayInputStream is = new ByteArrayInputStream(Base64.getMimeDecoder().decode(x509encoded));){
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            certificate = (X509Certificate)factory.generateCertificate(is);
        }
        Assert.assertNotNull((Object)certificate);
        PublicKey publicKey = certificate.getPublicKey();
        String queryString = "SAMLRequest=" + URLEncoder.encode(encodedXML, StandardCharsets.UTF_8) + "&RelayState=" + URLEncoder.encode("http://sp.example.com/relaystate", StandardCharsets.UTF_8) + "&SigAlg=" + URLEncoder.encode(Algorithm.RS1.uri, StandardCharsets.UTF_8) + "&Signature=" + URLEncoder.encode(redirectSignature, StandardCharsets.UTF_8);
        boolean verifySignature = false;
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        LogoutResponse response = binding == Binding.HTTP_Redirect ? service.parseLogoutResponseRedirectBinding(queryString, logoutRequest -> new TestRedirectBindingSignatureHelper(publicKey, verifySignature)) : service.parseLogoutResponsePostBinding(encodedXML, logoutRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(publicKey), verifySignature));
        Assert.assertEquals((String)response.id, (String)(binding == Binding.HTTP_Redirect ? "_6c3737282f007720e736f0f4028feed8cb9b40291c" : "pfxe335499f-e73b-80bd-60c4-1628984aed4f"));
        Assert.assertEquals((String)response.issuer, (String)"http://idp.example.com/metadata.php");
        Assert.assertEquals((String)response.version, (String)"2.0");
        Assert.assertNull((Object)response.inResponseTo);
        Assert.assertNull((Object)response.sessionIndex);
        String expectedXML = new String(bytes, StandardCharsets.UTF_8);
        Assert.assertEquals((String)response.xml.replace("\r\n", "\n"), (String)expectedXML.replace("\r\n", "\n"));
    }

    @Test(dataProvider="bindings")
    public void roundTripAuthnRequest(Binding binding) throws Exception {
        String queryString;
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        AuthenticationRequest request = new AuthenticationRequest();
        request.id = "foobarbaz";
        request.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        if (binding == Binding.HTTP_Redirect) {
            queryString = service.buildRedirectAuthnRequest(request, "Relay-State-String", true, kp.getPrivate(), Algorithm.RS256);
        } else {
            X509Certificate cert = this.generateX509Certificate(kp, "SHA256withRSA");
            queryString = service.buildPostAuthnRequest(request, true, kp.getPrivate(), cert, Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        }
        request = binding == Binding.HTTP_Redirect ? service.parseRequestRedirectBinding(queryString, authRequest -> new TestRedirectBindingSignatureHelper(kp.getPublic(), true)) : service.parseRequestPostBinding(queryString, authRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(kp.getPublic()), true));
        Assert.assertEquals((String)request.id, (String)"foobarbaz");
        Assert.assertEquals((String)request.issuer, (String)"https://local.fusionauth.io");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
    }

    @Test(dataProvider="bindings")
    public void roundTripAuthnRequest_ECDSA(Binding binding) throws Exception {
        String queryString;
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        kpg.initialize(256);
        KeyPair kp = kpg.generateKeyPair();
        AuthenticationRequest request = new AuthenticationRequest();
        request.id = "foobarbaz";
        request.issuer = "https://local.fusionauth.io";
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        if (binding == Binding.HTTP_Redirect) {
            queryString = service.buildRedirectAuthnRequest(request, "Relay-State-String", true, kp.getPrivate(), Algorithm.ES256);
        } else {
            X509Certificate cert = this.generateX509Certificate(kp, "SHA256withECDSA");
            queryString = service.buildPostAuthnRequest(request, true, kp.getPrivate(), cert, Algorithm.ES256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        }
        request = binding == Binding.HTTP_Redirect ? service.parseRequestRedirectBinding(queryString, authRequest -> new TestRedirectBindingSignatureHelper(kp.getPublic(), true)) : service.parseRequestPostBinding(queryString, authRequest -> new TestPostBindingSignatureHelper(KeySelector.singletonKeySelector(kp.getPublic()), true));
        Assert.assertEquals((String)request.id, (String)"foobarbaz");
        Assert.assertEquals((String)request.issuer, (String)"https://local.fusionauth.io");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
    }

    @Test(dataProvider="assertionEncryption")
    public void roundTripResponseEncryptedAssertion(EncryptionAlgorithm encryptionAlgorithm, KeyLocation keyLocation, KeyTransportAlgorithm transportAlgorithm, DigestAlgorithm digest, MaskGenerationFunction mgf) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair signingKeyPair = kpg.generateKeyPair();
        KeyPair encryptionKeyPair = kpg.generateKeyPair();
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String encodedResponse = new String(ba, StandardCharsets.UTF_8);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(encodedResponse, false, null);
        String encodedXML = service.buildAuthnResponse(response, true, signingKeyPair.getPrivate(), CertificateTools.fromKeyPair(signingKeyPair, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Response, true, true, encryptionAlgorithm, keyLocation, transportAlgorithm, CertificateTools.fromKeyPair(encryptionKeyPair, Algorithm.RS256, "FooBar"), digest, mgf);
        AuthenticationResponse parsedResponse = service.parseResponse(encodedXML, true, KeySelector.singletonKeySelector(signingKeyPair.getPublic()), true, encryptionKeyPair.getPrivate());
        Assert.assertEquals((Object)parsedResponse, (Object)response);
        encodedXML = service.buildAuthnResponse(response, true, signingKeyPair.getPrivate(), CertificateTools.fromKeyPair(signingKeyPair, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", SignatureLocation.Assertion, true, true, encryptionAlgorithm, keyLocation, transportAlgorithm, CertificateTools.fromKeyPair(encryptionKeyPair, Algorithm.RS256, "FooBar"), digest, mgf);
        parsedResponse = service.parseResponse(encodedXML, true, KeySelector.singletonKeySelector(signingKeyPair.getPublic()), true, encryptionKeyPair.getPrivate());
        Assert.assertEquals((Object)parsedResponse, (Object)response);
    }

    @Test(dataProvider="signatureLocation")
    public void roundTripResponseFailedRequestSignedAssertion(SignatureLocation signatureLocation, boolean includeKeyInfoInResponse) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse-authnFailed.txt", new String[0]));
        String encodedResponse = new String(ba);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(encodedResponse, false, null);
        String encodedXML = service.buildAuthnResponse(response, true, kp.getPrivate(), CertificateTools.fromKeyPair(kp, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", signatureLocation, includeKeyInfoInResponse);
        response = service.parseResponse(encodedXML, true, (KeySelector)new TestKeySelector(kp.getPublic()));
        Document document = this.parseDocument(encodedXML);
        Node signature = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        Assert.assertEquals((String)signature.getPreviousSibling().getLocalName(), (String)"Issuer");
        Assert.assertEquals((String)signature.getNextSibling().getLocalName(), (String)"Status");
        Assert.assertEquals((String)signature.getParentNode().getLocalName(), (String)"Response");
        Assert.assertEquals((String)response.destination, (String)"https://local.fusionauth.io/samlv2/acs");
        Assert.assertTrue((boolean)response.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((String)response.issuer, (String)"https://acme.com/saml/idp");
        Assert.assertEquals((Object)response.status.code, (Object)ResponseStatus.AuthenticationFailed);
    }

    @Test(dataProvider="signatureLocation")
    public void roundTripResponseSignedAssertion(SignatureLocation signatureLocation, boolean includeKeyInfoInResponse) throws Exception {
        ZonedDateTime expectedAuthnInstant;
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        byte[] ba = Files.readAllBytes(Paths.get("src/test/xml/encodedResponse.txt", new String[0]));
        String encodedResponse = new String(ba);
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        AuthenticationResponse response = service.parseResponse(encodedResponse, false, null);
        response.authnInstant = expectedAuthnInstant = ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(1L);
        String encodedXML = service.buildAuthnResponse(response, true, kp.getPrivate(), CertificateTools.fromKeyPair(kp, Algorithm.RS256, "FooBar"), Algorithm.RS256, "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", signatureLocation, includeKeyInfoInResponse);
        response = service.parseResponse(encodedXML, true, (KeySelector)new TestKeySelector(kp.getPublic()));
        Document document = this.parseDocument(encodedXML);
        Node signature = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        if (signatureLocation == SignatureLocation.Assertion) {
            Assert.assertEquals((String)signature.getPreviousSibling().getLocalName(), (String)"Issuer");
            Assert.assertEquals((String)signature.getNextSibling().getLocalName(), (String)"Subject");
            Assert.assertEquals((String)signature.getParentNode().getLocalName(), (String)"Assertion");
        } else {
            Assert.assertEquals((String)signature.getParentNode().getLocalName(), (String)"Response");
            Assert.assertEquals((String)signature.getPreviousSibling().getLocalName(), (String)"Issuer");
        }
        Assert.assertEquals((Object)response.authnInstant, (Object)SAMLTools.toZonedDateTime((XMLGregorianCalendar)SAMLTools.toXMLGregorianCalendar((ZonedDateTime)expectedAuthnInstant)));
        Assert.assertEquals((String)response.destination, (String)"https://local.fusionauth.io/oauth2/callback");
        Assert.assertTrue((boolean)response.issueInstant.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertEquals((String)response.issuer, (String)"https://sts.windows.net/c2150111-3c44-4508-9f08-790cb4032a23/");
        Assert.assertEquals((Object)response.status.code, (Object)ResponseStatus.Success);
        Assertion assertion = (Assertion)response.assertions.get(0);
        Assert.assertTrue((boolean)assertion.conditions.notBefore.isBefore(ZonedDateTime.now(ZoneOffset.UTC)));
        Assert.assertTrue((boolean)ZonedDateTime.now(ZoneOffset.UTC).isAfter(assertion.conditions.notOnOrAfter));
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.microsoft.com/identity/claims/displayname")).get(0)), (String)"Brian Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname")).get(0)), (String)"Brian");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname")).get(0)), (String)"Pontarelli");
        Assert.assertEquals((String)((String)((List)assertion.attributes.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress")).get(0)), (String)"brian@inversoft.com");
        Assert.assertNotNull((Object)assertion.subject.nameIDs);
        Assert.assertEquals((int)assertion.subject.nameIDs.size(), (int)1);
        Assert.assertEquals((String)((NameID)assertion.subject.nameIDs.get((int)0)).format, (String)NameIDFormat.EmailAddress.toSAMLFormat());
    }

    @DataProvider(name="signatureLocation")
    public Object[][] signatureLocation() {
        return new Object[][]{{SignatureLocation.Assertion, true}, {SignatureLocation.Assertion, false}, {SignatureLocation.Response, true}, {SignatureLocation.Response, false}};
    }

    @Test
    public void unmarshalPerformance() throws Exception {
        String encodedRequest = SAMLTools.encode((byte[])Files.readAllBytes(Paths.get("src/test/xml/authn-request-control.xml", new String[0])));
        DefaultSAMLv2Service service = new DefaultSAMLv2Service();
        long iterations = 5000L;
        long start = System.currentTimeMillis();
        int i = 0;
        while ((long)i < iterations) {
            service.parseRequestPostBinding(encodedRequest, authRequest -> new TestPostBindingSignatureHelper());
            ++i;
        }
        long total = System.currentTimeMillis() - start;
        double avg = total / iterations;
        Assert.assertTrue((avg < 1.0 ? 1 : 0) != 0, (String)("Not fast enough!\nIterations: " + iterations + ", total time: " + total + " ms, avg: " + avg + " ms\n"));
    }

    @Test
    public void variousURLEncoding_SignatureVerification() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        AuthenticationRequest request = new AuthenticationRequest();
        request.id = "foobarbaz";
        request.issuer = "https://local.fusionauth.io";
        MockDefaultSAMLv2Service service = new MockDefaultSAMLv2Service();
        String queryString = service.buildRedirectAuthnRequest(request, "Relay-State-String", true, kp.getPrivate(), Algorithm.RS256);
        request = service.parseRequestRedirectBinding(queryString, authRequest -> new TestRedirectBindingSignatureHelper(kp.getPublic(), true));
        Assert.assertEquals((String)request.id, (String)"foobarbaz");
        Assert.assertEquals((String)request.issuer, (String)"https://local.fusionauth.io");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
        service.lowerCaseURLEncoding = true;
        queryString = service.buildRedirectAuthnRequest(request, "Relay-State-String", true, kp.getPrivate(), Algorithm.RS256);
        request = service.parseRequestRedirectBinding(queryString, authRequest -> new TestRedirectBindingSignatureHelper(kp.getPublic(), true));
        Assert.assertEquals((String)request.id, (String)"foobarbaz");
        Assert.assertEquals((String)request.issuer, (String)"https://local.fusionauth.io");
        Assert.assertEquals((String)request.nameIdFormat, (String)NameIDFormat.EmailAddress.toSAMLFormat());
        Assert.assertEquals((String)request.version, (String)"2.0");
    }

    private X509Certificate generateX509Certificate(KeyPair keyPair, String algorithm) throws IllegalArgumentException {
        try {
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
            X509CertInfo certInfo = new X509CertInfo();
            CertificateX509Key certKey = new CertificateX509Key(keyPair.getPublic());
            certInfo.set("key", certKey);
            certInfo.set("version", new CertificateVersion(1));
            certInfo.set("algorithmID", new CertificateAlgorithmId(new AlgorithmId(ObjectIdentifier.of(KnownOIDs.SHA256withRSA))));
            certInfo.set("issuer", new X500Name("CN=FusionAuth"));
            certInfo.set("subject", new X500Name("CN=FusionAuth"));
            certInfo.set("validity", new CertificateValidity(Date.from(now.toInstant()), Date.from(now.plusYears(10L).toInstant())));
            certInfo.set("serialNumber", new CertificateSerialNumber(new BigInteger(UUID.randomUUID().toString().replace("-", ""), 16)));
            X509CertImpl impl = new X509CertImpl(certInfo);
            impl.sign(keyPair.getPrivate(), algorithm);
            return impl;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void loadAssertionTemplates() throws IOException {
        this.baseXml = Files.readString(Paths.get("src/test/xml/assertion/response-template.xml.txt", new String[0]));
        this.assertionSigned = Files.readString(Paths.get("src/test/xml/assertion/assertion-signed.xml.txt", new String[0]));
        this.assertionUnsigned = Files.readString(Paths.get("src/test/xml/assertion/assertion-unsigned.xml.txt", new String[0]));
        this.encryptedSigned = Files.readString(Paths.get("src/test/xml/assertion/encrypted-signed.xml.txt", new String[0]));
        this.encryptedUnsigned = Files.readString(Paths.get("src/test/xml/assertion/encrypted-unsigned.xml.txt", new String[0]));
    }

    private void loadKeys() throws Exception {
        try (InputStream isSigCert = Files.newInputStream(Paths.get("src/test/certificates/signature-certificate.pem", new String[0]), new OpenOption[0]);
             InputStream isSigKey = Files.newInputStream(Paths.get("src/test/certificates/signature-private-pkcs8.der", new String[0]), new OpenOption[0]);
             InputStream isEncCert = Files.newInputStream(Paths.get("src/test/certificates/encryption-certificate.pem", new String[0]), new OpenOption[0]);
             InputStream isEncKey = Files.newInputStream(Paths.get("src/test/certificates/encryption-private-pkcs8.der", new String[0]), new OpenOption[0]);){
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec sigKeySpec = new PKCS8EncodedKeySpec(isSigKey.readAllBytes());
            PrivateKey sigKey = kf.generatePrivate(sigKeySpec);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate sigCert = cf.generateCertificate(isSigCert);
            this.signingKeyPair = new KeyPair(sigCert.getPublicKey(), sigKey);
            PKCS8EncodedKeySpec encKeySpec = new PKCS8EncodedKeySpec(isEncKey.readAllBytes());
            PrivateKey encKey = kf.generatePrivate(encKeySpec);
            cf = CertificateFactory.getInstance("X.509");
            Certificate encCert = cf.generateCertificate(isEncCert);
            this.encryptionKeyPair = new KeyPair(encCert.getPublicKey(), encKey);
        }
    }

    private Document parseDocument(String encoded) throws ParserConfigurationException {
        byte[] bytes = Base64.getMimeDecoder().decode(encoded);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(bytes));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MockDefaultSAMLv2Service
    extends DefaultSAMLv2Service {
        public boolean lowerCaseURLEncoding = false;

        private MockDefaultSAMLv2Service() {
        }

        protected String urlEncode(String s) {
            if (this.lowerCaseURLEncoding) {
                return URLEncoder.encode(s, StandardCharsets.UTF_8).replace("%2B", "%2b").replace("%2F", "%2f").replace("%3A", "%3a").replace("%3D", "%3d");
            }
            return super.urlEncode(s);
        }
    }
}

