/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.service;

import io.fusionauth.samlv2.domain.Algorithm;
import io.fusionauth.samlv2.domain.AuthenticationRequest;
import io.fusionauth.samlv2.domain.AuthenticationResponse;
import io.fusionauth.samlv2.domain.DigestAlgorithm;
import io.fusionauth.samlv2.domain.EncryptionAlgorithm;
import io.fusionauth.samlv2.domain.KeyLocation;
import io.fusionauth.samlv2.domain.KeyTransportAlgorithm;
import io.fusionauth.samlv2.domain.LogoutRequest;
import io.fusionauth.samlv2.domain.LogoutResponse;
import io.fusionauth.samlv2.domain.MaskGenerationFunction;
import io.fusionauth.samlv2.domain.MetaData;
import io.fusionauth.samlv2.domain.SAMLException;
import io.fusionauth.samlv2.domain.SignatureLocation;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.function.Function;
import javax.xml.crypto.KeySelector;

public interface SAMLv2Service {
    public String buildAuthnResponse(AuthenticationResponse var1, boolean var2, PrivateKey var3, X509Certificate var4, Algorithm var5, String var6, SignatureLocation var7, boolean var8) throws SAMLException;

    public String buildAuthnResponse(AuthenticationResponse var1, boolean var2, PrivateKey var3, X509Certificate var4, Algorithm var5, String var6, SignatureLocation var7, boolean var8, boolean var9, EncryptionAlgorithm var10, KeyLocation var11, KeyTransportAlgorithm var12, X509Certificate var13, DigestAlgorithm var14, MaskGenerationFunction var15) throws SAMLException;

    public String buildMetadataResponse(MetaData var1) throws SAMLException;

    public String buildPostAuthnRequest(AuthenticationRequest var1, boolean var2, PrivateKey var3, X509Certificate var4, Algorithm var5, String var6) throws SAMLException;

    public String buildPostLogoutRequest(LogoutRequest var1, boolean var2, PrivateKey var3, X509Certificate var4, Algorithm var5, String var6) throws SAMLException;

    public String buildPostLogoutResponse(LogoutResponse var1, boolean var2, PrivateKey var3, X509Certificate var4, Algorithm var5, String var6) throws SAMLException;

    public String buildRedirectAuthnRequest(AuthenticationRequest var1, String var2, boolean var3, PrivateKey var4, Algorithm var5) throws SAMLException;

    public String buildRedirectLogoutRequest(LogoutRequest var1, String var2, boolean var3, PrivateKey var4, Algorithm var5) throws SAMLException;

    public String buildRedirectLogoutResponse(LogoutResponse var1, String var2, boolean var3, PrivateKey var4, Algorithm var5) throws SAMLException;

    public LogoutRequest parseLogoutRequestPostBinding(String var1, Function<LogoutRequest, PostBindingSignatureHelper> var2) throws SAMLException;

    public LogoutRequest parseLogoutRequestRedirectBinding(String var1, Function<LogoutRequest, RedirectBindingSignatureHelper> var2) throws SAMLException;

    public LogoutResponse parseLogoutResponsePostBinding(String var1, Function<LogoutResponse, PostBindingSignatureHelper> var2) throws SAMLException;

    public LogoutResponse parseLogoutResponseRedirectBinding(String var1, Function<LogoutResponse, RedirectBindingSignatureHelper> var2) throws SAMLException;

    public MetaData parseMetaData(String var1) throws SAMLException;

    public AuthenticationRequest parseRequestPostBinding(String var1, Function<AuthenticationRequest, PostBindingSignatureHelper> var2) throws SAMLException;

    public AuthenticationRequest parseRequestRedirectBinding(String var1, Function<AuthenticationRequest, RedirectBindingSignatureHelper> var2) throws SAMLException;

    public AuthenticationResponse parseResponse(String var1, boolean var2, KeySelector var3) throws SAMLException;

    public AuthenticationResponse parseResponse(String var1, boolean var2, KeySelector var3, boolean var4, PrivateKey var5) throws SAMLException;

    public static interface RedirectBindingSignatureHelper {
        public PublicKey publicKey();

        public boolean verifySignature();
    }

    public static interface PostBindingSignatureHelper {
        public KeySelector keySelector();

        public boolean verifySignature();
    }
}

