/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.service;

import io.fusionauth.der.DerInputStream;
import io.fusionauth.der.DerValue;
import io.fusionauth.samlv2.domain.Algorithm;
import io.fusionauth.samlv2.domain.Assertion;
import io.fusionauth.samlv2.domain.AuthenticationRequest;
import io.fusionauth.samlv2.domain.AuthenticationResponse;
import io.fusionauth.samlv2.domain.Binding;
import io.fusionauth.samlv2.domain.Conditions;
import io.fusionauth.samlv2.domain.ConfirmationMethod;
import io.fusionauth.samlv2.domain.DigestAlgorithm;
import io.fusionauth.samlv2.domain.EncryptionAlgorithm;
import io.fusionauth.samlv2.domain.KeyLocation;
import io.fusionauth.samlv2.domain.KeyTransportAlgorithm;
import io.fusionauth.samlv2.domain.LogoutRequest;
import io.fusionauth.samlv2.domain.LogoutResponse;
import io.fusionauth.samlv2.domain.MaskGenerationFunction;
import io.fusionauth.samlv2.domain.MetaData;
import io.fusionauth.samlv2.domain.NameID;
import io.fusionauth.samlv2.domain.NameIDFormat;
import io.fusionauth.samlv2.domain.ResponseStatus;
import io.fusionauth.samlv2.domain.SAMLException;
import io.fusionauth.samlv2.domain.SAMLRequest;
import io.fusionauth.samlv2.domain.SignatureLocation;
import io.fusionauth.samlv2.domain.SignatureNotFoundException;
import io.fusionauth.samlv2.domain.Subject;
import io.fusionauth.samlv2.domain.SubjectConfirmation;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.AssertionType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.AttributeStatementType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.AttributeType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.AudienceRestrictionType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.AuthnContextType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.AuthnStatementType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.ConditionAbstractType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.ConditionsType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.EncryptedElementType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.NameIDType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.ObjectFactory;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.StatementAbstractType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.SubjectConfirmationDataType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.SubjectConfirmationType;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.SubjectType;
import io.fusionauth.samlv2.domain.jaxb.oasis.metadata.EndpointType;
import io.fusionauth.samlv2.domain.jaxb.oasis.metadata.EntityDescriptorType;
import io.fusionauth.samlv2.domain.jaxb.oasis.metadata.IDPSSODescriptorType;
import io.fusionauth.samlv2.domain.jaxb.oasis.metadata.IndexedEndpointType;
import io.fusionauth.samlv2.domain.jaxb.oasis.metadata.KeyDescriptorType;
import io.fusionauth.samlv2.domain.jaxb.oasis.metadata.KeyTypes;
import io.fusionauth.samlv2.domain.jaxb.oasis.metadata.RoleDescriptorType;
import io.fusionauth.samlv2.domain.jaxb.oasis.metadata.SPSSODescriptorType;
import io.fusionauth.samlv2.domain.jaxb.oasis.metadata.SSODescriptorType;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.AuthnRequestType;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.LogoutRequestType;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.NameIDPolicyType;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.ResponseType;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.StatusCodeType;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.StatusResponseType;
import io.fusionauth.samlv2.domain.jaxb.oasis.protocol.StatusType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmldsig.DigestMethodType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmldsig.KeyInfoType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmldsig.X509DataType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmlenc.CipherDataType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmlenc.EncryptedDataType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmlenc.EncryptedKeyType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmlenc.EncryptedType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmlenc.EncryptionMethodType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmlenc11.AlgorithmIdentifierType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmlenc11.MGFType;
import io.fusionauth.samlv2.service.SAMLv2Service;
import io.fusionauth.samlv2.util.SAMLRequestParameters;
import io.fusionauth.samlv2.util.SAMLTools;
import jakarta.xml.bind.JAXBElement;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultSAMLv2Service
implements SAMLv2Service {
    static final io.fusionauth.samlv2.domain.jaxb.oasis.protocol.ObjectFactory PROTOCOL_OBJECT_FACTORY = new io.fusionauth.samlv2.domain.jaxb.oasis.protocol.ObjectFactory();
    private static final ObjectFactory ASSERTION_OBJECT_FACTORY = new ObjectFactory();
    private static final io.fusionauth.samlv2.domain.jaxb.w3c.xmldsig.ObjectFactory DSIG_OBJECT_FACTORY = new io.fusionauth.samlv2.domain.jaxb.w3c.xmldsig.ObjectFactory();
    private static final io.fusionauth.samlv2.domain.jaxb.oasis.metadata.ObjectFactory METADATA_OBJECT_FACTORY = new io.fusionauth.samlv2.domain.jaxb.oasis.metadata.ObjectFactory();
    private static final io.fusionauth.samlv2.domain.jaxb.w3c.xmlenc11.ObjectFactory XENC11_OBJECT_FACTORY = new io.fusionauth.samlv2.domain.jaxb.w3c.xmlenc11.ObjectFactory();
    private static final io.fusionauth.samlv2.domain.jaxb.w3c.xmlenc.ObjectFactory XENC_OBJECT_FACTORY = new io.fusionauth.samlv2.domain.jaxb.w3c.xmlenc.ObjectFactory();
    private static final Logger logger = LoggerFactory.getLogger(DefaultSAMLv2Service.class);

    @Override
    public String buildAuthnResponse(AuthenticationResponse authenticationResponse, boolean bl, PrivateKey privateKey, X509Certificate x509Certificate, Algorithm algorithm, String string, SignatureLocation signatureLocation, boolean bl2) throws SAMLException {
        return this.buildAuthnResponse(authenticationResponse, bl, privateKey, x509Certificate, algorithm, string, signatureLocation, bl2, false, null, null, null, null, null, null);
    }

    @Override
    public String buildAuthnResponse(AuthenticationResponse authenticationResponse, boolean bl, PrivateKey privateKey, X509Certificate x509Certificate, Algorithm algorithm, String string, SignatureLocation signatureLocation, boolean bl2, boolean bl3, EncryptionAlgorithm encryptionAlgorithm, KeyLocation keyLocation, KeyTransportAlgorithm keyTransportAlgorithm, X509Certificate x509Certificate2, DigestAlgorithm digestAlgorithm, MaskGenerationFunction maskGenerationFunction) throws SAMLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (authenticationResponse.assertions != null && authenticationResponse.assertions.size() > 1) {
            throw new SAMLException("This library does not currently support building a SAML Response containing multiple assertions.");
        }
        ResponseType responseType = new ResponseType();
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC);
        StatusType statusType = new StatusType();
        statusType.setStatusCode(new StatusCodeType());
        statusType.getStatusCode().setValue(authenticationResponse.status.code.toSAMLFormat());
        statusType.setStatusMessage(authenticationResponse.status.message);
        responseType.setStatus(statusType);
        responseType.setID(authenticationResponse.id);
        responseType.setIssuer(new NameIDType());
        responseType.getIssuer().setValue(authenticationResponse.issuer);
        responseType.setVersion(authenticationResponse.version);
        responseType.setInResponseTo(authenticationResponse.inResponseTo);
        ZonedDateTime zonedDateTime2 = authenticationResponse.issueInstant != null ? authenticationResponse.issueInstant : zonedDateTime;
        responseType.setIssueInstant(SAMLTools.toXMLGregorianCalendar(zonedDateTime2));
        responseType.setDestination(authenticationResponse.destination);
        AssertionType assertionType = new AssertionType();
        if (authenticationResponse.assertions != null && authenticationResponse.status.code == ResponseStatus.Success) {
            object4 = authenticationResponse.assertions.get(0);
            object3 = ((Assertion)object4).id != null ? ((Assertion)object4).id : "_" + UUID.randomUUID();
            assertionType.setID((String)object3);
            assertionType.setIssuer(responseType.getIssuer());
            assertionType.setIssueInstant(SAMLTools.toXMLGregorianCalendar(zonedDateTime));
            assertionType.setVersion(authenticationResponse.version);
            if (((Assertion)object4).subject != null) {
                object2 = new SubjectType();
                if (((Assertion)object4).subject.nameIDs != null) {
                    for (NameID object52 : ((Assertion)object4).subject.nameIDs) {
                        NameIDType nameIDType = new NameIDType();
                        nameIDType.setValue(object52.id);
                        nameIDType.setFormat(object52.format);
                        ((SubjectType)object2).getContent().add(ASSERTION_OBJECT_FACTORY.createNameID(nameIDType));
                    }
                }
                if (((Assertion)object4).subject.subjectConfirmation != null) {
                    object = new SubjectConfirmationDataType();
                    ((SubjectConfirmationDataType)object).setInResponseTo(((Assertion)object4).subject.subjectConfirmation.inResponseTo);
                    ((SubjectConfirmationDataType)object).setNotOnOrAfter(SAMLTools.toXMLGregorianCalendar(((Assertion)object4).subject.subjectConfirmation.notOnOrAfter));
                    ((SubjectConfirmationDataType)object).setRecipient(((Assertion)object4).subject.subjectConfirmation.recipient);
                    SubjectConfirmationType subjectConfirmationType = new SubjectConfirmationType();
                    subjectConfirmationType.setSubjectConfirmationData((SubjectConfirmationDataType)object);
                    if (((Assertion)object4).subject.subjectConfirmation.method != null) {
                        subjectConfirmationType.setMethod(((Assertion)object4).subject.subjectConfirmation.method.toSAMLFormat());
                    }
                    ((SubjectType)object2).getContent().add(ASSERTION_OBJECT_FACTORY.createSubjectConfirmation(subjectConfirmationType));
                }
                assertionType.setSubject((SubjectType)object2);
            }
            if (((Assertion)object4).conditions != null) {
                object2 = new ConditionsType();
                ((ConditionsType)object2).setNotBefore(SAMLTools.toXMLGregorianCalendar(((Assertion)object4).conditions.notBefore));
                ((ConditionsType)object2).setNotOnOrAfter(SAMLTools.toXMLGregorianCalendar(((Assertion)object4).conditions.notOnOrAfter));
                assertionType.setConditions((ConditionsType)object2);
                if (!((Assertion)object4).conditions.audiences.isEmpty()) {
                    object = new AudienceRestrictionType();
                    ((AudienceRestrictionType)object).getAudience().addAll(((Assertion)object4).conditions.audiences);
                    ((ConditionsType)object2).getConditionOrAudienceRestrictionOrOneTimeUse().add((ConditionAbstractType)object);
                }
            }
            object2 = new AttributeStatementType();
            ((Assertion)object4).attributes.forEach((arg_0, arg_1) -> DefaultSAMLv2Service.lambda$buildAuthnResponse$0((AttributeStatementType)object2, arg_0, arg_1));
            assertionType.getStatementOrAuthnStatementOrAuthzDecisionStatement().add((StatementAbstractType)object2);
            object = new AuthnStatementType();
            ZonedDateTime zonedDateTime3 = authenticationResponse.authnInstant != null ? authenticationResponse.authnInstant : zonedDateTime2;
            ((AuthnStatementType)object).setAuthnInstant(SAMLTools.toXMLGregorianCalendar(zonedDateTime3));
            ((AuthnStatementType)object).setAuthnContext(new AuthnContextType());
            ((AuthnStatementType)object).getAuthnContext().getContent().add(ASSERTION_OBJECT_FACTORY.createAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:Password"));
            ((AuthnStatementType)object).setSessionIndex(authenticationResponse.sessionIndex);
            ((AuthnStatementType)object).setSessionNotOnOrAfter(SAMLTools.toXMLGregorianCalendar(authenticationResponse.sessionExpiry));
            assertionType.getStatementOrAuthnStatementOrAuthzDecisionStatement().add((StatementAbstractType)object);
            responseType.getAssertionOrEncryptedAssertion().add(assertionType);
        }
        object4 = SAMLTools.marshallToDocument(PROTOCOL_OBJECT_FACTORY.createResponse(responseType), ResponseType.class);
        if (bl && authenticationResponse.status.code == ResponseStatus.Success && signatureLocation == SignatureLocation.Assertion) {
            try {
                object3 = (Element)object4.getElementsByTagName("Assertion").item(0);
                object2 = object3.getElementsByTagName("Issuer").item(0);
                object = object2.getNextSibling();
                this.signXML(privateKey, x509Certificate, algorithm, string, (Element)object3, (Node)object, bl2);
            }
            catch (Exception exception) {
                throw new SAMLException("Unable to sign XML SAML assertion", exception);
            }
        }
        if (bl3 && authenticationResponse.status.code == ResponseStatus.Success) {
            object4 = this.encryptAssertion((Document)object4, encryptionAlgorithm, keyLocation, keyTransportAlgorithm, x509Certificate2, digestAlgorithm, maskGenerationFunction);
        }
        if (bl && (signatureLocation == SignatureLocation.Response || authenticationResponse.status.code != ResponseStatus.Success)) {
            try {
                object3 = object4.getDocumentElement();
                object2 = this.findSignatureInsertLocation((Element)object3);
                this.signXML(privateKey, x509Certificate, algorithm, string, (Element)object3, (Node)object2, bl2);
            }
            catch (Exception exception) {
                throw new SAMLException("Unable to sign XML SAML response", exception);
            }
        }
        try {
            object3 = SAMLTools.marshallToString((Document)object4);
            return new String(Base64.getEncoder().encode(((String)object3).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (TransformerException transformerException) {
            throw new SAMLException("Unable to marshall the SAML response to XML.", transformerException);
        }
    }

    @Override
    public String buildMetadataResponse(MetaData metaData) throws SAMLException {
        Object object;
        EntityDescriptorType entityDescriptorType = new EntityDescriptorType();
        entityDescriptorType.setID("_" + metaData.id);
        entityDescriptorType.setEntityID(metaData.entityId);
        if (metaData.idp != null) {
            object = new IDPSSODescriptorType();
            ((RoleDescriptorType)object).getProtocolSupportEnumeration().add("urn:oasis:names:tc:SAML:2.0:protocol");
            ((IDPSSODescriptorType)object).setWantAuthnRequestsSigned(metaData.idp.wantAuthnRequestsSigned);
            metaData.idp.redirectBindingSignInEndpoints.forEach(arg_0 -> DefaultSAMLv2Service.lambda$buildMetadataResponse$1((IDPSSODescriptorType)object, arg_0));
            metaData.idp.postBindingSignInEndpoints.forEach(arg_0 -> DefaultSAMLv2Service.lambda$buildMetadataResponse$2((IDPSSODescriptorType)object, arg_0));
            metaData.idp.redirectBindingLogoutEndpoints.forEach(arg_0 -> DefaultSAMLv2Service.lambda$buildMetadataResponse$3((IDPSSODescriptorType)object, arg_0));
            metaData.idp.postBindingLogoutEndpoints.forEach(arg_0 -> DefaultSAMLv2Service.lambda$buildMetadataResponse$4((IDPSSODescriptorType)object, arg_0));
            this.addKeyDescriptors((SSODescriptorType)object, metaData.idp.certificates);
            entityDescriptorType.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor().add((RoleDescriptorType)object);
        }
        if (metaData.sp != null) {
            object = new SPSSODescriptorType();
            ((RoleDescriptorType)object).getProtocolSupportEnumeration().add("urn:oasis:names:tc:SAML:2.0:protocol");
            ((SPSSODescriptorType)object).setAuthnRequestsSigned(metaData.sp.authnRequestsSigned);
            ((SPSSODescriptorType)object).setWantAssertionsSigned(metaData.sp.wantAssertionsSigned);
            if (metaData.sp.acsEndpoint != null) {
                IndexedEndpointType indexedEndpointType = new IndexedEndpointType();
                indexedEndpointType.setBinding(Binding.HTTP_POST.toSAMLFormat());
                indexedEndpointType.setLocation(metaData.sp.acsEndpoint);
                ((SPSSODescriptorType)object).getAssertionConsumerService().add(indexedEndpointType);
            }
            if (metaData.sp.nameIDFormat != null) {
                ((SSODescriptorType)object).getNameIDFormat().add(metaData.sp.nameIDFormat.toSAMLFormat());
            }
            this.addKeyDescriptors((SSODescriptorType)object, metaData.sp.certificates);
            entityDescriptorType.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor().add((RoleDescriptorType)object);
        }
        object = SAMLTools.marshallToBytes(METADATA_OBJECT_FACTORY.createEntityDescriptor(entityDescriptorType), EntityDescriptorType.class);
        return new String((byte[])object, StandardCharsets.UTF_8);
    }

    @Override
    public String buildPostAuthnRequest(AuthenticationRequest authenticationRequest, boolean bl, PrivateKey privateKey, X509Certificate x509Certificate, Algorithm algorithm, String string) throws SAMLException {
        AuthnRequestType authnRequestType = this.toAuthnRequest(authenticationRequest, "2.0");
        return this.buildPostRequest(PROTOCOL_OBJECT_FACTORY.createAuthnRequest(authnRequestType), AuthnRequestType.class, bl, privateKey, x509Certificate, algorithm, string, true);
    }

    @Override
    public String buildPostLogoutRequest(LogoutRequest logoutRequest, boolean bl, PrivateKey privateKey, X509Certificate x509Certificate, Algorithm algorithm, String string) throws SAMLException {
        LogoutRequestType logoutRequestType = this.toLogoutRequest(logoutRequest, "2.0");
        return this.buildPostRequest(PROTOCOL_OBJECT_FACTORY.createLogoutRequest(logoutRequestType), LogoutRequestType.class, bl, privateKey, x509Certificate, algorithm, string, true);
    }

    @Override
    public String buildPostLogoutResponse(LogoutResponse logoutResponse, boolean bl, PrivateKey privateKey, X509Certificate x509Certificate, Algorithm algorithm, String string) throws SAMLException {
        StatusResponseType statusResponseType = this.toLogoutResponse(logoutResponse, "2.0");
        return this.buildPostRequest(PROTOCOL_OBJECT_FACTORY.createLogoutResponse(statusResponseType), StatusResponseType.class, bl, privateKey, x509Certificate, algorithm, string, true);
    }

    @Override
    public String buildRedirectAuthnRequest(AuthenticationRequest authenticationRequest, String string, boolean bl, PrivateKey privateKey, Algorithm algorithm) throws SAMLException {
        AuthnRequestType authnRequestType = this.toAuthnRequest(authenticationRequest, "2.0");
        return this.buildRedirectRequest(PROTOCOL_OBJECT_FACTORY.createAuthnRequest(authnRequestType), AuthnRequestType.class, string, bl, privateKey, algorithm);
    }

    @Override
    public String buildRedirectLogoutRequest(LogoutRequest logoutRequest, String string, boolean bl, PrivateKey privateKey, Algorithm algorithm) throws SAMLException {
        LogoutRequestType logoutRequestType = this.toLogoutRequest(logoutRequest, "2.0");
        return this.buildRedirectRequest(PROTOCOL_OBJECT_FACTORY.createLogoutRequest(logoutRequestType), LogoutRequestType.class, string, bl, privateKey, algorithm);
    }

    @Override
    public String buildRedirectLogoutResponse(LogoutResponse logoutResponse, String string, boolean bl, PrivateKey privateKey, Algorithm algorithm) throws SAMLException {
        StatusResponseType statusResponseType = this.toLogoutResponse(logoutResponse, "2.0");
        return this.buildRedirectResponse(PROTOCOL_OBJECT_FACTORY.createLogoutResponse(statusResponseType), StatusResponseType.class, string, bl, privateKey, algorithm);
    }

    @Override
    public LogoutRequest parseLogoutRequestPostBinding(String string, Function<LogoutRequest, SAMLv2Service.PostBindingSignatureHelper> function) throws SAMLException {
        byte[] byArray = Base64.getMimeDecoder().decode(string);
        LogoutRequestParseResult logoutRequestParseResult = this.parseLogoutRequest(byArray);
        SAMLv2Service.PostBindingSignatureHelper postBindingSignatureHelper = function.apply(logoutRequestParseResult.request);
        if (postBindingSignatureHelper.verifySignature()) {
            this.verifyEmbeddedSignaturesRequired(logoutRequestParseResult.document, postBindingSignatureHelper.keySelector(), logoutRequestParseResult.request);
        }
        return logoutRequestParseResult.request;
    }

    @Override
    public LogoutRequest parseLogoutRequestRedirectBinding(String string, Function<LogoutRequest, SAMLv2Service.RedirectBindingSignatureHelper> function) throws SAMLException {
        SAMLRequestParameters sAMLRequestParameters = SAMLTools.parseQueryString(string);
        LogoutRequestParseResult logoutRequestParseResult = this.parseLogoutRequest(SAMLTools.decodeAndInflate(sAMLRequestParameters.urlDecodedSAMLRequest()));
        SAMLv2Service.RedirectBindingSignatureHelper redirectBindingSignatureHelper = function.apply(logoutRequestParseResult.request);
        if (redirectBindingSignatureHelper.verifySignature()) {
            this.verifyRequestSignature(sAMLRequestParameters, redirectBindingSignatureHelper, logoutRequestParseResult.request);
        }
        return logoutRequestParseResult.request;
    }

    @Override
    public LogoutResponse parseLogoutResponsePostBinding(String string, Function<LogoutResponse, SAMLv2Service.PostBindingSignatureHelper> function) throws SAMLException {
        byte[] byArray = Base64.getMimeDecoder().decode(string);
        LogoutResponseParseResult logoutResponseParseResult = this.parseLogoutResponse(byArray);
        SAMLv2Service.PostBindingSignatureHelper postBindingSignatureHelper = function.apply(logoutResponseParseResult.response);
        if (postBindingSignatureHelper.verifySignature()) {
            this.verifyEmbeddedSignaturesRequired(logoutResponseParseResult.document, postBindingSignatureHelper.keySelector(), logoutResponseParseResult.response);
        }
        return logoutResponseParseResult.response;
    }

    @Override
    public LogoutResponse parseLogoutResponseRedirectBinding(String string, Function<LogoutResponse, SAMLv2Service.RedirectBindingSignatureHelper> function) throws SAMLException {
        SAMLRequestParameters sAMLRequestParameters = SAMLTools.parseQueryString(string);
        LogoutResponseParseResult logoutResponseParseResult = this.parseLogoutResponse(SAMLTools.decodeAndInflate(sAMLRequestParameters.urlDecodedSAMLRequest()));
        SAMLv2Service.RedirectBindingSignatureHelper redirectBindingSignatureHelper = function.apply(logoutResponseParseResult.response);
        if (redirectBindingSignatureHelper.verifySignature()) {
            this.verifyRequestSignature(sAMLRequestParameters, redirectBindingSignatureHelper, logoutResponseParseResult.response);
        }
        return logoutResponseParseResult.response;
    }

    @Override
    public MetaData parseMetaData(String string) throws SAMLException {
        Object object;
        Document document = SAMLTools.newDocumentFromBytes(string.getBytes(StandardCharsets.UTF_8));
        EntityDescriptorType entityDescriptorType = SAMLTools.unmarshallFromDocument(document, EntityDescriptorType.class);
        MetaData metaData = new MetaData();
        metaData.id = entityDescriptorType.getID();
        metaData.entityId = entityDescriptorType.getEntityID();
        List<RoleDescriptorType> list = entityDescriptorType.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor();
        Optional<RoleDescriptorType> optional = list.stream().filter(roleDescriptorType -> roleDescriptorType instanceof IDPSSODescriptorType).findFirst();
        if (optional.isPresent()) {
            object = (IDPSSODescriptorType)optional.get();
            metaData.idp = new MetaData.IDPMetaData();
            for (EndpointType endpointType : ((IDPSSODescriptorType)object).getSingleSignOnService()) {
                if (Binding.HTTP_Redirect.toSAMLFormat().equals(endpointType.getBinding())) {
                    metaData.idp.redirectBindingSignInEndpoints.add(endpointType.getLocation());
                    continue;
                }
                if (!Binding.HTTP_POST.toSAMLFormat().equals(endpointType.getBinding())) continue;
                metaData.idp.postBindingSignInEndpoints.add(endpointType.getLocation());
            }
            for (EndpointType endpointType : ((SSODescriptorType)object).getSingleLogoutService()) {
                if (Binding.HTTP_Redirect.toSAMLFormat().equals(endpointType.getBinding())) {
                    metaData.idp.redirectBindingLogoutEndpoints.add(endpointType.getLocation());
                    continue;
                }
                if (!Binding.HTTP_POST.toSAMLFormat().equals(endpointType.getBinding())) continue;
                metaData.idp.postBindingLogoutEndpoints.add(endpointType.getLocation());
            }
            try {
                metaData.idp.certificates = ((RoleDescriptorType)object).getKeyDescriptor().stream().filter(keyDescriptorType -> keyDescriptorType.getUse() == KeyTypes.SIGNING).map(SAMLTools::toCertificate).filter(Objects::nonNull).collect(Collectors.toList());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAMLException(illegalArgumentException.getCause());
            }
        }
        if (((Optional)(object = list.stream().filter(roleDescriptorType -> roleDescriptorType instanceof SPSSODescriptorType).findFirst())).isPresent()) {
            Iterator<EndpointType> iterator = (SPSSODescriptorType)((Optional)object).get();
            (metaData.sp = new MetaData.SPMetaData()).acsEndpoint = !((SPSSODescriptorType)((Object)iterator)).getAssertionConsumerService().isEmpty() ? ((SPSSODescriptorType)((Object)iterator)).getAssertionConsumerService().get(0).getLocation() : null;
            try {
                metaData.sp.nameIDFormat = !((SSODescriptorType)((Object)iterator)).getNameIDFormat().isEmpty() ? NameIDFormat.fromSAMLFormat(((SSODescriptorType)((Object)iterator)).getNameIDFormat().get(0)) : null;
            }
            catch (Exception exception) {
                throw new SAMLException(exception.getCause());
            }
        }
        return metaData;
    }

    @Override
    public AuthenticationRequest parseRequestPostBinding(String string, Function<AuthenticationRequest, SAMLv2Service.PostBindingSignatureHelper> function) throws SAMLException {
        byte[] byArray = Base64.getMimeDecoder().decode(string);
        AuthnRequestParseResult authnRequestParseResult = this.parseRequest(byArray);
        SAMLv2Service.PostBindingSignatureHelper postBindingSignatureHelper = function.apply(authnRequestParseResult.request);
        if (postBindingSignatureHelper.verifySignature()) {
            this.verifyEmbeddedSignaturesRequired(authnRequestParseResult.document, postBindingSignatureHelper.keySelector(), authnRequestParseResult.request);
        }
        return authnRequestParseResult.request;
    }

    @Override
    public AuthenticationRequest parseRequestRedirectBinding(String string, Function<AuthenticationRequest, SAMLv2Service.RedirectBindingSignatureHelper> function) throws SAMLException {
        SAMLRequestParameters sAMLRequestParameters = SAMLTools.parseQueryString(string);
        AuthnRequestParseResult authnRequestParseResult = this.parseRequest(SAMLTools.decodeAndInflate(sAMLRequestParameters.urlDecodedSAMLRequest()));
        SAMLv2Service.RedirectBindingSignatureHelper redirectBindingSignatureHelper = function.apply(authnRequestParseResult.request);
        if (redirectBindingSignatureHelper.verifySignature()) {
            this.verifyRequestSignature(sAMLRequestParameters, redirectBindingSignatureHelper, authnRequestParseResult.request);
        }
        return authnRequestParseResult.request;
    }

    @Override
    public AuthenticationResponse parseResponse(String string, boolean bl, KeySelector keySelector) throws SAMLException {
        return this.parseResponse(string, bl, keySelector, false, null);
    }

    @Override
    public AuthenticationResponse parseResponse(String string2, boolean bl, KeySelector keySelector, boolean bl2, PrivateKey privateKey) throws SAMLException {
        AuthenticationResponse authenticationResponse = new AuthenticationResponse();
        byte[] byArray = Base64.getMimeDecoder().decode(string2);
        authenticationResponse.rawResponse = new String(byArray, StandardCharsets.UTF_8);
        Document document = SAMLTools.newDocumentFromBytes(byArray);
        Set<String> set = this.checkDuplicateIDs(document.getDocumentElement());
        Set<Object> set2 = new HashSet();
        if (bl) {
            set2 = this.verifyEmbeddedSignatures(document, keySelector, null);
        }
        ResponseType responseType = SAMLTools.unmarshallFromDocument(document, ResponseType.class);
        authenticationResponse.status.code = ResponseStatus.fromSAMLFormat(responseType.getStatus().getStatusCode().getValue());
        authenticationResponse.id = responseType.getID();
        authenticationResponse.inResponseTo = responseType.getInResponseTo();
        authenticationResponse.issuer = responseType.getIssuer() != null ? responseType.getIssuer().getValue() : null;
        authenticationResponse.issueInstant = SAMLTools.toZonedDateTime(responseType.getIssueInstant());
        authenticationResponse.destination = responseType.getDestination();
        authenticationResponse.version = responseType.getVersion();
        boolean bl3 = set2.contains(authenticationResponse.id);
        List<Object> list = responseType.getAssertionOrEncryptedAssertion();
        for (Object object : list) {
            Object object2;
            List<ConditionAbstractType> list2;
            Object object3;
            Object object4;
            Object object5;
            if (object instanceof EncryptedElementType) {
                if (privateKey == null) {
                    logger.warn("SAML response contained encrypted assertion, but no encryption key was provided. It was ignored.");
                    continue;
                }
                object5 = this.decryptAssertion((EncryptedElementType)object, privateKey);
                if (!set.add(((AssertionType)(object = SAMLTools.unmarshallFromDocument((Document)object5, AssertionType.class))).getID())) {
                    throw new SAMLException("Unable to parse SAML v2.0 XML. The document contains duplicate element IDs.");
                }
                if (bl) {
                    object4 = this.verifyEmbeddedSignatures((Document)object5, keySelector, null);
                    if (!bl3 && !object4.contains(((AssertionType)object).getID())) {
                        logger.warn("SAML response contained an encrypted, unsigned assertion when signature verification was requested. It was ignored.");
                        continue;
                    }
                    set2.addAll((Collection<Object>)object4);
                }
            } else if (bl2) {
                logger.warn("Assertion encryption is required, but the SAML response contained an unencrypted assertion. It was ignored.");
                continue;
            }
            object5 = (AssertionType)object;
            if (bl && !bl3 && !set2.contains(((AssertionType)object5).getID())) {
                logger.warn("SAML response contained an unsigned assertion when signature verification was requested. It was ignored.");
                continue;
            }
            object4 = new Assertion();
            ((Assertion)object4).id = ((AssertionType)object5).getID();
            ((Assertion)object4).issuer = ((AssertionType)object5).getIssuer().getValue();
            SubjectType subjectType = ((AssertionType)object5).getSubject();
            if (subjectType != null) {
                ((Assertion)object4).subject = new Subject();
                object3 = subjectType.getContent();
                list2 = object3.iterator();
                while (list2.hasNext()) {
                    JAXBElement jAXBElement = (JAXBElement)list2.next();
                    Class clazz = jAXBElement.getDeclaredType();
                    if (clazz == NameIDType.class) {
                        if (((Assertion)object4).subject.nameIDs == null) {
                            ((Assertion)object4).subject.nameIDs = new ArrayList<NameID>();
                        }
                        ((Assertion)object4).subject.nameIDs.add(SAMLTools.parseNameId((NameIDType)jAXBElement.getValue()));
                        continue;
                    }
                    if (clazz == SubjectConfirmationType.class) {
                        ((Assertion)object4).subject.subjectConfirmation = this.parseConfirmation((SubjectConfirmationType)jAXBElement.getValue());
                        continue;
                    }
                    if (clazz != EncryptedElementType.class) continue;
                    throw new SAMLException("This library currently doesn't handle encrypted assertions");
                }
            }
            if ((object3 = ((AssertionType)object5).getConditions()) != null) {
                ((Assertion)object4).conditions = new Conditions();
                ((Assertion)object4).conditions.notBefore = SAMLTools.convertToZonedDateTime(((ConditionsType)object3).getNotBefore());
                ((Assertion)object4).conditions.notOnOrAfter = SAMLTools.convertToZonedDateTime(((ConditionsType)object3).getNotOnOrAfter());
                list2 = ((ConditionsType)object3).getConditionOrAudienceRestrictionOrOneTimeUse();
                for (ConditionAbstractType conditionAbstractType : list2) {
                    if (!(conditionAbstractType instanceof AudienceRestrictionType)) continue;
                    object2 = (AudienceRestrictionType)conditionAbstractType;
                    ((Assertion)object4).conditions.audiences.addAll(((AudienceRestrictionType)object2).getAudience());
                }
            }
            list2 = ((AssertionType)object5).getStatementOrAuthnStatementOrAuthzDecisionStatement();
            for (StatementAbstractType statementAbstractType : list2) {
                if (statementAbstractType instanceof AttributeStatementType) {
                    object2 = (AttributeStatementType)statementAbstractType;
                    List<Object> list3 = ((AttributeStatementType)object2).getAttributeOrEncryptedAttribute();
                    for (Object object6 : list3) {
                        if (object6 instanceof AttributeType) {
                            AttributeType attributeType = (AttributeType)object6;
                            String string3 = attributeType.getName();
                            List<Object> list4 = attributeType.getAttributeValue();
                            List<String> list5 = list4.stream().map(SAMLTools::attributeToString).toList();
                            ((Assertion)object4).attributes.computeIfAbsent(string3, string -> new ArrayList()).addAll(list5);
                            continue;
                        }
                        throw new SAMLException("This library currently doesn't support encrypted attributes");
                    }
                    continue;
                }
                if (!(statementAbstractType instanceof AuthnStatementType)) continue;
                AuthnStatementType authnStatementType = (AuthnStatementType)statementAbstractType;
                authenticationResponse.authnInstant = SAMLTools.toZonedDateTime(authnStatementType.getAuthnInstant());
            }
            authenticationResponse.assertions.add((Assertion)object4);
        }
        if (bl && set2.isEmpty()) {
            throw new SignatureNotFoundException("Invalid SAML v2.0 operation. The signature is missing from the XML but is required.");
        }
        return authenticationResponse;
    }

    protected String urlEncode(String string) {
        return URLEncoder.encode(string, StandardCharsets.UTF_8);
    }

    <T> String buildPostRequest(JAXBElement<T> jAXBElement, Class<T> clazz, boolean bl, PrivateKey privateKey, X509Certificate x509Certificate, Algorithm algorithm, String string, boolean bl2) throws SAMLException {
        Object object;
        Document document = SAMLTools.marshallToDocument(jAXBElement, clazz);
        if (bl) {
            try {
                object = document.getDocumentElement();
                Node node = this.findSignatureInsertLocation((Element)object);
                this.signXML(privateKey, x509Certificate, algorithm, string, (Element)object, node, bl2);
            }
            catch (Exception exception) {
                throw new SAMLException("Unable to sign XML SAML request", exception);
            }
        }
        try {
            object = SAMLTools.marshallToString(document);
            return new String(Base64.getEncoder().encode(((String)object).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            throw new SAMLException("Unable to marshall the SAML request to XML", exception);
        }
    }

    <T> String buildRedirect(JAXBElement<T> jAXBElement, Class<T> clazz, String string, boolean bl, PrivateKey privateKey, Algorithm algorithm, String string2) throws SAMLException {
        try {
            byte[] byArray = SAMLTools.marshallToBytes(jAXBElement, clazz);
            String string3 = SAMLTools.deflateAndEncode(byArray);
            String string4 = string2 + "=" + this.urlEncode(string3);
            if (string != null) {
                string4 = string4 + "&RelayState=" + this.urlEncode(string);
            }
            if (bl && privateKey != null && algorithm != null) {
                string4 = string4 + "&SigAlg=" + this.urlEncode(algorithm.uri);
                Signature signature = Signature.getInstance(algorithm.name);
                signature.initSign(privateKey);
                signature.update(string4.getBytes(StandardCharsets.UTF_8));
                String string5 = new String(Base64.getEncoder().encode(signature.sign()), StandardCharsets.UTF_8);
                string4 = string4 + "&Signature=" + this.urlEncode(string5);
            }
            return string4;
        }
        catch (Exception exception) {
            throw new SAMLException(exception);
        }
    }

    <T> String buildRedirectRequest(JAXBElement<T> jAXBElement, Class<T> clazz, String string, boolean bl, PrivateKey privateKey, Algorithm algorithm) throws SAMLException {
        return this.buildRedirect(jAXBElement, clazz, string, bl, privateKey, algorithm, "SAMLRequest");
    }

    <T> String buildRedirectResponse(JAXBElement<T> jAXBElement, Class<T> clazz, String string, boolean bl, PrivateKey privateKey, Algorithm algorithm) throws SAMLException {
        return this.buildRedirect(jAXBElement, clazz, string, bl, privateKey, algorithm, "SAMLResponse");
    }

    AuthnRequestType toAuthnRequest(AuthenticationRequest authenticationRequest, String string) throws SAMLException {
        AuthnRequestType authnRequestType = new AuthnRequestType();
        authnRequestType.setAssertionConsumerServiceURL(authenticationRequest.acsURL);
        authnRequestType.setForceAuthn(authenticationRequest.forceAuthn);
        authnRequestType.setDestination(authenticationRequest.destination);
        authnRequestType.setIssuer(new NameIDType());
        authnRequestType.getIssuer().setValue(authenticationRequest.issuer);
        authnRequestType.setNameIDPolicy(new NameIDPolicyType());
        authnRequestType.getNameIDPolicy().setFormat(authenticationRequest.nameIdFormat != null ? authenticationRequest.nameIdFormat : NameIDFormat.EmailAddress.toSAMLFormat());
        if (authenticationRequest.allowCreate != null) {
            authnRequestType.getNameIDPolicy().setAllowCreate(authenticationRequest.allowCreate);
        }
        authnRequestType.setID(authenticationRequest.id);
        authnRequestType.setVersion(string);
        authnRequestType.setIssueInstant(SAMLTools.toXMLGregorianCalendar(ZonedDateTime.now(ZoneOffset.UTC)));
        return authnRequestType;
    }

    LogoutRequestType toLogoutRequest(LogoutRequest logoutRequest, String string) throws SAMLException {
        LogoutRequestType logoutRequestType = new LogoutRequestType();
        logoutRequestType.setDestination(logoutRequest.destination);
        logoutRequestType.setIssuer(new NameIDType());
        logoutRequestType.getIssuer().setValue(logoutRequest.issuer);
        logoutRequestType.setNameID(new NameIDType());
        logoutRequestType.getNameID().setFormat(NameIDFormat.EmailAddress.toSAMLFormat());
        logoutRequestType.setID(logoutRequest.id);
        logoutRequestType.getSessionIndex().add(logoutRequest.sessionIndex);
        logoutRequestType.setVersion(string);
        logoutRequestType.setIssueInstant(SAMLTools.toXMLGregorianCalendar(ZonedDateTime.now(ZoneOffset.UTC)));
        return logoutRequestType;
    }

    StatusResponseType toLogoutResponse(LogoutResponse logoutResponse, String string) throws SAMLException {
        StatusResponseType statusResponseType = new StatusResponseType();
        statusResponseType.setDestination(logoutResponse.destination);
        statusResponseType.setIssuer(new NameIDType());
        statusResponseType.getIssuer().setValue(logoutResponse.issuer);
        statusResponseType.setID(logoutResponse.id);
        statusResponseType.setVersion(string);
        statusResponseType.setInResponseTo(logoutResponse.inResponseTo);
        statusResponseType.setIssueInstant(SAMLTools.toXMLGregorianCalendar(ZonedDateTime.now(ZoneOffset.UTC)));
        StatusType statusType = new StatusType();
        statusType.setStatusCode(new StatusCodeType());
        statusType.getStatusCode().setValue(logoutResponse.status.code.toSAMLFormat());
        statusType.setStatusMessage(logoutResponse.status.message);
        statusResponseType.setStatus(statusType);
        return statusResponseType;
    }

    private void addKeyDescriptors(SSODescriptorType sSODescriptorType, List<Certificate> list) {
        list.forEach(certificate -> {
            KeyDescriptorType keyDescriptorType = new KeyDescriptorType();
            keyDescriptorType.setUse(KeyTypes.SIGNING);
            KeyInfoType keyInfoType = new KeyInfoType();
            keyDescriptorType.setKeyInfo(keyInfoType);
            X509DataType x509DataType = new X509DataType();
            keyInfoType.getContent().add(DSIG_OBJECT_FACTORY.createX509Data(x509DataType));
            try {
                JAXBElement<byte[]> jAXBElement = DSIG_OBJECT_FACTORY.createX509DataTypeX509Certificate(certificate.getEncoded());
                x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(jAXBElement);
                sSODescriptorType.getKeyDescriptor().add(keyDescriptorType);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        });
    }

    private EncryptedElementType buildEncryptedAssertion(EncryptionAlgorithm encryptionAlgorithm, byte[] byArray, EncryptedKeyType encryptedKeyType, KeyLocation keyLocation) {
        EncryptedDataType encryptedDataType = new EncryptedDataType();
        encryptedDataType.setType("http://www.w3.org/2001/04/xmlenc#Element");
        EncryptionMethodType encryptionMethodType = new EncryptionMethodType();
        encryptionMethodType.setAlgorithm(encryptionAlgorithm.uri);
        encryptedDataType.setEncryptionMethod(encryptionMethodType);
        CipherDataType cipherDataType = new CipherDataType();
        cipherDataType.setCipherValue(byArray);
        encryptedDataType.setCipherData(cipherDataType);
        EncryptedElementType encryptedElementType = new EncryptedElementType();
        encryptedElementType.setEncryptedData(encryptedDataType);
        if (keyLocation == KeyLocation.Child) {
            KeyInfoType keyInfoType = new KeyInfoType();
            keyInfoType.getContent().add(XENC_OBJECT_FACTORY.createEncryptedKey(encryptedKeyType));
            encryptedDataType.setKeyInfo(keyInfoType);
        } else {
            encryptedElementType.getEncryptedKey().add(encryptedKeyType);
        }
        return encryptedElementType;
    }

    private EncryptedKeyType buildEncryptedKey(byte[] byArray, KeyTransportAlgorithm keyTransportAlgorithm, DigestAlgorithm digestAlgorithm, MaskGenerationFunction maskGenerationFunction) throws SAMLException {
        Object object;
        Object object2;
        EncryptionMethodType encryptionMethodType = new EncryptionMethodType();
        encryptionMethodType.setAlgorithm(keyTransportAlgorithm.uri);
        if (keyTransportAlgorithm != KeyTransportAlgorithm.RSAv15) {
            object2 = new DigestMethodType();
            ((DigestMethodType)object2).setAlgorithm(digestAlgorithm.uri);
            object = SAMLTools.marshallToDocument(DSIG_OBJECT_FACTORY.createDigestMethod((DigestMethodType)object2), DigestMethodType.class);
            encryptionMethodType.getContent().add(object.getDocumentElement());
            if (keyTransportAlgorithm == KeyTransportAlgorithm.RSA_OAEP) {
                MGFType mGFType = new MGFType();
                mGFType.setAlgorithm(maskGenerationFunction.uri);
                Document document = SAMLTools.marshallToDocument(XENC11_OBJECT_FACTORY.createMGF(mGFType), MGFType.class);
                encryptionMethodType.getContent().add(document.getDocumentElement());
            }
        }
        object2 = new CipherDataType();
        ((CipherDataType)object2).setCipherValue(byArray);
        object = new EncryptedKeyType();
        ((EncryptedType)object).setEncryptionMethod(encryptionMethodType);
        ((EncryptedType)object).setCipherData((CipherDataType)object2);
        return object;
    }

    private Set<String> checkDuplicateIDs(Element element) throws SAMLException {
        HashSet<String> hashSet = new HashSet<String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!attr.getLocalName().equalsIgnoreCase("id") || hashSet.add(attr.getValue())) continue;
            throw new SAMLException("Unable to parse SAML v2.0 XML. The document contains duplicate element IDs.");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Set<String> set = this.checkDuplicateIDs((Element)node);
            for (String string : set) {
                if (hashSet.add(string)) continue;
                throw new SAMLException("Unable to parse SAML v2.0 XML. The document contains duplicate element IDs.");
            }
        }
        return hashSet;
    }

    private void checkFor_CVE_2022_21449(SAMLRequest sAMLRequest, byte[] byArray) throws SAMLException {
        byte[] byArray2;
        byte[] byArray3;
        if (byArray.length == 0) {
            return;
        }
        if (byArray[0] == 48 && byArray[1] == byArray.length - 2) {
            try {
                DerValue[] derValueArray = new DerInputStream(byArray).getSequence();
                if (derValueArray.length != 2) {
                    return;
                }
                byArray3 = derValueArray[0].toByteArray();
                byArray2 = derValueArray[1].toByteArray();
            }
            catch (Exception exception) {
                throw new SAMLException("Invalid SAML v2.0 operation. The signature is invalid.", sAMLRequest, exception);
            }
        } else {
            int n = byArray.length / 2;
            byArray3 = Arrays.copyOfRange(byArray, 0, n);
            byArray2 = Arrays.copyOfRange(byArray, n, byArray.length);
        }
        boolean bl = false;
        boolean bl2 = false;
        for (byte by : byArray3) {
            boolean bl3 = bl = by != 0;
            if (bl) break;
        }
        for (byte by : byArray2) {
            boolean bl4 = bl2 = by != 0;
            if (bl2) break;
        }
        if (!bl || !bl2) {
            throw new SAMLException("Invalid SAML v2.0 operation. The signature is invalid.", sAMLRequest);
        }
    }

    private AlgorithmParameterSpec createAlgorithmParameterSpec(EncryptionAlgorithm encryptionAlgorithm, byte[] byArray) {
        if (List.of(EncryptionAlgorithm.AES128GCM, EncryptionAlgorithm.AES192GCM, EncryptionAlgorithm.AES256GCM).contains((Object)encryptionAlgorithm)) {
            return new GCMParameterSpec(128, byArray);
        }
        return new IvParameterSpec(byArray);
    }

    private Document decryptAssertion(EncryptedElementType encryptedElementType, PrivateKey privateKey) throws SAMLException {
        byte[] byArray;
        Key key;
        EncryptedKeyType encryptedKeyType = this.extractEncryptedAssertionEncryptionKey(encryptedElementType);
        if (encryptedKeyType == null) {
            throw new SAMLException("Unable to extract the encrypted symmetric key from the encrypted XML element.");
        }
        String string = encryptedElementType.getEncryptedData().getEncryptionMethod().getAlgorithm();
        EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.fromURI(string);
        if (encryptionAlgorithm == null) {
            throw new SAMLException("Unable to determine assertion encryption algorithm from URI [" + string + "]");
        }
        try {
            key = this.decryptKey(encryptedKeyType, privateKey, encryptionAlgorithm);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SAMLException("Unable to decrypt symmetric key using transport key", generalSecurityException);
        }
        try {
            byArray = this.decryptElement(encryptedElementType.getEncryptedData().getCipherData().getCipherValue(), encryptionAlgorithm, key);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SAMLException("Unable to decrypt assertion using symmetric key", generalSecurityException);
        }
        return SAMLTools.newDocumentFromBytes(byArray);
    }

    private byte[] decryptElement(byte[] byArray, EncryptionAlgorithm encryptionAlgorithm, Key key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, encryptionAlgorithm.ivLength);
        byte[] byArray3 = Arrays.copyOfRange(byArray, encryptionAlgorithm.ivLength, byArray.length);
        AlgorithmParameterSpec algorithmParameterSpec = this.createAlgorithmParameterSpec(encryptionAlgorithm, byArray2);
        Cipher cipher = Cipher.getInstance(encryptionAlgorithm.transformation);
        cipher.init(2, key, algorithmParameterSpec);
        return cipher.doFinal(byArray3);
    }

    private Key decryptKey(EncryptedKeyType encryptedKeyType, PrivateKey privateKey, EncryptionAlgorithm encryptionAlgorithm) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, SAMLException {
        Object object;
        Object object2;
        EncryptionMethodType encryptionMethodType = encryptedKeyType.getEncryptionMethod();
        String string = encryptionMethodType.getAlgorithm();
        KeyTransportAlgorithm keyTransportAlgorithm = KeyTransportAlgorithm.fromURI(string);
        if (keyTransportAlgorithm == null) {
            throw new SAMLException("Unable to determine key transport encryption algorithm from URI [" + string + "]");
        }
        Cipher cipher = Cipher.getInstance(keyTransportAlgorithm.transformation);
        if (keyTransportAlgorithm == KeyTransportAlgorithm.RSAv15) {
            cipher.init(2, privateKey);
        } else {
            Object object3;
            Object object42;
            object2 = null;
            object = null;
            for (Object object42 : encryptionMethodType.getContent()) {
                if (object42 instanceof JAXBElement) {
                    Object object5;
                    object3 = (JAXBElement)object42;
                    if (object3.getDeclaredType() == DigestMethodType.class) {
                        object5 = (DigestMethodType)object3.getValue();
                        object2 = ((DigestMethodType)object5).getAlgorithm();
                        continue;
                    }
                    if (object3.getDeclaredType() != MGFType.class) continue;
                    object5 = (MGFType)object3.getValue();
                    object = ((AlgorithmIdentifierType)object5).getAlgorithm();
                    continue;
                }
                if (!(object42 instanceof Element)) continue;
                object3 = (Element)object42;
                if (object3.getTagName().equals("DigestMethod")) {
                    object2 = object3.getAttribute("Algorithm");
                    continue;
                }
                if (!object3.getTagName().equals("MGF")) continue;
                object = object3.getAttribute("Algorithm");
            }
            Object object6 = DigestAlgorithm.fromURI((String)object2);
            object42 = MaskGenerationFunction.fromURI((String)object);
            if (keyTransportAlgorithm == KeyTransportAlgorithm.RSA_OAEP_MGF1P) {
                object42 = MaskGenerationFunction.MGF1_SHA1;
            }
            if (object6 == null) {
                if (object2 == null) {
                    object6 = DigestAlgorithm.SHA1;
                } else {
                    throw new SAMLException("Unable to determine digest algorithm from URI [" + (String)object2 + "]");
                }
            }
            if (object42 == null) {
                if (object == null) {
                    object42 = MaskGenerationFunction.MGF1_SHA1;
                } else {
                    throw new SAMLException("Unable to determine mask generation function from URI [" + (String)object + "]");
                }
            }
            object3 = new OAEPParameterSpec(((DigestAlgorithm)((Object)object6)).digest, "MGF1", new MGF1ParameterSpec(((MaskGenerationFunction)((Object)object42)).digest), PSource.PSpecified.DEFAULT);
            cipher.init(2, (Key)privateKey, (AlgorithmParameterSpec)object3);
        }
        object2 = encryptedKeyType.getCipherData().getCipherValue();
        object = cipher.doFinal((byte[])object2);
        if (encryptionAlgorithm == EncryptionAlgorithm.TripleDES) {
            return SecretKeyFactory.getInstance("DESede").generateSecret(new DESedeKeySpec((byte[])object));
        }
        return new SecretKeySpec((byte[])object, 0, ((byte[])object).length, "AES");
    }

    private Document encryptAssertion(Document document, EncryptionAlgorithm encryptionAlgorithm, KeyLocation keyLocation, KeyTransportAlgorithm keyTransportAlgorithm, X509Certificate x509Certificate, DigestAlgorithm digestAlgorithm, MaskGenerationFunction maskGenerationFunction) throws SAMLException {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        Key key;
        String string;
        Element element = (Element)document.getElementsByTagName("Assertion").item(0);
        try {
            string = SAMLTools.marshallToString(element);
        }
        catch (TransformerException transformerException) {
            throw new SAMLException("Unable to marshall the element to XML.", transformerException);
        }
        try {
            key = this.generateAssertionEncryptionKey(encryptionAlgorithm);
            byArray3 = this.generateIV(encryptionAlgorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SAMLException("Unable to generate symmetric key encryption parameters for assertion encryption", noSuchAlgorithmException);
        }
        try {
            byArray2 = this.encryptElement(string, encryptionAlgorithm, key, byArray3);
        }
        catch (Exception exception) {
            throw new SAMLException("Unable to encrypt assertion using symmetric key", exception);
        }
        try {
            byArray = this.encryptKey(key, keyTransportAlgorithm, x509Certificate, digestAlgorithm, maskGenerationFunction);
        }
        catch (Exception exception) {
            throw new SAMLException("Unable to encrypt symmetric key for transport", exception);
        }
        EncryptedKeyType encryptedKeyType = this.buildEncryptedKey(byArray, keyTransportAlgorithm, digestAlgorithm, maskGenerationFunction);
        EncryptedElementType encryptedElementType = this.buildEncryptedAssertion(encryptionAlgorithm, byArray2, encryptedKeyType, keyLocation);
        ResponseType responseType = SAMLTools.unmarshallFromDocument(document, ResponseType.class);
        responseType.getAssertionOrEncryptedAssertion().clear();
        responseType.getAssertionOrEncryptedAssertion().add(encryptedElementType);
        return SAMLTools.marshallToDocument(PROTOCOL_OBJECT_FACTORY.createResponse(responseType), ResponseType.class);
    }

    private byte[] encryptElement(String string, EncryptionAlgorithm encryptionAlgorithm, Key key, byte[] byArray) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        AlgorithmParameterSpec algorithmParameterSpec = this.createAlgorithmParameterSpec(encryptionAlgorithm, byArray);
        Cipher cipher = Cipher.getInstance(encryptionAlgorithm.transformation);
        cipher.init(1, key, algorithmParameterSpec);
        byte[] byArray2 = cipher.doFinal(string.getBytes(StandardCharsets.UTF_8));
        return ByteBuffer.allocate(byArray.length + byArray2.length).put(byArray).put(byArray2).array();
    }

    private byte[] encryptKey(Key key, KeyTransportAlgorithm keyTransportAlgorithm, X509Certificate x509Certificate, DigestAlgorithm digestAlgorithm, MaskGenerationFunction maskGenerationFunction) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(keyTransportAlgorithm.transformation);
        if (keyTransportAlgorithm == KeyTransportAlgorithm.RSAv15) {
            cipher.init(1, x509Certificate.getPublicKey());
        } else {
            OAEPParameterSpec oAEPParameterSpec = new OAEPParameterSpec(digestAlgorithm.digest, "MGF1", new MGF1ParameterSpec(keyTransportAlgorithm == KeyTransportAlgorithm.RSA_OAEP_MGF1P ? "SHA-1" : maskGenerationFunction.digest), PSource.PSpecified.DEFAULT);
            cipher.init(1, (Key)x509Certificate.getPublicKey(), oAEPParameterSpec);
        }
        return cipher.doFinal(key.getEncoded());
    }

    private EncryptedKeyType extractEncryptedAssertionEncryptionKey(EncryptedElementType encryptedElementType) {
        EncryptedDataType encryptedDataType = encryptedElementType.getEncryptedData();
        EncryptedKeyType encryptedKeyType = null;
        List<EncryptedKeyType> list = encryptedElementType.getEncryptedKey();
        if (!list.isEmpty()) {
            encryptedKeyType = list.get(0);
        } else {
            List<Object> list2;
            KeyInfoType keyInfoType = encryptedDataType.getKeyInfo();
            if (keyInfoType != null && !(list2 = keyInfoType.getContent()).isEmpty()) {
                JAXBElement jAXBElement = (JAXBElement)list2.get(0);
                encryptedKeyType = (EncryptedKeyType)jAXBElement.getValue();
            }
        }
        return encryptedKeyType;
    }

    private Node findSignatureInsertLocation(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            return node.getLocalName().equals("Issuer") ? node.getNextSibling() : node;
        }
        return null;
    }

    private void fixIDs(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!attr.getLocalName().equalsIgnoreCase("id")) continue;
            element.setIdAttributeNode(attr, true);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.fixIDs((Element)node);
        }
    }

    private Key generateAssertionEncryptionKey(EncryptionAlgorithm encryptionAlgorithm) throws NoSuchAlgorithmException {
        switch (encryptionAlgorithm) {
            case TripleDES: {
                return KeyGenerator.getInstance("DESede").generateKey();
            }
            case AES128: 
            case AES128GCM: {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(128);
                return keyGenerator.generateKey();
            }
            case AES192: 
            case AES192GCM: {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(192);
                return keyGenerator.generateKey();
            }
            case AES256: 
            case AES256GCM: {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(256);
                return keyGenerator.generateKey();
            }
        }
        throw new NoSuchAlgorithmException("Requested key for unsupported algorithm " + encryptionAlgorithm);
    }

    private byte[] generateIV(EncryptionAlgorithm encryptionAlgorithm) {
        byte[] byArray = new byte[encryptionAlgorithm.ivLength];
        new SecureRandom().nextBytes(byArray);
        return byArray;
    }

    private SubjectConfirmation parseConfirmation(SubjectConfirmationType subjectConfirmationType) {
        SubjectConfirmation subjectConfirmation = new SubjectConfirmation();
        SubjectConfirmationDataType subjectConfirmationDataType = subjectConfirmationType.getSubjectConfirmationData();
        if (subjectConfirmationDataType != null) {
            subjectConfirmation.address = subjectConfirmationDataType.getAddress();
            subjectConfirmation.inResponseTo = subjectConfirmationDataType.getInResponseTo();
            subjectConfirmation.notOnOrAfter = SAMLTools.toZonedDateTime(subjectConfirmationDataType.getNotOnOrAfter());
            subjectConfirmation.recipient = subjectConfirmationDataType.getRecipient();
        }
        subjectConfirmation.method = ConfirmationMethod.fromSAMLFormat(subjectConfirmationType.getMethod());
        return subjectConfirmation;
    }

    private LogoutRequestParseResult parseLogoutRequest(byte[] byArray) throws SAMLException {
        String string = new String(byArray, StandardCharsets.UTF_8);
        if (logger.isDebugEnabled()) {
            logger.debug("SAMLRequest XML is\n{}", (Object)string);
        }
        LogoutRequestParseResult logoutRequestParseResult = new LogoutRequestParseResult();
        logoutRequestParseResult.document = SAMLTools.newDocumentFromBytes(byArray);
        logoutRequestParseResult.logoutRequest = SAMLTools.unmarshallFromDocument(logoutRequestParseResult.document, LogoutRequestType.class);
        logoutRequestParseResult.request = new LogoutRequest();
        logoutRequestParseResult.request.xml = string;
        logoutRequestParseResult.request.id = logoutRequestParseResult.logoutRequest.getID();
        logoutRequestParseResult.request.issuer = logoutRequestParseResult.logoutRequest.getIssuer().getValue();
        logoutRequestParseResult.request.issueInstant = logoutRequestParseResult.logoutRequest.getIssueInstant().toGregorianCalendar().toZonedDateTime();
        NameIDType nameIDType = logoutRequestParseResult.logoutRequest.getNameID();
        logoutRequestParseResult.request.nameIdFormat = nameIDType == null ? NameIDFormat.EmailAddress.toSAMLFormat() : nameIDType.getFormat();
        List<String> list = logoutRequestParseResult.logoutRequest.getSessionIndex();
        logoutRequestParseResult.request.sessionIndex = list.isEmpty() ? null : list.get(0);
        logoutRequestParseResult.request.version = logoutRequestParseResult.logoutRequest.getVersion();
        return logoutRequestParseResult;
    }

    private LogoutResponseParseResult parseLogoutResponse(byte[] byArray) throws SAMLException {
        String string = new String(byArray, StandardCharsets.UTF_8);
        if (logger.isDebugEnabled()) {
            logger.debug("SAMLRequest XML is\n{}", (Object)string);
        }
        LogoutResponseParseResult logoutResponseParseResult = new LogoutResponseParseResult();
        logoutResponseParseResult.document = SAMLTools.newDocumentFromBytes(byArray);
        logoutResponseParseResult.logoutResponse = SAMLTools.unmarshallFromDocument(logoutResponseParseResult.document, StatusResponseType.class);
        logoutResponseParseResult.response = new LogoutResponse();
        logoutResponseParseResult.response.xml = string;
        logoutResponseParseResult.response.id = logoutResponseParseResult.logoutResponse.getID();
        logoutResponseParseResult.response.issuer = logoutResponseParseResult.logoutResponse.getIssuer().getValue();
        logoutResponseParseResult.response.issueInstant = logoutResponseParseResult.logoutResponse.getIssueInstant().toGregorianCalendar().toZonedDateTime();
        logoutResponseParseResult.response.version = logoutResponseParseResult.logoutResponse.getVersion();
        return logoutResponseParseResult;
    }

    private AuthnRequestParseResult parseRequest(byte[] byArray) throws SAMLException {
        String string = new String(byArray, StandardCharsets.UTF_8);
        if (logger.isDebugEnabled()) {
            logger.debug("SAMLRequest XML is\n{}", (Object)string);
        }
        AuthnRequestParseResult authnRequestParseResult = new AuthnRequestParseResult();
        authnRequestParseResult.document = SAMLTools.newDocumentFromBytes(byArray);
        authnRequestParseResult.authnRequest = SAMLTools.unmarshallFromDocument(authnRequestParseResult.document, AuthnRequestType.class);
        authnRequestParseResult.request = new AuthenticationRequest();
        authnRequestParseResult.request.acsURL = authnRequestParseResult.authnRequest.getAssertionConsumerServiceURL();
        authnRequestParseResult.request.forceAuthn = authnRequestParseResult.authnRequest.isForceAuthn();
        authnRequestParseResult.request.id = authnRequestParseResult.authnRequest.getID();
        authnRequestParseResult.request.issuer = authnRequestParseResult.authnRequest.getIssuer().getValue();
        authnRequestParseResult.request.issueInstant = authnRequestParseResult.authnRequest.getIssueInstant().toGregorianCalendar().toZonedDateTime();
        NameIDPolicyType nameIDPolicyType = authnRequestParseResult.authnRequest.getNameIDPolicy();
        authnRequestParseResult.request.nameIdFormat = nameIDPolicyType == null ? NameIDFormat.EmailAddress.toSAMLFormat() : nameIDPolicyType.getFormat();
        authnRequestParseResult.request.version = authnRequestParseResult.authnRequest.getVersion();
        authnRequestParseResult.request.xml = string;
        return authnRequestParseResult;
    }

    private void signXML(PrivateKey privateKey, X509Certificate x509Certificate, Algorithm algorithm, String string, Element element, Node node, boolean bl) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException {
        element.setIdAttributeNode(element.getAttributeNode("ID"), true);
        DOMSignContext dOMSignContext = new DOMSignContext(privateKey, (Node)element);
        dOMSignContext.setNextSibling(node);
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        CanonicalizationMethod canonicalizationMethod = xMLSignatureFactory.newCanonicalizationMethod(string, (C14NMethodParameterSpec)null);
        Reference reference = xMLSignatureFactory.newReference("#" + element.getAttribute("ID"), xMLSignatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null), Arrays.asList(xMLSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null), canonicalizationMethod), null, null);
        SignedInfo signedInfo = xMLSignatureFactory.newSignedInfo(canonicalizationMethod, xMLSignatureFactory.newSignatureMethod(algorithm.uri, null), Collections.singletonList(reference));
        KeyInfoFactory keyInfoFactory = xMLSignatureFactory.getKeyInfoFactory();
        X509Data x509Data = keyInfoFactory.newX509Data(Collections.singletonList(x509Certificate));
        KeyInfo keyInfo = bl ? keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data)) : null;
        XMLSignature xMLSignature = xMLSignatureFactory.newXMLSignature(signedInfo, keyInfo);
        xMLSignature.sign(dOMSignContext);
    }

    private Set<String> verifyEmbeddedSignatures(Document document, KeySelector keySelector, SAMLRequest sAMLRequest) throws SAMLException {
        HashSet<String> hashSet = new HashSet<String>();
        this.fixIDs(document.getDocumentElement());
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            DOMValidateContext dOMValidateContext = new DOMValidateContext(keySelector, nodeList.item(i));
            XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
            try {
                boolean bl;
                XMLSignature xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
                String string2 = xMLSignature.getSignedInfo().getSignatureMethod().getAlgorithm();
                if (string2.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1") || string2.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224") || string2.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256") || string2.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384") || string2.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512")) {
                    this.checkFor_CVE_2022_21449(sAMLRequest, xMLSignature.getSignatureValue().getValue());
                }
                if (!(bl = xMLSignature.validate(dOMValidateContext))) {
                    throw new SAMLException("Invalid SAML v2.0 operation. The signature is invalid.", sAMLRequest);
                }
                hashSet.addAll(xMLSignature.getSignedInfo().getReferences().stream().map(URIReference::getURI).filter(string -> string.startsWith("#")).map(string -> string.substring(1)).toList());
                continue;
            }
            catch (MarshalException marshalException) {
                throw new SAMLException("Unable to verify XML signature in the SAML v2.0 XML. We couldn't unmarshall the XML Signature element.", sAMLRequest, marshalException);
            }
            catch (XMLSignatureException xMLSignatureException) {
                throw new SAMLException("Unable to verify XML signature in the SAML v2.0 XML. The signature was unmarshalled but we couldn't validate it. Possible reasons include a key was not provided that was eligible to verify the signature, or an un-expected exception occurred.", sAMLRequest, xMLSignatureException);
            }
        }
        return hashSet;
    }

    private void verifyEmbeddedSignaturesRequired(Document document, KeySelector keySelector, SAMLRequest sAMLRequest) throws SAMLException {
        Set<String> set = this.verifyEmbeddedSignatures(document, keySelector, sAMLRequest);
        if (set.isEmpty()) {
            throw new SignatureNotFoundException("Invalid SAML v2.0 operation. The signature is missing from the XML but is required.", sAMLRequest);
        }
    }

    private void verifyRequestSignature(SAMLRequestParameters sAMLRequestParameters, SAMLv2Service.RedirectBindingSignatureHelper redirectBindingSignatureHelper, SAMLRequest sAMLRequest) throws SAMLException {
        Algorithm algorithm = Algorithm.fromURI(sAMLRequestParameters.urlDecodedSigAlg());
        if (sAMLRequestParameters.Signature == null || algorithm == null || redirectBindingSignatureHelper.publicKey() == null) {
            throw new SignatureNotFoundException("You must specify a signature, key and algorithm if you want to verify the SAML request signature", sAMLRequest);
        }
        try {
            String string = "SAMLRequest=" + sAMLRequestParameters.SAMLRequest;
            if (sAMLRequestParameters.RelayState != null) {
                string = string + "&RelayState=" + sAMLRequestParameters.RelayState;
            }
            string = string + "&SigAlg=" + sAMLRequestParameters.SigAlg;
            Signature signature = Signature.getInstance(algorithm.name);
            signature.initVerify(redirectBindingSignatureHelper.publicKey());
            signature.update(string.getBytes(StandardCharsets.UTF_8));
            byte[] byArray = Base64.getMimeDecoder().decode(sAMLRequestParameters.urlDecodedSignature().getBytes(StandardCharsets.UTF_8));
            if (algorithm.uri.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1") || algorithm.uri.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224") || algorithm.uri.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256") || algorithm.uri.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384") || algorithm.uri.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512")) {
                this.checkFor_CVE_2022_21449(sAMLRequest, byArray);
            }
            if (!signature.verify(byArray)) {
                throw new SAMLException("Invalid SAML v2.0 operation. The signature is invalid.", sAMLRequest);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SAMLException("Unable to verify signature", sAMLRequest, generalSecurityException);
        }
    }

    private static /* synthetic */ void lambda$buildMetadataResponse$4(IDPSSODescriptorType iDPSSODescriptorType, String string) {
        EndpointType endpointType = new EndpointType();
        endpointType.setBinding(Binding.HTTP_POST.toSAMLFormat());
        endpointType.setLocation(string);
        iDPSSODescriptorType.getSingleLogoutService().add(endpointType);
    }

    private static /* synthetic */ void lambda$buildMetadataResponse$3(IDPSSODescriptorType iDPSSODescriptorType, String string) {
        EndpointType endpointType = new EndpointType();
        endpointType.setBinding(Binding.HTTP_Redirect.toSAMLFormat());
        endpointType.setLocation(string);
        iDPSSODescriptorType.getSingleLogoutService().add(endpointType);
    }

    private static /* synthetic */ void lambda$buildMetadataResponse$2(IDPSSODescriptorType iDPSSODescriptorType, String string) {
        EndpointType endpointType = new EndpointType();
        endpointType.setBinding(Binding.HTTP_POST.toSAMLFormat());
        endpointType.setLocation(string);
        iDPSSODescriptorType.getSingleSignOnService().add(endpointType);
    }

    private static /* synthetic */ void lambda$buildMetadataResponse$1(IDPSSODescriptorType iDPSSODescriptorType, String string) {
        EndpointType endpointType = new EndpointType();
        endpointType.setBinding(Binding.HTTP_Redirect.toSAMLFormat());
        endpointType.setLocation(string);
        iDPSSODescriptorType.getSingleSignOnService().add(endpointType);
    }

    private static /* synthetic */ void lambda$buildAuthnResponse$0(AttributeStatementType attributeStatementType, String string, List list) {
        AttributeType attributeType = new AttributeType();
        attributeType.setName(string);
        attributeType.getAttributeValue().addAll(list);
        attributeStatementType.getAttributeOrEncryptedAttribute().add(attributeType);
    }

    static {
        String string = System.getProperty("com.sun.org.apache.xml.internal.security.ignoreLineBreaks");
        if (!Boolean.parseBoolean(string)) {
            throw new IllegalStateException("When the fusionauth-samlv2 jar is included in the classpath, you must set the following system property:\n-Dcom.sun.org.apache.xml.internal.security.ignoreLineBreaks=true");
        }
    }

    private static class LogoutRequestParseResult {
        public Document document;
        public LogoutRequestType logoutRequest;
        public LogoutRequest request;

        private LogoutRequestParseResult() {
        }
    }

    private static class LogoutResponseParseResult {
        public Document document;
        public StatusResponseType logoutResponse;
        public LogoutResponse response;

        private LogoutResponseParseResult() {
        }
    }

    private static class AuthnRequestParseResult {
        public AuthnRequestType authnRequest;
        public Document document;
        public AuthenticationRequest request;

        private AuthnRequestParseResult() {
        }
    }
}

