/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.Application;
import io.fusionauth.domain.ApplicationRole;
import io.fusionauth.domain.api.ApplicationRequest;
import io.fusionauth.load.Configuration;
import io.fusionauth.load.FusionAuthBaseWorker;
import java.util.concurrent.atomic.AtomicInteger;

public class FusionAuthCreateApplicationWorker
extends FusionAuthBaseWorker {
    private final AtomicInteger counter;

    public FusionAuthCreateApplicationWorker(FusionAuthClient client, Configuration configuration, AtomicInteger counter) {
        super(client, configuration);
        this.counter = counter;
    }

    @Override
    public boolean execute() {
        this.setApplicationIndex(this.counter.incrementAndGet());
        Application application = (Application)((Application)((Application)((Application)new Application().with(a -> {
            a.name = "application_" + this.applicationIndex;
        })).with(a -> {
            a.tenantId = this.tenantId;
        })).with(a -> a.roles.add(new ApplicationRole("admin")))).with(a -> a.roles.add(new ApplicationRole("user")));
        ClientResponse result = this.tenantScopedClient.createApplication(this.applicationId, new ApplicationRequest(null, application));
        if (result.wasSuccessful()) {
            return true;
        }
        this.printErrors(result);
        return false;
    }
}

