/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load.listeners;

import io.fusionauth.load.CSVSampleListener;
import io.fusionauth.load.Sample;
import io.fusionauth.load.SampleListener;
import io.fusionauth.load.ThrowingConsumer;
import java.io.BufferedWriter;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TimerListener
implements SampleListener,
CSVSampleListener {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private long count;
    private Instant start;
    private Instant stop;

    @Override
    public void done() {
        this.stop = Instant.now();
    }

    @Override
    public void handle(Sample sample) {
        this.lock.writeLock().lock();
        try {
            if (this.start == null) {
                this.start = Instant.now();
            }
            ++this.count;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String outputFileName() {
        return "timerListenerResults";
    }

    @Override
    public void report(BufferedWriter writer) throws Exception {
        this.buildReport(duration -> {
            writer.write(String.valueOf(duration.toMillis()) + "," + String.valueOf(this.count) + "," + String.valueOf(this.count / TimeUnit.MILLISECONDS.toSeconds(duration.toMillis())));
            writer.newLine();
        });
    }

    @Override
    public void report(Appendable writer) throws Exception {
        this.buildReport(duration -> writer.append("\n=== TimerListener ===\n").append("Overall duration: " + duration.toMillis() + "ms\n").append("Count: " + this.count + "\n").append("Avg: " + this.count / TimeUnit.MILLISECONDS.toSeconds(duration.toMillis()) + " per second\n"));
    }

    @Override
    public void reportHeader(BufferedWriter writer) throws Exception {
        writer.write("Total Duration, Total Count, Average Per Second");
        writer.newLine();
    }

    private void buildReport(ThrowingConsumer<Duration> consumer) throws Exception {
        this.lock.readLock().lock();
        try {
            if (this.stop != null) {
                Duration duration = Duration.between(this.start, this.stop);
                consumer.accept(duration);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

