/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SQLTools {
    private static final Pattern EmptySpace = Pattern.compile("\\s{2,}");
    private static final Pattern ValidOrderBy = Pattern.compile("(([a-z0-9_]+|`[a-z0-9_]+`)(\\s+(asc|desc))?\\s*(,\\s*(?=[a-z0-9_`])|$))+", 2);

    public static String normalizeOrderBy(String orderBy, Map<String, String> sortableFields) {
        return SQLTools.normalizeOrderBy(orderBy, sortableFields, Collections.emptySet());
    }

    public static String normalizeOrderBy(String orderBy, Map<String, String> sortableFields, Set<String> nullableFields) {
        List orderBys = Arrays.stream(orderBy.split(",")).map(s -> Arrays.stream(s.trim().split("\\s+")).collect(Collectors.toList())).collect(Collectors.toList());
        ArrayList<String> orderByWithNulls = new ArrayList<String>();
        for (List statement : orderBys) {
            String field = (String)statement.get(0);
            if (statement.size() <= 2 && nullableFields.contains(field)) {
                if (((String)statement.get(statement.size() - 1)).equalsIgnoreCase("desc")) {
                    orderByWithNulls.add(field + " IS NULL");
                } else {
                    orderByWithNulls.add(field + " IS NOT NULL");
                }
            }
            orderByWithNulls.add(String.join((CharSequence)" ", statement));
        }
        orderBy = String.join((CharSequence)", ", orderByWithNulls);
        for (String field : sortableFields.keySet()) {
            orderBy = orderBy.replaceAll(String.format("\\b%s\\b", field), sortableFields.get(field));
        }
        return orderBy;
    }

    public static String sanitizeOrderBy(String orderBy) {
        if (orderBy == null) {
            return null;
        }
        String normalized = EmptySpace.matcher(orderBy).replaceAll(" ").trim();
        if (ValidOrderBy.matcher(normalized).matches()) {
            return orderBy;
        }
        return null;
    }

    public static String toSearchString(String s) {
        return SQLTools.toSearchString(s, false);
    }

    public static String toSearchString(String s, boolean exactMatch) {
        int index;
        if (s == null) {
            return null;
        }
        if (exactMatch) {
            return s.toLowerCase();
        }
        StringBuilder sb = new StringBuilder();
        for (index = 0; index < s.length(); ++index) {
            if (s.charAt(index) == '%' || s.charAt(index) == '_') {
                sb.append('\\').append(s.charAt(index));
                continue;
            }
            sb.append(s.charAt(index));
        }
        if (sb.length() > s.length()) {
            s = sb.toString();
        }
        if ((index = s.indexOf(42)) == -1) {
            return "%" + s.trim().toLowerCase() + "%";
        }
        sb = new StringBuilder();
        s = s.trim().toLowerCase();
        for (index = 0; index < s.length(); ++index) {
            if (s.charAt(index) == '*') {
                if (index < s.length() - 1 && s.charAt(index + 1) == '*') {
                    sb.append(s.charAt(index));
                    ++index;
                    continue;
                }
                sb.append('%');
                continue;
            }
            sb.append(s.charAt(index));
        }
        return sb.toString();
    }
}

