/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.WebhookAttemptLog;
import io.fusionauth.domain.WebhookAttemptResult;
import io.fusionauth.domain.WebhookEventResult;
import io.fusionauth.domain.event.EventRequest;
import io.fusionauth.domain.event.EventType;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(value={"successfulAttempts", "failedAttempts"}, allowGetters=true)
public class WebhookEventLog
implements Buildable<WebhookEventLog> {
    @JsonIgnoreProperties(value={"webhookEventLogId"})
    public List<WebhookAttemptLog> attempts = new ArrayList<WebhookAttemptLog>();
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public EventRequest event;
    public WebhookEventResult eventResult = WebhookEventResult.Running;
    public EventType eventType;
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastAttemptInstant;
    public ZonedDateTime lastUpdateInstant;
    public UUID linkedObjectId;
    public Long sequence;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookEventLog that = (WebhookEventLog)o;
        return Objects.equals(this.attempts, that.attempts) && Objects.equals(this.data, that.data) && Objects.equals(this.event, that.event) && this.eventResult == that.eventResult && this.eventType == that.eventType && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastAttemptInstant, that.lastAttemptInstant) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && Objects.equals(this.linkedObjectId, that.linkedObjectId) && Objects.equals(this.sequence, that.sequence);
    }

    public Integer getFailedAttempts() {
        return Math.toIntExact(this.attempts.stream().filter(attempt -> attempt.getAttemptResult().equals((Object)WebhookAttemptResult.Failure)).count());
    }

    public Integer getSuccessfulAttempts() {
        return Math.toIntExact(this.attempts.stream().filter(attempt -> attempt.getAttemptResult().equals((Object)WebhookAttemptResult.Success)).count());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attempts, this.data, this.event, this.eventResult, this.eventType, this.id, this.insertInstant, this.lastAttemptInstant, this.lastUpdateInstant, this.linkedObjectId, this.sequence});
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

