/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.fusionauth.domain.connector.BaseConnectorConfiguration;
import io.fusionauth.domain.message.MessageTemplate;
import io.fusionauth.domain.message.MessageType;
import io.fusionauth.domain.message.sms.SMSMessageTemplate;
import java.io.IOException;
import java.util.Arrays;

public class MessageTemplateJacksonHelper {
    public static MessageType extractType(DeserializationContext ctxt, JsonParser p, JsonNode templateNode) throws IOException {
        JsonNode node = templateNode.at("/type");
        String type = node.asText();
        MessageType messengerType = MessageType.safeValueOf(type);
        if (messengerType == null) {
            return (MessageType)((Object)ctxt.handleUnexpectedToken(BaseConnectorConfiguration.class, node.asToken(), p, "Expected the type field to be one of " + String.join((CharSequence)",", Arrays.toString((Object[])MessageType.values()) + ", but found [" + node.asText() + "]"), new Object[0]));
        }
        return messengerType;
    }

    public static MessageTemplate newMessageTemplate(MessageType type) {
        switch (type) {
            case SMS: {
                return new SMSMessageTemplate();
            }
        }
        throw new IllegalStateException("Unexpected type [" + (Object)((Object)type) + "]. This is a FusionAuth bug, someone forgot to add a case statement for a new type.");
    }
}

