/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CoseEllipticCurve {
    Reserved(0, "N/A"),
    P256(1, "secp256r1"),
    P384(2, "secp384r1"),
    P521(3, "secp521r1"),
    X25519(4, "X25519"),
    X448(5, "X448"),
    Ed25519(6, "Ed25519"),
    Ed448(7, "Ed448"),
    Secp256k1(8, "secp256k1");

    private static final Map<Integer, CoseEllipticCurve> valueMap;
    public final String curve;
    @JsonValue
    public final int registryId;

    private CoseEllipticCurve(int registryId, String curve) {
        this.registryId = registryId;
        this.curve = curve;
    }

    @JsonCreator
    public static CoseEllipticCurve forValue(int registryId) {
        return valueMap.get(registryId);
    }

    static {
        valueMap = new HashMap<Integer, CoseEllipticCurve>();
        for (CoseEllipticCurve c : CoseEllipticCurve.values()) {
            valueMap.put(c.registryId, c);
        }
    }
}

