/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.oauth2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.TwoFactorMethod;
import io.fusionauth.domain.oauth2.OAuthResponse;
import java.util.List;

public class OAuthError
implements OAuthResponse {
    @JsonProperty(value="change_password_id")
    public String changePasswordId;
    @JsonProperty(value="error_description")
    public String description;
    public OAuthErrorType error;
    @JsonProperty(value="error_uri")
    public String errorURI;
    @JsonProperty(value="two_factor_methods")
    public List<TwoFactorMethod> methods;
    @JsonProperty(value="error_reason")
    public OAuthErrorReason reason;
    @JsonProperty(value="two_factor_id")
    public String twoFactorId;

    @JacksonConstructor
    public OAuthError() {
    }

    public OAuthError(OAuthErrorType error, OAuthErrorReason reason, String description) {
        this.error = error;
        this.reason = reason;
        this.description = description;
    }

    public OAuthError(OAuthErrorType error, String description) {
        this.description = description;
        this.error = error;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static enum OAuthErrorType {
        invalid_request,
        invalid_client,
        invalid_grant,
        invalid_token,
        consent_required,
        interaction_required,
        login_required,
        unauthorized_client,
        invalid_scope,
        server_error,
        unsupported_grant_type,
        unsupported_response_type,
        access_denied,
        change_password_required,
        not_licensed,
        two_factor_required,
        authorization_pending,
        expired_token,
        unsupported_token_type;

    }

    public static enum OAuthErrorReason {
        auth_code_not_found,
        access_token_malformed,
        access_token_expired,
        access_token_unavailable_for_processing,
        access_token_failed_processing,
        access_token_invalid,
        access_token_required,
        refresh_token_not_found,
        refresh_token_type_not_supported,
        id_token_invalid,
        unsupported_token_type,
        token_type_hint_mismatch,
        invalid_client_id,
        invalid_expires_in,
        invalid_user_credentials,
        invalid_grant_type,
        invalid_origin,
        invalid_origin_opaque,
        invalid_pkce_code_verifier,
        invalid_pkce_code_challenge,
        invalid_pkce_code_challenge_method,
        invalid_prompt,
        invalid_redirect_uri,
        invalid_response_mode,
        invalid_response_type,
        invalid_id_token_hint,
        invalid_post_logout_redirect_uri,
        invalid_device_code,
        invalid_user_code,
        invalid_additional_client_id,
        invalid_target_entity_scope,
        invalid_entity_permission_scope,
        invalid_user_id,
        invalid_tenant_id,
        grant_type_disabled,
        missing_client_id,
        missing_client_secret,
        missing_code,
        missing_code_challenge,
        missing_code_verifier,
        missing_device_code,
        missing_grant_type,
        missing_redirect_uri,
        missing_refresh_token,
        missing_response_type,
        missing_token,
        missing_user_code,
        missing_user_id,
        missing_verification_uri,
        missing_tenant_id,
        login_prevented,
        not_licensed,
        user_code_expired,
        user_expired,
        user_locked,
        user_not_found,
        client_authentication_missing,
        invalid_client_authentication_scheme,
        invalid_client_authentication,
        client_id_mismatch,
        change_password_administrative,
        change_password_breached,
        change_password_expired,
        change_password_validation,
        unknown,
        missing_required_scope,
        unknown_scope,
        consent_canceled,
        authentication_required,
        email_verification_required,
        multi_factor_challenge_required,
        phone_verification_required,
        registration_missing_requirement,
        registration_required,
        registration_verification_required,
        consent_required;

    }
}

