/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.message.sms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.LocalizedStrings;
import io.fusionauth.domain.message.MessageTemplate;
import io.fusionauth.domain.message.MessageType;
import io.fusionauth.domain.util.Normalizer;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class SMSMessageTemplate
extends MessageTemplate
implements Buildable<SMSMessageTemplate> {
    public String defaultTemplate;
    public LocalizedStrings localizedTemplates = new LocalizedStrings();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SMSMessageTemplate that = (SMSMessageTemplate)o;
        return Objects.equals(this.defaultTemplate, that.defaultTemplate) && Objects.equals(this.localizedTemplates, that.localizedTemplates);
    }

    @JsonIgnore
    public Set<Locale> getLocalizations() {
        return new HashSet<Locale>(this.localizedTemplates.keySet());
    }

    @Override
    public MessageType getType() {
        return MessageType.SMS;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.defaultTemplate, this.localizedTemplates);
    }

    @Override
    public void normalize() {
        this.defaultTemplate = Normalizer.trim(this.defaultTemplate);
        this.name = Normalizer.trim(this.name);
        if (this.localizedTemplates != null) {
            this.localizedTemplates.normalize();
        }
    }

    @Override
    public String toString() {
        return ToString.toString((Object)this);
    }
}

