/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.form;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.form.FormStep;
import io.fusionauth.domain.form.FormStepType;
import io.fusionauth.domain.form.FormType;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class Form
implements Buildable<Form> {
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastUpdateInstant;
    public String name;
    public List<FormStep> steps = new ArrayList<FormStep>();
    public FormType type = FormType.registration;

    @JacksonConstructor
    public Form() {
    }

    public Form(Form other) {
        this.data.putAll(other.data);
        this.id = other.id;
        this.insertInstant = other.insertInstant;
        this.lastUpdateInstant = other.lastUpdateInstant;
        this.name = other.name;
        other.steps.forEach(step -> this.steps.add(new FormStep((FormStep)step)));
        this.type = other.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Form)) {
            return false;
        }
        Form form = (Form)o;
        return Objects.equals(this.data, form.data) && Objects.equals(this.id, form.id) && Objects.equals(this.insertInstant, form.insertInstant) && Objects.equals(this.lastUpdateInstant, form.lastUpdateInstant) && Objects.equals(this.name, form.name) && Objects.equals(this.steps, form.steps) && this.type == form.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.id, this.insertInstant, this.lastUpdateInstant, this.name, this.steps, this.type});
    }

    public void normalize() {
        Normalizer.removeEmpty(this.data);
        Normalizer.removeEmpty(this.steps);
        this.steps.removeIf(step -> step.type == FormStepType.collectData && step.fields.isEmpty());
        this.steps.stream().map(step -> step.fields).forEach(Normalizer::removeEmpty);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

