/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.api.identityProvider;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.BaseIdentityProviderApplicationConfiguration;
import io.fusionauth.domain.provider.ExternalJWTIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderOauth2Configuration;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.provider.OpenIdConnectIdentityProvider;
import io.fusionauth.domain.provider.SAMLv2IdentityProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class LookupResponse {
    public IdentityProviderDetails identityProvider;

    @JacksonConstructor
    public LookupResponse() {
    }

    public LookupResponse(BaseIdentityProvider<?> identityProvider) {
        this.identityProvider = new IdentityProviderDetails();
        this.identityProvider.id = identityProvider.id;
        this.identityProvider.tenantId = identityProvider.tenantId;
        this.identityProvider.name = identityProvider.name;
        this.identityProvider.type = identityProvider.getType();
        identityProvider.applicationConfiguration.entrySet().stream().filter(map -> ((BaseIdentityProviderApplicationConfiguration)map.getValue()).enabled).forEach(entry -> this.identityProvider.applicationIds.add((UUID)entry.getKey()));
        if (identityProvider instanceof ExternalJWTIdentityProvider) {
            this.identityProvider.oauth2 = new IdentityProviderOauth2Configuration(((ExternalJWTIdentityProvider)identityProvider).oauth2);
            this.identityProvider.oauth2.clientAuthenticationMethod = null;
        }
        if (identityProvider instanceof OpenIdConnectIdentityProvider) {
            this.identityProvider.oauth2 = new IdentityProviderOauth2Configuration(((OpenIdConnectIdentityProvider)identityProvider).oauth2);
        }
        if (this.identityProvider.oauth2 != null) {
            this.identityProvider.oauth2.client_secret = null;
            this.identityProvider.oauth2.emailClaim = null;
            this.identityProvider.oauth2.emailVerifiedClaim = null;
            this.identityProvider.oauth2.uniqueIdClaim = null;
            this.identityProvider.oauth2.usernameClaim = null;
        }
        if (identityProvider instanceof SAMLv2IdentityProvider) {
            this.identityProvider.idpEndpoint = ((SAMLv2IdentityProvider)identityProvider).idpEndpoint;
        }
    }

    public static class IdentityProviderDetails {
        public List<UUID> applicationIds = new ArrayList<UUID>();
        public UUID id;
        public URI idpEndpoint;
        public String name;
        public IdentityProviderOauth2Configuration oauth2;
        public UUID tenantId;
        public IdentityProviderType type;
    }
}

