/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.GroupMember;
import io.fusionauth.domain.IdentityType;
import io.fusionauth.domain.SecureIdentity;
import io.fusionauth.domain.Tenantable;
import io.fusionauth.domain.UserIdentity;
import io.fusionauth.domain.UserRegistration;
import io.fusionauth.domain.UserTwoFactorConfiguration;
import io.fusionauth.domain.util.Normalizer;
import java.net.URI;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class User
extends SecureIdentity
implements Buildable<User>,
Tenantable {
    public final List<Locale> preferredLanguages = new ArrayList<Locale>();
    private final List<GroupMember> memberships = new ArrayList<GroupMember>();
    private final List<UserRegistration> registrations = new ArrayList<UserRegistration>();
    public boolean active;
    public LocalDate birthDate;
    public UUID cleanSpeakId;
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public String email;
    public ZonedDateTime expiry;
    public String firstName;
    public String fullName;
    public URI imageUrl;
    public ZonedDateTime insertInstant;
    public String lastName;
    public ZonedDateTime lastUpdateInstant;
    public String middleName;
    public String mobilePhone;
    public String parentEmail;
    public String phoneNumber;
    public UUID tenantId;
    public ZoneId timezone;
    public UserTwoFactorConfiguration twoFactor = new UserTwoFactorConfiguration();

    @JacksonConstructor
    public User() {
    }

    public User(User other) {
        this.active = other.active;
        this.connectorId = other.connectorId;
        this.breachedPasswordLastCheckedInstant = other.breachedPasswordLastCheckedInstant;
        this.breachedPasswordStatus = other.breachedPasswordStatus;
        this.birthDate = other.birthDate;
        this.cleanSpeakId = other.cleanSpeakId;
        this.email = other.email;
        this.encryptionScheme = other.encryptionScheme;
        this.expiry = other.expiry;
        this.factor = other.factor;
        this.firstName = other.firstName;
        this.fullName = other.fullName;
        this.id = other.id;
        this.imageUrl = other.imageUrl;
        this.insertInstant = other.insertInstant;
        this.lastLoginInstant = other.lastLoginInstant;
        this.lastUpdateInstant = other.lastUpdateInstant;
        this.lastName = other.lastName;
        this.identities.addAll(other.identities.stream().map(UserIdentity::new).collect(Collectors.toCollection(ArrayList::new)));
        this.memberships.addAll(other.memberships.stream().map(GroupMember::new).collect(Collectors.toCollection(ArrayList::new)));
        this.middleName = other.middleName;
        this.mobilePhone = other.mobilePhone;
        this.parentEmail = other.parentEmail;
        this.password = other.password;
        this.passwordChangeReason = other.passwordChangeReason;
        this.passwordChangeRequired = other.passwordChangeRequired;
        this.passwordLastUpdateInstant = other.passwordLastUpdateInstant;
        this.phoneNumber = other.phoneNumber;
        this.preferredLanguages.addAll(other.preferredLanguages);
        this.registrations.addAll(other.registrations.stream().map(UserRegistration::new).collect(Collectors.toCollection(ArrayList::new)));
        this.salt = other.salt;
        this.tenantId = other.tenantId;
        this.timezone = other.timezone;
        this.twoFactor = new UserTwoFactorConfiguration(other.twoFactor);
        this.uniqueUsername = other.uniqueUsername;
        this.username = other.username;
        this.usernameStatus = other.usernameStatus;
        this.verified = other.verified;
        this.verifiedInstant = other.verifiedInstant;
        if (other.data != null) {
            this.data.putAll(other.data);
        }
    }

    public void addMemberships(GroupMember member) {
        this.memberships.removeIf(m -> m.groupId.equals(member.groupId));
        this.memberships.add(member);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        User user = (User)o;
        this.sort();
        user.sort();
        return this.active == user.active && Objects.equals(this.preferredLanguages, user.preferredLanguages) && Objects.equals(this.memberships, user.memberships) && Objects.equals(this.registrations, user.registrations) && Objects.equals(this.birthDate, user.birthDate) && Objects.equals(this.cleanSpeakId, user.cleanSpeakId) && Objects.equals(this.data, user.data) && Objects.equals(this.email, user.email) && Objects.equals(this.expiry, user.expiry) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.fullName, user.fullName) && Objects.equals(this.imageUrl, user.imageUrl) && Objects.equals(this.insertInstant, user.insertInstant) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.lastUpdateInstant, user.lastUpdateInstant) && Objects.equals(this.middleName, user.middleName) && Objects.equals(this.mobilePhone, user.mobilePhone) && Objects.equals(this.parentEmail, user.parentEmail) && Objects.equals(this.phoneNumber, user.phoneNumber) && Objects.equals(this.twoFactor, user.twoFactor) && Objects.equals(this.tenantId, user.tenantId) && Objects.equals(this.timezone, user.timezone);
    }

    @JsonIgnore
    public int getAge() {
        if (this.birthDate == null) {
            return -1;
        }
        return (int)this.birthDate.until(LocalDate.now(), ChronoUnit.YEARS);
    }

    @JsonIgnore
    public String getLogin() {
        if (this.email != null) {
            return this.email;
        }
        if (this.uniqueUsername != null) {
            return this.uniqueUsername;
        }
        return this.phoneNumber;
    }

    public List<GroupMember> getMemberships() {
        return this.memberships;
    }

    @JsonIgnore
    public String getName() {
        if (this.fullName != null) {
            return this.fullName;
        }
        if (this.firstName != null) {
            return this.firstName + (this.lastName != null ? " " + this.lastName : "");
        }
        return null;
    }

    public UserRegistration getRegistrationForApplication(UUID id) {
        return this.getRegistrations().stream().filter(reg -> reg.applicationId.equals(id)).findFirst().orElse(null);
    }

    public List<UserRegistration> getRegistrations() {
        return this.registrations;
    }

    public Set<String> getRoleNamesForApplication(UUID id) {
        UserRegistration registration = this.getRegistrationForApplication(id);
        return registration != null ? registration.roles : null;
    }

    @Override
    public UUID getTenantId() {
        return this.tenantId;
    }

    public boolean hasIdentityType(IdentityType identityType) {
        return this.identities.stream().anyMatch(ui -> ui.type.is(identityType));
    }

    public boolean hasUserData() {
        if (!this.data.isEmpty()) {
            return true;
        }
        for (UserRegistration userRegistration : this.registrations) {
            if (!userRegistration.hasRegistrationData()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.preferredLanguages, this.memberships, this.registrations, this.active, this.birthDate, this.cleanSpeakId, this.data, this.email, this.expiry, this.firstName, this.fullName, this.imageUrl, this.insertInstant, this.lastName, this.lastUpdateInstant, this.middleName, this.mobilePhone, this.parentEmail, this.phoneNumber, this.tenantId, this.timezone, this.twoFactor);
    }

    public String lookupEmail() {
        if (this.email != null) {
            return this.email;
        }
        if (this.data.containsKey("email")) {
            return this.data.get("email").toString();
        }
        return null;
    }

    public Locale lookupPreferredLanguage(UUID applicationId) {
        for (UserRegistration registration : this.registrations) {
            if (!registration.applicationId.equals(applicationId) || registration.preferredLanguages.size() <= 0) continue;
            return registration.preferredLanguages.get(0);
        }
        if (this.preferredLanguages.size() > 0) {
            return this.preferredLanguages.get(0);
        }
        return null;
    }

    public void normalize() {
        Normalizer.removeEmpty(this.data);
        this.email = Normalizer.toLowerCase(Normalizer.trimToNull(this.email));
        this.identities.forEach(UserIdentity::normalize);
        this.encryptionScheme = Normalizer.trim(this.encryptionScheme);
        this.firstName = Normalizer.trim(this.firstName);
        this.fullName = Normalizer.trim(this.fullName);
        this.lastName = Normalizer.trim(this.lastName);
        this.middleName = Normalizer.trim(this.middleName);
        this.mobilePhone = Normalizer.trim(this.mobilePhone);
        this.parentEmail = Normalizer.toLowerCase(Normalizer.trim(this.parentEmail));
        this.phoneNumber = Normalizer.trimToNull(this.phoneNumber);
        Normalizer.removeEmpty(this.preferredLanguages);
        Normalizer.deDuplicate(this.preferredLanguages);
        this.preferredLanguages.removeIf(l -> l.toString().equals(""));
        this.username = Normalizer.trimToNull(this.username);
        this.memberships.removeIf(m -> m.groupId == null);
        this.getRegistrations().forEach(UserRegistration::normalize);
    }

    public void removeIdentitiesOfType(IdentityType identityType) {
        this.identities.removeIf(i -> i.type.is(identityType));
    }

    public void removeMembershipById(UUID groupId) {
        this.memberships.removeIf(m -> m.groupId.equals(groupId));
    }

    public void replaceIdentities(List<UserIdentity> replacementIdentities) {
        Set replaceTypes = replacementIdentities.stream().map(i -> i.type).collect(Collectors.toSet());
        this.identities.removeIf(existing -> replaceTypes.contains(existing.type));
        this.identities.addAll(replacementIdentities);
    }

    public UserIdentity resolveFirstIdentity() {
        return Optional.ofNullable(this.resolveLegacyIdentity()).orElse(this.identities.stream().findFirst().orElse(null));
    }

    public List<UserIdentity> resolveIdentitiesOfType(IdentityType identityType) {
        return this.identities.stream().filter(i -> i.type.is(identityType)).collect(Collectors.toList());
    }

    public UserIdentity resolveLegacyIdentity() {
        return this.resolvePrimaryIdentity(IdentityType.email, IdentityType.username);
    }

    public UserIdentity resolvePrimaryIdentity(IdentityType ... loginIdTypes) {
        for (IdentityType loginIdType : loginIdTypes) {
            UserIdentity result = this.resolvePrimaryIdentity(loginIdType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @JsonIgnore
    public UserIdentity resolvePrimaryIdentity(IdentityType loginIdType) {
        return this.identities.stream().filter(i -> i.primary).filter(i -> i.type.is(loginIdType)).findFirst().orElse(null);
    }

    public User secure() {
        this.encryptionScheme = null;
        this.factor = null;
        this.password = null;
        this.salt = null;
        this.twoFactor.secure();
        return this;
    }

    public User sort() {
        this.identities.sort(Comparator.comparing(i -> i.insertInstant, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(i -> i.type, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(i -> i.value, Comparator.nullsLast(Comparator.naturalOrder())));
        this.registrations.sort(Comparator.comparing(ur -> ur.applicationId));
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public boolean twoFactorEnabled() {
        return this.twoFactor.methods.size() > 0;
    }
}

