/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.fusionauth.domain.connector.BaseConnectorConfiguration;
import io.fusionauth.domain.messenger.BaseMessengerConfiguration;
import io.fusionauth.domain.messenger.GenericMessengerConfiguration;
import io.fusionauth.domain.messenger.KafkaMessengerConfiguration;
import io.fusionauth.domain.messenger.MessengerType;
import io.fusionauth.domain.messenger.TwilioMessengerConfiguration;
import java.io.IOException;
import java.util.Arrays;

public class MessengerJacksonHelper {
    public static MessengerType extractType(DeserializationContext ctxt, JsonParser p, JsonNode connectorNode) throws IOException {
        JsonNode node = connectorNode.at("/type");
        String type = node.asText(MessengerType.Twilio.name());
        MessengerType messengerType = MessengerType.safeValueOf(type);
        if (messengerType == null) {
            return (MessengerType)((Object)ctxt.handleUnexpectedToken(BaseConnectorConfiguration.class, node.asToken(), p, "Expected the type field to be one of " + String.join((CharSequence)",", Arrays.toString((Object[])MessengerType.values()) + ", but found [" + node.asText() + "]"), new Object[0]));
        }
        return messengerType;
    }

    public static BaseMessengerConfiguration newMessenger(MessengerType type) {
        switch (type) {
            case Generic: {
                return new GenericMessengerConfiguration();
            }
            case Twilio: {
                return new TwilioMessengerConfiguration();
            }
            case Kafka: {
                return new KafkaMessengerConfiguration();
            }
        }
        throw new IllegalStateException("Unexpected type [" + (Object)((Object)type) + "]. This is a FusionAuth bug, someone forgot to add a case statement for a new type.");
    }
}

