/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.fusionauth.client.json.IdentityProviderJacksonHelper;
import io.fusionauth.domain.api.IdentityProviderResponse;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderType;
import java.io.IOException;
import java.util.ArrayList;

public class IdentityProviderResponseDeserializer
extends StdDeserializer<IdentityProviderResponse> {
    public IdentityProviderResponseDeserializer() {
        super(IdentityProviderResponse.class);
    }

    public IdentityProviderResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserialize(p, ctxt, new IdentityProviderResponse());
    }

    public IdentityProviderResponse deserialize(JsonParser p, DeserializationContext ctxt, IdentityProviderResponse resp) throws IOException {
        JsonNode idpNodes;
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        JsonNode idpNode = node.at("/identityProvider");
        if (idpNode != null) {
            IdentityProviderType idpType = IdentityProviderJacksonHelper.extractType(ctxt, p, idpNode);
            resp.identityProvider = IdentityProviderJacksonHelper.newIdentityProvider(idpType);
            ((ObjectMapper)p.getCodec()).readerForUpdating(resp.identityProvider).readValue(idpNode);
        }
        if ((idpNodes = node.at("/identityProviders")) != null && idpNodes.isArray()) {
            resp.identityProviders = new ArrayList();
            for (JsonNode idp : idpNodes) {
                IdentityProviderType idpType = IdentityProviderJacksonHelper.extractType(ctxt, p, idp);
                BaseIdentityProvider<?> baseIdp = IdentityProviderJacksonHelper.newIdentityProvider(idpType);
                ((ObjectMapper)p.getCodec()).readerForUpdating(baseIdp).readValue(idp);
                resp.identityProviders.add(baseIdp);
            }
        }
        return resp;
    }
}

