/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.messenger;

import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.messenger.BaseMessengerConfiguration;
import io.fusionauth.domain.messenger.MessengerType;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class KafkaMessengerConfiguration
extends BaseMessengerConfiguration
implements Buildable<KafkaMessengerConfiguration> {
    public String defaultTopic;
    public Map<String, String> producer = new TreeMap<String, String>();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaMessengerConfiguration that = (KafkaMessengerConfiguration)o;
        return Objects.equals(this.defaultTopic, that.defaultTopic) && Objects.equals(this.producer, that.producer);
    }

    @Override
    public MessengerType getType() {
        return MessengerType.Kafka;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.defaultTopic, this.producer);
    }

    @Override
    public void normalize() {
        if (!this.producer.containsKey("bootstrap.servers")) {
            this.producer.put("bootstrap.servers", "localhost:9092");
            this.producer.put("max.block.ms", "5000");
            this.producer.put("request.timeout.ms", "2000");
        }
    }
}

